/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.XMLSchema;
import oracle.javatools.db.ora.XMLSchemaElement;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSchemaBuilder
extends OracleDBObjectBuilder<XMLSchema> {
    XMLSchemaBuilder(BaseOracleDatabase baseOracleDatabase) {
        super(baseOracleDatabase, "XML SCHEMA");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"source", "internalName", "global", "qualifiedURL"})
    public void fillInPropreties(final XMLSchema xMLSchema) throws DBException {
        final QueryWrapper queryWrapper = this.getDatabase().newQueryWrapper((SystemObject)xMLSchema, "SELECT /*OracleDictionaryQueries.ALL_XML_SCHEMA_OBJECT_QUERY*/\n       sys.xmltype.getClobVal(SCHEMA), INT_OBJNAME, LOCAL, QUAL_SCHEMA_URL FROM SYS.ALL_XML_SCHEMAS WHERE OWNER = ? AND SCHEMA_URL = ? ", xMLSchema.getSchema(), xMLSchema);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        xMLSchema.setSource(resultSet.getString(1));
                        xMLSchema.setInternalName(resultSet.getString(2));
                        xMLSchema.setGlobal(!"YES".equals(resultSet.getString(3)));
                        xMLSchema.setQualifiedURL(resultSet.getString(4));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)xMLSchema, sQLException);
                }
            }
        };
        queryWrapper.executeQuery(queryRunnable);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"elements"})
    public void fillInElements(XMLSchema xMLSchema) throws DBException {
        ArrayList<XMLSchemaElement> arrayList = new ArrayList<XMLSchemaElement>();
        if (xMLSchema != null) {
            Object object;
            DOMParser dOMParser = new DOMParser();
            String string = xMLSchema.getSource();
            XMLDocument xMLDocument = null;
            if (string != null) {
                object = new StringReader(string);
                try {
                    dOMParser.parse((Reader)object);
                    xMLDocument = dOMParser.getDocument();
                }
                catch (XMLParseException xMLParseException) {
                }
                catch (SAXException sAXException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (xMLDocument != null) {
                object = xMLDocument.getDocumentElement();
                NodeList nodeList = object.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node;
                    Node node2 = nodeList.item(i);
                    String string2 = node2.getLocalName();
                    if (string2 == null || !string2.equals("element") && !string2.endsWith(":element") || (node = node2.getAttributes().getNamedItem("name")) == null) continue;
                    String string3 = node.getTextContent();
                    XMLSchemaElement xMLSchemaElement = new XMLSchemaElement();
                    NameBasedID nameBasedID = new NameBasedID("XMLSchemaElement", string3, xMLSchema.getID());
                    xMLSchemaElement.setName(string3);
                    xMLSchemaElement.setID((DBObjectID)nameBasedID);
                    arrayList.add(xMLSchemaElement);
                }
            }
        }
        xMLSchema.setElements(arrayList.toArray(new XMLSchemaElement[arrayList.size()]));
    }
}

