/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import java.util.Map;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeCache;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.hive.HiveBucketPropertiesValidator;
import oracle.javatools.db.hive.HiveDDLGenerator;
import oracle.javatools.db.hive.HiveDatabaseImpl;
import oracle.javatools.db.hive.HivePartitionPropertiesValidator;
import oracle.javatools.db.hive.HivePartitionValidator;
import oracle.javatools.db.hive.HiveSkewPropertiesValidator;
import oracle.javatools.db.hive.HiveStoragePropertiesValidator;
import oracle.javatools.db.hive.HiveTableValidator;
import oracle.javatools.db.hive.resource.HiveBundle;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.validators.DBObjectValidator;

public class HiveDatabaseDescriptor
extends JdbcDatabaseDescriptor {
    private final int m_version;

    HiveDatabaseDescriptor(int n) {
        super(HiveDatabaseImpl.class);
        this.m_version = n;
    }

    @Override
    public String getDatabaseType() {
        return "Hive";
    }

    @Override
    public int getDatabaseVersion() {
        return this.m_version;
    }

    @Override
    public int getCasePolicy() {
        return 1;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "`";
    }

    @Override
    public int getMaxNameLength(String string) {
        return Integer.MAX_VALUE;
    }

    public String getDefaultSchemaName() {
        return "default";
    }

    public String getSchemaDisplayName() {
        return APIBundle.get((String)"DATABASE");
    }

    @Override
    protected void registerDataTypes(DataTypeCache dataTypeCache) {
        dataTypeCache.setResourceBundle(HiveBundle.getBundle());
        if (this.m_version == 12) {
            dataTypeCache.registerDataType("TINYINT");
            dataTypeCache.registerDataType("SMALLINT");
            dataTypeCache.registerDataType("INT");
            dataTypeCache.registerDataType("BIGINT");
            dataTypeCache.registerDataType("BOOLEAN");
            dataTypeCache.registerDataType("FLOAT");
            dataTypeCache.registerDataType("DOUBLE");
            dataTypeCache.registerDataType("STRING");
            dataTypeCache.registerDataType("BINARY");
            dataTypeCache.registerDataType("DATE");
            dataTypeCache.registerDataType("TIMESTAMP");
            dataTypeCache.registerDataType("DECIMAL");
            dataTypeCache.registerDataType("VARCHAR");
            dataTypeCache.registerDataType("ARRAY");
            dataTypeCache.registerDataType("MAP");
            dataTypeCache.registerDataType("STRUCT");
            dataTypeCache.registerDataType("UNIONTYPE");
        } else if (this.m_version == 13) {
            dataTypeCache.registerDataType("CHAR");
            dataTypeCache.registerDataType("DECIMAL");
        }
    }

    @Override
    public void validateName(String string, String string2) throws InvalidNameException {
        if (!"HivePartition".equals(string)) {
            super.validateName(string, string2);
        }
    }

    public DataTypeUsage createDefaultTypeUsage() {
        DataType dataType = this.getDataType("STRING");
        assert (dataType != null);
        DataTypeUsage dataTypeUsage = dataType == null ? super.createDefaultTypeUsage() : dataType.createDefaultUsage();
        return dataTypeUsage;
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider dBObjectProvider) {
        Map<String, DBObjectValidator> map = super.getValidators(dBObjectProvider);
        map.put("HiveStorageProperties", new HiveStoragePropertiesValidator(dBObjectProvider));
        map.put("HiveBucketProperties", new HiveBucketPropertiesValidator(dBObjectProvider));
        map.put("HivePartitionProperties", new HivePartitionPropertiesValidator(dBObjectProvider));
        map.put("HiveSkewProperties", new HiveSkewPropertiesValidator(dBObjectProvider));
        map.put("HivePartition", new HivePartitionValidator(dBObjectProvider));
        map.put("TABLE", (DBObjectValidator)new HiveTableValidator(dBObjectProvider));
        map.remove("VIEW");
        return map;
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider dBObjectProvider) {
        return new HiveDDLGenerator(dBObjectProvider);
    }
}

