/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.support;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.ide.util.MetaResource;
import oracle.dbtools.raptor.support.MetaURLReference;
import oracle.dbtools.raptor.utils.FileUtils;

public final class MetaPackageReference {
    private String m_pkg;
    private ClassLoader m_loader;

    private MetaPackageReference(String string, ClassLoader classLoader) {
        this.m_pkg = string;
        this.m_loader = classLoader;
    }

    public List<MetaURLReference> getURLReferences(String string) {
        ArrayList<MetaURLReference> arrayList = new ArrayList<MetaURLReference>();
        for (URL uRL : FileUtils.getFilesInPackage(this.m_pkg, this.m_loader, string)) {
            arrayList.add(MetaURLReference.createURLReference(uRL, this.m_loader));
        }
        return arrayList;
    }

    public ClassLoader getReferenceClassLoader() {
        return this.m_loader;
    }

    public String getPackage() {
        return this.m_pkg;
    }

    public static MetaPackageReference createPackageReference(String string, ClassLoader classLoader) {
        return new MetaPackageReference(string, classLoader);
    }

    public static MetaPackageReference createPackageReference(MetaResource metaResource) {
        return new MetaPackageReference(metaResource.getResourcePath(), metaResource.getClassLoader());
    }
}

