/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.grid.AbstractRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.ColumnAutoSizer;
import oracle.dbtools.raptor.controls.grid.ColumnHeaderCellRenderer;
import oracle.dbtools.raptor.controls.grid.FinderHighlighter;
import oracle.dbtools.raptor.controls.grid.GridColumn;
import oracle.dbtools.raptor.controls.grid.GridColumnSortParameter;
import oracle.dbtools.raptor.controls.grid.RaptorGridCopyAdapter;
import oracle.dbtools.raptor.controls.grid.RaptorGridPersistedSettings;
import oracle.dbtools.raptor.controls.grid.RaptorGridSearchParameter;
import oracle.dbtools.raptor.controls.grid.RaptorJTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.ColumnAutoFit;
import oracle.dbtools.raptor.controls.grid.contextmenu.ColumnSelector;
import oracle.dbtools.raptor.controls.grid.contextmenu.CopyColumnHeader;
import oracle.dbtools.raptor.controls.grid.contextmenu.CountRows;
import oracle.dbtools.raptor.controls.grid.contextmenu.DeleteSettings;
import oracle.dbtools.raptor.controls.grid.contextmenu.FindHighlight;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridHeaderContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridSorter;
import oracle.dbtools.raptor.controls.grid.contextmenu.HeaderMenu;
import oracle.dbtools.raptor.controls.grid.contextmenu.Messages;
import oracle.dbtools.raptor.controls.grid.contextmenu.SingleRecordView;
import oracle.dbtools.util.Debug;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.View;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Pair;

public class RaptorGridTable
extends RaptorJTable {
    protected static final long serialVersionUID = 1L;
    private static final String RAPTOR_GRID_TABLE_CTX_PROPERTY = "RaptorGridTableCtxProperty";
    protected static final int ROW_NUMBER_WIDTH = 45;
    protected static final int ROW_HEIGHT = 20;
    protected static final int MAX_TIP_LEN = 1024;
    public static final String _GHOST_VALUE = new String("...");
    private static final DefaultTableCellRenderer _GHOST_RENDERER = new DefaultTableCellRenderer();
    protected JTable _rowHeader;
    protected RaptorGridCopyAdapter _copyAdapter;
    protected KeyStroke copyWithHeader;
    protected KeyStroke copyHeader;
    private KeyStroke fetchAll;
    private KeyStroke fetchEndAll;
    protected boolean _editable = false;
    private boolean _isFilterFieldAllowed = false;
    private boolean _isRefreshAllowed = true;
    protected boolean _verticalDisplay = false;
    protected Boolean _isHostedInDialog = null;
    protected boolean isColumnSortingEnabled = true;
    protected boolean isColumnSelectorAvailable = true;
    protected boolean isMultiColSort = true;
    private static ContextMenu _gridCM = new ContextMenu(new MnemonicSolver());
    private static ContextMenu _columnHeaderCM;
    private ArrayList<GridContextMenuItem> _localCTXMenuItems;
    private RaptorGridSettingsPersistor _settingsPersistor = new RaptorGridSettingsPersistor();
    private ActionListener _copyPasteListener;
    private static MouseListener _contextMenuMouseListener;
    protected List<RaptorGridSearchParameter> _highlights = new ArrayList<RaptorGridSearchParameter>();
    private static boolean _initedStatics;
    private boolean _allowContextMenu = true;
    protected View _view = null;
    private Controller controller = new Controller(){

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (!this.shouldUpdate()) {
                return false;
            }
            switch (n) {
                case 17: {
                    if (RaptorGridTable.this.getGridCopyAdapter().canCut()) {
                        RaptorGridTable.this.getGridCopyAdapter().copyToClipboard(true);
                    }
                    return true;
                }
                case 18: {
                    if (RaptorGridTable.this.getGridCopyAdapter().canCopy()) {
                        RaptorGridTable.this.getGridCopyAdapter().copyToClipboard();
                    }
                    return true;
                }
                case 19: {
                    RaptorGridTable.this.getGridCopyAdapter().pasteToJTable();
                    return true;
                }
                case 78: {
                    boolean bl = ClipboardStack.adjustCurrentClipboard();
                    if (bl) {
                        RaptorGridTable.this.getGridCopyAdapter().pasteToJTable();
                    }
                    return true;
                }
                case 23: {
                    FinderHighlighter.showDialog(RaptorGridTable.this);
                    return true;
                }
                case 22: {
                    RaptorGridTable.this.selectAll();
                    return true;
                }
            }
            return false;
        }

        private boolean shouldUpdate() {
            boolean bl = false;
            if (RaptorGridTable.this.showing) {
                Container container = RaptorGridTable.this;
                do {
                    RaptorGridTable raptorGridTable;
                    JTableHeader jTableHeader;
                    if (container == KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner()) {
                        if (container.getParent() instanceof Window) break;
                        bl = true;
                        break;
                    }
                    if (!(container instanceof RaptorGridTable) || (jTableHeader = (raptorGridTable = container).getTableHeader()) != KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner()) continue;
                    bl = true;
                    break;
                } while (!((container = container.getParent()) instanceof Window) && container != null);
            }
            return bl;
        }

        public boolean update(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (this.shouldUpdate()) {
                Logger.finer(this.getClass(), (String)("update returning true for Grid" + RaptorGridTable.this.__myGridNum + context));
                if (n == 17) {
                    ideAction.setEnabled(RaptorGridTable.this.getGridCopyAdapter().canCut());
                    return true;
                }
                if (n == 18) {
                    ideAction.setEnabled(RaptorGridTable.this.getGridCopyAdapter().canCopy());
                    return true;
                }
                if (n == 19 || n == 78) {
                    ideAction.setEnabled(RaptorGridTable.this.getGridCopyAdapter().canPaste());
                    return true;
                }
                if (n == 23) {
                    ideAction.setEnabled(true);
                    return true;
                }
                if (n == 22) {
                    ideAction.setEnabled(true);
                    return true;
                }
            }
            Logger.fine(this.getClass(), (String)("update returning false for Grid" + RaptorGridTable.this.__myGridNum + context));
            return false;
        }
    };
    private GridContextMenuItem tacmListener = new GridContextMenuItem(){

        @Override
        protected boolean canShow(ContextMenu contextMenu) {
            return this._table == RaptorGridTable.this;
        }

        @Override
        protected void createAndShowMenu(ContextMenu contextMenu) {
            Context context = contextMenu.getContext();
            if (!UIUtils.isKeyboardPopup(context)) {
                return;
            }
            UIUtils.addToolbarActionsMenu(contextMenu, RaptorGridTable.this.toolbar);
        }
    };
    private Toolbar toolbar;
    private ContextMenuListener cmListener = new ContextMenuListener(){

        public boolean handleDefaultAction(Context context) {
            boolean bl = false;
            if (RaptorGridTable.this._allowContextMenu && RaptorGridTable.this._localCTXMenuItems != null) {
                for (GridContextMenuItem gridContextMenuItem : RaptorGridTable.this._localCTXMenuItems) {
                    if (bl) continue;
                    bl = gridContextMenuItem.handleDefaultAction(context);
                }
            }
            return bl;
        }

        public void menuWillHide(ContextMenu contextMenu) {
            if (RaptorGridTable.this._allowContextMenu && RaptorGridTable.this._localCTXMenuItems != null) {
                for (GridContextMenuItem gridContextMenuItem : RaptorGridTable.this._localCTXMenuItems) {
                    gridContextMenuItem.menuWillHide(contextMenu);
                }
            }
        }

        public void menuWillShow(ContextMenu contextMenu) {
            if (RaptorGridTable.this._allowContextMenu && RaptorGridTable.this._localCTXMenuItems != null) {
                for (GridContextMenuItem gridContextMenuItem : RaptorGridTable.this._localCTXMenuItems) {
                    gridContextMenuItem.menuWillShow(contextMenu);
                }
            }
        }
    };
    private static int lastGridNum;
    private int __myGridNum;
    private IdeAction[] ideActions;
    private boolean showing = true;
    private FireUpdateIdeActionsListener fireUpdateIdeActionsListener = new FireUpdateIdeActionsListener();

    public static final RaptorGridTable getRaptorGridTable(Context context) {
        return (RaptorGridTable)context.getProperty(RAPTOR_GRID_TABLE_CTX_PROPERTY);
    }

    public static final void setRaptorGridTable(Context context, RaptorGridTable raptorGridTable) {
        context.setProperty(RAPTOR_GRID_TABLE_CTX_PROPERTY, (Object)raptorGridTable);
    }

    public void setToolbar(Toolbar toolbar) {
        this.toolbar = toolbar;
    }

    @Override
    protected void initializeLocalVars() {
        if (this.copyWithHeader == null) {
            this.copyWithHeader = KeyStroke.getKeyStroke(67, 3, false);
        }
        if (this.copyHeader == null) {
            this.copyHeader = KeyStroke.getKeyStroke(72, 2, false);
        }
        if (this.fetchAll == null) {
            this.fetchAll = KeyStroke.getKeyStroke(35, 8, false);
        }
        if (this.fetchEndAll == null) {
            this.fetchEndAll = KeyStroke.getKeyStroke(35, 2, false);
        }
        if (this._copyAdapter == null) {
            this._copyAdapter = new RaptorGridCopyAdapter(this);
        }
        if (this._copyPasteListener == null) {
            this._copyPasteListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().compareTo("Copy.With.Header") == 0) {
                        RaptorGridTable.this._copyAdapter.copyToClipboard(false, true);
                    } else if (actionEvent.getActionCommand().compareTo("Copy.Header") == 0) {
                        RaptorGridTable.this._copyAdapter.copyHeadertoClipboard();
                    }
                }
            };
        }
        super.initializeLocalVars();
    }

    public RaptorGridTable() {
        this.__myGridNum = ++lastGridNum;
        _gridCM.addContextMenuListener(this.cmListener);
        this.addAncestorListener(this.fireUpdateIdeActionsListener);
        this.addFocusListener(this.fireUpdateIdeActionsListener);
        RaptorGridTable.initStatics();
        this.setSurrendersFocusOnKeystroke(true);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.putClientProperty("JTable.autoStartsEdit", Boolean.TRUE);
        this.setAutoResizeMode(0);
        this.getTableHeader().setAutoscrolls(true);
        this.setDragEnabled(true);
        this.setDefaultRenderer(TableColumn.class, new DefaultTableCellRenderer());
        this.setSurrendersFocusOnKeystroke(true);
        this.setFillsViewportHeight(true);
        this.setAutoCreateColumnsFromModel(true);
        this.getTableHeader().addMouseListener(new ColumnAutoSizer());
        this.setCellSelectionEnabled(true);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setRowHeight(20);
        this.registerKeyboardAction(this._copyPasteListener, "Copy.With.Header", this.copyWithHeader, 0);
        this.registerKeyboardAction(this._copyPasteListener, "Copy.Header", this.copyHeader, 0);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    IdeMainWindow.updateVisibleActions();
                }
            }
        });
        _contextMenuMouseListener = new UIUtils.MousePopupTriggerListener(){
            private Context _context = new Context();

            @Override
            protected void doPopup(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() == RaptorGridTable.this) {
                    this.initContext(mouseEvent);
                    _gridCM.show(this._context);
                } else if (mouseEvent.getSource() == RaptorGridTable.this.getTableHeader()) {
                    this.initContext(mouseEvent);
                    _columnHeaderCM.show(this._context);
                }
            }

            public void initContext(MouseEvent mouseEvent) {
                if (RaptorGridTable.this.getView() != null) {
                    this._context = RaptorGridTable.this.getView().getContext((EventObject)mouseEvent);
                } else {
                    this._context.setEvent((EventObject)mouseEvent);
                }
                RaptorGridTable.setRaptorGridTable(this._context, RaptorGridTable.this);
            }
        };
        this.addMouseListener(_contextMenuMouseListener);
        this.getTableHeader().addMouseListener(_contextMenuMouseListener);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                if (mouseEvent.getSource() instanceof JTableHeader) {
                    JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                    JTable jTable = jTableHeader.getTable();
                    if (jTable.isEditing()) {
                        jTable.getCellEditor().cancelCellEditing();
                    }
                    if (mouseEvent.getClickCount() == 2 && RaptorGridTable.this.canSortNow()) {
                        GridColumn gridColumn;
                        List<? extends GridColumn> list;
                        AbstractRaptorGridModel abstractRaptorGridModel;
                        int n;
                        int n2 = RaptorGridTable.this.columnAtPoint(mouseEvent.getPoint());
                        int n3 = RaptorGridTable.this.convertColumnIndexToModel(n2);
                        int n4 = n = jTableHeader.getResizingColumn() != null ? jTableHeader.getResizingColumn().getModelIndex() : -1;
                        if (n3 != -1 && jTableHeader.getResizingColumn() == null && (abstractRaptorGridModel = RaptorGridTable.this.getGridModel()) != null && abstractRaptorGridModel.isColumnSortable(n3) && (list = abstractRaptorGridModel.getGridColumns()) != null && list.size() > 0 && (gridColumn = list.get(n3)) != null) {
                            for (GridColumn gridColumn2 : list) {
                                if (gridColumn2 == gridColumn) continue;
                                gridColumn2.setSortParameter(null);
                            }
                            GridColumnSortParameter gridColumnSortParameter = gridColumn.getSortParameter();
                            if (gridColumnSortParameter != null) {
                                if (gridColumnSortParameter.getSortDir() == GridColumnSortParameter.SortDir.ASCENDING) {
                                    gridColumnSortParameter.setSortDir(GridColumnSortParameter.SortDir.DESCENDING);
                                    gridColumnSortParameter.setSortOrder(0);
                                } else if (gridColumnSortParameter.getSortDir() == GridColumnSortParameter.SortDir.DESCENDING) {
                                    gridColumn.setSortParameter(null);
                                }
                            } else {
                                gridColumn.setSortParameter(new GridColumnSortParameter(0, GridColumnSortParameter.SortDir.ASCENDING, GridColumnSortParameter.NullsOption.NONE));
                            }
                            RaptorGridTable.this.savePersistentSettings();
                            try {
                                RaptorGridTable.this.refresh();
                            }
                            catch (ExecutionException executionException) {
                                Logger.warn(this.getClass(), (Throwable)executionException);
                            }
                        }
                    } else if (mouseEvent.getClickCount() == 1) {
                        RaptorGridTable.this.setCellSelectionEnabled(false);
                        RaptorGridTable.this.setColumnSelectionAllowed(true);
                        RaptorGridTable.this.setRowSelectionAllowed(false);
                        ColumnAutoFit.select(RaptorGridTable.this.getColumnModel().getSelectionModel(), mouseEvent, RaptorGridTable.this.columnAtPoint(mouseEvent.getPoint()));
                        RaptorGridTable.this.requestFocusInWindow();
                    }
                }
            }
        });
        this.setTransferHandler(new TransferHandler(){

            @Override
            public int getSourceActions(JComponent jComponent) {
                return 3;
            }

            @Override
            public Transferable createTransferable(JComponent jComponent) {
                RaptorGridCopyAdapter raptorGridCopyAdapter = new RaptorGridCopyAdapter((RaptorGridTable)jComponent);
                StringBuilder stringBuilder = new StringBuilder();
                int n = raptorGridCopyAdapter._grid.getSelectedColumnCount();
                boolean bl = false;
                bl = n == 1 ? raptorGridCopyAdapter.copyToBuffer(stringBuilder, " ", ",", RaptorGridCopyAdapter.CopyData.COPY, false, true) : raptorGridCopyAdapter.copyToBuffer(stringBuilder, ",", "\n", RaptorGridCopyAdapter.CopyData.COPY, false);
                if (bl) {
                    return new StringSelection(stringBuilder.toString());
                }
                return null;
            }
        });
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RaptorGridTable.this.getGridModel() == null || !RaptorGridTable.this.getGridModel().allRowsFetched()) {
                    RaptorGridTable.this.fetchAllRows();
                }
            }
        }, "FetchAll", this.fetchAll, 0);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final AbstractRaptorGridModel abstractRaptorGridModel = RaptorGridTable.this.getGridModel();
                if (abstractRaptorGridModel != null) {
                    if (abstractRaptorGridModel.allRowsFetched()) {
                        RaptorGridTable.this.scrollToBottomWithSelection();
                    } else {
                        abstractRaptorGridModel.addTableModelListener(new TableModelListener(){

                            @Override
                            public void tableChanged(TableModelEvent tableModelEvent) {
                                if (tableModelEvent.getSource() == abstractRaptorGridModel && RaptorGridTable.this.getLoadedRowCount() > 0 && tableModelEvent.getFirstRow() != -1 && tableModelEvent.getColumn() == -1) {
                                    int n = RaptorGridTable.this.getLoadedRowCount() - 1;
                                    if (tableModelEvent.getType() == -1) {
                                        if (tableModelEvent.getFirstRow() - 1 != n) {
                                            return;
                                        }
                                    } else {
                                        if (tableModelEvent.getLastRow() != n) {
                                            return;
                                        }
                                        abstractRaptorGridModel.removeTableModelListener(this);
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                RaptorGridTable.this.scrollToBottomWithSelection();
                                            }
                                        });
                                        return;
                                    }
                                }
                                ((TableModel)tableModelEvent.getSource()).removeTableModelListener(this);
                            }
                        });
                        RaptorGridTable.this.fetchAllRows();
                    }
                }
            }
        }, "FetchAll", this.fetchEndAll, 0);
        this.getTableHeader().addMouseListener(this._settingsPersistor);
        this.getColumnModel().addColumnModelListener(this._settingsPersistor);
        this.getActionMap().put("copy", (Action)IdeActions.getEditCopyAction());
        this.getActionMap().put("paste", (Action)IdeActions.getEditPasteAction());
        this.getActionMap().put("cut", (Action)IdeActions.getEditCutAction());
        this.getInputMap(1).put(KeyStroke.getKeyStroke(32, 0), null);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(32, 0), null);
        this.getInputMap(0).put(KeyStroke.getKeyStroke(32, 0), null);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                Container container = ancestorEvent.getAncestorParent();
                if (container instanceof JViewport) {
                    container.setBackground(RaptorGridTable.this.getBackground());
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        this.addLocalContextMenuListener(this.tacmListener);
    }

    @Override
    public void selectAll() {
        final AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            if (abstractRaptorGridModel.allRowsFetched()) {
                super.selectAll();
            } else {
                abstractRaptorGridModel.addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent tableModelEvent) {
                        if (tableModelEvent.getSource() == abstractRaptorGridModel && RaptorGridTable.this.getLoadedRowCount() > 0 && tableModelEvent.getFirstRow() != -1 && tableModelEvent.getColumn() == -1) {
                            int n = RaptorGridTable.this.getLoadedRowCount() - 1;
                            if (tableModelEvent.getType() == -1) {
                                if (tableModelEvent.getFirstRow() - 1 != n) {
                                    return;
                                }
                            } else {
                                if (tableModelEvent.getLastRow() != n) {
                                    return;
                                }
                                abstractRaptorGridModel.removeTableModelListener(this);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        RaptorGridTable.super.selectAll();
                                    }
                                });
                                return;
                            }
                        }
                        ((TableModel)tableModelEvent.getSource()).removeTableModelListener(this);
                    }
                });
                this.fetchAllRows();
            }
        }
    }

    public RaptorGridCopyAdapter getGridCopyAdapter() {
        return this._copyAdapter;
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        this.setCellSelectionEnabled(true);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        return super.editCellAt(n, n2, eventObject);
    }

    private boolean processLocalActionKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        InputMap inputMap = this.getInputMap(n);
        ActionMap actionMap = this.getActionMap();
        if (inputMap != null && actionMap != null && this.isEnabled()) {
            Action action;
            Object object = inputMap.get(keyStroke);
            Action action2 = action = object == null ? null : actionMap.get(object);
            if (action != null) {
                return SwingUtilities.notifyAction(action, keyStroke, keyEvent, this, keyEvent.getModifiers());
            }
        }
        return false;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        boolean bl2 = this.processLocalActionKeyBinding(keyStroke, keyEvent, n, bl);
        String string = "local";
        if (!bl2) {
            if (UIUtils.isUndefined(keyStroke)) {
                bl2 = false;
                string = "undefinedKeyFilter";
            } else if (KeyUtil.isActionKey((KeyStroke)keyStroke)) {
                bl2 = false;
                string = "actionKeyFilter";
            } else if (KeyUtil.isModifierKey((KeyStroke)keyStroke)) {
                bl2 = false;
                string = "modifierKeyFilter";
            } else if (UIUtils.isAccelerator(keyStroke)) {
                bl2 = false;
                string = "acceleratorFilter";
            } else if (n == 1 && this.isFocusOwner() && 27 == keyStroke.getKeyCode()) {
                bl2 = false;
                string = "escapeKeyFilter";
            } else {
                bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
                string = "super";
            }
        }
        if (Debug.DEBUG) {
            Debug.info((Object)("RaptoGridTable.processKeyBinding(" + keyStroke.toString() + (n == 0 ? " WHEN_FOCUSED" : (n == 1 ? " WHEN_ANCESTOR_OF_FOCUSED_COMPONENT" : " CONDITION UNKNOWN")) + ") returning processed=" + bl2 + " from " + string));
        }
        return bl2;
    }

    public String getDisplayValueAt(int n, int n2, int n3) {
        String string = null;
        if (n < this.getLoadedRowCount() && n > -1 && n2 < this.getColumnCount() && n2 > -1) {
            AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
            string = abstractRaptorGridModel != null ? abstractRaptorGridModel.getDisplayValueAt(this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2), n3) : this.getValueAt(n, n2).toString();
        }
        return string;
    }

    public void setFromDisplayValueAt(String string, int n, int n2) {
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        String string2 = abstractRaptorGridModel != null ? abstractRaptorGridModel.formatDisplayValueAt(string, this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2)) : string;
        this.setValueAt(string2, n, n2);
    }

    public boolean isColumnSortingEnabled() {
        return this.isColumnSortingEnabled;
    }

    public void canSortColumns(boolean bl) {
        this.isColumnSortingEnabled = bl;
    }

    public boolean isMultiColSort() {
        if (!this.isColumnSortingEnabled) {
            return false;
        }
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            return abstractRaptorGridModel.isSortable() && this.isMultiColSort && !this.isVerticalDisplay();
        }
        return false;
    }

    public boolean canSortNow() {
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            return !abstractRaptorGridModel.isTaskRunning();
        }
        return true;
    }

    public void canMultiColSort(boolean bl) {
        this.isMultiColSort = bl;
    }

    public String getSortString() {
        if (this.getGridModel() != null) {
            return this.getGridModel().getSortString();
        }
        return null;
    }

    public boolean isFilterApplied() {
        if (this.getGridModel() != null) {
            return this.getGridModel().isFilterApplied();
        }
        return false;
    }

    public void setFilterClause(String string) {
        if (this.getGridModel() != null) {
            this.getGridModel().setFilterClause(string);
            try {
                this.refresh();
            }
            catch (ExecutionException executionException) {
                Logger.severe(this.getClass(), (Throwable)executionException);
            }
        }
    }

    public boolean canAutoFilter(int n) {
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null && !abstractRaptorGridModel.isTaskRunning()) {
            return !this.isHostedInDialog();
        }
        return false;
    }

    public String getGridUniqueName() {
        if (this.getGridModel() != null) {
            return this.getGridModel().getModelUniqueName();
        }
        return null;
    }

    public String getDefaultExportName() {
        return null;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean bl) {
        this._editable = bl;
    }

    public boolean isVerticalDisplay() {
        return this._verticalDisplay;
    }

    public void setVerticalDisplay(boolean bl) {
        this._verticalDisplay = bl;
    }

    public void savePersistentSettings() {
        RaptorGridPersistedSettings.savePersistentSettings(this);
    }

    public void deletePersistentSettings() {
        StringBuilder stringBuilder = new StringBuilder(Messages.getString("DeleteSettings.4"));
        if (RaptorGridPersistedSettings.deletePersistentSettings(this)) {
            stringBuilder.append(Messages.getString("DeleteSettings.2"));
            try {
                this.refresh();
            }
            catch (ExecutionException executionException) {
                Logger.warn(this.getClass(), (Throwable)executionException);
            }
        } else {
            stringBuilder.append(Messages.getString("DeleteSettings.3"));
        }
        MessageDialog.information((Component)this, (Object)stringBuilder, (String)Messages.getString("DeleteSettings.1"), null);
    }

    public void autoScrollColumn(Point point) {
        Rectangle rectangle = this.getVisibleRect();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (!rectangle2.contains(point)) {
            Rectangle rectangle3 = new Rectangle(point.x, point.y, 0, 0);
            this.scrollRectToVisible(rectangle3);
        }
    }

    public void scrollToRow(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, n2, true);
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            Rectangle rectangle2 = jViewport.getViewRect();
            rectangle.setLocation(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y);
            jViewport.scrollRectToVisible(rectangle);
        } else {
            this.scrollRectToVisible(rectangle);
        }
    }

    public void scrollToBottom() {
        this.scrollToBottom(false);
    }

    public void scrollToBottomWithSelection() {
        this.scrollToBottom(true);
    }

    public void scrollToBottom(boolean bl) {
        int n = this.getAdjustedLead(Axis.ROW);
        int n2 = this.getAdjustedLead(Axis.COLUMN);
        n = this.moveWithinTableRange(Axis.ROW, n, this.getLoadedRowCount());
        n2 = this.moveWithinTableRange(Axis.COLUMN, n2, 0);
        if (bl) {
            this.changeSelection(n, n2, false, false);
        }
        this.scrollToRow(n, n2);
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        int n = tableColumn.getModelIndex();
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null && (abstractRaptorGridModel.isSkipColumn(n) || abstractRaptorGridModel.isHiddenColumn(n))) {
            return;
        }
        super.addColumn(tableColumn);
        tableColumn.setHeaderRenderer(ColumnHeaderCellRenderer.INSTANCE);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (tableModelEvent.getFirstRow() == -1 && this.getGridModel() != null && this.getGridModel().getLoadedRowCount() > 0) {
            this._highlights.clear();
            RaptorGridPersistedSettings.applyPersistentSettings(this);
            this.getTableHeader().setReorderingAllowed(true);
        }
    }

    public AbstractRaptorGridModel getGridModel() {
        if (this.getModel() instanceof AbstractRaptorGridModel) {
            return (AbstractRaptorGridModel)this.getModel();
        }
        return null;
    }

    public JTable getRowHeader() {
        if (this._rowHeader == null || this.getGridModel() == null) {
            this._rowHeader = new JTable(){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    if (this.getPreferredSize().width < this.getParent().getSize().width) {
                        return this.getPreferredSize();
                    }
                    return this.getParent().getSize();
                }
            };
            this._rowHeader.setFillsViewportHeight(true);
            this._rowHeader.setRowHeight(20);
            this._rowHeader.setColumnModel(new RowHeaderTableColumnModel());
            if (this.getGridModel() != null) {
                this._rowHeader.setModel(this.getGridModel().getRowHeaderModel());
            }
            this._rowHeader.setColumnSelectionAllowed(false);
            this._rowHeader.setCellSelectionEnabled(false);
            this._rowHeader.setAutoResizeMode(0);
            this._rowHeader.setSelectionBackground(this._rowHeader.getBackground());
            this._rowHeader.setMaximumSize(new Dimension(45, Integer.MAX_VALUE));
            this._rowHeader.addHierarchyListener(new HierarchyListener(){
                private JViewport view;
                private ChangeListener cl = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        for (Container container = RaptorGridTable.this.getParent(); container != null; container = container.getParent()) {
                            if (!(container instanceof JViewport)) continue;
                            JViewport jViewport = (JViewport)container;
                            Point point = ((JViewport)changeEvent.getSource()).getViewPosition();
                            Point point2 = jViewport.getViewPosition();
                            if (point.y == point2.y) break;
                            point2.y = point.y;
                            jViewport.setViewPosition(point2);
                            break;
                        }
                    }
                };

                @Override
                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    for (Container container = RaptorGridTable.this._rowHeader.getParent(); container != null; container = container.getParent()) {
                        if (!(container instanceof JViewport)) continue;
                        if (this.view == container) break;
                        if (this.view != null) {
                            this.view.removeChangeListener(this.cl);
                        }
                        this.view = (JViewport)container;
                        this.view.setPreferredSize(RaptorGridTable.this._rowHeader.getMaximumSize());
                        this.view.addChangeListener(this.cl);
                        break;
                    }
                }
            });
            this._rowHeader.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    RaptorGridTable.this.setColumnSelectionAllowed(false);
                    RaptorGridTable.this.setRowSelectionAllowed(true);
                    ColumnAutoFit.select(RaptorGridTable.this.getSelectionModel(), mouseEvent, RaptorGridTable.this.rowAtPoint(mouseEvent.getPoint()));
                    RaptorGridTable.this.requestFocusInWindow();
                }
            });
        }
        return this._rowHeader;
    }

    public void hideColumns(List<GridColumn> list, List<GridColumn> list2) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        while (tableColumnModel.getColumnCount() > 0) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        for (GridColumn gridColumn : list) {
            gridColumn.setHidden(true);
        }
        for (int i = 0; i < list2.size(); ++i) {
            GridColumn gridColumn;
            gridColumn = list2.get(i);
            gridColumn.setHidden(false);
        }
        List<? extends GridColumn> list3 = this.getGridModel().getGridColumns();
        for (int i = 0; i < list2.size(); ++i) {
            GridColumn gridColumn = list2.get(i);
            int n = list3.indexOf(gridColumn);
            if (n == -1) continue;
            TableColumn tableColumn = new TableColumn(n);
            this.addColumn(tableColumn);
        }
        ColumnAutoFit.getInstance().restoreLast(this);
    }

    public List<GridColumn> getHiddenColumns() {
        List<GridColumn> list = new ArrayList<GridColumn>();
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            list = abstractRaptorGridModel.getHiddenCols();
        }
        return list;
    }

    public List<GridColumn> getShownColumns() {
        ArrayList<GridColumn> arrayList = new ArrayList<GridColumn>();
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        TableColumnModel tableColumnModel = this.getColumnModel();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            GridColumn gridColumn = abstractRaptorGridModel.getGridColumns().get(tableColumn.getModelIndex());
            arrayList.add(gridColumn);
        }
        return arrayList;
    }

    public void setColumnSelectorAvailable(boolean bl) {
        this.isColumnSelectorAvailable = bl;
    }

    public boolean isColumnSelectorAvailable() {
        return this.isColumnSelectorAvailable;
    }

    public boolean canColumnSelectNow() {
        return this.isColumnSelectorAvailable();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        TableCellRenderer tableCellRenderer;
        Component component;
        Object object = null;
        Point point = mouseEvent.getPoint();
        int n = this.columnAtPoint(point);
        int n2 = this.rowAtPoint(point);
        if (n != -1 && n2 != -1 && (component = this.prepareRenderer(tableCellRenderer = this.getCellRenderer(n2, n), n2, n)) instanceof JComponent) {
            Rectangle rectangle = this.getCellRect(n2, n, false);
            if (rectangle.width >= component.getPreferredSize().width) {
                return null;
            }
            point.translate(-rectangle.x, -rectangle.y);
            MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            object = ((JComponent)component).getToolTipText(mouseEvent2);
        }
        if (object == null) {
            object = this.getToolTipText();
        }
        if (object == null) {
            object = this.getDisplayValueAt(n2, n, Integer.MAX_VALUE);
        }
        if (object != null) {
            if (((String)object).length() == 0) {
                object = null;
            }
            if (((String)object).length() > 1024) {
                object = ((String)object).substring(0, 1021) + "...";
            }
        }
        return object;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        if (n == -1) {
            return null;
        }
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n2 == -1) {
            return null;
        }
        boolean bl = this.getToolTipText() == null ? this.getToolTipText(mouseEvent) != null : true;
        return bl ? this.getCellRect(n, n2, false).getLocation() : null;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new GridColumnHeader(this.columnModel);
    }

    protected void fetchAllRows() {
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            try {
                abstractRaptorGridModel.fetchAllRows(true);
            }
            catch (ExecutionException executionException) {
                Logger.warn(this.getClass(), (Throwable)executionException);
            }
        }
    }

    public void refresh() throws ExecutionException {
        this.clearSelection();
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            this.getTableHeader().setReorderingAllowed(false);
            abstractRaptorGridModel.refresh();
        } else {
            Logger.severe(this.getClass(), (String)Messages.getString("RaptorGridTable.4"));
        }
    }

    public static void addGridContextMenu(GridContextMenuItem gridContextMenuItem) {
        _gridCM.addContextMenuListener((ContextMenuListener)gridContextMenuItem);
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)gridContextMenuItem);
    }

    public static void addColumnHeaderContextMenu(GridHeaderContextMenuItem gridHeaderContextMenuItem) {
        _columnHeaderCM.addContextMenuListener((ContextMenuListener)gridHeaderContextMenuItem);
    }

    public static void removeGridContextMenu(GridContextMenuItem gridContextMenuItem) {
        _gridCM.removeContextMenuListener((ContextMenuListener)gridContextMenuItem);
    }

    public static void removeColumnHeaderContextMenu(GridHeaderContextMenuItem gridHeaderContextMenuItem) {
        _columnHeaderCM.removeContextMenuListener((ContextMenuListener)gridHeaderContextMenuItem);
    }

    @Override
    protected Component overlayHightlightColor(Component component, int n, int n2) {
        component = super.overlayHightlightColor(component, n, n2);
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (!this.isCellSelected(n, n2) && abstractRaptorGridModel != null && component != null) {
            Color color = abstractRaptorGridModel.getRowHighlightColor(this.convertRowIndexToModel(n));
            if (color != null) {
                component.setBackground(color);
            } else {
                Color color2 = component.getBackground();
                if (color2 != color) {
                    component.setBackground(color2);
                }
            }
        }
        return component;
    }

    @Override
    protected Component overlayValueColor(Component component, int n, int n2) {
        component = super.overlayValueColor(component, n, n2);
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (!this.isCellSelected(n, n2) && abstractRaptorGridModel != null && component != null) {
            for (RaptorGridSearchParameter raptorGridSearchParameter : this.getSearchParams(false)) {
                Color color;
                if (raptorGridSearchParameter == null || !raptorGridSearchParameter.matches(this, n, n2) || (color = raptorGridSearchParameter.getColor()) == null) continue;
                component.setBackground(color);
            }
        }
        return component;
    }

    public List<RaptorGridSearchParameter> getSearchParams(boolean bl) {
        if (!bl) {
            return this._highlights;
        }
        ArrayList<RaptorGridSearchParameter> arrayList = new ArrayList<RaptorGridSearchParameter>();
        for (RaptorGridSearchParameter raptorGridSearchParameter : this._highlights) {
            if (!raptorGridSearchParameter.isPersist()) continue;
            arrayList.add(raptorGridSearchParameter);
        }
        return arrayList;
    }

    public void addHighLightParam(RaptorGridSearchParameter raptorGridSearchParameter) {
        this._highlights.add(raptorGridSearchParameter);
        if (raptorGridSearchParameter.isPersist()) {
            RaptorGridPersistedSettings.savePersistentSettings(this);
        }
    }

    public void removeHighLightParam(RaptorGridSearchParameter raptorGridSearchParameter) {
        this._highlights.remove(raptorGridSearchParameter);
        if (raptorGridSearchParameter.isPersist()) {
            RaptorGridPersistedSettings.savePersistentSettings(this);
        }
    }

    public int getLoadedRowCount() {
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            return abstractRaptorGridModel.getLoadedRowCount();
        }
        return this.getRowCount();
    }

    public boolean allRowsFetched() {
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            return abstractRaptorGridModel.allRowsFetched();
        }
        return true;
    }

    public void closeModel() {
        ContextMenuListener contextMenuListener;
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            abstractRaptorGridModel.closeModel();
        }
        List list = _gridCM.getContextMenuListeners();
        for (Pair object : list) {
            contextMenuListener = (ContextMenuListener)object.second;
            if (contextMenuListener == null || !(contextMenuListener instanceof GridContextMenuItem)) continue;
            ((GridContextMenuItem)contextMenuListener).releaseGrid();
        }
        list = _columnHeaderCM.getContextMenuListeners();
        for (Pair pair : list) {
            contextMenuListener = (ContextMenuListener)pair.second;
            if (contextMenuListener == null || !(contextMenuListener instanceof GridContextMenuItem)) continue;
            ((GridContextMenuItem)contextMenuListener).releaseGrid();
        }
        if (this._localCTXMenuItems != null) {
            for (GridContextMenuItem gridContextMenuItem : this._localCTXMenuItems) {
                gridContextMenuItem.releaseGrid();
            }
            this._localCTXMenuItems.clear();
        }
        this.removeIdeActionController();
        _gridCM.removeContextMenuListener(this.cmListener);
        this.toolbar = null;
    }

    private static synchronized void initStatics() {
        if (!_initedStatics) {
            _initedStatics = true;
            RaptorGridTable.addGridContextMenu(SingleRecordView.getInstance());
            RaptorGridTable.addGridContextMenu(CountRows.getInstance());
            RaptorGridTable.addGridContextMenu(FindHighlight.getInstance());
            RaptorGridTable.addGridContextMenu(HeaderMenu.getInstance());
            RaptorGridTable.addColumnHeaderContextMenu(ColumnAutoFit.getInstance());
            RaptorGridTable.addColumnHeaderContextMenu(ColumnSelector.getInstance());
            RaptorGridTable.addColumnHeaderContextMenu(GridSorter.getInstance());
            RaptorGridTable.addColumnHeaderContextMenu(DeleteSettings.getInstance());
            RaptorGridTable.addColumnHeaderContextMenu(CopyColumnHeader.getInstance());
            _initedStatics = true;
        }
    }

    public ArrayList<GridContextMenuItem> getLocalContextMenuListeners() {
        return this._localCTXMenuItems;
    }

    public void addLocalContextMenuListener(GridContextMenuItem gridContextMenuItem) {
        if (this._localCTXMenuItems == null) {
            this._localCTXMenuItems = new ArrayList();
        }
        this._localCTXMenuItems.add(gridContextMenuItem);
    }

    public ContextMenu getHeaderContextMenu() {
        return _columnHeaderCM;
    }

    public void allowContextMenu(boolean bl) {
        this._allowContextMenu = bl;
    }

    public ContextMenu getContextMenu() {
        if (this._allowContextMenu) {
            return _gridCM;
        }
        return null;
    }

    public View getView() {
        return this._view;
    }

    public void setView(View view) {
        this._view = view;
    }

    public boolean isHostedInDialog() {
        if (this._isHostedInDialog == null) {
            for (Container container = this; container != null; container = container.getParent()) {
                if (!(container instanceof Dialog)) continue;
                this._isHostedInDialog = Boolean.TRUE;
                break;
            }
            if (this._isHostedInDialog == null) {
                this._isHostedInDialog = Boolean.FALSE;
            }
        }
        return this._isHostedInDialog;
    }

    @Override
    public void setModel(TableModel tableModel) {
        this.addIdeActionController();
        super.setModel(tableModel);
    }

    private void initIdeActions() {
        if (null == this.ideActions) {
            this.ideActions = new IdeAction[]{IdeActions.getEditCopyAction(), IdeActions.getEditPasteAction(), IdeActions.getEditCutAction(), IdeActions.getEditSelectAllAction(), IdeActions.getSearchFindAction()};
        }
    }

    private void addIdeActionController() {
        this.initIdeActions();
        for (IdeAction ideAction : this.ideActions) {
            ideAction.addController(this.controller);
        }
    }

    private void removeIdeActionController() {
        this.initIdeActions();
        for (IdeAction ideAction : this.ideActions) {
            ideAction.removeController(this.controller);
        }
    }

    public Controller getController() {
        return this.controller;
    }

    private void updateIdeActions() {
        this.initIdeActions();
        for (IdeAction ideAction : this.ideActions) {
            ideAction.updateAction();
        }
    }

    public RowSelectionIterator iterator() {
        RowSelectionIterator rowSelectionIterator = null;
        if (this.getColumnSelectionAllowed() && !this.getRowSelectionAllowed()) {
            rowSelectionIterator = new AllRowsIterator(new ColumnAllowedSelectionIterator());
        } else if (!this.getColumnSelectionAllowed() && this.getRowSelectionAllowed()) {
            rowSelectionIterator = new RowAllowedSelectionIterator(new AllColumnsIterator());
        } else if (this.getCellSelectionEnabled()) {
            if (this.getSelectionModel().getSelectionMode() == 0 && this.getColumnModel().getSelectionModel().getSelectionMode() == 0) {
                rowSelectionIterator = new SingleRowIterator(new SingleColumnIterator());
            } else {
                int n;
                int n2 = this.getSelectedColumn();
                int n3 = this.getColumnModel().getSelectionModel().getMaxSelectionIndex();
                MultiColumnIterator multiColumnIterator = new MultiColumnIterator(n2, n3);
                int n4 = this.getSelectedRow();
                rowSelectionIterator = n4 == (n = this.getSelectionModel().getMaxSelectionIndex()) ? new SingleRowIterator(multiColumnIterator, n) : new MultiRowIterator(multiColumnIterator, n4, n);
            }
        }
        return rowSelectionIterator;
    }

    public boolean isFilterFieldAllowed() {
        return this._isFilterFieldAllowed;
    }

    public void setFilterFieldAllowed(boolean bl) {
        this._isFilterFieldAllowed = bl;
    }

    public boolean isRefreshAllowed() {
        return this._isRefreshAllowed;
    }

    public void setRefreshAllowed(boolean bl) {
        this._isRefreshAllowed = bl;
    }

    private int moveWithinTableRange(Axis axis, int n, int n2) {
        switch (axis) {
            case ROW: {
                return RaptorGridTable.clipToRange(n + n2, 0, this.getRowCount());
            }
        }
        return RaptorGridTable.clipToRange(n + n2, 0, this.getColumnCount());
    }

    private static int clipToRange(int n, int n2, int n3) {
        return Math.min(Math.max(n, n2), n3 - 1);
    }

    private int getAdjustedLead(Axis axis, ListSelectionModel listSelectionModel) {
        int n = listSelectionModel.getLeadSelectionIndex();
        int n2 = axis == Axis.ROW ? this.getLoadedRowCount() : this.getColumnCount();
        return n < n2 ? n : -1;
    }

    private int getAdjustedLead(Axis axis) {
        return axis == Axis.ROW ? this.getAdjustedLead(axis, this.getSelectionModel()) : this.getAdjustedLead(axis, this.getColumnModel().getSelectionModel());
    }

    @Override
    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Object object = this.getValueAt(n, n2);
        return _GHOST_VALUE != object ? super.prepareEditor(tableCellEditor, n, n2) : null;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Object object = this.getValueAt(n, n2);
        TableCellRenderer tableCellRenderer2 = _GHOST_VALUE == object ? _GHOST_RENDERER : tableCellRenderer;
        return super.prepareRenderer(tableCellRenderer2, n, n2);
    }

    @Override
    protected ListSelectionModel createDefaultSelectionModel() {
        return new DefaultListSelectionModel(){

            @Override
            public void insertIndexInterval(int n, int n2, boolean bl) {
                int n3 = this.getLeadSelectionIndex();
                int n4 = RaptorGridTable.this.getRowCount() - 1;
                int n5 = -1;
                if ((n3 > n || bl && n3 == n) && n4 < n3 + n2) {
                    n5 = n3;
                    this.setLeadSelectionIndex(bl ? n - 1 : n);
                }
                super.insertIndexInterval(n, n2, bl);
                if (n5 > -1) {
                    this.setLeadSelectionIndex(n5 < n4 ? n5 : n4);
                }
            }
        };
    }

    static {
        UIUtils.addMnemonicSolver(_gridCM);
        _columnHeaderCM = new ContextMenu();
        _contextMenuMouseListener = null;
        lastGridNum = 0;
    }

    private class RaptorGridSettingsPersistor
    extends MouseAdapter
    implements TableColumnModelListener {
        private boolean colMoved = false;
        private boolean marginChanged = false;
        private int movedFrom = -1;
        private int movedTo = -1;

        private RaptorGridSettingsPersistor() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            if (tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex()) {
                this.colMoved = true;
                this.movedFrom = tableColumnModelEvent.getFromIndex();
                this.movedTo = tableColumnModelEvent.getToIndex();
                if (this.movedFrom == this.movedTo || this.movedFrom == -1 || this.movedTo != -1) {
                    // empty if block
                }
                this.movedFrom = -1;
                this.movedTo = -1;
            }
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            this.marginChanged = true;
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.colMoved || this.marginChanged) {
                this.colMoved = false;
                this.marginChanged = false;
                RaptorGridTable.this.savePersistentSettings();
            }
        }
    }

    class FireUpdateIdeActionsListener
    implements AncestorListener,
    FocusListener {
        FireUpdateIdeActionsListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.fireUpdateIdeActions();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            if (!RaptorGridTable.this.showing) {
                RaptorGridTable.this.showing = true;
                this.fireUpdateIdeActions();
            }
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            RaptorGridTable.this.showing = false;
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        private void fireUpdateIdeActions() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RaptorGridTable.this.updateIdeActions();
                }
            });
        }
    }

    protected static enum Axis {
        ROW,
        COLUMN;

    }

    protected class RowHeaderTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 1L;

        protected RowHeaderTableColumnModel() {
        }

        @Override
        public TableColumn getColumn(int n) {
            if (n < this.getColumnCount()) {
                return (TableColumn)this.tableColumns.elementAt(n);
            }
            return null;
        }

        @Override
        public void addColumn(TableColumn tableColumn) {
            if (tableColumn.getModelIndex() == 0) {
                tableColumn.setCellRenderer(RowHeaderCellRenderer.INSTANCE);
                tableColumn.setMaxWidth(45);
                super.addColumn(tableColumn);
            }
        }
    }

    protected class GridColumnHeader
    extends JTableHeader {
        public GridColumnHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
            this.registerKeyboardAction(RaptorGridTable.this._copyPasteListener, "Copy.With.Header", RaptorGridTable.this.copyWithHeader, 0);
            this.registerKeyboardAction(RaptorGridTable.this._copyPasteListener, "Copy.Header", RaptorGridTable.this.copyHeader, 0);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.columnAtPoint(point);
            int n2 = RaptorGridTable.this.rowAtPoint(point);
            Rectangle rectangle = RaptorGridTable.this.getCellRect(n2, n, false);
            int n3 = this.columnModel.getColumnIndexAtX(point.x);
            AbstractRaptorGridModel abstractRaptorGridModel = RaptorGridTable.this.getGridModel();
            if (n3 != -1 && abstractRaptorGridModel != null) {
                String string = abstractRaptorGridModel.getColumnName(RaptorGridTable.this.convertColumnIndexToModel(n3));
                int n4 = new Double(new JLabel(string).getPreferredSize().getWidth()).intValue();
                return rectangle.width > n4 ? null : string;
            }
            return null;
        }
    }

    protected class AllRowsIterator
    extends RowRangeIterator {
        protected AllRowsIterator(ColumnSelectionIterator columnSelectionIterator) {
            super(columnSelectionIterator, RaptorGridTable.this.getRowCount() > 0 ? 0 : -1, RaptorGridTable.this.getRowCount() > 0 ? RaptorGridTable.this.getRowCount() - 1 : -1);
        }
    }

    protected class ColumnAllowedSelectionIterator
    extends ColumnSelectionIterator {
        protected ArrayList<Integer> selectedColumns;

        protected ColumnAllowedSelectionIterator(int n, int[] nArray) {
            super(n);
            this.setNext(n, nArray);
        }

        protected ColumnAllowedSelectionIterator(int[] nArray) {
            this(-1, nArray);
        }

        protected ColumnAllowedSelectionIterator() {
            this(raptorGridTable.getSelectedColumns());
        }

        @Override
        public ColumnAllowedSelectionIterator clone() {
            ColumnAllowedSelectionIterator columnAllowedSelectionIterator = (ColumnAllowedSelectionIterator)super.clone();
            columnAllowedSelectionIterator.selectedColumns = (ArrayList)this.selectedColumns.clone();
            return columnAllowedSelectionIterator;
        }

        @Override
        public int getColumnCount() {
            return this.selectedColumns != null ? this.selectedColumns.size() : 0;
        }

        @Override
        public int[] getSelectedColumns() {
            if (this.selectedColumns == null) {
                return new int[0];
            }
            int[] nArray = new int[this.selectedColumns.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.selectedColumns.get(i);
            }
            return nArray;
        }

        public void setNext(int n, int[] nArray) {
            this.setNext(n);
            if (nArray == null) {
                this.selectedColumns = null;
            } else {
                this.selectedColumns = new ArrayList(nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    this.selectedColumns.add(nArray[i]);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.selectedColumns.size() > 0 && this.pos < this.selectedColumns.size() - 1;
        }

        @Override
        public Integer next() {
            if (this.hasNext()) {
                return this.selectedColumns.get(++this.pos);
            }
            return -1;
        }
    }

    public abstract class ColumnSelectionIterator
    implements Iterator,
    Cloneable {
        protected int rowIndex;
        protected int pos = -1;

        protected ColumnSelectionIterator(int n) {
            this.rowIndex = n;
        }

        protected ColumnSelectionIterator() {
            this(-1);
        }

        public ColumnSelectionIterator clone() {
            try {
                ColumnSelectionIterator columnSelectionIterator = (ColumnSelectionIterator)super.clone();
                columnSelectionIterator.rowIndex = this.rowIndex;
                columnSelectionIterator.pos = this.pos;
                return columnSelectionIterator;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public abstract int getColumnCount();

        public abstract int[] getSelectedColumns();

        public void setNext(int n) {
            this.pos = -1;
            this.rowIndex = n;
        }

        @Override
        public abstract boolean hasNext();

        public abstract Integer next();

        @Override
        public void remove() {
        }
    }

    protected class RowAllowedSelectionIterator
    extends RowSelectionIterator {
        int[] selectedRows;

        protected RowAllowedSelectionIterator(ColumnSelectionIterator columnSelectionIterator, int[] nArray) {
            super(columnSelectionIterator);
            this.selectedRows = (int[])nArray.clone();
        }

        protected RowAllowedSelectionIterator(ColumnSelectionIterator columnSelectionIterator) {
            this(columnSelectionIterator, raptorGridTable.getSelectedRows());
        }

        @Override
        public RowAllowedSelectionIterator clone() {
            RowAllowedSelectionIterator rowAllowedSelectionIterator = (RowAllowedSelectionIterator)super.clone();
            rowAllowedSelectionIterator.selectedRows = (int[])this.selectedRows.clone();
            return rowAllowedSelectionIterator;
        }

        @Override
        public int getRowCount() {
            return this.selectedRows != null ? this.selectedRows.length : 0;
        }

        @Override
        public boolean hasNext() {
            return this.selectedRows.length > 0 && this.pos < this.selectedRows.length - 1;
        }

        @Override
        public ColumnSelectionIterator next() {
            if (this.hasNext()) {
                this.currentIterator.setNext(this.selectedRows[++this.pos]);
                return this.currentIterator;
            }
            return null;
        }
    }

    protected class AllColumnsIterator
    extends ColumnRangeIterator {
        protected AllColumnsIterator() {
            super(-1, RaptorGridTable.this.getColumnCount() > 0 ? 0 : -1, RaptorGridTable.this.getColumnCount() > 0 ? RaptorGridTable.this.getColumnCount() - 1 : -1);
        }
    }

    protected class SingleRowIterator
    extends RowRangeIterator {
        protected SingleRowIterator(ColumnSelectionIterator columnSelectionIterator, int n) {
            super(columnSelectionIterator, n, n);
        }

        protected SingleRowIterator(ColumnSelectionIterator columnSelectionIterator) {
            this(columnSelectionIterator, raptorGridTable.getSelectedRow());
        }
    }

    protected class SingleColumnIterator
    extends ColumnRangeIterator {
        protected SingleColumnIterator(int n, int n2) {
            super(n, n2, n2);
        }

        protected SingleColumnIterator(int n) {
            this(-1, n);
        }

        protected SingleColumnIterator() {
            this(raptorGridTable.getSelectedColumn());
        }
    }

    protected class MultiColumnIterator
    extends ColumnAllowedSelectionIterator {
        protected int firstIndex;
        protected int lastIndex;
        protected boolean hasColumns;

        protected MultiColumnIterator(int n, int n2, int n3) {
            super(n, null);
            if (!(n2 >= 0 && n3 >= n2 && n3 <= RaptorGridTable.this.getColumnCount() - 1 || n2 == -1 && n3 == -1)) {
                throw new IllegalArgumentException();
            }
            this.firstIndex = n2;
            this.lastIndex = n3;
            this.hasColumns = false;
        }

        protected MultiColumnIterator(int n, int n2) {
            this(-1, n, n2);
        }

        @Override
        public MultiColumnIterator clone() {
            MultiColumnIterator multiColumnIterator = (MultiColumnIterator)super.clone();
            multiColumnIterator.firstIndex = this.firstIndex;
            multiColumnIterator.lastIndex = this.lastIndex;
            multiColumnIterator.hasColumns = this.hasColumns;
            return multiColumnIterator;
        }

        protected void scanRow() {
            boolean bl;
            boolean bl2 = bl = this.selectedColumns != null;
            if (!bl) {
                this.selectedColumns = new ArrayList();
            }
            for (int i = this.firstIndex; i > -1 && i <= this.lastIndex; ++i) {
                if (!RaptorGridTable.this.isCellSelected(this.rowIndex, i)) continue;
                if (!bl) {
                    this.selectedColumns.add(i);
                }
                this.hasColumns = true;
            }
        }

        @Override
        public void setNext(int n) {
            super.setNext(n);
            this.hasColumns = false;
            if (n != -1) {
                this.scanRow();
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasColumns ? super.hasNext() : false;
        }
    }

    protected class MultiRowIterator
    extends RowRangeIterator {
        protected ColumnSelectionIterator nextIterator;

        protected MultiRowIterator(ColumnSelectionIterator columnSelectionIterator, int n, int n2) {
            super(null, n, n2);
            this.nextIterator = columnSelectionIterator;
        }

        @Override
        public MultiRowIterator clone() {
            MultiRowIterator multiRowIterator = (MultiRowIterator)super.clone();
            multiRowIterator.nextIterator = this.nextIterator != null ? this.nextIterator.clone() : null;
            return multiRowIterator;
        }

        @Override
        public int getRowCount() {
            if (this.firstIndex == -1) {
                return 0;
            }
            if (RaptorGridTable.this.getRowCount() < 2) {
                return RaptorGridTable.this.getRowCount();
            }
            return -1;
        }

        @Override
        public boolean hasNext() {
            int n;
            int n2 = n = this.pos < this.firstIndex ? this.firstIndex : this.pos + 1;
            while (n <= this.lastIndex) {
                if (this.nextIterator == null) {
                    this.nextIterator = this.currentIterator.clone();
                }
                this.nextIterator.setNext(n++);
                if (!this.nextIterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public ColumnSelectionIterator next() {
            if (this.hasNext()) {
                ColumnSelectionIterator columnSelectionIterator = this.currentIterator;
                this.currentIterator = this.nextIterator;
                this.nextIterator = columnSelectionIterator;
                this.pos = this.currentIterator.getRowIndex();
                return this.currentIterator;
            }
            return null;
        }
    }

    protected class RowRangeIterator
    extends RowSelectionIterator {
        protected int firstIndex;
        protected int lastIndex;

        protected RowRangeIterator(ColumnSelectionIterator columnSelectionIterator, int n, int n2) {
            super(columnSelectionIterator);
            if (!(n >= 0 && n2 >= n && n2 <= RaptorGridTable.this.getRowCount() - 1 || n == -1 && n2 == -1)) {
                throw new IllegalArgumentException();
            }
            this.firstIndex = n;
            this.lastIndex = n2;
        }

        @Override
        public RowRangeIterator clone() {
            RowRangeIterator rowRangeIterator = (RowRangeIterator)super.clone();
            rowRangeIterator.firstIndex = this.firstIndex;
            rowRangeIterator.lastIndex = this.lastIndex;
            return rowRangeIterator;
        }

        @Override
        public int getRowCount() {
            return this.firstIndex != -1 ? this.lastIndex - this.firstIndex + 1 : 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.lastIndex;
        }

        @Override
        public ColumnSelectionIterator next() {
            if (this.hasNext()) {
                this.pos = this.pos < this.firstIndex ? this.firstIndex : this.pos + 1;
                this.currentIterator.setNext(this.pos);
                return this.currentIterator;
            }
            return null;
        }
    }

    public abstract class RowSelectionIterator
    implements Iterator,
    Cloneable {
        protected ColumnSelectionIterator currentIterator;
        protected int pos;

        protected RowSelectionIterator(ColumnSelectionIterator columnSelectionIterator) {
            this.currentIterator = columnSelectionIterator;
            this.pos = -1;
        }

        public RowSelectionIterator clone() {
            try {
                RowSelectionIterator rowSelectionIterator = (RowSelectionIterator)super.clone();
                rowSelectionIterator.currentIterator = this.currentIterator != null ? this.currentIterator.clone() : null;
                rowSelectionIterator.pos = this.pos;
                return rowSelectionIterator;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public abstract int getRowCount();

        @Override
        public abstract boolean hasNext();

        public abstract ColumnSelectionIterator next();

        @Override
        public void remove() {
        }
    }

    protected class ColumnRangeIterator
    extends ColumnSelectionIterator {
        protected int firstIndex;
        protected int lastIndex;

        protected ColumnRangeIterator(int n, int n2, int n3) {
            super(n);
            if (!(n2 >= 0 && n3 >= n2 && n3 <= RaptorGridTable.this.getColumnCount() - 1 || n2 == -1 && n3 == -1)) {
                throw new IllegalArgumentException();
            }
            this.firstIndex = n2;
            this.lastIndex = n3;
        }

        protected ColumnRangeIterator(int n, int n2) {
            this(-1, n, n2);
        }

        @Override
        public ColumnRangeIterator clone() {
            ColumnRangeIterator columnRangeIterator = (ColumnRangeIterator)super.clone();
            columnRangeIterator.firstIndex = this.firstIndex;
            columnRangeIterator.lastIndex = this.lastIndex;
            return columnRangeIterator;
        }

        @Override
        public int getColumnCount() {
            return this.firstIndex != -1 ? this.lastIndex - this.firstIndex + 1 : 0;
        }

        @Override
        public int[] getSelectedColumns() {
            int[] nArray = new int[this.getColumnCount()];
            int n = this.firstIndex;
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = n++;
            }
            return nArray;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.lastIndex;
        }

        @Override
        public Integer next() {
            if (this.hasNext()) {
                this.pos = this.pos < this.firstIndex ? this.firstIndex : this.pos + 1;
                return this.pos;
            }
            return -1;
        }
    }

    protected static class RowHeaderCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        static final RowHeaderCellRenderer INSTANCE = new RowHeaderCellRenderer();

        protected RowHeaderCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setHorizontalAlignment(4);
            Border border = jLabel.getBorder();
            if (border != null) {
                border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 0, 0, 2));
            }
            jLabel.setBorder(border);
            return jLabel;
        }
    }
}

