/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.dbtools.raptor.metrics.panel.Namespace;

public abstract class AbstractNamespaceObject
implements Namespace {
    @Override
    public Object get(String string) {
        Map<String, Object> map = this.getNamedObjectMap();
        if (!map.containsKey(string)) {
            Logger.getLogger(AbstractNamespaceObject.class.getName()).log(Level.WARNING, "named value not found: ''{0}''", string);
            return null;
        }
        return map.get(string);
    }

    @Override
    public Object get(String string, Object object) {
        Object object2 = this.getNamedObjectMap().get(string);
        if (object2 == null) {
            object2 = object;
        }
        return object2;
    }

    @Override
    public <T> T get(Class<T> clazz, String string) {
        Object object = this.get(string);
        if (object != null) {
            if (clazz.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            Logger.getLogger(AbstractNamespaceObject.class.getName()).log(Level.WARNING, "named value of type ''{0}'' not found: ''{1}''", new Object[]{clazz.getSimpleName(), string});
        }
        return null;
    }

    @Override
    public <T> T get(Class<T> clazz, String string, T t) {
        Object object = this.get(string, t);
        if (object != null) {
            if (clazz.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            Logger.getLogger(AbstractNamespaceObject.class.getName()).log(Level.WARNING, "named value has incorrect type: ''{1}''", new Object[]{string});
            return t;
        }
        return null;
    }

    @Override
    public Collection<String> getNames() {
        return this.getNamedObjectMap().keySet();
    }

    @Override
    public Collection<Object> getObjects() {
        return this.getNamedObjectMap().values();
    }

    @Override
    public <T> Collection<T> getObjects(Class<T> clazz) {
        return this.getObjects().stream().filter(object -> clazz.isAssignableFrom(object.getClass())).collect(Collectors.toList());
    }

    protected abstract Map<String, Object> getNamedObjectMap();
}

