/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.SplitPane;
import oracle.dbtools.raptor.metrics.engine.DXListenerList;
import oracle.dbtools.raptor.metrics.facet.Monitor;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.InstanceListener;
import oracle.dbtools.raptor.metrics.panel.PanelTemplate;
import oracle.dbtools.raptor.metrics.panel.TemplateInstance;

@DefaultProperty(value="panelTemplates")
public class SplitPaneMonitor
implements Monitor {
    private final List<TemplateInstance<Parent>> instances = new ArrayList<TemplateInstance<Parent>>();
    private final ObservableList<PanelTemplate<Parent>> panelTemplates = FXCollections.observableArrayList();

    public SplitPaneMonitor() {
        this.init(new Listener());
    }

    public ObservableList<PanelTemplate<Parent>> getPanelTemplates() {
        return this.panelTemplates;
    }

    @Override
    public Class<?> getBindToClass() {
        return SplitPane.class;
    }

    protected class Listener
    implements InstanceListener {
        protected Listener() {
        }

        @Override
        public void onOpen(Context context) {
            SplitPane splitPane = context.getLinkedTarget(SplitPane.class, SplitPaneMonitor.this);
            ArrayList<Node> arrayList = new ArrayList<Node>(SplitPaneMonitor.this.instances.size());
            for (PanelTemplate panelTemplate : SplitPaneMonitor.this.getPanelTemplates()) {
                TemplateInstance templateInstance = panelTemplate.newPanel();
                if (templateInstance == null) continue;
                SplitPaneMonitor.this.instances.add(templateInstance);
                arrayList.add((Node)templateInstance.getRootObject());
            }
            splitPane.getItems().setAll(arrayList);
        }

        @Override
        public void onStart(Context context, DXListenerList dXListenerList) {
            for (TemplateInstance<Parent> templateInstance : SplitPaneMonitor.this.instances) {
                templateInstance.getContext().setDataStreamEnabled(true);
            }
        }

        @Override
        public void onStop(Context context, DXListenerList dXListenerList) {
            for (TemplateInstance<Parent> templateInstance : SplitPaneMonitor.this.instances) {
                templateInstance.getContext().setDataStreamEnabled(false);
            }
        }
    }
}

