/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.Map;
import javafx.beans.DefaultProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TableCell;
import oracle.dbtools.raptor.metrics.engine.DXListenerList;
import oracle.dbtools.raptor.metrics.facet.AbstractCellFactory;
import oracle.dbtools.raptor.metrics.facet.EnumCellHelper;
import oracle.dbtools.raptor.metrics.facet.EnumItem;
import oracle.dbtools.raptor.metrics.facet.TableCellFactory;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.TemplateInstance;

@DefaultProperty(value="enumItems")
public class EnumCellFactory
extends TableCellFactory<TableCell<DXRow, String>> {
    private final EnumCellHelper<?, ?> helper = new EnumCellHelper();

    public EnumCellFactory() {
        this.init(new Listener());
    }

    public ObservableList<EnumItem> getEnumItems() {
        return this.helper.getEnumItems();
    }

    @Override
    protected TableCell<DXRow, String> createCell() {
        return new TableCell<DXRow, String>(){
            private final Map<String, TemplateInstance<Parent>> panelMap;
            {
                this.panelMap = EnumCellFactory.this.helper.createPanelMap();
            }

            public void updateItem(String string, boolean bl) {
                super.updateItem((Object)string, bl);
                if (bl) {
                    this.setGraphic(null);
                } else {
                    TemplateInstance<Parent> templateInstance = this.panelMap.get(string);
                    this.setGraphic(templateInstance != null ? (Node)templateInstance.getRootObject() : null);
                }
                EnumCellFactory.this.updateCellText(this, bl);
                EnumCellFactory.this.updateCellTooltip(this, bl);
            }
        };
    }

    @Override
    protected boolean useValueColumnAsDefaultTextColumn() {
        return false;
    }

    protected class Listener
    extends AbstractCellFactory.Listener {
        protected Listener() {
        }

        @Override
        public void onStart(Context context, DXListenerList dXListenerList) {
            EnumCellFactory.this.helper.startPanelMaps();
        }

        @Override
        public void onStop(Context context, DXListenerList dXListenerList) {
            EnumCellFactory.this.helper.stopPanelMaps();
        }
    }
}

