/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.ChoiceBox;
import oracle.dbtools.raptor.metrics.facet.EditableMonitor;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.DataObject;
import oracle.dbtools.raptor.metrics.panel.StringDataObject;

@DefaultProperty(value="item")
public class ChoiceBoxMonitor
extends EditableMonitor {
    private ChangeListener<String> changeListener;
    private final ObjectProperty<StringDataObject> itemProperty = new SimpleObjectProperty((Object)this, "item");

    public ChoiceBoxMonitor() {
        this.init(new Listener());
    }

    public StringDataObject getItem() {
        return (StringDataObject)this.itemProperty.get();
    }

    public void setItem(StringDataObject stringDataObject) {
        this.itemProperty.set((Object)stringDataObject);
    }

    public ObjectProperty<StringDataObject> itemProperty() {
        return this.itemProperty;
    }

    @Override
    public Class<?> getBindToClass() {
        return ChoiceBox.class;
    }

    @Override
    public List<DataObject<?>> getDataObjects(Context context) {
        return Collections.singletonList(this.getItem());
    }

    protected class Listener
    extends EditableMonitor.Listener {
        protected Listener() {
            super(ChoiceBoxMonitor.this);
        }

        @Override
        public void onOpen(Context context) {
            ChoiceBox choiceBox = context.getLinkedTarget(ChoiceBox.class, ChoiceBoxMonitor.this);
            ChoiceBoxMonitor.this.changeListener = (observableValue, string, string2) -> {
                if (ChoiceBoxMonitor.this.onUpdate()) {
                    choiceBox.getSelectionModel().select(string2);
                }
            };
            ChoiceBoxMonitor.this.getItem().valueProperty().addListener(ChoiceBoxMonitor.this.changeListener);
        }

        @Override
        public void onClose(Context context) {
            ChoiceBoxMonitor.this.getItem().valueProperty().removeListener(ChoiceBoxMonitor.this.changeListener);
        }
    }
}

