/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.metrics.engine.ItemInstance;
import oracle.dbtools.raptor.metrics.engine.ItemType;
import oracle.dbtools.raptor.metrics.engine.JobInstance;

class JobPartition {
    private final JobInstance job;
    private final Map<String, String> parameters;
    private Map<String, ItemInstance> itemMap;
    private int itemPinnedCount;
    private boolean runAtLeastOnce;

    JobPartition(JobInstance jobInstance, Map<String, String> map) {
        this.job = jobInstance;
        this.parameters = map;
    }

    JobInstance getJob() {
        return this.job;
    }

    Map<String, String> getParameters() {
        return this.parameters;
    }

    Collection<ItemInstance> getItems() {
        return this.itemMap().values();
    }

    boolean hasRunAtLeastOnce() {
        return this.runAtLeastOnce;
    }

    void setRunAtLeastOnce(boolean bl) {
        this.runAtLeastOnce = bl;
    }

    ItemInstance getItem(String string) {
        return this.itemMap().get(string);
    }

    void onItemPinned() {
        ++this.itemPinnedCount;
    }

    void onItemUnpinned() {
        --this.itemPinnedCount;
        if (this.itemPinnedCount == 0) {
            this.job.removePartition(this.parameters);
        }
    }

    private Map<String, ItemInstance> itemMap() {
        if (this.itemMap == null) {
            this.itemMap = new HashMap<String, ItemInstance>();
            Map<String, String> map = this.job.getSource().getParameters();
            for (ItemType itemType : this.job.getRunnableType().itemTypeMap().values()) {
                ItemInstance itemInstance = itemType.createItem(this.job.getContext(), this, map, this.parameters);
                this.itemMap.put(itemType.getPath(), itemInstance);
            }
        }
        return this.itemMap;
    }
}

