/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.util.logging.Logger;
import oracle.dbtools.raptor.metrics.engine.ActivityListenerService;
import oracle.dbtools.raptor.metrics.engine.Engine;
import oracle.dbtools.raptor.metrics.engine.ExecutionService;
import oracle.dbtools.raptor.metrics.engine.ObjectManager;
import oracle.dbtools.raptor.metrics.engine.ObjectService;
import oracle.dbtools.raptor.metrics.engine.PropertyStore;
import oracle.dbtools.raptor.metrics.engine.TracingService;

class Context {
    private final Logger logger;
    private final ExecutionService executionService;
    private final ObjectManager objectManager;
    private final ObjectService objectService;
    private final PropertyStore propertyStore;
    private final TracingService tracingService;
    private final ActivityListenerService activityListenerService;

    static Context createContext() {
        ObjectManager objectManager = new ObjectManager();
        ActivityListenerService activityListenerService = new ActivityListenerService();
        ExecutionService executionService = new ExecutionService();
        ObjectService objectService = new ObjectService();
        PropertyStore propertyStore = new PropertyStore();
        TracingService tracingService = new TracingService();
        Logger logger = Logger.getLogger(Engine.class.getPackage().getName());
        Context context = new Context(logger, executionService, objectManager, objectService, propertyStore, tracingService, activityListenerService);
        activityListenerService.setContext(context);
        executionService.setContext(context);
        objectManager.setContext(context);
        objectService.setContext(context);
        tracingService.setContext(context);
        return context;
    }

    private Context(Logger logger, ExecutionService executionService, ObjectManager objectManager, ObjectService objectService, PropertyStore propertyStore, TracingService tracingService, ActivityListenerService activityListenerService) {
        this.logger = logger;
        this.executionService = executionService;
        this.objectManager = objectManager;
        this.objectService = objectService;
        this.propertyStore = propertyStore;
        this.tracingService = tracingService;
        this.activityListenerService = activityListenerService;
    }

    ObjectManager getObjectManager() {
        return this.objectManager;
    }

    ExecutionService getExecutionService() {
        return this.executionService;
    }

    ObjectService getObjectService() {
        return this.objectService;
    }

    PropertyStore getPropertyStore() {
        return this.propertyStore;
    }

    ActivityListenerService getActivityListenerService() {
        return this.activityListenerService;
    }

    TracingService getTracingService() {
        return this.tracingService;
    }

    Logger getLogger() {
        return this.logger;
    }
}

