/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.dataobject;

import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.NumberBinding;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import oracle.dbtools.raptor.metrics.dataobject.AbstractCalcDataObject;
import oracle.dbtools.raptor.metrics.panel.NumberDataObject;

public abstract class ArithmeticDataObject
extends AbstractCalcDataObject<Number>
implements NumberDataObject {
    private final Property<Number> whenNaNProperty = new SimpleDoubleProperty((Object)this, "whenNaN");

    public Number getWhenNaN() {
        return (Number)this.whenNaNProperty.getValue();
    }

    public void setWhenNaN(Number number) {
        this.whenNaNProperty.setValue((Object)number);
    }

    public Property<Number> whenNaNProperty() {
        return this.whenNaNProperty;
    }

    protected abstract Number calculateValue();

    protected abstract List<ObservableValue<?>> getDependencies();

    protected NumberBinding createBinding() {
        List<ObservableValue<?>> list = this.getDependencies();
        ObservableValue[] observableValueArray = new ObservableValue[list.size()];
        list.toArray(observableValueArray);
        for (ObservableValue<?> observableValue : list) {
            if (!(observableValue instanceof DoubleExpression)) continue;
            return Bindings.createDoubleBinding(() -> this.calculateValueWithNaN().doubleValue(), (Observable[])observableValueArray);
        }
        return Bindings.createLongBinding(() -> this.calculateValueWithNaN().longValue(), (Observable[])observableValueArray);
    }

    private Number calculateValueWithNaN() {
        Number number;
        Number number2 = this.calculateValue();
        if (!Double.isFinite(number2.doubleValue()) && (number = this.getWhenNaN()) != null) {
            number2 = number;
        }
        return number2;
    }
}

