/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.Ellipse;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import oracle.dbtools.raptor.metrics.control.AbstractGraphControl;
import oracle.dbtools.raptor.metrics.control.AreaComponent;
import oracle.dbtools.raptor.metrics.control.BezierCurveComponent;
import oracle.dbtools.raptor.metrics.control.EllipseComponent;
import oracle.dbtools.raptor.metrics.control.ExpandableEdge;
import oracle.dbtools.raptor.metrics.control.ExpandableVertex;
import oracle.dbtools.raptor.metrics.control.Layout;
import oracle.dbtools.raptor.metrics.control.LocatedEdge;
import oracle.dbtools.raptor.metrics.control.LocatedVertex;
import oracle.dbtools.raptor.metrics.control.LongLabel;
import oracle.dbtools.raptor.metrics.control.RegionComponent;
import oracle.dbtools.raptor.metrics.control.Tree;
import oracle.dbtools.raptor.metrics.control.Vertex;

public abstract class AbstractTreeControl<T, G extends Tree<T, V, E>, V extends ExpandableVertex<T, V, E>, E extends ExpandableEdge<T, V, E>>
extends AbstractGraphControl<T, G, V, E, BezierCurveComponent> {
    private final PseudoClass contractedVertexClass = PseudoClass.getPseudoClass((String)"contractedVertex");

    public AbstractTreeControl(Layout<T, G, V, E> layout) {
        super(layout);
    }

    protected abstract Rectangle2D computeBounds(double var1, double var3);

    protected abstract BezierControlPoints computeBezierControlPoints(AbstractGraphControl.UIEdge var1);

    protected abstract VertexDisplayGeometry computeVertexDisplayGeometry(AbstractGraphControl.UIVertex var1);

    @Override
    protected AreaComponent createDefaultVertexRepresentation(V v) {
        Ellipse ellipse = new Ellipse(10.0, 10.0);
        ellipse.getStyleClass().setAll((Object[])new String[]{"tree-vertex"});
        String string = ((LocatedVertex)v).getStyleClass();
        if (string != null && !string.isEmpty()) {
            ellipse.getStyleClass().add((Object)string);
        }
        return new EllipseComponent(ellipse);
    }

    @Override
    protected AreaComponent createDefaultVertexDisplay(V v, double d) {
        RegionComponent regionComponent = null;
        String string = ((LocatedVertex)v).getLabel();
        if (string != null) {
            LongLabel longLabel = new LongLabel(string);
            longLabel.setMaxWidth(d);
            longLabel.setAlignment(Pos.BOTTOM_LEFT);
            longLabel.getStyleClass().setAll((Object[])new String[]{"tree-label"});
            String string2 = ((LocatedVertex)v).getStyleClass();
            if (string2 != null && !string2.isEmpty()) {
                longLabel.getStyleClass().add((Object)string2);
            }
            regionComponent = new RegionComponent((Region)longLabel);
        }
        return regionComponent;
    }

    @Override
    protected BezierCurveComponent createEdgeRepresentation(E e) {
        CubicCurve cubicCurve = new CubicCurve();
        cubicCurve.getStyleClass().setAll((Object[])new String[]{"tree-edge"});
        String string = ((LocatedEdge)e).getStyleClass();
        if (string != null && !string.isEmpty()) {
            cubicCurve.getStyleClass().add((Object)string);
        }
        return new BezierCurveComponent(cubicCurve);
    }

    @Override
    protected void onCreateVertexRepresentation(V v, AreaComponent areaComponent) {
        Node node = areaComponent.getNode();
        if (((Vertex)v).isLeaf()) {
            node.getStyleClass().add((Object)"leaf");
        } else {
            node.getStyleClass().add((Object)"internal");
        }
        if (((Vertex)v).isRoot()) {
            node.getStyleClass().add((Object)"root");
        }
        this.updateVertexUIPseudoClass(v, areaComponent);
        node.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
            if (mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 1) {
                v.setExpanded(!v.isExpanded());
                this.updateVertexUIPseudoClass(v, areaComponent);
                this.updateUIModel();
                mouseEvent.consume();
            }
        });
    }

    @Override
    protected Collection<V> getVisibleVertices() {
        Tree tree = (Tree)this.getGraph();
        ArrayList<ExpandableVertex> arrayList = new ArrayList<ExpandableVertex>();
        ExpandableVertex expandableVertex = (ExpandableVertex)tree.getRoot();
        if (expandableVertex != null) {
            arrayList.add(expandableVertex);
            this.addVisibleVertices(expandableVertex, arrayList);
        }
        return arrayList;
    }

    @Override
    protected Collection<E> getVisibleEdges() {
        Tree tree = (Tree)this.getGraph();
        ArrayList arrayList = new ArrayList();
        ExpandableVertex expandableVertex = (ExpandableVertex)tree.getRoot();
        if (expandableVertex != null) {
            this.addVisibleEdges(expandableVertex, arrayList);
        }
        return arrayList;
    }

    @Override
    protected boolean isAnimated() {
        return true;
    }

    @Override
    protected boolean isVertexDraggable() {
        return false;
    }

    @Override
    protected void layoutUIModel(double d, double d2) {
        this.setPhysicalBounds(this.computeBounds(d, d2));
        ExpandableVertex expandableVertex = (ExpandableVertex)((Tree)this.getGraph()).getRoot();
        if (expandableVertex != null) {
            this.layoutBranchUI(expandableVertex, -1.0, -1.0, expandableVertex);
        }
    }

    private void layoutBranchUI(V v, double d, double d2, V v2) {
        AbstractGraphControl.UIVertex uIVertex = this.getUIVertex(v2);
        if (uIVertex != null) {
            AbstractGraphControl.UIStatus uIStatus = uIVertex.getStatus();
            AreaComponent areaComponent = uIVertex.getRepresentation();
            AreaComponent areaComponent2 = uIVertex.getDisplay();
            double d3 = -1.0;
            double d4 = -1.0;
            if (uIStatus != AbstractGraphControl.UIStatus.REMOVED) {
                d3 = this.getPhysicalX(((LocatedVertex)v2).getX());
                d4 = this.getPhysicalY(((LocatedVertex)v2).getY());
                if (uIStatus == AbstractGraphControl.UIStatus.NOMINAL) {
                    v = v2;
                    d = d3;
                    d2 = d4;
                }
            }
            AreaComponent areaComponent3 = this.getUIVertex(v).getRepresentation();
            double d5 = areaComponent3.getCenterX();
            double d6 = areaComponent3.getCenterY();
            for (ExpandableEdge expandableEdge : this.sortEdgesByDestY(((Vertex)v2).getOutEdges())) {
                AbstractGraphControl.UIEdge uIEdge = this.getUIEdge(expandableEdge);
                if (uIEdge != null) {
                    AbstractGraphControl.UIStatus uIStatus2 = uIEdge.getStatus();
                    BezierCurveComponent bezierCurveComponent = (BezierCurveComponent)uIEdge.getRepresentation();
                    AreaComponent areaComponent4 = uIEdge.getDisplay();
                    if (uIStatus2 != AbstractGraphControl.UIStatus.REMOVED) {
                        if (uIStatus2 == AbstractGraphControl.UIStatus.NEW) {
                            bezierCurveComponent.setStartX(d5);
                            bezierCurveComponent.setStartY(d6);
                            bezierCurveComponent.setEndX(d5);
                            bezierCurveComponent.setEndY(d6);
                            bezierCurveComponent.setControlX1(d5);
                            bezierCurveComponent.setControlY1(d6);
                            bezierCurveComponent.setControlX2(d5);
                            bezierCurveComponent.setControlY2(d6);
                            bezierCurveComponent.move();
                            if (areaComponent4 != null) {
                                areaComponent4.setCenterX(d5);
                                areaComponent4.setCenterY(d6);
                                areaComponent4.move();
                            }
                        }
                        double d7 = this.getPhysicalX(((ExpandableVertex)expandableEdge.getSource()).getX());
                        double d8 = this.getPhysicalY(((ExpandableVertex)expandableEdge.getSource()).getY());
                        double d9 = this.getPhysicalX(((ExpandableVertex)expandableEdge.getDest()).getX());
                        double d10 = this.getPhysicalY(((ExpandableVertex)expandableEdge.getDest()).getY());
                        BezierControlPoints bezierControlPoints = this.computeBezierControlPoints(uIEdge);
                        bezierCurveComponent.setStartX(d7);
                        bezierCurveComponent.setStartY(d8);
                        bezierCurveComponent.setEndX(d9);
                        bezierCurveComponent.setEndY(d10);
                        bezierCurveComponent.setControlX1(bezierControlPoints.x1);
                        bezierCurveComponent.setControlY1(bezierControlPoints.y1);
                        bezierCurveComponent.setControlX2(bezierControlPoints.x2);
                        bezierCurveComponent.setControlY2(bezierControlPoints.y2);
                        if (areaComponent4 != null) {
                            areaComponent4.setCenterX(0.5 * (d7 + d9));
                            areaComponent4.setCenterY(0.5 * (d8 + d10));
                        }
                    } else {
                        bezierCurveComponent.setStartX(d);
                        bezierCurveComponent.setStartY(d2);
                        bezierCurveComponent.setEndX(d);
                        bezierCurveComponent.setEndY(d2);
                        bezierCurveComponent.setControlX1(d);
                        bezierCurveComponent.setControlY1(d2);
                        bezierCurveComponent.setControlX2(d);
                        bezierCurveComponent.setControlY2(d2);
                        if (areaComponent4 != null) {
                            areaComponent4.setCenterX(d);
                            areaComponent4.setCenterY(d2);
                        }
                    }
                }
                this.layoutBranchUI(v, d, d2, (ExpandableVertex)expandableEdge.getDest());
            }
            if (uIStatus != AbstractGraphControl.UIStatus.REMOVED) {
                if (uIStatus == AbstractGraphControl.UIStatus.NEW) {
                    areaComponent.setCenterX(d5);
                    areaComponent.setCenterY(d6);
                    areaComponent.move();
                    if (areaComponent2 != null) {
                        areaComponent2.setCenterX(d5);
                        areaComponent2.setCenterY(d6);
                        areaComponent2.move();
                    }
                }
                areaComponent.setCenterX(d3);
                areaComponent.setCenterY(d4);
                if (areaComponent2 != null) {
                    ExpandableEdge expandableEdge;
                    VertexDisplayGeometry vertexDisplayGeometry = this.computeVertexDisplayGeometry(uIVertex);
                    expandableEdge = areaComponent2.getNode();
                    if (vertexDisplayGeometry.angle == 0.0) {
                        expandableEdge.getTransforms().clear();
                    } else {
                        expandableEdge.getTransforms().setAll((Object[])new Transform[]{new Rotate(Math.toDegrees(vertexDisplayGeometry.angle), 0.5 * areaComponent2.getWidth(), 0.5 * areaComponent2.getHeight())});
                    }
                    areaComponent2.setCenterX(vertexDisplayGeometry.x);
                    areaComponent2.setCenterY(vertexDisplayGeometry.y);
                }
            } else {
                areaComponent.setCenterX(d);
                areaComponent.setCenterY(d2);
                if (areaComponent2 != null) {
                    areaComponent2.setCenterX(d5);
                    areaComponent2.setCenterY(d2);
                }
            }
        }
    }

    private void addVisibleVertices(V v, Collection<V> collection) {
        if (((ExpandableVertex)v).isExpanded()) {
            for (ExpandableVertex expandableVertex : ((Vertex)v).getSuccessors()) {
                collection.add(expandableVertex);
                this.addVisibleVertices(expandableVertex, collection);
            }
        }
    }

    private void addVisibleEdges(V v, Collection<E> collection) {
        if (((ExpandableVertex)v).isExpanded()) {
            for (ExpandableEdge expandableEdge : ((Vertex)v).getOutEdges()) {
                collection.add(expandableEdge);
                this.addVisibleEdges((ExpandableVertex)expandableEdge.getDest(), collection);
            }
        }
    }

    private void updateVertexUIPseudoClass(V v, AreaComponent areaComponent) {
        areaComponent.getNode().pseudoClassStateChanged(this.contractedVertexClass, !((Vertex)v).isLeaf() && !((ExpandableVertex)v).isExpanded());
    }

    private List<E> sortEdgesByDestY(Collection<E> collection) {
        ArrayList<E> arrayList = new ArrayList<E>(collection);
        Collections.sort(arrayList, (expandableEdge, expandableEdge2) -> {
            double d;
            double d2 = ((ExpandableVertex)expandableEdge.getDest()).getY();
            if (d2 == (d = ((ExpandableVertex)expandableEdge2.getDest()).getY())) {
                return expandableEdge.getId() > expandableEdge2.getId() ? -1 : 1;
            }
            return ((ExpandableVertex)expandableEdge.getDest()).getY() > ((ExpandableVertex)expandableEdge2.getDest()).getY() ? -1 : 1;
        });
        return arrayList;
    }

    protected class BezierControlPoints {
        private final double x1;
        private final double y1;
        private final double x2;
        private final double y2;

        protected BezierControlPoints(double d, double d2, double d3, double d4) {
            this.x1 = d;
            this.y1 = d2;
            this.x2 = d3;
            this.y2 = d4;
        }
    }

    protected class VertexDisplayGeometry {
        private final double angle;
        private final double x;
        private final double y;

        protected VertexDisplayGeometry(double d, double d2, double d3) {
            this.angle = d;
            this.x = d2;
            this.y = d3;
        }
    }
}

