/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.print.awt;

import ice.debug.Debug;
import ice.pilots.html4.ThePilot;
import ice.ri.common.dialog.awt.WholeNumberTextField;
import ice.ri.common.print.PrintHelper;
import ice.ri.common.print.PrintUtilities;
import ice.ri.common.print.awt.PageSetupDialog;
import ice.storm.Pilot;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.storm.print.StormPageFormat;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;

public class PrintPreviewDialog
extends Dialog
implements WindowListener,
ActionListener,
ItemListener,
Runnable,
PropertyChangeListener {
    private PrintComponent printPreviewComponent;
    private Button firstPageButton;
    private Button lastPageButton;
    private Button nextPageButton;
    private Button previousPageButton;
    private Button portriatButton;
    private Button landscapeButton;
    private WholeNumberTextField pageNumberTextField;
    private Label pageTotalLabel;
    private Button printButton;
    private Button pageSetupButton;
    private Choice scaleChoice;
    private Choice frameChoice;
    private Button closeButton;
    private StormPrinter printer;
    private StormPageFormat stormPageFormat;
    private Frame parentFrame;
    private Vector viewports;
    private Viewport currentViewport;
    private Viewport mainViewport;
    private boolean isFrameset;
    private int zoom;
    private double originalLayoutWidth = 0.0;
    private double scale = 1.0;
    private double[] scaleLevels = new double[]{0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.25, 1.5, 1.75, 2.0, 3.0};
    private int pageIndex = 0;
    private int pagePadding = 25;
    private ScrollPane scrollPane = null;
    DoubleBufferPanel doubleBufferPanel = null;

    public PrintPreviewDialog(Frame parent, Viewport viewport, StormPageFormat storm_Page_Format) {
        super(parent, "Print preview ", true);
        this.stormPageFormat = (StormPageFormat)storm_Page_Format.clone();
        this.parentFrame = parent;
        this.mainViewport = viewport;
        this.isFrameset = PrintUtilities.isFrameset(this.mainViewport);
        this.zoom = this.mainViewport.getZoom();
        this.viewports = new Vector(4, 2);
        this.mainViewport.getViewAndAllChildren(this.viewports);
        int viewportIdx = this.getIndexOffset();
        if (viewportIdx == 0) {
            this.currentViewport = this.mainViewport;
            this.printer = this.currentViewport.getPilot().createPrinter();
        } else {
            this.currentViewport = (Viewport)this.viewports.elementAt(1);
            this.printer = this.currentViewport.getPilot().createPrinter();
            if (this.printer == null) {
                for (int i = 1; i < this.viewports.size(); ++i) {
                    this.currentViewport = (Viewport)this.viewports.elementAt(i);
                    this.printer = this.currentViewport.getPilot().createPrinter();
                    if (this.printer != null) break;
                }
            }
        }
        PageSetupDialog.refreshPageDecoration(this.currentViewport, this.stormPageFormat);
        this.setTitle("Print preview - " + this.getDocumentTitle(this.mainViewport));
        this.addWindowListener(this);
        if (this.printer != null) {
            this.originalLayoutWidth = this.printer.getDimension().width;
            PrintUtilities.adjustScale(this.stormPageFormat, this.originalLayoutWidth);
            this.printer.setStormPageFormat(this.stormPageFormat);
        } else {
            Debug.trace("Pilot does not support printing!");
        }
    }

    private void setGUI() {
        this.addWindowListener(this);
        this.closeButton = new Button("Close");
        this.closeButton.addActionListener(this);
        this.firstPageButton = new Button("|<");
        this.firstPageButton.addActionListener(this);
        this.lastPageButton = new Button(">|");
        this.lastPageButton.addActionListener(this);
        this.nextPageButton = new Button(">");
        this.nextPageButton.addActionListener(this);
        this.previousPageButton = new Button("<");
        this.previousPageButton.addActionListener(this);
        this.printButton = new Button("Print");
        this.printButton.addActionListener(this);
        this.pageSetupButton = new Button("Page Setup");
        this.pageSetupButton.addActionListener(this);
        this.portriatButton = new Button("Portrait");
        this.portriatButton.addActionListener(this);
        this.landscapeButton = new Button("Landscape");
        this.landscapeButton.addActionListener(this);
        this.scaleChoice = new Choice();
        this.scaleChoice.add("30%");
        this.scaleChoice.add("40%");
        this.scaleChoice.add("50%");
        this.scaleChoice.add("60%");
        this.scaleChoice.add("70%");
        this.scaleChoice.add("80%");
        this.scaleChoice.add("90%");
        this.scaleChoice.add("100%");
        this.scaleChoice.add("125%");
        this.scaleChoice.add("150%");
        this.scaleChoice.add("175%");
        this.scaleChoice.add("200%");
        this.scaleChoice.add("300%");
        this.scaleChoice.add("Fit to Width");
        this.scaleChoice.select(7);
        this.scaleChoice.addItemListener(this);
        this.setScaleComboBoxSelection();
        this.frameChoice = new Choice();
        this.buildAndUpdateFramesChoices();
        this.frameChoice.addItemListener(this);
        this.pageNumberTextField = new WholeNumberTextField(this.pageIndex + 1, 5, 3);
        this.pageNumberTextField.addActionListener(this);
        this.pageTotalLabel = new Label(" of " + this.printer.getPageCount());
        Panel controlPanel = new Panel();
        if (this.isFrameset) {
            controlPanel.add(this.frameChoice);
        }
        controlPanel.add(this.printButton);
        controlPanel.add(this.pageSetupButton);
        controlPanel.add(this.firstPageButton);
        controlPanel.add(this.previousPageButton);
        controlPanel.add(this.pageNumberTextField);
        controlPanel.add(this.pageTotalLabel);
        controlPanel.add(this.nextPageButton);
        controlPanel.add(this.lastPageButton);
        controlPanel.add(this.scaleChoice);
        controlPanel.add(this.portriatButton);
        controlPanel.add(this.landscapeButton);
        controlPanel.add(this.closeButton);
        this.printPreviewComponent = new PrintComponent(this.printer);
        this.doubleBufferPanel = new DoubleBufferPanel();
        this.doubleBufferPanel.add(this.printPreviewComponent);
        this.scrollPane = new ScrollPane();
        this.scrollPane.setBackground(Color.lightGray);
        this.scrollPane.add(this.doubleBufferPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)controlPanel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.setSize(this.parentFrame.getSize().width, this.parentFrame.getSize().height);
        this.setLocation(this.parentFrame.getLocation().x + 20, this.parentFrame.getLocation().y + 20);
    }

    private void buildAndUpdateFramesChoices() {
        if (this.frameChoice.getItemCount() > 0) {
            this.frameChoice.removeAll();
        }
        if (!this.isFrameset || this.stormPageFormat.getFramePrintFormat() == 3) {
            this.frameChoice.addItem("Main frame");
            this.frameChoice.setEnabled(false);
        } else if (this.isFrameset && this.stormPageFormat.getFramePrintFormat() == 1) {
            if (!this.frameChoice.isEnabled()) {
                this.frameChoice.setEnabled(true);
            }
            int n = this.viewports.size();
            for (int i = 1; i < n; ++i) {
                Viewport tmp = (Viewport)this.viewports.elementAt(i);
                this.frameChoice.addItem("Frame " + tmp.getId());
            }
        }
    }

    private String getDocumentTitle(Viewport viewport) {
        Pilot tmp = viewport.getPilot();
        if (tmp instanceof ThePilot) {
            return viewport.getName();
        }
        if (tmp instanceof ice.pilots.text.ThePilot) {
            return "Text Pilot";
        }
        if (tmp instanceof ice.pilots.image.ThePilot) {
            return "Image Pilot";
        }
        return "";
    }

    private void setNewPreviewViewport(int viewportIndex) {
        Viewport selectedViewport = (Viewport)this.viewports.elementAt(viewportIndex);
        if (this.currentViewport == selectedViewport) {
            return;
        }
        this.pageIndex = 0;
        this.currentViewport = selectedViewport;
        StormPrinter tmpPrinter = this.currentViewport.getPilot().createPrinter();
        if (tmpPrinter != null) {
            this.printer.dispose();
            this.printer = tmpPrinter;
            this.originalLayoutWidth = this.printer.getDimension().width;
            this.stormPageFormat.setScale(this.getScaleChoice(this.scaleChoice.getSelectedIndex()));
            this.stormPageFormat.setSelectedViewportIndex(viewportIndex);
            this.printer.setStormPageFormat(this.stormPageFormat);
            this.printPreviewComponent.setPrinter(this.printer);
            this.printPreviewComponent.setSize((int)this.stormPageFormat.getPageWidth() + this.pagePadding, (int)this.stormPageFormat.getPageHeight() + this.pagePadding);
            this.scrollPane.validate();
            this.scrollPane.repaint();
        } else {
            Debug.trace("Pilot does not support printing!");
        }
    }

    private double getScaleChoice(int index) {
        if (index >= 0 && index < this.scaleLevels.length) {
            this.stormPageFormat.setScaleToFitEnabled(false);
            return this.scaleLevels[index];
        }
        this.stormPageFormat.setScaleToFitEnabled(true);
        this.scale = this.originalLayoutWidth > this.stormPageFormat.getImageableWidth() ? 1.0 / this.originalLayoutWidth * this.stormPageFormat.getImageableWidth() : 1.0;
        return this.scale;
    }

    public StormPageFormat showDialog() {
        this.setVisible(true);
        return this.stormPageFormat;
    }

    public void dispose() {
        int aZoom;
        if (this.printer != null) {
            this.printer.dispose();
        }
        this.mainViewport.setZoom((aZoom = this.zoom - 1) > 0 ? aZoom : this.zoom + 1);
        this.mainViewport.setZoom(this.zoom);
        if (super.getParent() != null) {
            super.getParent().validate();
            super.getParent().repaint();
        }
        super.dispose();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.printer == null) {
                this.dispose();
            } else {
                this.setGUI();
            }
        }
        if (this.printer != null) {
            super.setVisible(visible);
        }
    }

    public void run() {
        this.doubleBufferPanel.setDoubleBufferedEnabled(false);
        PrintHelper printHelper = PrintUtilities.getPrintHelper(this.mainViewport, this.stormPageFormat);
        printHelper.print(this.parentFrame);
        PageSetupDialog.refreshPageDecoration(this.currentViewport, this.stormPageFormat);
        if (this.printer != null) {
            this.printer.dispose();
        }
        this.printer = this.currentViewport.getPilot().createPrinter();
        if (this.printer != null) {
            this.printer.setStormPageFormat(this.stormPageFormat);
            this.printPreviewComponent.setPrinter(this.printer);
            this.printPreviewComponent.repaint();
            this.doubleBufferPanel.setDoubleBufferedEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.nextPageButton) {
            this.pageIndex = this.printer.getPageIndex();
            ++this.pageIndex;
            this.printer.setPageIndex(this.pageIndex);
        } else if (e.getSource() == this.previousPageButton) {
            this.pageIndex = this.printer.getPageIndex();
            --this.pageIndex;
            this.printer.setPageIndex(this.pageIndex);
        } else if (e.getSource() == this.firstPageButton) {
            this.pageIndex = 0;
            this.printer.setPageIndex(this.pageIndex);
        } else if (e.getSource() == this.lastPageButton) {
            this.pageIndex = this.printer.getPageCount() - 1;
            this.printer.setPageIndex(this.pageIndex);
        } else {
            if (e.getSource() == this.printButton) {
                this.printPage();
                return;
            }
            if (e.getSource() == this.pageNumberTextField) {
                int value = this.pageNumberTextField.getValue();
                if (value >= 1 && value <= this.printer.getPageCount()) {
                    this.pageIndex = value - 1;
                    this.printer.setPageIndex(this.pageIndex);
                }
            } else if (e.getSource() == this.portriatButton) {
                if (this.stormPageFormat.getOrientation() != 1) {
                    this.stormPageFormat.setOrientation(1);
                    this.stormPageFormat.setScale(this.getScaleChoice(this.scaleChoice.getSelectedIndex()));
                    this.printer.setStormPageFormat(this.stormPageFormat);
                    this.pageIndex = 0;
                    this.printPreviewComponent.setSize((int)this.stormPageFormat.getPageWidth() + this.pagePadding, (int)this.stormPageFormat.getPageHeight() + this.pagePadding);
                }
            } else if (e.getSource() == this.landscapeButton) {
                this.stormPageFormat.setOrientation(0);
                this.stormPageFormat.setScale(this.getScaleChoice(this.scaleChoice.getSelectedIndex()));
                this.printer.setStormPageFormat(this.stormPageFormat);
                this.pageIndex = 0;
                this.printPreviewComponent.setPrinter(this.printer);
                this.printPreviewComponent.setSize((int)this.stormPageFormat.getPageWidth() + this.pagePadding, (int)this.stormPageFormat.getPageHeight() + this.pagePadding);
            } else if (e.getSource() == this.pageSetupButton) {
                PageSetupDialog pageSetup = new PageSetupDialog(this.parentFrame, this.mainViewport, this.stormPageFormat);
                StormPageFormat pageFormat = pageSetup.showDialog();
                if (pageFormat.getFramePrintFormat() != this.stormPageFormat.getFramePrintFormat()) {
                    this.stormPageFormat = pageFormat;
                    this.frameChoice.removeItemListener(this);
                    this.buildAndUpdateFramesChoices();
                    this.frameChoice.addItemListener(this);
                    this.frameChoice.select(0);
                    this.setNewPreviewViewport(this.getIndexOffset());
                } else {
                    this.stormPageFormat = pageFormat;
                }
                this.setScaleComboBoxSelection();
                PageSetupDialog.refreshPageDecoration(this.currentViewport, this.stormPageFormat);
                this.printer.setStormPageFormat(this.stormPageFormat);
                this.printPreviewComponent.setPrinter(this.printer);
                this.printPreviewComponent.setSize((int)this.stormPageFormat.getPageWidth() + this.pagePadding, (int)this.stormPageFormat.getPageHeight() + this.pagePadding);
            }
        }
        this.printPreviewComponent.setPageComponentDirty();
        this.doubleBufferPanel.repaint();
        this.scrollPane.validate();
        this.scrollPane.repaint();
        this.updateNavigationText();
    }

    private int getIndexOffset() {
        int offset = 0;
        if (this.isFrameset && this.viewports.size() > 1 && this.stormPageFormat.getFramePrintFormat() == 1) {
            offset = 1;
        }
        return offset;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.scaleChoice) {
            this.pageIndex = 0;
            this.scale = this.getScaleChoice(this.scaleChoice.getSelectedIndex());
            this.stormPageFormat.setScale(this.scale);
            this.printer.setStormPageFormat(this.stormPageFormat);
        } else if (e.getSource() == this.frameChoice) {
            this.setNewPreviewViewport(this.frameChoice.getSelectedIndex() + this.getIndexOffset());
            PageSetupDialog.refreshPageDecoration(this.currentViewport, this.stormPageFormat);
        }
        this.updateNavigationText();
        this.printPreviewComponent.setPageComponentDirty();
        this.doubleBufferPanel.invalidate();
        this.doubleBufferPanel.repaint();
        this.scrollPane.validate();
        this.scrollPane.repaint();
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        String val = "";
        if (e.getNewValue() instanceof String) {
            val = (String)e.getNewValue();
        }
        if (name.equals("contentRendering") && val.equals("finished")) {
            this.stormPageFormat.setImageableAreaChangedFlag(true);
            this.printer.setStormPageFormat(this.stormPageFormat);
            this.printPreviewComponent.setPageComponentDirty();
            this.doubleBufferPanel.repaint();
        }
    }

    private void printPage() {
        this.run();
    }

    private void updateNavigationText() {
        this.pageNumberTextField.setValue(this.printer.getPageIndex() + 1);
        this.pageTotalLabel.setText(" of " + this.printer.getPageCount());
    }

    private void setScaleComboBoxSelection() {
        if (this.stormPageFormat.isScaleToFitEnabled()) {
            this.scaleChoice.select(13);
            this.getScaleChoice(13);
        } else {
            double scale = (double)Math.round(this.stormPageFormat.getScale() * 100.0) / 100.0;
            boolean found = false;
            for (int i = 0; i < this.scaleLevels.length; ++i) {
                if (scale != this.scaleLevels[i]) continue;
                this.scaleChoice.select(i);
                found = true;
                break;
            }
            if (!found) {
                this.scaleChoice.select(7);
                this.stormPageFormat.setScale(1.0);
            }
        }
    }

    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public void windowClosed(WindowEvent ev) {
    }

    public void windowOpened(WindowEvent ev) {
    }

    public void windowIconified(WindowEvent ev) {
    }

    public void windowDeiconified(WindowEvent ev) {
    }

    public void windowActivated(WindowEvent ev) {
    }

    public void windowDeactivated(WindowEvent ev) {
    }

    class DoubleBufferPanel
    extends Panel {
        Image offscreen;
        boolean enabled = true;

        DoubleBufferPanel() {
        }

        public void invalidate() {
            super.invalidate();
            this.offscreen = null;
        }

        public void update(Graphics g) {
            if (this.enabled) {
                this.paint(g);
            } else {
                super.update(g);
            }
        }

        public void setDoubleBufferedEnabled(boolean flag) {
            this.enabled = flag;
        }

        public void paint(Graphics g) {
            if (this.offscreen == null) {
                this.offscreen = this.createImage(this.getSize().width, this.getSize().height);
            }
            Graphics og = this.offscreen.getGraphics();
            og.setClip(0, 0, this.getSize().width, this.getSize().height);
            super.paint(og);
            g.drawImage(this.offscreen, 0, 0, null);
            og.dispose();
        }
    }

    class PrintComponent
    extends Component {
        private StormPrinter printer;
        private StormPageFormat pageFormat;
        private Image pageImage;
        private boolean pageImageDirty = true;

        PrintComponent(StormPrinter p) {
            this.printer = p;
            this.pageFormat = p.getStormPageFormat();
            this.setSize((int)this.pageFormat.getPageWidth() + PrintPreviewDialog.this.pagePadding, (int)this.pageFormat.getPageHeight() + PrintPreviewDialog.this.pagePadding);
        }

        public void setPrinter(StormPrinter p) {
            this.printer = p;
            this.pageFormat = p.getStormPageFormat();
            PrintPreviewDialog.this.doubleBufferPanel.invalidate();
            PrintPreviewDialog.this.doubleBufferPanel.repaint();
            PrintPreviewDialog.this.scrollPane.validate();
            PrintPreviewDialog.this.scrollPane.repaint();
        }

        public Dimension getSize() {
            this.setSize(new Dimension((int)this.pageFormat.getPageWidth() + PrintPreviewDialog.this.pagePadding, (int)this.pageFormat.getPageHeight() + PrintPreviewDialog.this.pagePadding));
            return super.getSize();
        }

        public Dimension getPreferredSize() {
            this.setSize(new Dimension((int)this.pageFormat.getPageWidth() + PrintPreviewDialog.this.pagePadding, (int)this.pageFormat.getPageHeight() + PrintPreviewDialog.this.pagePadding));
            return super.getSize();
        }

        public void setPageComponentDirty() {
            this.pageImageDirty = true;
        }

        public void paint(Graphics g) {
            Dimension componentSize = this.getSize();
            double x = 0.0;
            double y = 0.0;
            if (this.pageFormat.getPageWidth() < (double)componentSize.width) {
                x = ((double)componentSize.width - this.pageFormat.getPageWidth()) / 2.0;
            }
            if (this.pageFormat.getPageHeight() < (double)componentSize.height) {
                y = ((double)componentSize.height - this.pageFormat.getPageHeight()) / 2.0;
            }
            g.setColor(Color.white);
            g.fillRect((int)x, (int)y, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
            if (this.pageImageDirty) {
                this.pageImage = this.createImage((int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
                Graphics imageGraphics = this.pageImage.getGraphics();
                imageGraphics.setColor(Color.white);
                imageGraphics.fillRect(0, 0, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
                this.printer.printPage(imageGraphics, PrintPreviewDialog.this.pageIndex);
                imageGraphics.dispose();
                this.pageImageDirty = false;
            }
            Graphics gg = g.create((int)x, (int)y, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
            gg.drawImage(this.pageImage, 0, 0, this);
            gg.dispose();
            g.setColor(Color.lightGray);
            g.drawRect((int)(x + this.pageFormat.getMargin(2)), (int)(y + this.pageFormat.getMargin(1)), (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
            int shadowsize = 3;
            g.setColor(Color.black);
            g.drawRect((int)x, (int)y, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
            g.fillRect((int)(x + this.pageFormat.getPageWidth()), (int)(y + (double)shadowsize), shadowsize, (int)this.pageFormat.getPageHeight());
            g.fillRect((int)(x + (double)shadowsize), (int)(y + this.pageFormat.getPageHeight()), (int)this.pageFormat.getPageWidth() - shadowsize, shadowsize);
            g.setColor(Color.lightGray);
        }
    }
}

