/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetContext;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;

class JTextDropTarget {
    private static JTextDropTarget _sInstance;

    public static JTextDropTarget getJTextDropTarget() {
        if (_sInstance == null) {
            _sInstance = new JTextDropTarget();
        }
        return _sInstance;
    }

    public void addDropTarget(JTextComponent textComponent) {
        DropTarget dummy = new DropTarget((Component)textComponent, (DropTargetListener)new A(textComponent));
    }

    private JTextDropTarget() {
    }

    private class A
    implements DropTargetListener {
        private JTextComponent _text;

        public A(JTextComponent text) {
            this._text = text;
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (!this._acceptDrag(dtde)) {
                dtde.rejectDrag();
            } else {
                this._text.setBackground(Color.lightGray);
            }
        }

        public void dragOver(DropTargetDragEvent dtde) {
            if (!this._acceptDrag(dtde)) {
                dtde.rejectDrag();
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void dragExit(DropTargetEvent dtde) {
            this._text.setBackground(UIManager.getColor(LookAndFeel.TEXT));
        }

        public void drop(DropTargetDropEvent dtde) {
            this._text.setBackground(UIManager.getColor(LookAndFeel.TEXT));
            DropTargetContext context = dtde.getDropTargetContext();
            dtde.acceptDrop(2);
            Transferable transfer = dtde.getTransferable();
            Object data = null;
            try {
                data = transfer.getTransferData(DataFlavor.stringFlavor);
            }
            catch (IOException ioException) {
                data = null;
            }
            catch (UnsupportedFlavorException ufException) {
                data = null;
            }
            if (data != null) {
                String s = data.toString();
                this._text.replaceSelection(s);
            }
            context.dropComplete(data != null);
        }

        private boolean _acceptDrag(DropTargetDragEvent dtde) {
            DataFlavor[] flavors = dtde.getCurrentDataFlavors();
            if (flavors == null) {
                return true;
            }
            for (int i = 0; i < flavors.length; ++i) {
                if (!DataFlavor.stringFlavor.equals(flavors[i])) continue;
                return true;
            }
            return false;
        }
    }
}

