/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.StyleCache;
import oracle.sdovis.VisContext;
import oracle.sdovis.ds.DSManager;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleLine;
import oracle.sdovis.stylex.BucketStyle;
import oracle.sdovis.stylex.ColorSchemeStyle;
import oracle.sdovis.stylex.VariableMarkerStyle;
import oracle.sdovis.stylex.VariablePieChartStyle;
import oracle.sdovis.util.ShapeUtil;

public class RenderingUtils {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public static final void smartDraw(Shape shp, Graphics2D g2, VisContext vc) {
        Rectangle shpMbr = shp.getBounds();
        if (vc == null && shpMbr.getWidth() < 5000.0 && shpMbr.getHeight() < 5000.0) {
            g2.draw(shp);
            return;
        }
        Rectangle2D devBounds = null;
        if (vc != null) {
            devBounds = vc.getDeviceWindow();
            log.finest("device window from vc: (w,h): " + devBounds.getWidth() + "," + devBounds.getHeight());
        } else {
            devBounds = g2.getDeviceConfiguration().getBounds();
            log.finest("device window from g2: (w,h): " + devBounds.getWidth() + "," + devBounds.getHeight());
        }
        devBounds = new Rectangle2D.Double(devBounds.getMinX() - (double)VisContext.BUFFER_VECTOR_THEME, devBounds.getMinY() - (double)VisContext.BUFFER_VECTOR_THEME, devBounds.getWidth() + (double)(VisContext.BUFFER_VECTOR_THEME * 2), devBounds.getHeight() + (double)(VisContext.BUFFER_VECTOR_THEME * 2));
        if (ShapeUtil.intersectsShapeSegments(devBounds, shp, shpMbr)) {
            if (devBounds.contains(shpMbr)) {
                g2.draw(shp);
                return;
            }
            Rectangle2D.Double clipBound = new Rectangle2D.Double();
            clipBound.setFrame(devBounds.getMinX(), devBounds.getMinY(), devBounds.getWidth(), devBounds.getHeight());
            Shape intersected = ShapeUtil.clipLineString(clipBound, shp, shpMbr);
            if (intersected != null) {
                g2.draw(intersected);
                log.finest("clipBound(minx, miny, maxx, maxy): " + clipBound.getMinX() + "," + clipBound.getMinY() + "," + clipBound.getMaxX() + "," + clipBound.getMaxY());
                log.finest("shapeMBR(minx, miny, maxx, maxy): " + shpMbr.getMinX() + "," + shpMbr.getMinY() + "," + shpMbr.getMaxX() + "," + shpMbr.getMaxY());
            }
        }
    }

    public static final boolean hasCasedLineStyle(String[] styles, String dataSrc, VisContext vc) {
        boolean res = false;
        if (styles == null || styles.length == 0 || dataSrc == null || vc == null) {
            return res;
        }
        for (int i = 0; i < styles.length; ++i) {
            String styName = styles[i];
            Style sty = vc.resolveStyle(styName, dataSrc);
            if (sty != null) {
                boolean resolved;
                StyleCache sc = DSManager.getStyleCache(dataSrc);
                if (vc.getTemporaryStyleCache() != null) {
                    sc = vc.getTemporaryStyleCache();
                }
                if (!(resolved = sty.resolveStyles(sc, vc.getDynamicStyles()))) {
                    log.warning("cannot resolve referenced styles for style " + sty.getModel().getName());
                }
            }
            if (sty == null || !(sty instanceof StyleLine ? ((StyleLine)sty).supportCasedLine() : sty instanceof BucketStyle && !(sty instanceof ColorSchemeStyle) && !(sty instanceof VariableMarkerStyle) && !(sty instanceof VariablePieChartStyle) && ((BucketStyle)sty).hasCasedLineStyles())) continue;
            return true;
        }
        return false;
    }
}

