/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis.util;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.mapviewer.share.FeatureConflictDescriptor;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.util.Util;
import oracle.spatial.geometry.JGeometry;
import oracle.sql.STRUCT;

public class ORAWorkspaceJDBCUtil {
    private static final Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.SDOVIS);

    public static String[] getWorkspaces(Connection conn, String owner) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        ArrayList<String> wspNames = new ArrayList<String>();
        String querystr = null;
        String user = owner;
        try {
            if (user == null) {
                user = conn.getMetaData().getUserName();
            }
            querystr = "select workspace from all_workspaces where owner = ?";
            st = conn.prepareStatement(querystr);
            st.setString(1, user.toUpperCase());
            rs = st.executeQuery();
            while (rs.next()) {
                wspNames.add(rs.getString(1));
            }
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(querystr, ex);
            wspNames = null;
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        if (wspNames == null) {
            return null;
        }
        if (wspNames.size() > 0) {
            Collections.sort(wspNames);
        }
        return wspNames.toArray(new String[wspNames.size()]);
    }

    public static String[] getChildWorkspaces(Connection conn, String owner, String parentWorkspace) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        ArrayList<String> wspNames = new ArrayList<String>();
        String querystr = null;
        String user = owner;
        String wksp = "LIVE";
        if (parentWorkspace != null) {
            wksp = parentWorkspace;
        }
        try {
            if (user == null) {
                user = conn.getMetaData().getUserName();
            }
            querystr = "select workspace from all_workspaces where owner = ? and parent_workspace = ?";
            st = conn.prepareStatement(querystr);
            st.setString(1, user.toUpperCase());
            st.setString(2, wksp);
            rs = st.executeQuery();
            while (rs.next()) {
                wspNames.add(rs.getString(1));
            }
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(querystr, ex);
            wspNames = null;
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        if (wspNames == null) {
            return null;
        }
        if (wspNames.size() > 0) {
            Collections.sort(wspNames);
        }
        return wspNames.toArray(new String[wspNames.size()]);
    }

    public static String[] getTableChildWorkspaces(Connection conn, String owner, String table, String parentWorkspace) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("Table name name is null.");
        }
        if (parentWorkspace == null) {
            throw new Exception("Parent workspace name is null.");
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        ArrayList<String> wspNames = new ArrayList<String>();
        String querystr = null;
        String user = owner;
        try {
            if (user == null) {
                user = conn.getMetaData().getUserName();
            }
            querystr = "select a.workspace from (select workspace from all_workspaces where owner = ? and parent_workspace = ? ) a, (select distinct(workspace), table_name from all_wm_modified_tables where workspace != ? and table_name = ? ) b where a.workspace = b.workspace";
            st = conn.prepareStatement(querystr);
            st.setString(1, user.toUpperCase());
            st.setString(2, parentWorkspace);
            st.setString(3, parentWorkspace);
            st.setString(4, user.toUpperCase() + "." + table.toUpperCase());
            rs = st.executeQuery();
            while (rs.next()) {
                wspNames.add(rs.getString(1));
            }
        }
        catch (Exception ex) {
            log.severe(querystr + "\n" + ex.getMessage());
            wspNames = null;
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        if (wspNames == null) {
            return null;
        }
        if (wspNames.size() > 0) {
            Collections.sort(wspNames);
        }
        return wspNames.toArray(new String[wspNames.size()]);
    }

    public static String getParentWorkspace(Connection conn, String owner, String childWorkspace) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (childWorkspace == null) {
            throw new Exception("Child workspace name is null.");
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        String querystr = null;
        String user = owner;
        try {
            if (user == null) {
                user = conn.getMetaData().getUserName();
            }
            querystr = "select parent_workspace from all_workspaces where owner = ? and workspace = ?";
            st = conn.prepareStatement(querystr);
            st.setString(1, user.toUpperCase());
            st.setString(2, childWorkspace);
            rs = st.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(querystr, ex);
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return null;
    }

    public static String[] getWorkspaceSavepoints(Connection conn, String owner, String workspace) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (workspace == null) {
            throw new Exception("Workspace name is null");
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        ArrayList<String> wspspNames = new ArrayList<String>();
        String querystr = null;
        String user = owner;
        try {
            if (user == null) {
                user = conn.getMetaData().getUserName();
            }
            querystr = "select savepoint from all_workspaces_savepoints where owner = ? and workspace = ?";
            st = conn.prepareStatement(querystr);
            st.setString(1, user.toUpperCase());
            st.setString(2, workspace);
            rs = st.executeQuery();
            while (rs.next()) {
                wspspNames.add(rs.getString(1));
            }
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(querystr, ex);
            wspspNames = null;
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        if (wspspNames == null) {
            return null;
        }
        if (wspspNames.size() > 0) {
            Collections.sort(wspspNames);
        }
        return wspspNames.toArray(new String[wspspNames.size()]);
    }

    public static String getVersionedTablePrimaryKey(Connection conn, String owner, String table) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("table name is null");
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        ArrayList wspspNames = new ArrayList();
        String querystr = null;
        String user = owner;
        try {
            if (user == null) {
                user = conn.getMetaData().getUserName();
            }
            querystr = "select column_name from all_wm_ind_columns where owner = ? and table_name = ?";
            st = conn.prepareStatement(querystr);
            st.setString(1, user.toUpperCase());
            st.setString(2, table.toUpperCase());
            rs = st.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(querystr, ex);
            wspspNames = null;
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return null;
    }

    public static boolean setTablePrimaryKey(Connection conn, String table, String keyColumn) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("Table name name is null.");
        }
        if (keyColumn == null) {
            throw new Exception("Key column name is null.");
        }
        Statement st = null;
        ResultSet rs = null;
        String alterTable = null;
        try {
            alterTable = "alter table " + table + " add primary key (" + keyColumn + ")";
            st = conn.prepareStatement(alterTable);
            st.execute();
        }
        catch (Exception ex) {
            log.severe(alterTable + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return true;
    }

    public static boolean isVersionedTable(Connection conn, String owner, String table) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("Table name name is null.");
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        String querystr = null;
        String user = owner;
        try {
            if (user == null) {
                user = conn.getMetaData().getUserName();
            }
            querystr = "select table_name from all_wm_versioned_tables where  owner = ? and table_name = ?";
            st = conn.prepareStatement(querystr);
            st.setString(1, user.toUpperCase());
            st.setString(2, table.toUpperCase());
            rs = st.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            log.severe(querystr + "\n" + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        return false;
    }

    public static boolean enableVersioning(Connection conn, String dataName, String historyMode, boolean isTopology, String undoSpace) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (dataName == null) {
            throw new Exception("Data name is null");
        }
        String history = "'NONE'";
        if (historyMode != null) {
            history = "'" + historyMode + "'";
        }
        String topol = "FALSE";
        if (isTopology) {
            topol = "TRUE";
        }
        String undoSp = null;
        if (undoSpace != null) {
            undoSp = "'" + undoSpace + "'";
        }
        CallableStatement callstmt = null;
        String callStr = null;
        callStr = undoSp == null ? "declare\nbegin\ndbms_wm.EnableVersioning('" + dataName + "'," + history + "," + topol + ");\n" + "end;\n" : "declare\nbegin\ndbms_wm.EnableVersioning('" + dataName + "'," + history + "," + topol + "," + undoSp + ");\n" + "end;\n";
        try {
            callstmt = conn.prepareCall(callStr);
            callstmt.execute();
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(callStr, ex);
            throw ex;
        }
        finally {
            if (callstmt != null) {
                try {
                    callstmt.close();
                }
                catch (Exception ex) {}
            }
        }
        return true;
    }

    public static boolean disableVersioning(Connection conn, String table, boolean force, boolean ignoreLastError, boolean isTopology) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("Table name is null");
        }
        String forceStr = "FALSE";
        if (force) {
            forceStr = "TRUE";
        }
        String ignoreLError = "FALSE";
        if (ignoreLastError) {
            ignoreLError = "TRUE";
        }
        String topol = "FALSE";
        if (isTopology) {
            topol = "TRUE";
        }
        CallableStatement callstmt = null;
        String callStr = "declare\nbegin\ndbms_wm.DisableVersioning('" + table + "'," + forceStr + "," + ignoreLError + "," + topol + ");\n" + "end;\n";
        try {
            callstmt = conn.prepareCall(callStr);
            callstmt.execute();
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(callStr, ex);
            throw ex;
        }
        finally {
            if (callstmt != null) {
                try {
                    callstmt.close();
                }
                catch (Exception ex) {}
            }
        }
        return true;
    }

    public static boolean createWorkspace(Connection conn, String parentWorkspace, String childWorkspace) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (parentWorkspace == null) {
            throw new Exception("Parent workspace name is null");
        }
        if (childWorkspace == null) {
            throw new Exception("Child workspace name is null");
        }
        Statement callstmt = null;
        String callStr = "declare\nbegin\ndbms_wm.CreateWorkspace('" + childWorkspace + "'," + "'VIEW_WO_OVERWRITE');\n" + "end;\n";
        String parWksp = "LIVE";
        if (parentWorkspace != null) {
            parWksp = parentWorkspace;
        }
        try {
            Util.gotoWorkspace(conn, parWksp);
            callstmt = conn.prepareCall(callStr);
            callstmt.execute();
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(callStr, ex);
            throw ex;
        }
        finally {
            if (callstmt != null) {
                try {
                    callstmt.close();
                }
                catch (Exception ex) {}
            }
            if (conn != null && !parWksp.equals("LIVE")) {
                try {
                    Util.gotoWorkspace(conn, "LIVE");
                }
                catch (Exception re) {}
            }
        }
        return true;
    }

    public static boolean removeWorkspace(Connection conn, String workspace) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (workspace == null) {
            throw new Exception("Workspace name is null");
        }
        String parWksp = ORAWorkspaceJDBCUtil.getParentWorkspace(conn, null, workspace);
        if (parWksp == null) {
            throw new Exception("Parent workspace of [" + workspace + "] is null.");
        }
        Statement callstmt = null;
        String callStr = "declare\nbegin\ndbms_wm.RemoveWorkspace('" + workspace + "');\n" + "end;\n";
        try {
            Util.gotoWorkspace(conn, parWksp);
            callstmt = conn.prepareCall(callStr);
            callstmt.execute();
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(callStr, ex);
            throw ex;
        }
        finally {
            if (callstmt != null) {
                try {
                    callstmt.close();
                }
                catch (Exception ex) {}
            }
            if (conn != null && !parWksp.equals("LIVE")) {
                try {
                    Util.gotoWorkspace(conn, "LIVE");
                }
                catch (Exception re) {}
            }
        }
        return true;
    }

    public static boolean mergeTable(Connection conn, String table, String childWksp) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("Table name is null");
        }
        if (childWksp == null) {
            throw new Exception("Child workspace name is null");
        }
        Statement callstmt = null;
        String callStr = null;
        try {
            callStr = "declare\nbegin\ndbms_wm.MergeTable('" + childWksp + "','" + table + "'," + "'',FALSE,FALSE,TRUE);\n" + "end;\n";
            callstmt = conn.prepareCall(callStr);
            callstmt.execute();
            log.finest("Merge table operation is completed.");
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(callStr, ex);
            throw ex;
        }
        finally {
            if (callstmt != null) {
                try {
                    callstmt.close();
                }
                catch (Exception ex) {}
            }
            if (conn != null) {
                // empty if block
            }
        }
        return true;
    }

    public static boolean mergeWorkspace(Connection conn, String childWksp) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (childWksp == null) {
            throw new Exception("Child workspace name is null");
        }
        Statement callstmt = null;
        String callStr = null;
        try {
            callStr = "declare\nbegin\ndbms_wm.MergeWorkspace('" + childWksp + "');\n" + "end;\n";
            callstmt = conn.prepareCall(callStr);
            callstmt.execute();
            log.finest("Merge workspace operation is completed.");
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(callStr, ex);
            throw ex;
        }
        finally {
            if (callstmt != null) {
                try {
                    callstmt.close();
                }
                catch (Exception ex) {}
            }
        }
        return true;
    }

    public static boolean lockTopologyRows(Connection conn, String workspace, String topology, String lockMode, double xmin, double ymin, double xmax, double ymax) throws Exception {
        String modeLock = "E";
        String whereClause = "";
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (workspace == null) {
            throw new Exception("Workspace name is null.");
        }
        if (topology == null) {
            throw new Exception("Topology name is null.");
        }
        if (Double.isNaN(xmin)) {
            throw new Exception("Invalid X minimum value.");
        }
        if (Double.isNaN(ymin)) {
            throw new Exception("Invalid Y minimum value.");
        }
        if (Double.isNaN(xmax)) {
            throw new Exception("Invalid X maximum value.");
        }
        if (Double.isNaN(ymax)) {
            throw new Exception("Invalid Y maximum value.");
        }
        if (lockMode != null) {
            modeLock = lockMode;
        }
        Statement callstmt = null;
        String callStr = null;
        try {
            callStr = "declare\nbegin\ndbms_wm.LockRows('" + workspace + "','" + topology + "'," + "'" + whereClause + "'," + "'" + modeLock + "'," + xmin + "," + ymin + "," + xmax + "'" + ymax + ");\n" + "end;\n";
            callstmt = conn.prepareCall(callStr);
            callstmt.execute();
            log.finest("Lock topology workspace rows operation is completed.");
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(callStr, ex);
            throw ex;
        }
        finally {
            if (callstmt != null) {
                try {
                    callstmt.close();
                }
                catch (Exception ex) {}
            }
        }
        return true;
    }

    public static boolean unlockTopologyRows(Connection conn, String workspace, String topology, String lockMode, String userORall, double xmin, double ymin, double xmax, double ymax) throws Exception {
        String modeLock = "ES";
        String whereClause = "";
        String user = "USER";
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (workspace == null) {
            throw new Exception("Workspace name is null.");
        }
        if (topology == null) {
            throw new Exception("Topology name is null.");
        }
        if (Double.isNaN(xmin)) {
            throw new Exception("Invalid X minimum value.");
        }
        if (Double.isNaN(ymin)) {
            throw new Exception("Invalid Y minimum value.");
        }
        if (Double.isNaN(xmax)) {
            throw new Exception("Invalid X maximum value.");
        }
        if (Double.isNaN(ymax)) {
            throw new Exception("Invalid Y maximum value.");
        }
        if (lockMode != null) {
            modeLock = lockMode;
        }
        if (userORall != null) {
            user = userORall;
        }
        Statement callstmt = null;
        String callStr = null;
        try {
            callStr = "declare\nbegin\ndbms_wm.UnlockRows('" + workspace + "','" + topology + "'," + "'" + whereClause + "'," + "'" + user + "'," + "'" + modeLock + "'," + xmin + "," + ymin + "," + xmax + "'" + ymax + ");\n" + "end;\n";
            callstmt = conn.prepareCall(callStr);
            callstmt.execute();
            log.finest("Unlock topology workspace rows operation is completed.");
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(callStr, ex);
            throw ex;
        }
        finally {
            if (callstmt != null) {
                try {
                    callstmt.close();
                }
                catch (Exception ex) {}
            }
        }
        return true;
    }

    public static Vector<FeatureConflictDescriptor> getFeatureConflicts(Connection conn, String table, String keyColumn, String parentWorkspace, String childWorkspace) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("Table name is null");
        }
        if (keyColumn == null) {
            throw new Exception("Key attribute name is null.");
        }
        if (parentWorkspace == null) {
            throw new Exception("Parent workspace name is null");
        }
        if (childWorkspace == null) {
            throw new Exception("Child workspace name is null");
        }
        Vector<FeatureConflictDescriptor> conflicts = new Vector<FeatureConflictDescriptor>();
        String query = "select * from " + table + "_conf where " + "wm_workspace = ? or wm_workspace = ? " + "order by " + keyColumn;
        PreparedStatement st = null;
        ResultSet rs = null;
        Hashtable<String, Object[]> childValues = new Hashtable<String, Object[]>();
        Hashtable<String, Object[]> parentValues = new Hashtable<String, Object[]>();
        try {
            Util.gotoWorkspace(conn, childWorkspace);
            st = conn.prepareStatement(query);
            st.setString(1, childWorkspace);
            st.setString(2, parentWorkspace);
            rs = st.executeQuery();
            ResultSetMetaData rsmeta = rs.getMetaData();
            int colCnt = rsmeta.getColumnCount();
            int keyIndex = -1;
            int wmwkspIndex = -1;
            int wmdelIndex = -1;
            for (int i = 1; i <= colCnt; ++i) {
                String colname = rsmeta.getColumnName(i);
                if (colname.equalsIgnoreCase(keyColumn)) {
                    keyIndex = i - 1;
                    continue;
                }
                if (colname.equalsIgnoreCase("WM_WORKSPACE")) {
                    wmwkspIndex = i - 1;
                    continue;
                }
                if (!colname.equalsIgnoreCase("WM_DELETED")) continue;
                wmdelIndex = i - 1;
            }
            while (rs.next()) {
                Object[] objs = new Object[colCnt];
                String wksp = null;
                String key = null;
                for (int i = 1; i <= colCnt; ++i) {
                    String colname = rsmeta.getColumnName(i);
                    objs[i - 1] = rs.getObject(i);
                    if (colname.equalsIgnoreCase(keyColumn)) {
                        key = objs[i - 1].toString();
                        continue;
                    }
                    if (!colname.equalsIgnoreCase("WM_WORKSPACE")) continue;
                    wksp = objs[i - 1].toString();
                }
                if (wksp == null || key == null) continue;
                if (wksp.equalsIgnoreCase(childWorkspace)) {
                    childValues.put(key, objs);
                    continue;
                }
                parentValues.put(key, objs);
            }
            if (childValues.size() > 0) {
                Enumeration e = childValues.keys();
                while (e.hasMoreElements()) {
                    Object[] parentObjs;
                    String key = (String)e.nextElement();
                    Object[] childObjs = (Object[])childValues.get(key);
                    if (childObjs == null || (parentObjs = (Object[])parentValues.get(key)) == null) continue;
                    for (int i = 0; i < colCnt; ++i) {
                        if (i == keyIndex || i == wmwkspIndex || i == wmdelIndex || childObjs[i] == null && parentObjs[i] == null || !(childObjs[i] != null && parentObjs[i] == null || childObjs[i] == null && parentObjs[i] != null) && childObjs[i].equals(parentObjs[i])) continue;
                        Object childObj = null;
                        Object parentObj = null;
                        if (rsmeta.getColumnTypeName(i + 1).equalsIgnoreCase("MDSYS.SDO_GEOMETRY")) {
                            childObj = JGeometry.load((STRUCT)((STRUCT)childObjs[i]));
                            parentObj = JGeometry.load((STRUCT)((STRUCT)parentObjs[i]));
                        } else if (rsmeta.getColumnTypeName(i + 1).equalsIgnoreCase("MDSYS.ST_ANNOTATION_TEXT")) {
                            childObj = AnnotationText.load((STRUCT)childObjs[i]);
                            parentObj = AnnotationText.load((STRUCT)parentObjs[i]);
                        } else {
                            childObj = childObjs[i];
                            parentObj = parentObjs[i];
                        }
                        FeatureConflictDescriptor fc = new FeatureConflictDescriptor(key, rsmeta.getColumnName(i + 1), parentObj, childObj, parentObjs[wmdelIndex].toString(), childObjs[wmdelIndex].toString(), "child");
                        conflicts.add(fc);
                    }
                }
            }
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(query, ex);
            conflicts.clear();
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    Util.gotoWorkspace(conn, "LIVE");
                }
                catch (Exception re) {}
            }
        }
        return conflicts;
    }

    public static String[] getTableWorkspaces(Connection conn, String table) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("Table name is null");
        }
        Statement st = null;
        ResultSet rs = null;
        ArrayList<String> wspNames = new ArrayList<String>();
        String querystr = null;
        String user = null;
        try {
            user = conn.getMetaData().getUserName();
            querystr = "select distinct(workspace), table_name from all_wm_modified_tables where table_name = ?";
            st = conn.prepareStatement(querystr);
            st.setString(1, user.toUpperCase() + "." + table.toUpperCase());
            rs = st.executeQuery();
            while (rs.next()) {
                wspNames.add(rs.getString(1));
            }
        }
        catch (Exception ex) {
            wspNames = null;
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
        }
        if (wspNames == null) {
            return null;
        }
        if (wspNames.size() > 0) {
            Collections.sort(wspNames);
        }
        return wspNames.toArray(new String[wspNames.size()]);
    }

    public static boolean resolveConflicts(Connection conn, String table, String keyColumn, String childWorkspace, Vector<FeatureConflictDescriptor> conflicts) throws Exception {
        if (conflicts == null) {
            throw new Exception("Conflict list is null.");
        }
        if (conflicts.size() == 0) {
            log.warning("There are no conflicts to be resolved. Conflict list is empty.");
            return true;
        }
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("Table name is null");
        }
        if (keyColumn == null) {
            throw new Exception("Key attribute name is null.");
        }
        if (childWorkspace == null) {
            throw new Exception("Child workspace name is null.");
        }
        boolean hasParentSelection = false;
        for (int i = 0; i < conflicts.size(); ++i) {
            FeatureConflictDescriptor fc = conflicts.get(i);
            String resolve = fc.getResolveWorkspace();
            if (!resolve.equalsIgnoreCase("parent")) continue;
            hasParentSelection = true;
            break;
        }
        Statement st = null;
        Statement dStmt = null;
        Statement uStmt = null;
        Statement callStmt = null;
        ResultSet rs = null;
        boolean autoCommit = false;
        String childWKSP = childWorkspace;
        boolean isUpdateChild = true;
        boolean isResolve = false;
        String lastCall = null;
        try {
            String callComRes;
            String callBR;
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            Util.gotoWorkspace(conn, childWKSP);
            if (hasParentSelection) {
                String resolve;
                FeatureConflictDescriptor fc;
                int i;
                ArrayList<String> delRecords = new ArrayList<String>();
                for (i = 0; i < conflicts.size(); ++i) {
                    boolean isdel;
                    fc = conflicts.get(i);
                    resolve = fc.getResolveWorkspace();
                    if (!resolve.equalsIgnoreCase("parent") || !(isdel = fc.isParentRecordDeleted())) continue;
                    delRecords.add(fc.getKey());
                }
                for (i = 0; i < conflicts.size(); ++i) {
                    String query;
                    fc = conflicts.get(i);
                    resolve = fc.getResolveWorkspace();
                    if (!resolve.equalsIgnoreCase("parent")) continue;
                    String key = fc.getKey();
                    String column = fc.getAttribute();
                    Object value = fc.getParentValue();
                    if (delRecords.contains(key)) continue;
                    lastCall = query = "update " + table + " set " + column + " = ? " + " where " + keyColumn + " = ?";
                    uStmt = conn.prepareStatement(query);
                    ORAWorkspaceJDBCUtil.setBindingVariable(conn, (PreparedStatement)uStmt, value, 1);
                    ORAWorkspaceJDBCUtil.setBindingVariable(conn, (PreparedStatement)uStmt, key, 2);
                    uStmt.executeUpdate();
                    uStmt.close();
                }
                if (delRecords.size() > 0) {
                    for (i = 0; i < delRecords.size(); ++i) {
                        String query = "delete from " + table + " where " + keyColumn + " = ?";
                        dStmt = conn.prepareStatement(query);
                        dStmt.setString(1, ((String)delRecords.get(i)).toString());
                        dStmt.execute();
                        dStmt.close();
                    }
                }
                conn.commit();
            }
            isUpdateChild = false;
            String lastKey = null;
            lastCall = callBR = "declare\nbegin\ndbms_wm.BeginResolve('" + childWKSP + "');\n" + "end;\n";
            callStmt = conn.prepareCall(callBR);
            callStmt.execute();
            callStmt.close();
            isResolve = true;
            for (int i = 0; i < conflicts.size(); ++i) {
                String callResolve;
                FeatureConflictDescriptor fc = conflicts.get(i);
                String key = fc.getKey();
                if (key.equalsIgnoreCase(lastKey)) continue;
                lastKey = key;
                lastCall = callResolve = "declare\nbegin\ndbms_wm.ResolveConflicts('" + childWKSP + "'," + "'" + table + "'," + "'" + keyColumn + " = ''" + key + "'''," + "'child');\n" + "end;\n";
                callStmt = conn.prepareCall(callResolve);
                callStmt.execute();
                callStmt.close();
            }
            conn.commit();
            lastCall = callComRes = "declare\nbegin\ndbms_wm.CommitResolve('" + childWKSP + "');\n" + "end;\n";
            callStmt = conn.prepareCall(callComRes);
            callStmt.execute();
            callStmt.close();
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(lastCall, ex);
            if (conn != null && isUpdateChild) {
                try {
                    conn.rollback();
                }
                catch (Exception esp) {
                    // empty catch block
                }
            }
            if (conn != null && isResolve) {
                try {
                    String callRBRes = "declare\nbegin\ndbms_wm.RollbackResolve('" + childWKSP + "');\n" + "end;\n";
                    callStmt = conn.prepareCall(callRBRes);
                    callStmt.execute();
                    callStmt.close();
                }
                catch (Exception esp) {
                    // empty catch block
                }
            }
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
            if (dStmt != null) {
                try {
                    dStmt.close();
                }
                catch (Exception re) {}
            }
            if (uStmt != null) {
                try {
                    uStmt.close();
                }
                catch (Exception re) {}
            }
            if (callStmt != null) {
                try {
                    callStmt.close();
                }
                catch (Exception re) {}
            }
            if (conn != null) {
                try {
                    Util.gotoWorkspace(conn, "LIVE");
                }
                catch (Exception re) {}
                conn.setAutoCommit(autoCommit);
            }
        }
        return true;
    }

    public static boolean isWorkspaceTableModified(Connection conn, String table, String parentWorkspace, String childWorkspace) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("Table name is null");
        }
        if (parentWorkspace == null) {
            throw new Exception("Parent workspace name is null");
        }
        if (childWorkspace == null) {
            throw new Exception("Child workspace name is null");
        }
        Statement st = null;
        ResultSet rs = null;
        Statement callStmt = null;
        String query = null;
        try {
            query = "declare\nbegin\nDBMS_WM.SetDiffVersions('" + parentWorkspace + "','" + childWorkspace + "');\n" + "end;\n";
            callStmt = conn.prepareCall(query);
            callStmt.execute();
            String tbname = table + "_diff";
            query = "select count(*) from " + tbname.toLowerCase() + " where " + "WM_DIFFVER=? and WM_CODE in (?,?,?)";
            st = conn.prepareStatement(query);
            st.setString(1, childWorkspace + ", LATEST");
            st.setString(2, "U");
            st.setString(3, "D");
            st.setString(4, "I");
            rs = st.executeQuery();
            if (rs.next()) {
                int count = rs.getInt(1);
                if (count > 0) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(query, ex);
            throw ex;
        }
        finally {
            try {
                if (callStmt != null) {
                    callStmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
        return false;
    }

    public static String[] getModifiedWorkspacesForTable(Connection conn, String tableName) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (tableName == null) {
            throw new Exception("Table name is null");
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        String query = null;
        String user = conn.getMetaData().getUserName();
        ArrayList<String> names = new ArrayList<String>();
        try {
            query = "select workspace from all_wm_modified_tables where table_name = ?";
            st = conn.prepareStatement(query);
            String name = tableName;
            if (name.indexOf(".") < 0) {
                name = user + "." + tableName;
            }
            st.setString(1, name.toUpperCase());
            rs = st.executeQuery();
            while (rs.next()) {
                String wksp = rs.getString(1);
                if (wksp == null || names.contains(wksp)) continue;
                names.add(wksp);
            }
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(query, ex);
            throw ex;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
        if (names.size() == 0) {
            return null;
        }
        return names.toArray(new String[names.size()]);
    }

    public static String[] getModifiedTablesForWorkspace(Connection conn, String workspace) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (workspace == null) {
            throw new Exception("Workspace name is null");
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        String query = null;
        String user = conn.getMetaData().getUserName();
        ArrayList<String> names = new ArrayList<String>();
        try {
            query = "select table_name from all_wm_modified_tables where workspace = ?";
            st = conn.prepareStatement(query);
            st.setString(1, workspace);
            rs = st.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                String owner = user;
                int index = name.indexOf(".");
                if (index > -1) {
                    owner = name.substring(0, index);
                    name = owner.equalsIgnoreCase(user) ? name.substring(index + 1, name.length()) : null;
                }
                if (name == null || names.contains(name)) continue;
                names.add(name);
            }
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(query, ex);
            throw ex;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
        if (names.size() == 0) {
            return null;
        }
        return names.toArray(new String[names.size()]);
    }

    public static String[] getModifiedWorkspacesForTopology(Connection conn, String topology) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (topology == null) {
            throw new Exception("Data name (table or topology) is null");
        }
        Statement st = null;
        ResultSet rs = null;
        String query = null;
        String user = conn.getMetaData().getUserName();
        ArrayList<String> names = new ArrayList<String>();
        String topoTables = "'" + user + "." + topology + "_NODE$'";
        topoTables = topoTables + ",'" + user + "." + topology + "_EDGE$'";
        topoTables = topoTables + ",'" + user + "." + topology + "_FACE$'";
        topoTables = topoTables + ",'" + user + "." + topology + "_RELATION$'";
        try {
            query = "select distinct workspace from all_wm_modified_tables where table_name in (" + topoTables.toUpperCase() + ") or " + "table_name in (select distinct table_name from all_sdo_topo_metadata where owner = '" + user.toUpperCase() + "')";
            st = conn.prepareStatement(query);
            rs = st.executeQuery();
            while (rs.next()) {
                String wksp = rs.getString(1);
                if (wksp == null || names.contains(wksp)) continue;
                names.add(wksp);
            }
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(query, ex);
            throw ex;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
        if (names.size() == 0) {
            return null;
        }
        return names.toArray(new String[names.size()]);
    }

    public static String[] getVersionedTables(Connection conn) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        PreparedStatement st = null;
        ResultSet rs = null;
        String query = null;
        String user = conn.getMetaData().getUserName();
        ArrayList<String> names = new ArrayList<String>();
        try {
            query = "select table_name from all_wm_versioned_tables where owner = ?";
            st = conn.prepareStatement(query);
            st.setString(1, user.toUpperCase());
            rs = st.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                if (name == null) continue;
                names.add(name);
            }
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(query, ex);
            throw ex;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (st != null) {
                    st.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
        if (names.size() == 0) {
            return null;
        }
        return names.toArray(new String[names.size()]);
    }

    private static void flushError(String query, Exception ex) {
        if (ex == null) {
            return;
        }
        if (query != null) {
            log.info("Action:\n" + query);
        }
        log.severe("Exception: " + ex.getMessage());
    }

    public static Object getTableAttributeAsObject(Connection conn, String workspace, String table, String keyAttribute, String keyValue, String attribute) throws Exception {
        if (conn == null) {
            throw new Exception("Connection is null.");
        }
        if (workspace == null) {
            throw new Exception("Workspace name is null");
        }
        if (table == null) {
            throw new Exception("Table name is null");
        }
        if (keyAttribute == null) {
            throw new Exception("Key attribute name is null");
        }
        if (keyValue == null) {
            throw new Exception("Key value is null");
        }
        if (attribute == null) {
            throw new Exception("Attribute name is null");
        }
        Statement st = null;
        ResultSet rs = null;
        String user = null;
        String query = null;
        String wksp = "LIVE";
        if (!workspace.equalsIgnoreCase(wksp)) {
            wksp = workspace;
        }
        try {
            user = conn.getMetaData().getUserName();
            Util.gotoWorkspace(conn, workspace);
            query = "select " + attribute + " from " + table + " where " + keyAttribute + " = ?";
            st = conn.prepareStatement(query);
            st.setString(1, keyValue);
            rs = st.executeQuery();
            if (rs.next()) {
                Object object = rs.getObject(1);
                return object;
            }
        }
        catch (Exception ex) {
            ORAWorkspaceJDBCUtil.flushError(query, ex);
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception re) {}
            }
            if (conn != null && !wksp.equals("LIVE")) {
                try {
                    Util.gotoWorkspace(conn, "LIVE");
                }
                catch (Exception re) {}
            }
        }
        return null;
    }

    private static void setBindingVariable(Connection conn, PreparedStatement stmt, Object var, int idx) throws SQLException, IllegalArgumentException {
        if (conn == null) {
            return;
        }
        if (var == null || var instanceof String) {
            stmt.setString(idx, (String)var);
        } else if (var instanceof Integer) {
            stmt.setInt(idx, (Integer)var);
        } else if (var instanceof Double) {
            stmt.setDouble(idx, (Double)var);
        } else if (var instanceof Float) {
            stmt.setFloat(idx, ((Float)var).floatValue());
        } else if (var instanceof Long) {
            stmt.setLong(idx, (Long)var);
        } else if (var instanceof Short) {
            stmt.setShort(idx, (Short)var);
        } else if (var instanceof Byte) {
            stmt.setByte(idx, (Byte)var);
        } else if (var instanceof BigDecimal) {
            stmt.setBigDecimal(idx, (BigDecimal)var);
        } else if (var instanceof byte[]) {
            stmt.setBytes(idx, (byte[])var);
        } else if (var instanceof Date) {
            stmt.setDate(idx, (Date)var);
        } else if (var instanceof Time) {
            stmt.setTime(idx, (Time)var);
        } else if (var instanceof Timestamp) {
            stmt.setTimestamp(idx, (Timestamp)var);
        } else if (var instanceof JGeometry) {
            JGeometry g = (JGeometry)var;
            STRUCT geom = null;
            Object[] descs = Util.createDBGeomDescriptors(conn);
            geom = JGeometry.store((JGeometry)g, (Connection)conn, (Object[])descs);
            stmt.setObject(idx, geom);
        } else if (var instanceof AnnotationText) {
            AnnotationText atext = (AnnotationText)var;
            STRUCT geom = null;
            Object[] descs = AnnotationText.getDBDescriptors(conn);
            geom = atext.store(conn, descs);
            stmt.setObject(idx, geom);
        } else {
            throw new IllegalArgumentException("Binding data type not supported: " + var.getClass().toString());
        }
    }
}

