/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

import java.awt.geom.Rectangle2D;
import oracle.sdovis.CoordArray;
import oracle.sdovis.Proj;
import oracle.sdovis.Spheroid;

public class ProjMercator
implements Proj {
    private double R;
    private double clat;
    private double clon;
    private double easting;
    private double northing;

    public ProjMercator() {
        this(Spheroid.clarke1866.getSemiMajorAxis(), 0.0, 0.0);
    }

    public ProjMercator(double cLongitude) {
        this(Spheroid.clarke1866.getSemiMajorAxis(), cLongitude, 0.0);
    }

    public ProjMercator(double cLongitude, double cLatitude) {
        this(Spheroid.clarke1866.getSemiMajorAxis(), cLongitude, cLatitude);
    }

    public ProjMercator(double earthRadius, double cLongitude, double cLatitude) {
        this.R = earthRadius;
        this.clon = Proj.util.Clip(cLongitude * (Math.PI / 180), Math.PI * -2, Math.PI * 2);
        this.clat = cLatitude * (Math.PI / 180);
        this.init();
    }

    @Override
    public double[] save() {
        return new double[]{this.getProjId(), this.R, this.clon, this.clat};
    }

    public double getR() {
        return this.R;
    }

    @Override
    public Proj.P2 getCenter() {
        return new Proj.P2(this.clon * 57.29577951308232, this.clat * 57.29577951308232);
    }

    @Override
    public Proj.P2 getOpposite() {
        return null;
    }

    @Override
    public int getProjId() {
        return 2;
    }

    @Override
    public Rectangle2D getBoundingBox(Rectangle2D dataView, Rectangle2D deviceView) {
        return null;
    }

    @Override
    public final boolean forward(double lon, double lat, Proj.P2 result) {
        double x = this.R * Proj.util.adjustLon((lon *= Math.PI / 180) - this.clon);
        double sin_phi = Math.sin(lat *= Math.PI / 180);
        double y = 0.0;
        y = sin_phi != 1.0 ? this.R * 0.5 * Math.log((1.0 + sin_phi) / (1.0 - sin_phi)) : Double.POSITIVE_INFINITY;
        result.set(x + this.easting, y + this.northing);
        return true;
    }

    @Override
    public final boolean inverse(double x, double y, Proj.P2 result) {
        if (Double.isInfinite(y)) {
            return false;
        }
        double ts = Math.exp(-(y -= this.northing) / this.R);
        double lat = 1.5707963267948966 - 2.0 * Math.atan(ts);
        double lon = Proj.util.adjustLon(this.clon + (x -= this.easting) / this.R);
        result.set(lon * 57.29577951308232, lat * 57.29577951308232);
        return true;
    }

    @Override
    public void setOffset(double easting, double northing) {
        this.easting = easting;
        this.northing = northing;
    }

    @Override
    public Proj.P2 getOffset() {
        return new Proj.P2(this.easting, this.northing);
    }

    public boolean isOddPoint(double x, double y) {
        return Double.isInfinite(y);
    }

    @Override
    public double[] getBoundingGeom() {
        return null;
    }

    @Override
    public double[] getParallel(double y, double density) {
        CoordArray ca = new CoordArray(1440);
        int i = 360;
        int k = 0;
        while (i >= -360) {
            ca.add(i, y);
            --i;
            ++k;
        }
        return ca.getAll();
    }

    private void init() {
        this.easting = 0.0;
        this.northing = 0.0;
    }
}

