/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletResponse;
import oracle.lbs.util.ServerInitListener;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.Util;

public class FileIOUtil {
    private static Logger log = LogFactory.getLogger(LogFactory.LoggerEnum.MAPVIEWER);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamFile(HttpServletResponse resp, String filePath, long expires, String mimeType, boolean gzip) {
        byte[] bytes = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            bytes = Util.readFile(filePath);
            if (gzip) {
                resp.setHeader("Content-Encoding", "gzip");
            }
            if (mimeType != null) {
                resp.setContentType(mimeType);
            }
            if (expires > 0L) {
                resp.setDateHeader("Expires", System.currentTimeMillis() + expires * 3600L * 1000L);
            } else if (expires == 0L) {
                resp.addHeader("Cache-Control", "no-cache");
                resp.addHeader("Expires", "Mon, 26 Jul 1997 05:00:00 GMT");
            }
            if (!gzip) {
                resp.setContentLength(bytes.length);
            }
            in = new ByteArrayInputStream(bytes);
            out = resp.getOutputStream();
            if (gzip) {
                out = new GZIPOutputStream(out);
            }
            byte[] buffer = new byte[4096];
            int i = in.read(buffer);
            while (i > 0) {
                out.write(buffer, 0, i);
                i = in.read(buffer);
            }
        }
        catch (IndexOutOfBoundsException ie) {
        }
        catch (IOException ie) {
            log.finer(ie.getMessage());
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
            try {
                if (out != null) {
                    out.flush();
                }
            }
            catch (Exception e) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static InputStream getXSDStream(String xsdFile) {
        String privateDir = ServerInitListener.getPrivateRootFolder();
        String xsdPathName = privateDir + "xsd" + File.separator + xsdFile;
        try {
            return new FileInputStream(xsdPathName);
        }
        catch (FileNotFoundException e) {
            log.warning("xsd file: " + xsdPathName + " not found.");
            return null;
        }
    }
}

