/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.mapcommon;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import oracle.lbs.mapcache.config.TileLayerTheme;
import oracle.lbs.mapcommon.GeoFeature;
import oracle.lbs.mapcommon.MapDefinition;
import oracle.lbs.mapcommon.MapResponse;
import oracle.lbs.mapcommon.ThemeDescriptor;
import oracle.lbs.mapcommon.ThemeIdentify;
import oracle.mapviewer.share.MapBounds;
import oracle.mapviewer.share.NorthArrow;
import oracle.mapviewer.share.ScaleBar;
import oracle.mapviewer.share.ext.NsDpInfo;
import oracle.sdovis.Legend;
import oracle.sdovis.LegendColumn;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.util.UserIdentity;

public class MapRequest
implements Serializable {
    static final long serialVersionUID = 133933289466235682L;
    MapDefinition mapDef = null;
    GeoFeature center = null;
    double size = 0.0;
    long mapScale = Long.MAX_VALUE;
    Dimension deviceSize = new Dimension(500, 375);
    Color backgroundColor = new Color(166, 202, 240);
    String bgImageURL = null;
    String bgImageURL2 = null;
    boolean antiAliase = false;
    boolean verbose = false;
    boolean imageScaling = true;
    ArrayList<TileLayerTheme> tlThemes = null;
    double[] queryWindow = null;
    int imageFormat = 0;
    private String infoformat = null;
    private String service = null;
    private String childlayer = null;
    private boolean isWithUTFGrid = false;
    private short utfgrid_resolution = (short)4;
    String srs = null;
    GeoFeature[] geoFeatures;
    String title;
    String titleStyle = null;
    String footnote;
    String footnoteStyle = null;
    ThemeIdentify themeIdentify = null;
    Legend legend = null;
    boolean isBgTransparent = false;
    int SRid = 0;
    String mapFileName = null;
    Hashtable dynamicStyles = null;
    String originalXMLRequest = null;
    int zoomLevels = 4;
    double zoomFactor = 2.0;
    double initScale = 1.0;
    boolean showNavigationBar = true;
    boolean showSVGInfo = true;
    String svgOnClick = null;
    String svgOnMouseMove = null;
    boolean svgLayersOnly = false;
    boolean svgStyles = true;
    boolean svgLabels = true;
    boolean svgDeviceCoordinateSys = true;
    boolean svgSkipImageThemes = false;
    boolean rasterBaseMapInSVG = false;
    String onRectangleSelect = null;
    String onPolygonSelect = null;
    String[] boundingThemes = null;
    float boundingThemeBorderMargin = 0.05f;
    boolean boundingThemeKeepAspectRatio = true;
    double boundingSizeHint = 0.0;
    ScaleBar scaleBar = null;
    boolean keepThemesOrder = false;
    boolean useCachedBaseMap = false;
    boolean snapToCachedZoomLevel = false;
    boolean wrapAround = false;
    Vector nsdps = null;
    Hashtable themeModifiers = new Hashtable(3);
    MapBounds bounds = null;
    String svgInfoFont = null;
    boolean disableMapPieces = false;
    boolean tileLabeling = false;
    boolean isTileRequest = false;
    double rotation = 0.0;
    NorthArrow northArrow = null;
    UserIdentity userId;
    Rectangle2D mapQueryWindowConstrain = null;
    String userLanguage = null;
    String deviceSizeUnit = null;
    int dpi = 0;

    public void setCenterAndSize(double cx, double cy, double size) {
        this.center = new GeoFeature(cx, cy);
        this.size = size;
    }

    public void setCenter(GeoFeature gf) {
        this.center = gf;
    }

    public void setCenter(double cx, double cy) {
        this.center = new GeoFeature(cx, cy);
    }

    public void setSize(double size) {
        this.size = size;
    }

    public GeoFeature getCenter() {
        return this.center;
    }

    public double getSize() {
        return this.size;
    }

    public void setQueryWindow(double x1, double y1, double x2, double y2) {
        if (this.queryWindow == null) {
            this.queryWindow = new double[4];
        }
        this.queryWindow[0] = x1;
        this.queryWindow[1] = y1;
        this.queryWindow[2] = x2;
        this.queryWindow[3] = y2;
        this.center = null;
        this.size = y2 - y1;
    }

    public void setQueryWindow(double[] win) {
        this.queryWindow = win;
        if (win != null) {
            this.size = win[3] - win[1];
        }
    }

    public double[] getQueryWindow() {
        return this.queryWindow;
    }

    public void setMapDefinition(MapDefinition mdef) {
        this.mapDef = mdef;
    }

    public void setImageScaling(boolean v) {
        this.imageScaling = v;
    }

    public boolean getImageScaling() {
        return this.imageScaling;
    }

    public void setThemeList(ArrayList<TileLayerTheme> list) {
        this.tlThemes = list;
    }

    public ArrayList<TileLayerTheme> getTileLayerThemeList() {
        return this.tlThemes;
    }

    public MapDefinition getMapDefinition() {
        return this.mapDef;
    }

    public void setDeviceSize(Dimension dsz) {
        this.deviceSize = dsz;
    }

    public Dimension getDeviceSize() {
        return this.deviceSize;
    }

    public void setBackgroundColor(Color bg) {
        this.backgroundColor = bg;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundImageURL(String bgImgUrl) {
        this.bgImageURL = bgImgUrl;
    }

    public void setBackgroundImageURL2(String bgImgUrl2) {
        this.bgImageURL2 = bgImgUrl2;
    }

    public String getBackgroundImageURL() {
        return this.bgImageURL;
    }

    public String getBackgroundImageURL2() {
        return this.bgImageURL2;
    }

    public void setAntiAliasing(boolean aa) {
        this.antiAliase = aa;
    }

    public boolean getAntiAliasing() {
        return this.antiAliase;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setImageFormat(int f) {
        this.imageFormat = f;
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    public boolean hasThemes() {
        if (this.mapDef != null) {
            return this.mapDef.hasThemes();
        }
        return false;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        if (this.mapDef != null) {
            return this.mapDef.getTitle();
        }
        return null;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public String getTitleStyleName() {
        return this.titleStyle;
    }

    public void setTitleStyleName(String style) {
        this.titleStyle = style;
    }

    public String getBaseMap() {
        if (this.mapDef != null) {
            return this.mapDef.getBaseMap();
        }
        return null;
    }

    public String getMapDataSource() {
        if (this.mapDef != null) {
            return this.mapDef.getMapDataSource();
        }
        return null;
    }

    public void setLegend(Legend legend) {
        this.legend = legend;
    }

    public Legend getLegend() {
        return this.legend;
    }

    public void setGeoFeatures(GeoFeature[] geo) {
        this.geoFeatures = geo;
    }

    public GeoFeature[] getGeoFeatures() {
        return this.geoFeatures;
    }

    public ThemeIdentify getThemeIdentify() {
        return this.themeIdentify;
    }

    public void setThemeIdentify(ThemeIdentify ti) {
        this.themeIdentify = ti;
    }

    public boolean isBgTransparent() {
        return this.isBgTransparent;
    }

    public void setBgTransparent(boolean v) {
        this.isBgTransparent = v;
    }

    public void setOriginalXMLRequest(String req) {
        this.originalXMLRequest = req;
    }

    public String getOriginalXMLRequest() {
        return this.originalXMLRequest;
    }

    public void setScaleBar(ScaleBar sbar) {
        this.scaleBar = sbar;
    }

    public ScaleBar getScaleBar() {
        return this.scaleBar;
    }

    public void setNorthArrow(NorthArrow na) {
        this.northArrow = na;
    }

    public NorthArrow getNorthArrow() {
        return this.northArrow;
    }

    public boolean isSVGRequest() {
        return this.imageFormat == 27 || this.imageFormat == 28 || this.imageFormat == 18 || this.imageFormat == 17 || this.imageFormat == 16 || this.imageFormat == 15;
    }

    public boolean isPDFRequest() {
        return this.imageFormat == 51 || this.imageFormat == 53;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int count = 0;
        try {
            out.writeObject(this.mapDef);
            out.writeObject(this.center);
            out.writeDouble(this.size);
            out.writeLong(this.mapScale);
            out.writeObject(this.deviceSize);
            out.writeObject(this.deviceSizeUnit);
            out.writeInt(this.dpi);
            out.writeObject(this.backgroundColor);
            out.writeObject(this.bgImageURL);
            out.writeBoolean(this.antiAliase);
            out.writeBoolean(this.verbose);
            out.writeInt(this.imageFormat);
            out.writeObject(this.srs);
            out.writeObject(this.title);
            out.writeObject(this.geoFeatures);
            out.writeObject(this.themeIdentify);
            out.writeBoolean(this.isBgTransparent);
            out.writeInt(this.SRid);
            if (this.queryWindow != null) {
                count = this.queryWindow.length;
            }
            out.writeInt(count);
            for (int i = 0; i < count; ++i) {
                out.writeDouble(this.queryWindow[i]);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw ioe;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        double centerX = 0.0;
        double centerY = 0.0;
        int count = 0;
        try {
            this.mapDef = (MapDefinition)in.readObject();
            this.center = (GeoFeature)in.readObject();
            this.size = in.readDouble();
            this.mapScale = in.readLong();
            this.deviceSize = (Dimension)in.readObject();
            this.deviceSizeUnit = (String)in.readObject();
            this.dpi = in.readInt();
            this.backgroundColor = (Color)in.readObject();
            this.bgImageURL = (String)in.readObject();
            this.antiAliase = in.readBoolean();
            this.verbose = in.readBoolean();
            this.imageFormat = in.readInt();
            this.srs = (String)in.readObject();
            this.title = (String)in.readObject();
            this.geoFeatures = (GeoFeature[])in.readObject();
            this.themeIdentify = (ThemeIdentify)in.readObject();
            this.isBgTransparent = in.readBoolean();
            this.SRid = in.readInt();
            count = in.readInt();
            if (count > 0) {
                this.queryWindow = new double[count];
                for (int i = 0; i < count; ++i) {
                    this.queryWindow[i] = in.readDouble();
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw ioe;
        }
    }

    public String toXMLString() {
        int i;
        ThemeDescriptor[] themes;
        int i2;
        String header = "xml_request=<?xml version=\"1.0\" standalone=\"yes\"?>\n<map_request\n";
        boolean hasThemes = false;
        Point2D pt = null;
        if (this.center != null) {
            pt = this.center.getCenterAsPoint2D();
        }
        if (this.getTitle() != null && this.getTitle().length() > 0) {
            header = header + "  title=\"" + this.getTitle() + "\"\n";
        }
        if (this.getBaseMap() != null && this.getBaseMap().length() > 0) {
            header = header + "  basemap=\"" + this.getBaseMap() + "\"\n";
        }
        if (this.getMapDataSource() != null && this.getMapDataSource().length() > 0) {
            header = header + "  datasource=\"" + this.getMapDataSource() + "\"\n";
        }
        String centerAttr = " size=\"" + this.size + "\"";
        if (this.size == 0.0 && this.mapScale != Long.MAX_VALUE) {
            centerAttr = " scale=\"" + Math.abs(this.mapScale) + "\"";
        }
        if (this.isBgTransparent) {
            header = header + "  transparent=\"true\"\n";
        }
        if (this.isTileRequest) {
            header = header + "  istilereq=\"true\"\n";
        }
        if (this.backgroundColor != null) {
            header = header + "  bgcolor=\"#" + Integer.toHexString(this.backgroundColor.getRGB()).substring(2) + "\"\n";
        }
        header = header + "  srid=\"" + this.SRid + "\"\n" + "  width=\"" + (int)this.deviceSize.getWidth() + "\"\n" + "  height=\"" + (int)this.deviceSize.getHeight() + "\"\n" + (this.deviceSizeUnit != null ? "  width_height_unit=\"" + this.deviceSizeUnit + "\"\n" : "") + (this.dpi > 0 ? "  dpi=\"" + this.dpi + "\"\n" : "") + "  antialiase=\"" + this.antiAliase + "\"\n" + "  format=\"" + MapResponse.getImageFormatString(this.imageFormat) + "\">\n" + (this.rotation != 0.0 ? "  rotation=\"" + this.rotation + "\"\n" : "") + (this.center != null ? "  <center" + centerAttr + ">\n" + "    <geoFeature>\n" + "      <geometricProperty typeName=\"center\">\n" + "        <Point>\n" + "          <coordinates>" + pt.getX() + "," + pt.getY() + "</coordinates>\n" + "        </Point>\n" + "      </geometricProperty>\n" + "    </geoFeature>\n" + "  </center>\n" : "");
        if (this.geoFeatures != null) {
            for (i2 = 0; i2 < this.geoFeatures.length; ++i2) {
                String labelStyleName;
                String label;
                if (this.geoFeatures[i2] == null) continue;
                Point2D cpt = this.geoFeatures[i2].getCenterAsPoint2D();
                header = header + "  <geoFeature\n     render_style=\"" + this.geoFeatures[i2].getRenderStyleName() + "\"\n";
                double[] radius = this.geoFeatures[i2].getRadius();
                if (radius != null && radius.length > 0) {
                    header = header + "     radius=\"";
                    for (int j = 0; j < radius.length; ++j) {
                        if (j > 0) {
                            header = header + ",";
                        }
                        header = header + radius[j];
                    }
                    header = header + "\"\n";
                }
                if ((label = this.geoFeatures[i2].getLabel()) != null && label.length() > 0) {
                    header = header + "     label=\"" + label + "\"\n";
                }
                if ((labelStyleName = this.geoFeatures[i2].getLabelStyleName()) != null && labelStyleName.length() > 0) {
                    header = header + "     text_style=\"" + labelStyleName + "\"\n";
                }
                if (this.geoFeatures[i2].forcedLabeling()) {
                    header = header + "     label_always_on=\"true\"\n";
                }
                if (this.geoFeatures[i2].getMarkerStyleSize() > 0) {
                    header = header + "     marker_size=\"" + this.geoFeatures[i2].getMarkerStyleSize() + "\"\n";
                }
                header = header + "  >\n";
                header = header + "    <geometricProperty typeName=\"center\">\n      <Point>\n        <coordinates>" + cpt.getX() + "," + cpt.getY() + "</coordinates>\n" + "      </Point>\n" + "    </geometricProperty>\n" + "  </geoFeature>\n";
            }
        }
        if (this.legend != null) {
            header = header + "  <legend bgstyle=\"fill:" + (this.legend.getBackground() == null ? "none" : MapRequest.getColorString(this.legend.getBackground())) + ";stroke:" + (this.legend.getBorderColor() == null ? "none" : MapRequest.getColorString(this.legend.getBorderColor())) + "\" ";
            switch (this.legend.getProfile()) {
                case 0: {
                    header = header + "profile=\"SMALL\" ";
                    break;
                }
                case 1: {
                    header = header + "profile=\"MEDIUM\" ";
                    break;
                }
                case 2: {
                    header = header + "profile=\"LARGE\" ";
                }
            }
            if (this.legend.getPositionHint() != null) {
                header = header + "position=\"" + this.legend.getPositionHint() + "\" ";
            }
            header = header + ">\n";
            for (i2 = 0; i2 < this.legend.getNumColumns(); ++i2) {
                LegendColumn col = this.legend.getColumn(i2);
                header = header + this.legendColumnToString(col) + "\n";
            }
            header = header + "</legend>\n";
        }
        if (this.northArrow != null) {
            header = header + "  <north_arrow>\n    <style> " + this.northArrow.getStyle() + " </style>\n" + "    <location> " + this.northArrow.getLocationX() + "," + this.northArrow.getLocationY() + " </location>\n" + "    <size> " + this.northArrow.getWidth() + "," + this.northArrow.getHeight() + " </size>\n" + "  </north_arrow>\n";
        }
        if ((themes = this.mapDef.getThemes()) == null) {
            header = header + "</map_request>";
            return header;
        }
        if (themes.length > 1 || themes.length == 1 && themes[0].type != 3) {
            header = header + "  <themes>\n";
            hasThemes = true;
        }
        block12: for (i = themes.length - 1; i >= 0; --i) {
            switch (themes[i].type) {
                case 1: {
                    header = header + "    <theme name=\"" + themes[i].name + "\" min_scale=\"" + themes[i].minScale + "\" max_scale=\"" + themes[i].maxScale + "\" " + (themes[i].labelAlwaysOn ? " label_always_on=\"true\"" : "") + " />\n";
                    continue block12;
                }
                case 2: {
                    header = header + "    <theme name=\"" + themes[i].name + "\" min_scale=\"" + themes[i].minScale + "\" max_scale=\"" + themes[i].maxScale + "\" " + (themes[i].labelAlwaysOn ? " label_always_on=\"true\"" : "") + " >\n" + "       <jdbc_query\n" + "         asis=\"" + themes[i].passThrough + "\"\n" + "         label_column=\"" + themes[i].labelColumn + "\"\n" + "         spatial_column=\"" + themes[i].spatialColumn + "\"\n" + "         jdbc_srid=\"" + themes[i].SRID + "\"\n" + "         label_style=\"" + themes[i].labelStyleName + "\"\n" + "         render_style=\"" + themes[i].renderStyleName + "\"\n" + (themes[i].dataSource != null && (themes[i].host == null || themes[i].host.length() == 0) ? "         datasource=\"" + themes[i].dataSource + "\"" : "         jdbc_host=\"" + themes[i].host + "\"\n" + "         jdbc_port=\"" + themes[i].port + "\"\n" + "         jdbc_sid=\"" + themes[i].sid + "\"\n" + "         jdbc_srid=\"" + themes[i].SRID + "\"\n" + "         jdbc_mode=\"" + themes[i].mode + "\"\n" + "         jdbc_user=\"" + themes[i].user + "\"\n" + "         jdbc_password=\"" + themes[i].passwd + "\"") + ">" + MapRequest.escapeXMLReservedCharacters(themes[i].query) + "</jdbc_query>\n" + "     </theme>\n";
                    continue block12;
                }
            }
        }
        if (hasThemes) {
            header = header + "  </themes>\n";
        }
        for (i = 0; i < themes.length; ++i) {
            if (themes[i].type != 3) continue;
            for (int j = 0; j < themes[i].localTheme.size(); ++j) {
                double[] radius;
                StyledFeatureI feature = themes[i].localTheme.getStyledFeature(j);
                header = header + "  <geoFeature\n     render_style=\"" + feature.getFeatureStyleName() + "\"\n";
                if (feature.getRadius() != null && (radius = feature.getRadius()) != null && radius.length > 0) {
                    header = header + "     radius=\"";
                    for (int k = 0; k < radius.length; ++k) {
                        if (k > 0) {
                            header = header + ",";
                        }
                        header = header + radius[k];
                    }
                    header = header + "\"\n";
                }
                if (feature.getLabel() != null || feature.getLabel().length() > 0) {
                    header = header + "     label=\"" + feature.getLabel() + "\"\n";
                }
                if (feature.getLabelStyleName() != null || feature.getLabelStyleName().length() > 0) {
                    header = header + "     text_style=\"" + feature.getLabelStyleName() + "\"\n";
                }
                if (feature.getMarkerStyleSize() > 0) {
                    header = header + "     marker_size=\"" + feature.getMarkerStyleSize() + "\"\n";
                }
                header = header + "  >\n";
                header = header + "    <geometricProperty typeName=\"center\">\n      <Point>\n        <coordinates>" + feature.getCenterX() + "," + feature.getCenterY() + "</coordinates>\n" + "      </Point>\n" + "    </geometricProperty>\n" + "  </geoFeature>\n";
            }
        }
        header = header + "</map_request>";
        return header;
    }

    private String legendColumnToString(LegendColumn col) {
        String str = "<column>\n";
        for (int i = 0; i < col.getNumEntries(); ++i) {
            str = str + col.getEntry(i).toXMLString() + "\n";
        }
        return str + "</column>\n";
    }

    private static String getColorString(Color color) {
        if (color == null) {
            return "none";
        }
        return "#" + Integer.toHexString(color.getRGB()).substring(2);
    }

    public void setSRS(String s) {
        this.srs = s;
    }

    public String getSRS() {
        return this.srs;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append("MapRequest=\n");
        sb.append("\n title=" + this.title);
        sb.append("\n center=" + this.center);
        sb.append("\n size=" + this.size);
        sb.append("\n scale=" + this.mapScale);
        sb.append("\n verbose=" + this.verbose);
        sb.append("\n srid=" + this.SRid);
        sb.append("\n queryWindow=" + this.queryWindow);
        sb.append("\n imageFormat=" + this.imageFormat);
        sb.append("\n backgroundColor=" + this.backgroundColor);
        sb.append("\n bgImageURL=" + this.bgImageURL);
        sb.append("\n antialise=" + this.antiAliase);
        sb.append("\n deviceSize=" + this.deviceSize);
        sb.append("\n srs=" + this.srs);
        sb.append("\n geoFeatures=" + this.geoFeatures);
        sb.append("\n mapDefinition=" + this.mapDef);
        return sb.toString();
    }

    public void setSRID(int id) {
        this.SRid = id < 0 ? 0 : id;
    }

    public int getSRID() {
        return this.SRid;
    }

    public void setMapFileName(String name) {
        this.mapFileName = name;
    }

    public String getMapFileName() {
        return this.mapFileName;
    }

    public void setSVGZoomLevels(int nZoom) {
        this.zoomLevels = nZoom;
    }

    public int getSVGZoomLevels() {
        return this.zoomLevels;
    }

    public void setSVGZoomFactor(double zfactor) {
        this.zoomFactor = zfactor;
    }

    public double getSVGZoomFactor() {
        return this.zoomFactor;
    }

    public void setSVGInitScale(double scale) {
        this.initScale = scale <= 0.0 ? 1.0 : scale;
    }

    public double getSVGInitScale() {
        return this.initScale;
    }

    public void setSVGNavigationBar(String navbar) {
        this.showNavigationBar = navbar == null ? false : navbar.equalsIgnoreCase("TRUE");
    }

    public boolean getSVGShowNavigationBar() {
        return this.showNavigationBar;
    }

    public void setShowSVGInfo(String info) {
        this.showSVGInfo = info == null ? true : info.equalsIgnoreCase("TRUE");
    }

    public boolean getShowSVGInfo() {
        return this.showSVGInfo;
    }

    public void setSVGOnClick(String fun) {
        if (fun != null && fun.trim().length() > 0) {
            this.svgOnClick = fun.trim();
        }
    }

    public void setSVGOnMouseMove(String fun) {
        if (fun != null && fun.trim().length() > 0) {
            this.svgOnMouseMove = fun.trim();
        }
    }

    public String getSVGOnClick() {
        return this.svgOnClick;
    }

    public String getSVGOnMouseMove() {
        return this.svgOnMouseMove;
    }

    public boolean renderSVGLayersOnly() {
        return this.svgLayersOnly;
    }

    public boolean renderSVGStyles() {
        return this.svgStyles;
    }

    public boolean renderSVGLabels() {
        return this.svgLabels;
    }

    public void setSVGType(String type) {
        if ("LAYERS".equalsIgnoreCase(type)) {
            this.svgLayersOnly = true;
            this.svgStyles = false;
            this.svgLabels = false;
        } else if ("STYLED_LAYERS".equalsIgnoreCase(type)) {
            this.svgLayersOnly = true;
            this.svgStyles = true;
            this.svgLabels = false;
        } else if ("LAYERS_WITH_LABELS".equalsIgnoreCase(type)) {
            this.svgLayersOnly = true;
            this.svgStyles = false;
            this.svgLabels = true;
        } else if ("STYLED_LAYERS_WITH_LABELS".equalsIgnoreCase(type)) {
            this.svgLayersOnly = true;
            this.svgStyles = true;
            this.svgLabels = true;
        } else {
            this.svgLayersOnly = false;
            this.svgStyles = true;
            this.svgLabels = true;
        }
    }

    public boolean getSVGInDevCoordSys() {
        return this.svgDeviceCoordinateSys;
    }

    public void setSVGInDevCoordSys(String deviceCoord) {
        if ("false".equalsIgnoreCase(deviceCoord)) {
            this.svgDeviceCoordinateSys = false;
        }
    }

    public boolean getSVGLayersOnly() {
        return this.svgLayersOnly;
    }

    public boolean getSVGStyles() {
        return this.svgStyles;
    }

    public boolean getSVGLabels() {
        return this.svgLabels;
    }

    public void setBoundingThemes(String[] themes, float borderMargin, boolean keepAspectRatio) {
        this.boundingThemes = new String[themes.length];
        for (int i = 0; i < themes.length; ++i) {
            this.boundingThemes[i] = themes[i];
        }
        this.boundingThemeBorderMargin = borderMargin < 0.0f ? 0.05f : borderMargin;
        this.boundingThemeKeepAspectRatio = keepAspectRatio;
    }

    public String[] getBoundingThemes() {
        return this.boundingThemes;
    }

    public float getBorderMarginForBoundingThemes() {
        return this.boundingThemeBorderMargin;
    }

    public boolean boundingThemesRespectAspectRatio() {
        return this.boundingThemeKeepAspectRatio;
    }

    public double getBoundingThemesSizeHint() {
        return this.boundingSizeHint;
    }

    public void setBoundingThemesSizeHint(double mbrSize) {
        this.boundingSizeHint = mbrSize;
    }

    public void setRenderRasterBaseMapInSVG(boolean r) {
        this.rasterBaseMapInSVG = r;
    }

    public boolean renderRasterBaseMapInSVG() {
        return this.rasterBaseMapInSVG;
    }

    public void setOnRectangleSelect(String onrs) {
        this.onRectangleSelect = onrs;
    }

    public void setOnPolygonSelect(String onps) {
        this.onPolygonSelect = onps;
    }

    public String getOnRectangleSelect() {
        return this.onRectangleSelect;
    }

    public String getOnPolygonSelect() {
        return this.onPolygonSelect;
    }

    public boolean getKeepThemesOrder() {
        return this.keepThemesOrder;
    }

    public void setKeepThemesOrder(boolean order) {
        this.keepThemesOrder = order;
    }

    public void addNsDp(NsDpInfo nsdp) {
        if (this.nsdps == null) {
            this.nsdps = new Vector();
        }
        this.nsdps.add(nsdp);
    }

    public void removeNsDp(NsDpInfo nsdp) {
        if (this.nsdps == null || this.nsdps.size() == 0) {
            return;
        }
        this.nsdps.remove(nsdp);
    }

    public void removeAllNsDps() {
        if (this.nsdps != null) {
            this.nsdps.removeAllElements();
        }
    }

    public Vector getNsDps() {
        return this.nsdps;
    }

    public Hashtable getThemeModifiers() {
        return this.themeModifiers;
    }

    public void addThemeModifier(String theme, String modifier, String value) {
        if (theme == null || modifier == null || value == null) {
            return;
        }
        Hashtable<String, String> tmod = (Hashtable<String, String>)this.themeModifiers.get(theme.toUpperCase());
        if (tmod == null) {
            tmod = new Hashtable<String, String>(3);
            this.themeModifiers.put(theme.toUpperCase(), tmod);
        }
        tmod.put(modifier, value);
    }

    public void removeThemeModifier(String theme, String modifier) {
        if (theme == null || modifier == null) {
            return;
        }
        Hashtable tmod = (Hashtable)this.themeModifiers.get(theme.toUpperCase());
        if (tmod == null) {
            return;
        }
        tmod.remove(modifier);
        if (tmod.size() == 0) {
            this.removeThemeModifiers(theme);
        }
    }

    public void removeThemeModifiers(String theme) {
        if (theme == null) {
            return;
        }
        this.themeModifiers.remove(theme.toUpperCase());
    }

    public void removeAllThemeModifiers() {
        this.themeModifiers.clear();
    }

    public boolean useCachedBaseMap() {
        return this.useCachedBaseMap;
    }

    public void setUseCachedBaseMap(boolean use) {
        this.useCachedBaseMap = use;
    }

    public boolean snapToCachedZoomLevel() {
        return this.snapToCachedZoomLevel;
    }

    public void setSnapToCachedZoomLevel(boolean snap) {
        this.snapToCachedZoomLevel = snap;
    }

    public void setWrapAround(boolean wa) {
        this.wrapAround = wa;
    }

    public boolean getWrapAround() {
        return this.wrapAround;
    }

    public void setMapBounds(MapBounds bounds) {
        this.bounds = bounds;
    }

    public MapBounds getMapBounds() {
        return this.bounds;
    }

    public void setSVGInfoFont(String font) {
        this.svgInfoFont = font;
    }

    public String getSVGInfoFont() {
        return this.svgInfoFont;
    }

    public void setFootnote(String footnote) {
        this.footnote = footnote;
    }

    public String getFootnote() {
        return this.footnote;
    }

    public String getFootnoteStyleName() {
        return this.footnoteStyle;
    }

    public void setFootnoteStyleName(String style) {
        this.footnoteStyle = style;
    }

    public void setDisableMapPieces(boolean disableMapPieces) {
        this.disableMapPieces = disableMapPieces;
    }

    public boolean isDisableMapPieces() {
        return this.disableMapPieces;
    }

    public void setMapScale(long value) {
        this.mapScale = value;
    }

    public long getMapScale() {
        return this.mapScale;
    }

    public void setTileLabeling(boolean tileLabeling) {
        this.tileLabeling = tileLabeling;
    }

    public boolean isTileLabeling() {
        return this.tileLabeling;
    }

    public void setIsTileRequest(boolean tileRequest) {
        this.isTileRequest = tileRequest;
    }

    public boolean isTileRequest() {
        return this.isTileRequest;
    }

    public void setRotation(double angle) {
        this.rotation = angle;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setUserIdentity(UserIdentity id) {
        this.userId = id;
    }

    public UserIdentity getUserIdentity() {
        return this.userId;
    }

    public void setQueryWindowConstraint(Rectangle2D constraint) {
        this.mapQueryWindowConstrain = constraint;
    }

    public Rectangle2D getQueryWindowConstraint() {
        return this.mapQueryWindowConstrain;
    }

    public void setDynamicStyles(Hashtable styles) {
        this.dynamicStyles = styles;
    }

    public Hashtable getDynamicStyles() {
        return this.dynamicStyles;
    }

    public void setUserLanguage(String userLanguage) {
        this.userLanguage = userLanguage;
    }

    public String getUserLanguage() {
        return this.userLanguage;
    }

    public String getInfoFormat() {
        return this.infoformat;
    }

    public void setInfoFormat(String str) {
        this.infoformat = str;
    }

    public String getChildLayer() {
        return this.childlayer;
    }

    public void setChildLayer(String str) {
        this.childlayer = str;
    }

    public String getServiceType() {
        return this.service;
    }

    public void setServiceType(String str) {
        this.service = str;
    }

    public String getDeviceSizeUnit() {
        return this.deviceSizeUnit;
    }

    public void setDeviceSizeUnit(String unit) {
        this.deviceSizeUnit = unit;
    }

    public int getDeviceDPI() {
        return this.dpi;
    }

    public void setDeviceDPI(int dotsPerInch) {
        if (dotsPerInch < 0) {
            return;
        }
        this.dpi = dotsPerInch;
    }

    public void setIsWithUTFGrid(boolean b) {
        this.isWithUTFGrid = b;
    }

    public boolean getIsWithUTFGrid() {
        return this.isWithUTFGrid;
    }

    public void setUTFGridResolution(short n) {
        this.utfgrid_resolution = n;
    }

    public short getUTFGridResolution() {
        return this.utfgrid_resolution;
    }

    public static String escapeXMLReservedCharacters(String str) {
        if (str == null) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str.length() * 2);
        block6: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '%': {
                    sb.append("&#37;");
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

