/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.mapcommon;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import oracle.lbs.mapcache.config.TileLayerTheme;
import oracle.lbs.mapcommon.ThemeDescriptor;
import oracle.sdovis.LocalTheme;
import oracle.sdovis.StyledFeatureI;

public class MapDefinition
implements Serializable {
    static final long serialVersionUID = 451825724650160139L;
    public static final int MAX_THEMES = 256;
    private Hashtable cache = new Hashtable(256);
    private ArrayList order = new ArrayList(256);
    private String title = null;
    private String baseMap = null;
    private String mapDataSource = null;
    private ArrayList<TileLayerTheme> tlThemes = null;

    public ThemeDescriptor getThemeDescriptor(String name) {
        return (ThemeDescriptor)((Object)this.cache.get(name));
    }

    public int getThemePosition(String name) {
        return this.order.indexOf(name);
    }

    public int addPredefinedTheme(String name) throws SQLException {
        return this.addPredefinedTheme(this.cache.size(), name);
    }

    public int addTheme(ThemeDescriptor td) {
        int idx = this.cache.size();
        if (this.cache.get(td.name) != null) {
            this.cache.put(td.name, td);
            return -1;
        }
        this.cache.put(td.name, td);
        this.order.add(idx, td.name);
        return this.cache.size();
    }

    public int addPredefinedTheme(int index, String name) throws SQLException {
        if (this.cache.get(name) != null) {
            return -1;
        }
        ThemeDescriptor td = new ThemeDescriptor();
        td.type = 1;
        td.name = name;
        this.cache.put(name, td);
        this.order.add(index, name);
        return index;
    }

    public int addJDBCTheme(String host, String sid, String port, String user, String passwd, String mode, String name, String query, String spatialColumn, String srid, String renderStyle, String labelColumn, String labelStyle) {
        return this.addJDBCTheme(this.cache.size(), host, sid, port, user, passwd, mode, name, query, spatialColumn, srid, renderStyle, labelColumn, labelStyle);
    }

    public int addJDBCTheme(int index, String host, String sid, String port, String user, String passwd, String mode, String name, String query, String spatialColumn, String srid, String renderStyle, String labelColumn, String labelStyle) {
        ThemeDescriptor td = new ThemeDescriptor();
        td.type = 2;
        td.name = name;
        td.host = host;
        td.sid = sid;
        td.port = port;
        td.mode = mode;
        td.user = user;
        td.passwd = passwd;
        td.query = query;
        td.spatialColumn = spatialColumn;
        try {
            td.SRID = Integer.parseInt(srid);
        }
        catch (Exception e) {
            td.SRID = 0;
        }
        td.renderStyleName = renderStyle;
        td.labelColumn = labelColumn;
        td.labelStyleName = labelStyle;
        if (this.cache.get(name) != null) {
            this.cache.put(name, td);
            return -1;
        }
        this.cache.put(name, td);
        this.order.add(index, name);
        return index;
    }

    public int addLocalTheme(LocalTheme t) {
        return this.addLocalTheme(this.cache.size(), t);
    }

    public int addLocalTheme(int index, LocalTheme t) {
        if (t == null) {
            return -1;
        }
        StyledFeatureI[] v = t.getStyledFeatures();
        if (v == null || v.length == 0) {
            return -1;
        }
        ThemeDescriptor td = new ThemeDescriptor();
        td.name = t.getName();
        td.maxScale = t.getDecorator().getMaxScale();
        td.minScale = t.getDecorator().getMinScale();
        td.type = 3;
        td.localTheme = t;
        if (this.cache.get(t.getName()) != null) {
            this.cache.put(t.getName(), td);
            return -1;
        }
        this.cache.put(t.getName(), td);
        this.order.add(index, t.getName());
        return index;
    }

    public void deleteTheme(String name) {
        int index = this.getThemePosition(name);
        if (index < 0) {
            return;
        }
        this.cache.remove(name);
        this.order.remove(index);
    }

    public void moveThemeUp(int index) {
        try {
            Object t = this.order.remove(index);
            if (t == null) {
                return;
            }
            this.order.add(index - 1, t);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void moveThemeDown(int index) {
        try {
            Object t = this.order.remove(index);
            this.order.add(index + 1, t);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public String getActiveTheme(double currentScale) {
        for (int i = this.order.size() - 1; i >= 0; --i) {
            ThemeDescriptor t = (ThemeDescriptor)((Object)this.cache.get(this.order.get(i)));
            if (!(currentScale >= t.maxScale) || !(currentScale <= t.minScale)) continue;
            return t.name;
        }
        return null;
    }

    public void setThemeScale(String name, double minScale, double maxScale) {
        ThemeDescriptor td = (ThemeDescriptor)((Object)this.cache.get(name));
        td.maxScale = maxScale;
        td.minScale = minScale;
    }

    public String[] getThemeNames() {
        if (this.order.size() == 0) {
            return null;
        }
        return this.order.toArray(new String[this.order.size()]);
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public String getTitle() {
        return this.title;
    }

    public void setBaseMap(String name) {
        this.baseMap = name;
    }

    public String getBaseMap() {
        return this.baseMap;
    }

    public void setMapDataSource(String name) {
        this.mapDataSource = name;
    }

    public String getMapDataSource() {
        return this.mapDataSource;
    }

    public boolean hasThemes() {
        return this.cache.size() > 0;
    }

    public ThemeDescriptor[] getThemes() {
        if (this.hasThemes()) {
            int i = 0;
            ThemeDescriptor[] theThemes = new ThemeDescriptor[this.cache.size()];
            for (i = 0; i < this.order.size(); ++i) {
                theThemes[i] = this.getThemeDescriptor((String)this.order.get(i));
            }
            return theThemes;
        }
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.cache);
        out.writeObject(this.order);
        out.writeObject(this.title);
        out.writeObject(this.baseMap);
        out.writeObject(this.mapDataSource);
        out.writeObject(this.tlThemes);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.cache = (Hashtable)in.readObject();
        this.order = (ArrayList)in.readObject();
        this.title = (String)in.readObject();
        this.baseMap = (String)in.readObject();
        this.mapDataSource = (String)in.readObject();
        this.tlThemes = (ArrayList)in.readObject();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append(" MapDefinition=");
        sb.append("\n  baseMap=" + this.baseMap);
        sb.append("\n  mapDataSource=" + this.mapDataSource);
        sb.append("\n  title=" + this.title);
        if (this.hasThemes()) {
            ThemeDescriptor[] ts = this.getThemes();
            for (int i = 0; i < ts.length; ++i) {
                sb.append("\n  theme [" + i + "]=" + (Object)((Object)ts[i]));
            }
        }
        if (this.tlThemes != null && this.tlThemes.size() > 0) {
            for (int i = 0; i < this.tlThemes.size(); ++i) {
                sb.append("\n theme [" + i + "]=" + this.tlThemes.get(i).getName());
            }
        }
        return sb.toString();
    }
}

