/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.core.Cipher;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.RC2AlgorithmIdentifier;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.Utils;

public class PKCS5
implements Serializable,
ASN1Object {
    private static final long a = 7379820901078112237L;
    public static final int NONE = -2;
    public static final int MD2_DES = -1;
    public static final int MD5_DES = 0;
    public static final int SHA_128RC4 = 1;
    public static final int SHA_40RC4 = 2;
    public static final int SHA_3DES = 3;
    public static final int SHA_2DES = 4;
    public static final int SHA_128RC2 = 5;
    public static final int SHA_40RC2 = 6;
    public static final int DEFAULT_SALT_LEN = 8;
    public static final int DEFAULT_ITER_COUNT = 1024;
    private transient String b;
    private byte[] c;
    private int d;
    private int e;
    private transient ASN1Sequence f;

    public PKCS5() {
        this(3);
    }

    public PKCS5(int n) {
        this((String)null, (byte[])null, 1024, n);
    }

    public PKCS5(int n, int n2, RandomBitsSource randomBitsSource) {
        this.setMode(n);
        this.setCount(n2);
        this.setSalt(this.a(randomBitsSource));
    }

    private byte[] a(RandomBitsSource randomBitsSource) {
        int n = 0;
        switch (this.e) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n = 8;
            }
        }
        return randomBitsSource.randomBytes(new byte[n]);
    }

    public PKCS5(int n, RandomBitsSource randomBitsSource) {
        this(n, 1024, randomBitsSource);
    }

    public PKCS5(RandomBitsSource randomBitsSource) {
        this(3, randomBitsSource);
    }

    public PKCS5(String string, byte[] byArray, int n, int n2) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.b = string;
        this.c = byArray;
        this.d = n;
        this.setMode(n2);
    }

    public PKCS5(String string, byte[] byArray, int n) {
        this(string, byArray, 1024, n);
    }

    public PKCS5(String string, int n, int n2, RandomBitsSource randomBitsSource) {
        this(n, n2, randomBitsSource);
        this.b = string;
    }

    public PKCS5(String string, int n, RandomBitsSource randomBitsSource) {
        this(n, randomBitsSource);
        this.b = string;
    }

    public PKCS5(String string, RandomBitsSource randomBitsSource) {
        this(randomBitsSource);
        this.b = string;
    }

    public PKCS5(byte[] byArray, byte[] byArray2, int n, int n2) {
        this.setPassword(byArray);
        this.setSalt(byArray2);
        this.setCount(n);
        this.setMode(n2);
    }

    public PKCS5(byte[] byArray, byte[] byArray2, int n) {
        this(byArray, byArray2, n, 0);
    }

    public byte[] encrypt(byte[] byArray) throws CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.e == -1 || this.e == 0) {
            return this.a(byArray);
        }
        return this.b(byArray);
    }

    private byte[] a(byte[] byArray) throws CipherException {
        MessageDigest messageDigest;
        try {
            messageDigest = this.e == 0 ? MessageDigest.getInstance(AlgID.md5) : MessageDigest.getInstance(AlgID.md2);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        byte[] byArray2 = new byte[16];
        if (this.b == null) {
            throw new CipherException("Encryption password not set");
        }
        messageDigest.updateASCII(this.b);
        if (this.c == null) {
            this.c = this.a(RandomBitsSource.getDefault());
        }
        messageDigest.update(this.c);
        messageDigest.computeCurrent();
        System.arraycopy(messageDigest.a(), 0, byArray2, 0, byArray2.length);
        int n = this.d - 1;
        for (int i = 0; i < n; ++i) {
            messageDigest.init();
            messageDigest.update(byArray2);
            messageDigest.computeCurrent();
            System.arraycopy(messageDigest.a(), 0, byArray2, 0, byArray2.length);
        }
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[8];
        System.arraycopy(byArray2, 0, byArray3, 0, 8);
        System.arraycopy(byArray2, 8, byArray4, 0, 8);
        try {
            Cipher cipher = Cipher.getInstance(new CBCAlgorithmIdentifier(AlgID.desCBC.getOID(), new ASN1OctetString(byArray4)), new SymmetricKey(byArray3));
            return cipher.encrypt(byArray, true);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
    }

    private byte[] b(byte[] byArray) throws CipherException {
        int n = 0;
        int n2 = 0;
        AlgorithmIdentifier algorithmIdentifier = null;
        switch (this.e) {
            case 1: {
                n = 16;
                n2 = 0;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 2: {
                n = 5;
                n2 = 0;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 3: {
                n = 24;
                n2 = 8;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 4: {
                n = 16;
                n2 = 8;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 5: {
                n = 16;
                n2 = 8;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 6: {
                n = 5;
                n2 = 8;
                algorithmIdentifier = AlgID.sha_1;
            }
        }
        if (this.b == null) {
            throw new CipherException("Encryption password not set");
        }
        if (this.c == null) {
            this.c = this.a(RandomBitsSource.getDefault());
        }
        byte[] byArray2 = PKCS5.pkcs12PseudoRandomBytes((byte)1, n, algorithmIdentifier, this.b, this.c, this.d);
        byte[] byArray3 = null;
        if (n2 != 0) {
            byArray3 = PKCS5.pkcs12PseudoRandomBytes((byte)2, n2, algorithmIdentifier, this.b, this.c, this.d);
        }
        Cipher cipher = null;
        try {
            switch (this.e) {
                case 1: 
                case 2: {
                    cipher = Cipher.getInstance(AlgID.RC4, new SymmetricKey(byArray2));
                    break;
                }
                case 3: {
                    cipher = Cipher.getInstance(new CBCAlgorithmIdentifier(AlgID.DES_EDE3_CBC.getOID(), new ASN1OctetString(byArray3)), new SymmetricKey(byArray2));
                    break;
                }
                case 4: {
                    byte[] byArray4 = new byte[24];
                    System.arraycopy(byArray2, 0, byArray4, 0, 16);
                    System.arraycopy(byArray2, 0, byArray4, 16, 8);
                    byArray2 = byArray4;
                    cipher = Cipher.getInstance(new CBCAlgorithmIdentifier(AlgID.DES_EDE3_CBC.getOID(), new ASN1OctetString(byArray3)), new SymmetricKey(byArray2));
                    break;
                }
                case 5: 
                case 6: {
                    cipher = Cipher.getInstance(new RC2AlgorithmIdentifier(byArray3, byArray2.length * 8), new SymmetricKey(byArray2));
                }
            }
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
        return cipher.encrypt(byArray, true);
    }

    public static byte[] pkcs12PseudoRandomBytes(byte by, int n, AlgorithmIdentifier algorithmIdentifier, String string, byte[] byArray, int n2) throws CipherException {
        int n3;
        MessageDigest messageDigest;
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        try {
            messageDigest = MessageDigest.getInstance(algorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        int n4 = messageDigest.getDigestLength();
        int n5 = 64;
        byte[] byArray2 = new byte[n4];
        if (string == null) {
            throw new CipherException("Encryption password not set");
        }
        byte[] byArray3 = Utils.unicodeToBytes(string);
        byte[] byArray4 = new byte[byArray3.length + 2];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        byArray4[byArray4.length - 1] = 0;
        byArray4[byArray4.length - 2] = 0;
        int n6 = byArray4.length;
        int n7 = byArray.length;
        byte[] byArray5 = new byte[n5];
        Utils.setArray(byArray5, by);
        int n8 = n7 == 0 ? 0 : ((n7 - 1) / n5 + 1) * n5;
        int n9 = n6 == 0 ? 0 : ((n6 - 1) / n5 + 1) * n5;
        byte[] byArray6 = new byte[n8 + n9];
        for (n3 = 0; n3 < n8; n3 += n7) {
            System.arraycopy(byArray, 0, byArray6, n3, Math.min(n8 - n3, n7));
        }
        int n10 = byArray6.length;
        for (n3 = n8; n3 < n10; n3 += n6) {
            System.arraycopy(byArray4, 0, byArray6, n3, Math.min(byArray6.length - n3, n6));
        }
        byte[] byArray7 = new byte[n];
        for (n10 = 0; n10 < n; n10 += n4) {
            messageDigest.init();
            messageDigest.update(byArray5);
            messageDigest.update(byArray6);
            messageDigest.computeCurrent();
            System.arraycopy(messageDigest.a(), 0, byArray2, 0, n4);
            int n11 = n2 - 1;
            for (int i = 0; i < n11; ++i) {
                messageDigest.init();
                messageDigest.update(byArray2);
                messageDigest.computeCurrent();
                System.arraycopy(messageDigest.a(), 0, byArray2, 0, n4);
            }
            byte[] byArray8 = new byte[n5];
            for (n11 = 0; n11 < n5; n11 += n4) {
                System.arraycopy(messageDigest.a(), 0, byArray8, n11, Math.min(n5 - n11, n4));
            }
            BigInteger bigInteger = BigInteger.valueOf(1L);
            BigInteger bigInteger2 = new BigInteger(1, byArray8).add(bigInteger);
            BigInteger bigInteger3 = bigInteger.shiftLeft(n5 * 8).subtract(bigInteger);
            int n12 = byArray6.length;
            for (int i = 0; i < n12; i += n5) {
                byte[] byArray9 = new byte[n5];
                System.arraycopy(byArray6, i, byArray9, 0, n5);
                BigInteger bigInteger4 = new BigInteger(1, byArray9).add(bigInteger2).and(bigInteger3);
                Utils.toByteArray(bigInteger4, byArray6, i, n5);
            }
            System.arraycopy(messageDigest.a(), 0, byArray7, n10, Math.min(n - n10, n4));
        }
        return byArray7;
    }

    public byte[] decrypt(byte[] byArray) throws CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.e == -1 || this.e == 0) {
            return this.c(byArray);
        }
        return this.d(byArray);
    }

    private byte[] c(byte[] byArray) throws CipherException {
        Cipher cipher;
        MessageDigest messageDigest;
        try {
            messageDigest = this.e == 0 ? MessageDigest.getInstance(AlgID.md5) : MessageDigest.getInstance(AlgID.md2);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        if (this.b == null) {
            throw new CipherException("Decryption password not set");
        }
        messageDigest.updateASCII(this.b);
        messageDigest.update(this.c);
        messageDigest.computeCurrent();
        byte[] byArray2 = messageDigest.a();
        int n = this.d - 1;
        for (int i = 0; i < n; ++i) {
            messageDigest.init();
            messageDigest.update(byArray2);
            messageDigest.computeCurrent();
            byArray2 = messageDigest.a();
        }
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[8];
        System.arraycopy(byArray2, 0, byArray3, 0, 8);
        System.arraycopy(byArray2, 8, byArray4, 0, 8);
        try {
            cipher = Cipher.getInstance(new CBCAlgorithmIdentifier(AlgID.desCBC.getOID(), new ASN1OctetString(byArray4)), new SymmetricKey(byArray3));
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
        return cipher.decrypt(byArray, true);
    }

    private byte[] d(byte[] byArray) throws CipherException {
        int n = 0;
        int n2 = 0;
        AlgorithmIdentifier algorithmIdentifier = null;
        switch (this.e) {
            case 1: {
                n = 16;
                n2 = 0;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 2: {
                n = 5;
                n2 = 0;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 3: {
                n = 24;
                n2 = 8;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 4: {
                n = 16;
                n2 = 8;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 5: {
                n = 16;
                n2 = 8;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 6: {
                n = 5;
                n2 = 8;
                algorithmIdentifier = AlgID.sha_1;
            }
        }
        if (this.b == null) {
            throw new CipherException("Decryption password not set");
        }
        byte[] byArray2 = PKCS5.pkcs12PseudoRandomBytes((byte)1, n, algorithmIdentifier, this.b, this.c, this.d);
        byte[] byArray3 = null;
        if (n2 != 0) {
            byArray3 = PKCS5.pkcs12PseudoRandomBytes((byte)2, n2, algorithmIdentifier, this.b, this.c, this.d);
        }
        Cipher cipher = null;
        try {
            switch (this.e) {
                case 1: 
                case 2: {
                    cipher = Cipher.getInstance(AlgID.RC4, new SymmetricKey(byArray2));
                    break;
                }
                case 3: {
                    cipher = Cipher.getInstance(new CBCAlgorithmIdentifier(AlgID.DES_EDE3_CBC.getOID(), new ASN1OctetString(byArray3)), new SymmetricKey(byArray2));
                    break;
                }
                case 4: {
                    byte[] byArray4 = new byte[24];
                    System.arraycopy(byArray2, 0, byArray4, 0, 16);
                    System.arraycopy(byArray2, 0, byArray4, 16, 8);
                    byArray2 = byArray4;
                    cipher = Cipher.getInstance(new CBCAlgorithmIdentifier(AlgID.DES_EDE3_CBC.getOID(), new ASN1OctetString(byArray3)), new SymmetricKey(byArray2));
                    break;
                }
                case 5: 
                case 6: {
                    cipher = Cipher.getInstance(new RC2AlgorithmIdentifier(byArray3, byArray2.length * 8), new SymmetricKey(byArray2));
                }
            }
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
        return cipher.decrypt(byArray, true);
    }

    public int encryptedLength(int n) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        int n2 = 0;
        switch (this.e) {
            case -1: 
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 8;
                break;
            }
            case 1: 
            case 2: {
                n2 = 1;
            }
        }
        if (n2 == 1) {
            return n;
        }
        return n + n2 - n % n2;
    }

    public void setMode(int n) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.e = n;
        if (this.e < -1 || this.e > 6) {
            throw new IllegalArgumentException("Unsupported mode " + n);
        }
        this.f = null;
    }

    public int getMode() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.e;
    }

    public void setPassword(String string) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.b = string;
    }

    public void setPassword(byte[] byArray) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)(byArray[i] & 0xFF));
        }
        this.b = stringBuffer.toString();
    }

    public String getPassword() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.b;
    }

    public void setSalt(byte[] byArray) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.c = byArray;
        this.f = null;
    }

    public byte[] getSalt() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.c;
    }

    public void setCount(int n) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.d = n;
        this.f = null;
    }

    public int getCount() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.d;
    }

    public void setMode(ASN1ObjectID aSN1ObjectID) throws IOException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 5, 1)) {
            this.setMode(-1);
        } else if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 5, 3)) {
            this.setMode(0);
        } else if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 12, 1, 1)) {
            this.setMode(1);
        } else if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 12, 1, 2)) {
            this.setMode(2);
        } else if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 12, 1, 3)) {
            this.setMode(3);
        } else if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 12, 1, 4)) {
            this.setMode(4);
        } else if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 12, 1, 5)) {
            this.setMode(5);
        } else if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 12, 1, 6)) {
            this.setMode(6);
        } else {
            throw new IOException("Unknown PKCS5/12 algorithm");
        }
    }

    public ASN1ObjectID getModeID() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        switch (this.e) {
            case -1: {
                return new ASN1ObjectID(ASN1Utils.pkcsID, 5, 1);
            }
            case 0: {
                return new ASN1ObjectID(ASN1Utils.pkcsID, 5, 3);
            }
            case 1: {
                return new ASN1ObjectID(ASN1Utils.pkcsID, 12, 1, 1);
            }
            case 2: {
                return new ASN1ObjectID(ASN1Utils.pkcsID, 12, 1, 2);
            }
            case 3: {
                return new ASN1ObjectID(ASN1Utils.pkcsID, 12, 1, 3);
            }
            case 4: {
                return new ASN1ObjectID(ASN1Utils.pkcsID, 12, 1, 4);
            }
            case 5: {
                return new ASN1ObjectID(ASN1Utils.pkcsID, 12, 1, 5);
            }
            case 6: {
                return new ASN1ObjectID(ASN1Utils.pkcsID, 12, 1, 6);
            }
        }
        return null;
    }

    public void outputAlgID(OutputStream outputStream) throws IOException {
        this.outputAlgIDASN1().output(outputStream);
    }

    public ASN1Sequence outputAlgIDASN1() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(this.getModeID());
        aSN1Sequence.addElement(this.a());
        return aSN1Sequence;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.a().output(outputStream);
    }

    private ASN1Sequence a() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.f != null) {
            return this.f;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1OctetString(this.c));
        aSN1Sequence.addElement(new ASN1Integer(this.d));
        this.f = aSN1Sequence;
        return this.f;
    }

    public void inputAlgID(InputStream inputStream) throws IOException {
        this.inputAlgID(new ASN1Sequence(inputStream));
    }

    public void inputAlgID(ASN1Sequence aSN1Sequence) throws IOException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        try {
            this.setMode((ASN1ObjectID)aSN1Sequence.elementAt(0));
            this.a((ASN1Sequence)aSN1Sequence.elementAt(1));
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.a(new ASN1Sequence(inputStream));
    }

    private void a(ASN1Sequence aSN1Sequence) throws IOException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.f = aSN1Sequence;
        try {
            this.c = ((ASN1OctetString)aSN1Sequence.elementAt(0)).getValue();
            this.d = ((ASN1Integer)aSN1Sequence.elementAt(1)).getValue().intValue();
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    @Override
    public int length() {
        return this.a().length();
    }

    public String algName() {
        return "PKCS5";
    }

    public static String modeString(int n) {
        String[] stringArray = new String[]{"NONE", "MD2_DES", "MD5_DES", "SHA_128RC4", "SHA_40RC4", "SHA_3DES", "SHA_2DES", "SHA_128RC2", "SHA_40RC2"};
        return stringArray[n + 2];
    }

    public String toString() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return "mode = " + PKCS5.modeString(this.e) + ", salt = " + Utils.toHexString(this.c) + ", count = " + this.d;
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

