/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.WeakHashMap;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlIdentifier;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.token.Token;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

@Deprecated
public class PlSqlInterrogator {
    private PlSqlTokenizer m_tokenizer;
    private PlSqlFragment m_rootFrag;
    private PlSqlToken m_firstToken;
    private PlSqlToken m_nameToken;
    private PlSqlFragment m_triggerBaseItemFragment;
    private String m_source;
    private String m_objType;
    private String m_schemaName;
    private int m_schemaDotNameStart;
    private String m_userDefTypeTypeCode = "";
    private String m_userDefTypeCollectionType = "";
    private boolean m_newStatementBlockReqd;
    private boolean m_fullInterrogation;
    private boolean m_isUserDefType;
    private boolean m_isUserDefTypeSepc;
    private boolean m_isSourceWrapped = false;
    private boolean m_evolvedType = false;
    private Boolean m_containsTodo = null;
    private String[] m_sourceByLines = null;
    private PlSqlSearch m_methodTailSearch = null;
    private PlSqlSearch m_alterSubClauseSearch = null;
    private PlSqlSearch m_dataTypeSearch = null;
    private char[] m_searchBuffer = null;
    private Holder<Boolean> m_cancelled;
    private static HashSet<String> s_knownTypes = new HashSet();
    private static final String OBJECT_TYPECODE = "OBJECT";
    private static final String COLLECTION_TYPECODE = "COLLECTION";
    private static final String TABLE_TYPE = "TABLE";
    private static final String VARRAY_TYPE = "VARYING ARRAY";
    private static final String TYPE_BODY = "TYPE BODY";
    private static final String PACKAGE_BODY = "PACKAGE BODY";
    private static WeakHashMap<String, WeakReference<PlSqlInterrogator>> s_cache = new WeakHashMap();
    private static int s_invocations = 0;
    private boolean m_debug = false;
    private static final String EMPTY_STRING = "";
    private static final String KW_ADD = "ADD";
    private static final String KW_AFTER = "AFTER";
    private static final String KW_ALTER = "ALTER";
    private static final String KW_AS = "AS";
    private static final String KW_BEFORE = "BEFORE";
    private static final String KW_BEGIN = "BEGIN";
    private static final String KW_BODY = "BODY";
    private static final String KW_CALL = "CALL";
    private static final String KW_CASE = "CASE";
    private static final String KW_CONSTRUCTOR = "CONSTRUCTOR";
    private static final String KW_CREATE = "CREATE";
    private static final String KW_CURSOR = "CURSOR";
    private static final String KW_DECLARE = "DECLARE";
    private static final String KW_DROP = "DROP";
    private static final String KW_EACH = "EACH";
    private static final String KW_ELSE = "ELSE";
    private static final String KW_ELSIF = "ELSIF";
    private static final String KW_END = "END";
    private static final String KW_EXCEPTION = "EXCEPTION";
    private static final String KW_FINAL = "FINAL";
    private static final String KW_FOR = "FOR";
    private static final String KW_FUNCTION = "FUNCTION";
    private static final String KW_IF = "IF";
    private static final String KW_INSTANTIABLE = "INSTANTIABLE";
    private static final String KW_INSTEAD = "INSTEAD";
    private static final String KW_IS = "IS";
    private static final String KW_LANGUAGE = "LANGUAGE";
    private static final String KW_LOOP = "LOOP";
    private static final String KW_MAP = "MAP";
    private static final String KW_MEMBER = "MEMBER";
    private static final String KW_MODIFY = "MODIFY";
    private static final String KW_NESTED = "NESTED";
    private static final String KW_NOT = "NOT";
    private static final String KW_OBJECT = "OBJECT";
    private static final String KW_OF = "OF";
    private static final String KW_ON = "ON";
    private static final String KW_OPAQUE = "OPAQUE";
    private static final String KW_OR = "OR";
    private static final String KW_ORDER = "ORDER";
    private static final String KW_OVERRIDING = "OVERRIDING";
    private static final String KW_PACKAGE = "PACKAGE";
    private static final String KW_PRAGMA = "PRAGMA";
    private static final String KW_PROCEDURE = "PROCEDURE";
    private static final String KW_REFERENCING = "REFERENCING";
    private static final String KW_REPLACE = "REPLACE";
    private static final String KW_RETURN = "RETURN";
    private static final String KW_ROW = "ROW";
    private static final String KW_STATIC = "STATIC";
    private static final String KW_TABLE = "TABLE";
    private static final String KW_THEN = "THEN";
    private static final String KW_TRIGGER = "TRIGGER";
    private static final String KW_TYPE = "TYPE";
    private static final String KW_UNDER = "UNDER";
    private static final String KW_UPDATE = "UPDATE";
    private static final String KW_VARRAY = "VARRAY";
    private static final String KW_VARYING = "VARYING";
    private static final String KW_WHEN = "WHEN";
    private static final String KW_WHILE = "WHILE";
    private static final String KW_WRAPPED = "WRAPPED";
    private static final String PUNC_COMMA = ",";
    private static final String PUNC_DBL_LCHEV = "<<";
    private static final String PUNC_DBL_RCHEV = ">>";
    private static final String PUNC_DOT = ".";
    private static final String PUNC_LPAREN = "(";
    private static final String PUNC_RPAREN = ")";
    private static final String PUNC_SEMICOLON = ";";

    private PlSqlInterrogator() {
    }

    public static PlSqlInterrogator findOrCreate(String string) {
        return PlSqlInterrogator.findOrCreate(string, string);
    }

    public static PlSqlInterrogator findOrCreate(String string, String string2) {
        return PlSqlInterrogator.findOrCreate(string, string2, null);
    }

    public static PlSqlInterrogator findOrCreate(String string, String string2, Holder<PlSqlInterrogator> holder) {
        WeakReference<PlSqlInterrogator> weakReference;
        PlSqlInterrogator plSqlInterrogator = null;
        if (s_invocations++ > 1000) {
            weakReference = new ArrayList();
            for (String string3 : s_cache.keySet()) {
                WeakReference<PlSqlInterrogator> weakReference2 = s_cache.get(string3);
                if (weakReference2 == null) {
                    ((ArrayList)((Object)weakReference)).add((String)string3);
                    continue;
                }
                if (weakReference2.get() != null) continue;
                ((ArrayList)((Object)weakReference)).add((String)string3);
            }
            if (((ArrayList)((Object)weakReference)).size() > 0) {
                for (int i = 0; i < ((ArrayList)((Object)weakReference)).size(); ++i) {
                    s_cache.remove(((ArrayList)((Object)weakReference)).get(i));
                }
            }
            s_invocations = 0;
        }
        if ((weakReference = s_cache.get(string)) != null) {
            plSqlInterrogator = (PlSqlInterrogator)weakReference.get();
        }
        if (plSqlInterrogator == null) {
            plSqlInterrogator = new PlSqlInterrogator();
            if (holder != null) {
                holder.set((Object)plSqlInterrogator);
            }
            try {
                plSqlInterrogator.setSource(string2);
                weakReference = new WeakReference<PlSqlInterrogator>(plSqlInterrogator);
                s_cache.put(string, weakReference);
                plSqlInterrogator.m_cancelled = null;
            }
            catch (InterrogatorCancelledException interrogatorCancelledException) {}
        } else if (holder != null) {
            holder.set((Object)plSqlInterrogator);
        }
        return plSqlInterrogator;
    }

    static PlSqlIdentifier getPlSqlIdentifier(String string, String string2, boolean bl) {
        PlSqlInterrogator plSqlInterrogator = new PlSqlInterrogator();
        plSqlInterrogator.interrogateBasics(string);
        return plSqlInterrogator.getPlSqlIdentifier(string2, bl);
    }

    public PlSqlIdentifier getPlSqlIdentifier(String string) {
        return this.getPlSqlIdentifier(string, false);
    }

    public PlSqlIdentifier getPlSqlIdentifier(String string, boolean bl) {
        String string2 = null;
        String string3 = null;
        PlSqlIdentifier.PlSqlType plSqlType = null;
        if (this.m_nameToken != null) {
            string2 = this.m_nameToken.getSource(true);
        }
        string3 = ModelUtil.hasLength((String)this.m_schemaName) && !bl ? this.m_schemaName : string;
        if (ModelUtil.hasLength((String)this.m_objType)) {
            try {
                plSqlType = PlSqlIdentifier.PlSqlType.valueOf(this.m_objType.replaceAll(" ", "_"));
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unknown type " + this.m_objType);
            }
        }
        return new PlSqlIdentifier(string2, string3, plSqlType);
    }

    private void setSource(String string) throws InterrogatorCancelledException {
        this.m_cancelled = new Holder((Object)false);
        this.interrogateBasics(string);
        if (this.m_firstToken != null) {
            this.m_rootFrag = new PlSqlFragment(this);
            this.m_rootFrag.setFragmentType(PlSqlFragment.Type.ROOT);
            this.m_rootFrag.setFirstToken(this.m_firstToken);
            boolean bl = this.m_fullInterrogation;
            if (bl) {
                try {
                    if (this.m_firstToken.matches(KW_BEGIN) || this.m_firstToken.matches(KW_DECLARE)) {
                        this.buildFragmentTree(this.m_firstToken, this.m_rootFrag, InterrogateState.PLSQL_BLOCK);
                    } else {
                        this.buildFragmentTree(this.m_firstToken, this.m_rootFrag, InterrogateState.DECLARATIVE_SECTION);
                    }
                }
                catch (PlSqlInterrogationException plSqlInterrogationException) {
                    this.m_rootFrag.getSubFragments().clear();
                    bl = false;
                }
            }
            if (!bl) {
                PlSqlFragment plSqlFragment = new PlSqlFragment(this, this.m_rootFrag);
                if (this.m_objType.equals(KW_PROCEDURE)) {
                    plSqlFragment.setFragmentType(PlSqlFragment.Type.PROCEDURE);
                } else if (this.m_objType.equals(KW_FUNCTION)) {
                    plSqlFragment.setFragmentType(PlSqlFragment.Type.FUNCTION);
                } else if (this.m_objType.equals(KW_PACKAGE)) {
                    plSqlFragment.setFragmentType(PlSqlFragment.Type.PACKAGE_SPEC);
                } else if (this.m_objType.equals(PACKAGE_BODY)) {
                    plSqlFragment.setFragmentType(PlSqlFragment.Type.PACKAGE_BODY);
                } else if (this.m_objType.equals(KW_TYPE)) {
                    plSqlFragment.setFragmentType(PlSqlFragment.Type.TYPE_SPEC);
                } else if (this.m_objType.equals(TYPE_BODY)) {
                    plSqlFragment.setFragmentType(PlSqlFragment.Type.TYPE_BODY);
                } else {
                    plSqlFragment.setFragmentType(PlSqlFragment.Type.UNKNOWN);
                }
                plSqlFragment.setFirstToken(this.m_firstToken);
                plSqlFragment.setLastToken((PlSqlToken)this.m_tokenizer.getEndMarker().getPrevCodeToken());
                PlSqlFragment plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                plSqlFragment2.setFragmentType(PlSqlFragment.Type.DECLARATION);
                plSqlFragment2.setFirstToken(this.m_firstToken);
                plSqlFragment2.setLastToken((PlSqlToken)this.m_tokenizer.getEndMarker().getPrevCodeToken());
                this.m_rootFrag.setLastToken((PlSqlToken)this.m_tokenizer.getEndMarker().getPrevCodeToken());
            }
        }
    }

    public void cancelCurrentBuild() {
        Holder<Boolean> holder = this.m_cancelled;
        if (holder != null) {
            holder.set((Object)true);
        }
    }

    public boolean isCurrentBuildCancelled() {
        Holder<Boolean> holder = this.m_cancelled;
        if (holder != null) {
            return (Boolean)holder.get();
        }
        return false;
    }

    private void checkInterrupt() {
        if (Thread.currentThread().isInterrupted()) {
            this.cancelCurrentBuild();
        }
    }

    private void checkInterruptOrCancel() throws InterrogatorCancelledException {
        this.checkInterrupt();
        if (this.isCurrentBuildCancelled()) {
            throw new InterrogatorCancelledException();
        }
    }

    private void interrogateBasics(String string) {
        if (this.m_methodTailSearch == null) {
            this.m_methodTailSearch = new PlSqlSearch("[RETURN {SELF AS RESULT|?%} [EXTERNAL [VARIABLE] NAME ? ] ] [{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME?     | C [NAME ?] LIBRARY ?.       [AGENT IN ({^)}...) ]       [WITH CONTEXT]       [PARAMETERS ({^)}...) ]     } ]");
        }
        if (this.m_alterSubClauseSearch == null) {
            this.m_alterSubClauseSearch = new PlSqlSearch("[ALTER TYPE ?.] <action {ADD|DROP|MODIFY} [ATTRIBUTE]> {^{LIMIT|ELEMENT}}");
        }
        if (this.m_dataTypeSearch == null) {
            this.m_dataTypeSearch = new PlSqlSearch("{ <timetamp TIMESTAMP [(?)][WITH [LOCAL] TIME ZONE]> | <interval INTERVAL {YEAR|DAY}[(?)] TO {MONTH|SECOND[(?)]}> | <number NUMBER [(?[,?])]> | <ref REF ?[.?]> | <pct ?[.?]...%{TYPE|ROWTYPE}> | <other {^{(|)|,|;|:=|DEFAULT|IS|AS|EXTERNAL|ALTER TYPE|DETERMINISTIC|PIPELINED|RESULT_CACHE}}... [({^)}...)]>}");
        }
        this.m_source = string;
        this.m_objType = EMPTY_STRING;
        this.m_schemaName = null;
        this.m_userDefTypeTypeCode = EMPTY_STRING;
        this.m_userDefTypeCollectionType = EMPTY_STRING;
        this.m_tokenizer = new PlSqlTokenizer(this.m_source, new String[0]);
        this.m_firstToken = this.m_tokenizer.getFirst();
        this.m_rootFrag = null;
        this.m_nameToken = null;
        this.m_triggerBaseItemFragment = null;
        this.m_newStatementBlockReqd = false;
        this.m_fullInterrogation = true;
        this.m_isUserDefType = false;
        this.m_isUserDefTypeSepc = false;
        this.m_isSourceWrapped = false;
        this.m_sourceByLines = null;
        this.m_evolvedType = false;
        this.m_containsTodo = null;
        this.m_searchBuffer = null;
        if (this.m_firstToken != null) {
            this.m_fullInterrogation = true;
            this.m_isUserDefTypeSepc = false;
            this.m_userDefTypeTypeCode = EMPTY_STRING;
            this.m_userDefTypeCollectionType = EMPTY_STRING;
            this.m_isSourceWrapped = false;
            PlSqlToken plSqlToken = this.m_firstToken;
            if (!plSqlToken.isCode() && plSqlToken.getType() != Token.Type.END_MARKER) {
                plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
            }
            while (plSqlToken.matches(KW_CREATE) || plSqlToken.matches(KW_OR) || plSqlToken.matches(KW_REPLACE)) {
                plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
            }
            this.m_firstToken = plSqlToken;
            this.m_objType = plSqlToken.getSource(true);
            if (this.m_objType != null && s_knownTypes.contains(this.m_objType)) {
                if (this.m_objType.equals(KW_TYPE)) {
                    this.m_isUserDefType = true;
                    if (((PlSqlToken)plSqlToken.getNextCodeToken()).matches(KW_BODY)) {
                        this.m_objType = this.m_objType + " BODY";
                        plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                    } else {
                        this.m_fullInterrogation = false;
                        this.m_isUserDefTypeSepc = true;
                        while (!(plSqlToken.matches(KW_IS) || plSqlToken.matches(KW_AS) || plSqlToken.matches(PUNC_SEMICOLON) || plSqlToken.matches(KW_UNDER) || plSqlToken.matches(KW_WRAPPED) || plSqlToken == this.m_tokenizer.getEndMarker())) {
                            plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                        }
                        if (plSqlToken.matches(KW_WRAPPED)) {
                            this.m_isSourceWrapped = true;
                        } else if (plSqlToken != this.m_tokenizer.getEndMarker()) {
                            if (plSqlToken.matches(KW_IS) || plSqlToken.matches(KW_AS)) {
                                if ((plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken()).matches("OBJECT") || plSqlToken.matches(KW_OPAQUE)) {
                                    this.m_fullInterrogation = true;
                                    this.m_userDefTypeTypeCode = "OBJECT";
                                    this.m_userDefTypeCollectionType = EMPTY_STRING;
                                } else if (plSqlToken.matches("TABLE")) {
                                    this.m_fullInterrogation = true;
                                    this.m_userDefTypeTypeCode = COLLECTION_TYPECODE;
                                    this.m_userDefTypeCollectionType = "TABLE";
                                } else if (plSqlToken.matches(KW_VARRAY) || plSqlToken.matches(KW_VARYING)) {
                                    this.m_fullInterrogation = true;
                                    this.m_userDefTypeTypeCode = COLLECTION_TYPECODE;
                                    this.m_userDefTypeCollectionType = VARRAY_TYPE;
                                }
                            } else if (plSqlToken.matches(KW_UNDER)) {
                                this.m_fullInterrogation = true;
                                this.m_userDefTypeTypeCode = "OBJECT";
                            }
                        }
                        plSqlToken = this.m_firstToken;
                    }
                } else if (((PlSqlToken)plSqlToken.getNextCodeToken()).matches(KW_BODY)) {
                    this.m_objType = this.m_objType + " BODY";
                    plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                }
            } else {
                this.m_objType = EMPTY_STRING;
            }
            if (!this.m_objType.equals(EMPTY_STRING)) {
                this.m_nameToken = plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                if (plSqlToken == null || plSqlToken.getType() == Token.Type.END_MARKER) {
                    return;
                }
                this.m_schemaDotNameStart = plSqlToken.getStart();
                if (((PlSqlToken)plSqlToken.getNextCodeToken()).matches(PUNC_DOT)) {
                    this.m_schemaName = this.m_nameToken.getSource();
                    this.m_nameToken = plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken(2);
                }
                if ((plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken()).matches(KW_WRAPPED)) {
                    this.m_fullInterrogation = false;
                    this.m_isUserDefType = false;
                    this.m_isUserDefTypeSepc = false;
                    this.m_isSourceWrapped = true;
                }
            }
        }
    }

    public PlSqlFragment getRoot() {
        return this.m_rootFrag;
    }

    public String getType() {
        return this.m_objType;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public String getName() {
        return this.m_nameToken == null ? EMPTY_STRING : this.m_nameToken.getSource(true);
    }

    public int getNameOffset() {
        return this.m_nameToken == null ? -1 : this.m_nameToken.getStart();
    }

    public String getTypeCode() {
        return this.m_userDefTypeTypeCode;
    }

    public String getCollectionType() {
        return this.m_userDefTypeCollectionType;
    }

    public boolean isWrapped() {
        return this.m_isSourceWrapped;
    }

    private PlSqlToken buildFragmentTree(PlSqlToken plSqlToken, PlSqlFragment plSqlFragment, InterrogateState interrogateState) throws PlSqlInterrogationException {
        return this.buildFragmentTree(plSqlToken, plSqlFragment, interrogateState, null);
    }

    private PlSqlToken buildFragmentTree(PlSqlToken plSqlToken, PlSqlFragment plSqlFragment, InterrogateState interrogateState, PlSqlFragment.AlterSubType alterSubType) throws PlSqlInterrogationException {
        PlSqlToken plSqlToken2 = this.debugBuildFragmentTree(plSqlToken, plSqlFragment, interrogateState, alterSubType);
        this.m_newStatementBlockReqd = false;
        PlSqlToken plSqlToken3 = null;
        try {
            if (plSqlFragment.getFirstToken() == null) {
                plSqlFragment.setFirstToken(plSqlToken);
            }
            while (plSqlToken2 != null && plSqlToken2.getType() != Token.Type.END_MARKER) {
                this.checkInterruptOrCancel();
                if (plSqlToken3 == plSqlToken2) {
                    throw new PlSqlInterrogationException();
                }
                plSqlToken3 = plSqlToken2;
                switch (interrogateState) {
                    case PROCEDURE: 
                    case FUNCTION: {
                        PlSqlFragment plSqlFragment2;
                        if (this.m_isUserDefTypeSepc) {
                            while (!(plSqlToken2.matches(PUNC_COMMA) || plSqlToken2.matches(PUNC_LPAREN) || plSqlToken2.matches(PUNC_RPAREN) || plSqlToken2.matches(KW_ALTER) || plSqlToken2.getType() == Token.Type.END_MARKER)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            if (plSqlToken2.matches(PUNC_LPAREN)) {
                                plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                                plSqlFragment2.setFragmentType(PlSqlFragment.Type.PARAMETER_LIST);
                                plSqlFragment2.setFirstToken(plSqlToken2);
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                                plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.PARAMETER_LIST);
                            }
                            if (this.m_methodTailSearch.matches(plSqlToken2)) {
                                plSqlToken2 = this.m_methodTailSearch.getEndToken();
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            while (!(plSqlToken2.matches(PUNC_COMMA) || plSqlToken2.matches(PUNC_RPAREN) || plSqlToken2.matches(KW_ALTER) || plSqlToken2.getType() == Token.Type.END_MARKER)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            if (plSqlFragment.getFragmentType() == PlSqlFragment.Type.PROCEDURE) {
                                plSqlFragment.setFragmentType(PlSqlFragment.Type.PROCEDURE_FD);
                            } else {
                                plSqlFragment.setFragmentType(PlSqlFragment.Type.FUNCTION_FD);
                            }
                            plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                            plSqlFragment.setAlterSubType(alterSubType);
                            if (plSqlToken2.matches(PUNC_COMMA)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        while (!(plSqlToken2.matches(KW_IS) || plSqlToken2.matches(KW_AS) || plSqlToken2.matches(PUNC_SEMICOLON) || plSqlToken2.matches(PUNC_LPAREN))) {
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        }
                        if (plSqlToken2.matches(PUNC_LPAREN)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.PARAMETER_LIST);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.PARAMETER_LIST);
                            while (!(plSqlToken2.matches(KW_IS) || plSqlToken2.matches(KW_AS) || plSqlToken2.matches(PUNC_SEMICOLON))) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                        }
                        if (plSqlToken2.matches(PUNC_SEMICOLON)) {
                            if (plSqlFragment.getFragmentType() == PlSqlFragment.Type.PROCEDURE) {
                                plSqlFragment.setFragmentType(PlSqlFragment.Type.PROCEDURE_FD);
                            } else {
                                plSqlFragment.setFragmentType(PlSqlFragment.Type.FUNCTION_FD);
                            }
                            plSqlFragment.setLastToken(plSqlToken2);
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        if ((plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken()).matches(KW_LANGUAGE)) {
                            if (plSqlFragment.getFragmentType() == PlSqlFragment.Type.PROCEDURE) {
                                plSqlFragment.setFragmentType(PlSqlFragment.Type.PROCEDURE_FD);
                            } else {
                                plSqlFragment.setFragmentType(PlSqlFragment.Type.FUNCTION_FD);
                            }
                            while (!plSqlToken2.matches(PUNC_SEMICOLON)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextToken();
                            }
                            plSqlFragment.setLastToken(plSqlToken2);
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                        plSqlFragment2.setFirstToken(plSqlToken2);
                        plSqlFragment2.setFragmentType(PlSqlFragment.Type.PLSQL_BLOCK);
                        plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.PLSQL_BLOCK);
                        plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                        plSqlFragment.replaceChildWithGrandChildren(plSqlFragment2);
                        return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                    }
                    case TRIGGER: {
                        int n;
                        PlSqlFragment plSqlFragment2;
                        if (plSqlToken2.matches(KW_BEFORE) || plSqlToken2.matches(KW_AFTER) || plSqlToken2.matches(KW_INSTEAD) && ((PlSqlToken)plSqlToken2.getNextCodeToken()).matches(KW_OF)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.TRIGGER_TIMING);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            if (plSqlToken2.matches(KW_INSTEAD)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            plSqlFragment2.setLastToken(plSqlToken2);
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            if (plSqlToken2.matches(KW_ON) || plSqlToken2.matches(KW_FOR) || plSqlToken2.matches(KW_REFERENCING) || plSqlToken2.matches(KW_WHEN) || plSqlToken2.matches(KW_DECLARE) || plSqlToken2.matches(KW_BEGIN) || plSqlToken2.matches(KW_CALL)) break;
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.TRIGGER_EVENTS);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.TRIGGER_EVENTS);
                            break;
                        }
                        if (plSqlToken2.matches(KW_ON)) {
                            if (plSqlFragment.getFragmentType() == PlSqlFragment.Type.TRIGGER) {
                                plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                                plSqlFragment2.setFragmentType(PlSqlFragment.Type.TRIGGER_TABLE);
                                this.m_triggerBaseItemFragment = plSqlFragment2;
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                                plSqlFragment2.setFirstToken(plSqlToken2);
                                plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.TRIGGER);
                                break;
                            }
                            plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        if (plSqlToken2.matches(KW_WHEN)) {
                            if (plSqlFragment.getFragmentType() == PlSqlFragment.Type.TRIGGER) {
                                plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                                plSqlFragment2.setFragmentType(PlSqlFragment.Type.TRIGGER_WHEN);
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                                plSqlFragment2.setFirstToken(plSqlToken2);
                                if (plSqlToken2.matches(PUNC_LPAREN)) {
                                    n = 1;
                                    while (n > 0) {
                                        if ((plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken()).matches(PUNC_LPAREN)) {
                                            ++n;
                                            continue;
                                        }
                                        if (!plSqlToken2.matches(PUNC_RPAREN)) continue;
                                        --n;
                                    }
                                    plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                                } else {
                                    while (!plSqlToken2.matches(KW_BEGIN) && !plSqlToken2.matches(KW_DECLARE)) {
                                        plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                                    }
                                }
                                plSqlFragment2.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                                break;
                            }
                            plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        if (plSqlToken2.matches(KW_REFERENCING)) {
                            if (plSqlFragment.getFragmentType() == PlSqlFragment.Type.TRIGGER) {
                                plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                                plSqlFragment2.setFragmentType(PlSqlFragment.Type.TRIGGER_REFERENCING);
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                                plSqlFragment2.setFirstToken(plSqlToken2);
                                plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.TRIGGER);
                                break;
                            }
                            plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        if (plSqlToken2.matches(KW_FOR) && ((PlSqlToken)plSqlToken2.getNextCodeToken()).matches(KW_EACH) && ((PlSqlToken)plSqlToken2.getNextCodeToken(2)).matches(KW_ROW)) {
                            if (plSqlFragment.getFragmentType() == PlSqlFragment.Type.TRIGGER) {
                                plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                                plSqlFragment2.setFragmentType(PlSqlFragment.Type.TRIGGER_ROW_LEVEL);
                                plSqlFragment2.setFirstToken(plSqlToken2);
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                                plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.TRIGGER);
                                break;
                            }
                            plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        if (plSqlToken2.matches(KW_DECLARE) || plSqlToken2.matches(KW_BEGIN)) {
                            if (plSqlFragment.getFragmentType() == PlSqlFragment.Type.TRIGGER) {
                                plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                                plSqlFragment2.setFragmentType(PlSqlFragment.Type.PLSQL_BLOCK);
                                plSqlFragment2.setFirstToken(plSqlToken2);
                                plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.PLSQL_BLOCK);
                                break;
                            }
                            plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        if (plSqlFragment.getFragmentType() == PlSqlFragment.Type.TRIGGER_TABLE && plSqlToken2.matches(KW_NESTED)) {
                            while (!plSqlToken2.matches(KW_OF)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            if (((PlSqlToken)(plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken()).getNextCodeToken()).matches(PUNC_DOT)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken(2);
                            }
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            break;
                        }
                        if (plSqlToken2.matches(KW_ALTER)) {
                            plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        break;
                    }
                    case TRIGGER_EVENTS: {
                        PlSqlFragment plSqlFragment2;
                        while (!(plSqlToken2.matches(KW_ON) || plSqlToken2.matches(KW_FOR) || plSqlToken2.matches(KW_REFERENCING) || plSqlToken2.matches(KW_WHEN) || plSqlToken2.matches(KW_DECLARE) || plSqlToken2.matches(KW_BEGIN) || plSqlToken2.matches(KW_CALL))) {
                            if (plSqlToken2.matches(KW_UPDATE) && ((PlSqlToken)plSqlToken2.getNextCodeToken()).matches(KW_OF)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                                plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                                plSqlFragment2.setFragmentType(PlSqlFragment.Type.TRIGGER_COLUMNS);
                                plSqlFragment2.setFirstToken(plSqlToken2);
                                plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.TRIGGER_COLUMNS);
                                continue;
                            }
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        }
                        plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                        return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                    }
                    case TRIGGER_COLUMNS: {
                        while (plSqlToken2.matches(PUNC_COMMA) || ((PlSqlToken)plSqlToken2.getNextCodeToken()).matches(PUNC_COMMA)) {
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        }
                        plSqlFragment.setLastToken(plSqlToken2);
                        plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                    }
                    case PLSQL_BLOCK: {
                        PlSqlFragment plSqlFragment2;
                        if (plSqlToken2.matches(KW_BEGIN)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.BEGIN);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.STATEMENT_BLOCK);
                            if (plSqlToken2.matches(KW_EXCEPTION)) break;
                            plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        if (plSqlToken2.matches(KW_EXCEPTION)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.EXCEPTION);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.EXCEPTION_BLOCK);
                            while (!plSqlToken2.matches(PUNC_SEMICOLON)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            plSqlFragment.setLastToken(plSqlToken2);
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        if (plSqlToken2.getType() == Token.Type.PUNCTUATION) {
                            throw new PlSqlInterrogationException();
                        }
                        plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                        plSqlFragment2.setFragmentType(PlSqlFragment.Type.DECLARE);
                        plSqlFragment2.setFirstToken(plSqlToken2);
                        if (plSqlToken2.matches(KW_DECLARE)) {
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        }
                        plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.DECLARATIVE_SECTION);
                        break;
                    }
                    case DECLARATIVE_SECTION: {
                        int n;
                        PlSqlFragment plSqlFragment2;
                        if (plSqlToken2.matches(KW_END) && (plSqlFragment.getFragmentType() == PlSqlFragment.Type.PACKAGE_BODY || plSqlFragment.getFragmentType() == PlSqlFragment.Type.PACKAGE_SPEC || plSqlFragment.getFragmentType() == PlSqlFragment.Type.TYPE_BODY)) {
                            while (plSqlToken2.getType() != Token.Type.END_MARKER) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        if (plSqlToken2.matches(KW_PACKAGE)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            if (((PlSqlToken)plSqlToken2.getNextCodeToken()).matches(KW_BODY)) {
                                plSqlFragment2.setFragmentType(PlSqlFragment.Type.PACKAGE_BODY);
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            } else {
                                plSqlFragment2.setFragmentType(PlSqlFragment.Type.PACKAGE_SPEC);
                            }
                            while (!plSqlToken2.matches(KW_IS) && !plSqlToken2.matches(KW_AS)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.DECLARATIVE_SECTION);
                            break;
                        }
                        if (plSqlToken2.matches(KW_TYPE) && plSqlFragment.getFragmentType() == PlSqlFragment.Type.ROOT) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            if (((PlSqlToken)plSqlToken2.getNextCodeToken()).matches(KW_BODY)) {
                                plSqlFragment2.setFragmentType(PlSqlFragment.Type.TYPE_BODY);
                                while (!plSqlToken2.matches(KW_IS) && !plSqlToken2.matches(KW_AS)) {
                                    plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                                }
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                                plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.DECLARATIVE_SECTION);
                                break;
                            }
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.TYPE_SPEC);
                            while ("OBJECT".equals(this.m_userDefTypeTypeCode) && !plSqlToken2.matches(PUNC_LPAREN)) {
                                if (!(plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken()).matches(PUNC_LPAREN) || !((PlSqlToken)plSqlToken2.getPrevCodeToken()).matches(KW_VARYING) || !((PlSqlToken)plSqlToken2.getNextCodeToken()).matches("*") || !((PlSqlToken)plSqlToken2.getNextCodeToken(2)).matches(PUNC_RPAREN)) continue;
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            if (!(plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.TYPE_SPEC)).matches(KW_ALTER)) break;
                            this.m_evolvedType = true;
                            while (plSqlToken2.getType() != Token.Type.END_MARKER) {
                                if (plSqlToken2.matches(KW_ALTER) && plSqlToken2.firstCodeTokenOnLine()) {
                                    plSqlFragment2.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                                    plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                                    plSqlFragment2.setFirstToken(plSqlToken2);
                                    plSqlFragment2.setFragmentType(PlSqlFragment.Type.TYPE_ALTER_STATEMENT);
                                    n = 0;
                                    while (this.m_alterSubClauseSearch.matches(plSqlToken2)) {
                                        n = 1;
                                        PlSqlFragment.AlterSubType alterSubType2 = null;
                                        String string = this.m_alterSubClauseSearch.getNamedMatch("action", true);
                                        if ("ADD ATTRIBUTE".equals(string)) {
                                            alterSubType2 = PlSqlFragment.AlterSubType.ADD_ATTRIBUTE;
                                        } else if ("DROP ATTRIBUTE".equals(string)) {
                                            alterSubType2 = PlSqlFragment.AlterSubType.DROP_ATTRIBUTE;
                                        } else if ("MODIFY ATTRIBUTE".equals(string)) {
                                            alterSubType2 = PlSqlFragment.AlterSubType.MODIFY_ATTRIBUTE;
                                        } else if (KW_ADD.equals(string)) {
                                            alterSubType2 = PlSqlFragment.AlterSubType.ADD_METHOD;
                                        } else if (KW_DROP.equals(string)) {
                                            alterSubType2 = PlSqlFragment.AlterSubType.DROP_METHOD;
                                        }
                                        plSqlToken2 = this.m_alterSubClauseSearch.getEndToken();
                                        if (!(plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.DECLARATIVE_SECTION, alterSubType2)).matches(KW_ALTER)) continue;
                                        break;
                                    }
                                    if (n == 0) {
                                        for (plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken(); !plSqlToken2.matches(KW_ALTER) && plSqlToken2 != this.m_tokenizer.getEndMarker(); plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken()) {
                                        }
                                    }
                                }
                                if (plSqlToken2.matches(KW_ALTER) || plSqlToken2 == this.m_tokenizer.getEndMarker()) continue;
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            plSqlFragment2.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        if (plSqlToken2.matches(KW_BEGIN)) {
                            if (plSqlFragment.getFragmentType() == PlSqlFragment.Type.DECLARE) {
                                plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                                return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                            }
                            if (plSqlFragment.getFragmentType() != PlSqlFragment.Type.PACKAGE_BODY) break;
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.PLSQL_BLOCK);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.PLSQL_BLOCK);
                            break;
                        }
                        if (plSqlToken2.matches(KW_FUNCTION)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.FUNCTION);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.FUNCTION);
                            break;
                        }
                        if (plSqlToken2.matches(KW_PROCEDURE)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.PROCEDURE);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.PROCEDURE);
                            break;
                        }
                        if (plSqlToken2.matches(KW_CURSOR)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.CURSOR);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.CURSOR);
                            break;
                        }
                        if (plSqlToken2.matches(KW_TRIGGER)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.TRIGGER);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.TRIGGER);
                            break;
                        }
                        if (plSqlToken2.matches(KW_PRAGMA)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.PRAGMA);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.SIMPLE_STATEMENT);
                            break;
                        }
                        if (plSqlToken2.matches(PUNC_DBL_LCHEV)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.LABEL);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.LABEL);
                            break;
                        }
                        if (this.m_isUserDefType && (plSqlToken2.matches(KW_NOT) || plSqlToken2.matches(KW_OVERRIDING) || plSqlToken2.matches(KW_FINAL) || plSqlToken2.matches(KW_INSTANTIABLE) || plSqlToken2.matches(KW_MEMBER) || plSqlToken2.matches(KW_STATIC) || plSqlToken2.matches(KW_CONSTRUCTOR) || plSqlToken2.matches(KW_MAP) || plSqlToken2.matches(KW_ORDER) || plSqlToken2.matches(KW_PROCEDURE) || plSqlToken2.matches(KW_FUNCTION))) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            while (!plSqlToken2.matches(KW_PROCEDURE) && !plSqlToken2.matches(KW_FUNCTION)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            if (plSqlToken2.matches(KW_PROCEDURE)) {
                                plSqlFragment2.setFragmentType(PlSqlFragment.Type.PROCEDURE);
                                plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.PROCEDURE, alterSubType);
                            } else {
                                plSqlFragment2.setFragmentType(PlSqlFragment.Type.FUNCTION);
                                plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.FUNCTION, alterSubType);
                            }
                            if (!plSqlToken2.matches(KW_ALTER) && !plSqlToken2.matches(KW_ADD) && !plSqlToken2.matches(KW_DROP) && !plSqlToken2.matches(KW_MODIFY)) break;
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        if (plSqlToken2.matches(PUNC_SEMICOLON)) break;
                        plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                        plSqlFragment2.setFragmentType(PlSqlFragment.Type.DECLARATION);
                        plSqlFragment2.setFirstToken(plSqlToken2);
                        if (this.m_isUserDefTypeSepc && (plSqlFragment.getFragmentType() == PlSqlFragment.Type.TYPE_SPEC || plSqlFragment.getFragmentType() == PlSqlFragment.Type.TYPE_ALTER_STATEMENT)) {
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.ORACLE_TYPE_DECLN);
                            plSqlFragment2.setAlterSubType(alterSubType);
                            if (!plSqlToken2.matches(KW_ALTER) && !plSqlToken2.matches(KW_ADD) && !plSqlToken2.matches(KW_DROP) && !plSqlToken2.matches(KW_MODIFY)) break;
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.SIMPLE_STATEMENT);
                        break;
                    }
                    case STATEMENT_BLOCK: {
                        PlSqlFragment plSqlFragment2;
                        if ((plSqlToken2.matches(KW_END) || plSqlToken2.matches(KW_WHEN)) && (plSqlFragment.getFragmentType() == PlSqlFragment.Type.EX_WHEN || plSqlFragment.getFragmentType() == PlSqlFragment.Type.CASE_WHEN || plSqlFragment.getFragmentType() == PlSqlFragment.Type.CASE_ELSE)) {
                            plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        if (plSqlToken2.matches(KW_END)) {
                            while (!plSqlToken2.matches(PUNC_SEMICOLON)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            plSqlFragment.setLastToken(plSqlToken2);
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        if (plSqlToken2.matches(KW_DECLARE) || plSqlToken2.matches(KW_BEGIN)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.PLSQL_BLOCK);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.PLSQL_BLOCK);
                            break;
                        }
                        if (plSqlToken2.matches(KW_EXCEPTION)) {
                            if (plSqlFragment.getFragmentType() != PlSqlFragment.Type.PLSQL_BLOCK) {
                                plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                                return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                            }
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            break;
                        }
                        if (plSqlToken2.matches(KW_IF)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.IF);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            while (!plSqlToken2.matches(KW_THEN)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (plSqlToken2.matches(KW_ELSIF)) {
                            if (!(plSqlFragment.getFragmentType() != PlSqlFragment.Type.IF && plSqlFragment.getFragmentType() != PlSqlFragment.Type.ELSIF || this.m_newStatementBlockReqd)) {
                                plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                                this.m_newStatementBlockReqd = true;
                                return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                            }
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.ELSIF);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            while (!plSqlToken2.matches(KW_THEN)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (plSqlToken2.matches(KW_ELSE)) {
                            if (plSqlFragment.getFragmentType() == PlSqlFragment.Type.CASE_WHEN && !this.m_newStatementBlockReqd) {
                                plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                                return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                            }
                            if (!(plSqlFragment.getFragmentType() != PlSqlFragment.Type.IF && plSqlFragment.getFragmentType() != PlSqlFragment.Type.ELSIF || this.m_newStatementBlockReqd)) {
                                plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                                this.m_newStatementBlockReqd = true;
                                return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                            }
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.ELSE);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (plSqlToken2.matches(KW_LOOP)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.LOOP);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (plSqlToken2.matches(KW_FOR)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.FOR_LOOP);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            while (!plSqlToken2.matches(KW_LOOP)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (plSqlToken2.matches(KW_WHILE)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.WHILE_LOOP);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            while (!plSqlToken2.matches(KW_LOOP)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (plSqlToken2.matches(KW_CASE)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.CASE);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            while (!plSqlToken2.matches(KW_WHEN)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.CASE_STATEMENT);
                            break;
                        }
                        if (plSqlToken2.matches(PUNC_DBL_LCHEV)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.LABEL);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.LABEL);
                            break;
                        }
                        if (!plSqlToken2.matches(PUNC_SEMICOLON)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.STATEMENT);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.SIMPLE_STATEMENT);
                            break;
                        }
                        if (!plSqlToken2.matches(PUNC_SEMICOLON)) break;
                        plSqlFragment.setLastToken(plSqlToken2);
                        return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                    }
                    case CASE_STATEMENT: {
                        PlSqlFragment plSqlFragment2;
                        if (plSqlToken2.matches(KW_END)) {
                            while (!plSqlToken2.matches(PUNC_SEMICOLON)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            plSqlFragment.setLastToken(plSqlToken2);
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        if (plSqlToken2.matches(KW_WHEN)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.CASE_WHEN);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            while (!plSqlToken2.matches(KW_THEN)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            plSqlFragment.setLastToken(plSqlToken2);
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.STATEMENT_BLOCK);
                            break;
                        }
                        if (!plSqlToken2.matches(KW_ELSE)) break;
                        plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                        plSqlFragment2.setFragmentType(PlSqlFragment.Type.CASE_ELSE);
                        plSqlFragment2.setFirstToken(plSqlToken2);
                        plSqlFragment.setLastToken(plSqlToken2);
                        plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.STATEMENT_BLOCK);
                        break;
                    }
                    case EXCEPTION_BLOCK: {
                        PlSqlFragment plSqlFragment2;
                        if (plSqlToken2.matches(KW_WHEN)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.EX_WHEN);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            while (!plSqlToken2.matches(KW_THEN)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.STATEMENT_BLOCK);
                            plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                        }
                        if (!plSqlToken2.matches(KW_END)) break;
                        return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                    }
                    case TYPE_SPEC: {
                        PlSqlFragment plSqlFragment2;
                        if (plSqlToken2.matches(KW_ALTER) && plSqlToken2.firstCodeTokenOnLine()) {
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        if (plSqlToken2.matches(PUNC_RPAREN)) {
                            while (plSqlToken2.getType() != Token.Type.END_MARKER) {
                                if (plSqlToken2.matches(KW_ALTER) && plSqlToken2.firstCodeTokenOnLine()) {
                                    return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                                }
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        if (plSqlToken2.matches(KW_NOT) || plSqlToken2.matches(KW_OVERRIDING) || plSqlToken2.matches(KW_FINAL) || plSqlToken2.matches(KW_INSTANTIABLE) || plSqlToken2.matches(KW_MEMBER) || plSqlToken2.matches(KW_STATIC) || plSqlToken2.matches(KW_CONSTRUCTOR) || plSqlToken2.matches(KW_MAP) || plSqlToken2.matches(KW_ORDER) || plSqlToken2.matches(KW_PROCEDURE) || plSqlToken2.matches(KW_FUNCTION)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            while (!plSqlToken2.matches(KW_PROCEDURE) && !plSqlToken2.matches(KW_FUNCTION)) {
                                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            }
                            if (plSqlToken2.matches(KW_PROCEDURE)) {
                                plSqlFragment2.setFragmentType(PlSqlFragment.Type.PROCEDURE);
                                plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.PROCEDURE);
                                break;
                            }
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.FUNCTION);
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.FUNCTION);
                            break;
                        }
                        if (plSqlToken2.matches(PUNC_SEMICOLON)) break;
                        plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                        plSqlFragment2.setFragmentType(PlSqlFragment.Type.DECLARATION);
                        plSqlFragment2.setFirstToken(plSqlToken2);
                        plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.ORACLE_TYPE_DECLN);
                        break;
                    }
                    case ORACLE_TYPE_DECLN: {
                        int n = 0;
                        while (!(plSqlToken2 == null || plSqlToken2 == this.m_tokenizer.getEndMarker() || n == 0 && (plSqlToken2.matches(PUNC_COMMA) || plSqlToken2.matches(PUNC_SEMICOLON) || plSqlToken2.matches(PUNC_RPAREN) || plSqlToken2.matches(KW_ALTER)))) {
                            if (plSqlToken2.matches(PUNC_LPAREN)) {
                                ++n;
                            } else if (plSqlToken2.matches(PUNC_RPAREN)) {
                                --n;
                            }
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        }
                        plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                        if (plSqlToken2 != null && plSqlToken2 != this.m_tokenizer.getEndMarker() && !plSqlToken2.matches(PUNC_RPAREN) && !plSqlToken2.matches(KW_ALTER)) {
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        }
                        return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                    }
                    case SIMPLE_STATEMENT: {
                        while (plSqlToken2 != null && plSqlToken2 != this.m_tokenizer.getEndMarker() && !plSqlToken2.matches(PUNC_SEMICOLON)) {
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        }
                        plSqlFragment.setLastToken(plSqlToken2);
                        plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                    }
                    case LABEL: {
                        while (plSqlToken2 != null && plSqlToken2 != this.m_tokenizer.getEndMarker() && !plSqlToken2.matches(PUNC_DBL_RCHEV)) {
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        }
                        plSqlFragment.setLastToken(plSqlToken2);
                        plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                    }
                    case PARAMETER_LIST: {
                        if (plSqlToken2.matches(PUNC_RPAREN)) {
                            plSqlFragment.setLastToken(plSqlToken2);
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                        }
                        PlSqlFragment plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                        plSqlFragment2.setFragmentType(PlSqlFragment.Type.PARAMETER);
                        plSqlFragment2.setFirstToken(plSqlToken2);
                        plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.PARAMETER);
                        break;
                    }
                    case PARAMETER: {
                        int n = 0;
                        while (plSqlToken2 != null && (n != 0 || !plSqlToken2.matches(PUNC_COMMA) && !plSqlToken2.matches(PUNC_RPAREN))) {
                            if (plSqlToken2.matches(PUNC_LPAREN)) {
                                ++n;
                            } else if (plSqlToken2.matches(PUNC_RPAREN)) {
                                --n;
                            }
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        }
                        plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                        if (plSqlToken2.matches(PUNC_COMMA)) {
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        }
                        return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                    }
                    case CURSOR: {
                        PlSqlFragment plSqlFragment2;
                        plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken(2);
                        if (plSqlToken2.matches(PUNC_LPAREN)) {
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.PARAMETER_LIST);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.PARAMETER_LIST);
                        }
                        if (plSqlToken2.matches(PUNC_SEMICOLON)) {
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                        } else if (plSqlToken2.matches(KW_IS) || plSqlToken2.matches(KW_RETURN)) {
                            plSqlToken2 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                            plSqlFragment2 = new PlSqlFragment(this, plSqlFragment);
                            plSqlFragment2.setFragmentType(PlSqlFragment.Type.STATEMENT);
                            plSqlFragment2.setFirstToken(plSqlToken2);
                            plSqlToken2 = this.buildFragmentTree(plSqlToken2, plSqlFragment2, InterrogateState.SIMPLE_STATEMENT);
                        } else {
                            throw new PlSqlInterrogationException();
                        }
                        plSqlFragment.setLastToken((PlSqlToken)plSqlToken2.getPrevCodeToken());
                        return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            return this.debugBuildFragmentTree(null, plSqlFragment, interrogateState, alterSubType);
        }
        return this.debugBuildFragmentTree(plSqlToken2, plSqlFragment, interrogateState, alterSubType);
    }

    public int getLineNumber(int n) {
        return this.m_tokenizer.getLineNumber(n);
    }

    public PlSqlFragment getFragmentAtOffset(int n) {
        return this.getFragmentAtOffset(n, this.m_rootFrag);
    }

    private PlSqlFragment getFragmentAtOffset(int n, PlSqlFragment plSqlFragment) {
        if (plSqlFragment != null && plSqlFragment.getFirstToken() != null && plSqlFragment.getFirstToken().getStart() <= n && (plSqlFragment.getLastToken() == null || plSqlFragment.getLastToken().getEnd() >= n)) {
            if (plSqlFragment.getChildren() == null || plSqlFragment.getChildren().length == 0) {
                return plSqlFragment;
            }
            for (PlSqlFragment plSqlFragment2 : plSqlFragment.getChildren()) {
                if (plSqlFragment2.getFirstToken().getStart() > n || plSqlFragment2.getLastToken() != null && plSqlFragment2.getLastToken().getEnd() < n) continue;
                PlSqlFragment plSqlFragment3 = this.getFragmentAtOffset(n, plSqlFragment2);
                return plSqlFragment3 == null ? plSqlFragment2 : plSqlFragment3;
            }
        }
        return null;
    }

    public PlSqlToken getTokenAtOffset(int n) {
        return this.m_firstToken == null ? null : (PlSqlToken)this.m_firstToken.getTokenAt(n);
    }

    @Deprecated
    public boolean hasParseErrors() {
        return false;
    }

    public boolean containsToDo() {
        if (this.m_containsTodo == null) {
            this.m_containsTodo = Boolean.FALSE;
            PlSqlToken plSqlToken = (PlSqlToken)this.m_tokenizer.getStartMarker().getNextToken();
            while (plSqlToken.getType() != Token.Type.END_MARKER) {
                if ((plSqlToken.getType() == Token.Type.SINGLE_LINE_COMMENT || plSqlToken.getType() == Token.Type.MULTI_LINE_COMMENT) && plSqlToken.getSource().toUpperCase().contains("TODO")) {
                    this.m_containsTodo = Boolean.TRUE;
                    break;
                }
                plSqlToken = (PlSqlToken)plSqlToken.getNextToken();
            }
        }
        return this.m_containsTodo;
    }

    public String getRenamedSource(String string) {
        return this.getRenamedSource(string, false);
    }

    public String getRenamedSource(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_nameToken != null) {
            int n = bl ? this.m_schemaDotNameStart : this.m_nameToken.getStart();
            stringBuilder.append(this.m_source.substring(0, n));
            stringBuilder.append(string);
            PlSqlToken plSqlToken = (PlSqlToken)this.m_tokenizer.getEndMarker().getPrevCodeToken();
            PlSqlToken plSqlToken2 = (PlSqlToken)plSqlToken.getPrevCodeToken();
            PlSqlToken plSqlToken3 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
            if (plSqlToken.matches(PUNC_SEMICOLON) && plSqlToken2.matches(this.m_nameToken.getSource()) && plSqlToken3.matches(KW_END)) {
                stringBuilder.append(this.m_source.substring(this.m_nameToken.getEnd() + 1, plSqlToken2.getStart()));
                if (string.indexOf(PUNC_DOT) > -1 && bl) {
                    stringBuilder.append(string.substring(string.indexOf(PUNC_DOT) + 1));
                } else {
                    stringBuilder.append(string);
                }
                stringBuilder.append(this.m_source.substring(plSqlToken2.getEnd() + 1));
            } else {
                stringBuilder.append(this.m_source.substring(this.m_nameToken.getEnd() + 1));
            }
        }
        return stringBuilder.toString();
    }

    public boolean isEvolvedType() {
        return this.m_evolvedType;
    }

    public String getUpdatedSourceForRelationRename(String string) {
        if (this.m_triggerBaseItemFragment == null) {
            return this.m_source;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_source.substring(0, this.m_triggerBaseItemFragment.getStartOffset()));
        stringBuilder.append(string);
        stringBuilder.append(this.m_source.substring(this.m_triggerBaseItemFragment.getEndOffset() + 1));
        return stringBuilder.toString();
    }

    public String getSource(PlSqlToken plSqlToken, PlSqlToken plSqlToken2) {
        return plSqlToken.getSource(false, plSqlToken2);
    }

    int getSourceLength() {
        return this.m_source == null ? 0 : this.m_source.length();
    }

    public PlSqlToken skipToCodeToken(PlSqlFragment plSqlFragment, PlSqlToken plSqlToken, String ... stringArray) {
        int n = plSqlFragment != null ? plSqlFragment.getLastToken().getEnd() : this.getSourceLength();
        do {
            for (String string : stringArray) {
                if (!plSqlToken.matches(string)) continue;
                return plSqlToken;
            }
        } while ((plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken()) != null && plSqlToken.getType() != Token.Type.END_MARKER && plSqlToken.getStart() <= n);
        return null;
    }

    public int findExecutableLineNumber(String string) {
        List<PlSqlFragment> list = this.findFragmentsBySignature(string);
        if (list.size() > 0) {
            return this.findExecutableLineNumber(list.get(0));
        }
        return 0;
    }

    private int findExecutableLineNumber(PlSqlFragment plSqlFragment) {
        if (plSqlFragment.getFragmentType() == PlSqlFragment.Type.STATEMENT || plSqlFragment.getFragmentType() == PlSqlFragment.Type.IF || plSqlFragment.getFragmentType() == PlSqlFragment.Type.FOR_LOOP || plSqlFragment.getFragmentType() == PlSqlFragment.Type.WHILE_LOOP || plSqlFragment.getFragmentType() == PlSqlFragment.Type.CASE) {
            return this.getLineNumber(plSqlFragment.getFirstToken().getStart());
        }
        for (PlSqlFragment plSqlFragment2 : plSqlFragment.getChildren()) {
            int n = this.findExecutableLineNumber(plSqlFragment2);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public int getMatchingOffset(int n) {
        PlSqlFragment plSqlFragment = this.getFragmentAtOffset(n);
        if (plSqlFragment != null) {
            PlSqlToken plSqlToken = plSqlFragment.getFirstToken();
            PlSqlToken plSqlToken2 = plSqlFragment.getLastToken();
            if (n >= plSqlToken.getStart() && n <= plSqlToken.getEnd()) {
                return plSqlToken2.getStart();
            }
            if (n >= plSqlToken2.getStart() && n <= plSqlToken2.getEnd()) {
                return plSqlToken.getStart();
            }
        }
        return -1;
    }

    public List<PlSqlFragment> findFragmentsBySignature(String string) {
        Object object;
        if (this.m_objType == null) {
            throw new IllegalStateException("object type not known");
        }
        ArrayList<PlSqlFragment> arrayList = new ArrayList<PlSqlFragment>();
        PlSqlToken plSqlToken = PlSqlTokenizer.tokenize(string, new String[0]);
        String string2 = plSqlToken.getSource(true);
        ArrayList<String> arrayList2 = null;
        String string3 = null;
        if ((plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken()).matches(PUNC_LPAREN)) {
            arrayList2 = new ArrayList<String>();
        }
        while (plSqlToken.matches(PUNC_LPAREN) || plSqlToken.matches(PUNC_COMMA)) {
            object = new StringBuffer();
            if ((plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken()).matches(PUNC_RPAREN)) continue;
            if (((PlSqlToken)plSqlToken.getNextCodeToken()).matches("=>")) {
                ((StringBuffer)object).append(plSqlToken.getSource(true));
                plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken(2);
            } else {
                ((StringBuffer)object).append("?");
            }
            ((StringBuffer)object).append(" [{in out|in|out}]");
            while (!plSqlToken.matches(PUNC_RPAREN) && !plSqlToken.matches(PUNC_COMMA)) {
                if (plSqlToken.getType() == Token.Type.END_MARKER) {
                    throw new IllegalArgumentException("Missing )");
                }
                ((StringBuffer)object).append(" ");
                ((StringBuffer)object).append(plSqlToken.getSource(true));
                plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
            }
            arrayList2.add(((StringBuffer)object).toString());
        }
        if (plSqlToken.matches(PUNC_RPAREN)) {
            plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
        }
        if (plSqlToken.matches(":")) {
            plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
            object = plSqlToken;
            while (((PlSqlToken)((Token)object).getNextToken()).getType() != Token.Type.END_MARKER) {
                object = (PlSqlToken)((Token)object).getNextToken();
            }
            string3 = plSqlToken.getSource(true, (Token)object);
        }
        this.findSignature(arrayList, this.m_rootFrag, string2, arrayList2, string3);
        return arrayList;
    }

    private void findSignature(List<PlSqlFragment> list, PlSqlFragment plSqlFragment, String string, ArrayList<String> arrayList, String string2) {
        boolean bl = this.m_objType.equals(KW_PACKAGE) || this.m_objType.equals(KW_TYPE);
        boolean bl2 = string2 == null;
        boolean bl3 = arrayList == null || string2 != null;
        for (PlSqlFragment plSqlFragment2 : plSqlFragment.getChildren()) {
            Object object;
            if ((!bl2 || plSqlFragment2.getFragmentType() != (bl ? PlSqlFragment.Type.PROCEDURE_FD : PlSqlFragment.Type.PROCEDURE)) && (!bl3 || plSqlFragment2.getFragmentType() != (bl ? PlSqlFragment.Type.FUNCTION_FD : PlSqlFragment.Type.FUNCTION)) || !((PlSqlToken)plSqlFragment2.getFirstToken().getNextCodeToken()).matches(string)) continue;
            if (string2 != null) {
                object = null;
                try {
                    object = new PlSqlSearch("return " + string2);
                    if (object == null || !((PlSqlSearch)object).isWithin(plSqlFragment2.getFirstToken())) {
                        continue;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (arrayList == null) {
                list.add(plSqlFragment2);
                continue;
            }
            object = null;
            PlSqlFragment[] plSqlFragmentArray = plSqlFragment2.getChildren();
            int n = plSqlFragmentArray.length;
            for (int i = 0; i < n; ++i) {
                PlSqlFragment plSqlFragment3 = plSqlFragmentArray[i];
                if (plSqlFragment3.getFragmentType() != PlSqlFragment.Type.PARAMETER_LIST) continue;
                object = plSqlFragment3;
                break;
            }
            if (object == null && arrayList.size() == 0) {
                list.add(plSqlFragment2);
                continue;
            }
            if (object == null || ((PlSqlFragment)object).getChildren().length != arrayList.size()) continue;
            boolean bl4 = true;
            for (n = 0; n < ((PlSqlFragment)object).getChildren().length; ++n) {
                PlSqlSearch plSqlSearch = null;
                try {
                    plSqlSearch = new PlSqlSearch(arrayList.get(n));
                    if (plSqlSearch != null && plSqlSearch.matches(((PlSqlFragment)object).getChildren()[n].getSource())) continue;
                    bl4 = false;
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (!bl4) continue;
            list.add(plSqlFragment2);
        }
        if (list.size() == 0) {
            for (PlSqlFragment plSqlFragment2 : plSqlFragment.getChildren()) {
                this.findSignature(list, plSqlFragment2, string, arrayList, string2);
            }
        }
    }

    @Deprecated
    public List<String> getExternalDeclarations() {
        return Collections.emptyList();
    }

    private PlSqlToken debugBuildFragmentTree(PlSqlToken plSqlToken, PlSqlFragment plSqlFragment, InterrogateState interrogateState, PlSqlFragment.AlterSubType alterSubType) {
        if (this.m_debug) {
            int n;
            Exception exception = new Exception();
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            StackTraceElement stackTraceElement = stackTraceElementArray[1];
            System.out.println("\nLine:  " + stackTraceElement.getLineNumber());
            for (n = 1; n < stackTraceElementArray.length && "buildFragmentTree".equals(stackTraceElementArray[n].getMethodName()); ++n) {
            }
            System.out.println("Depth: " + n);
            StringBuilder stringBuilder = new StringBuilder(plSqlFragment.getFragmentType().toString());
            for (PlSqlFragment plSqlFragment2 = plSqlFragment.getParent(); plSqlFragment2 != null; plSqlFragment2 = plSqlFragment2.getParent()) {
                stringBuilder.append(PUNC_DOT).append(plSqlFragment2.getFragmentType().toString());
            }
            System.out.println("Frags: " + stringBuilder.toString());
            System.out.println("State: " + interrogateState.toString());
            if (plSqlToken != null) {
                System.out.println("Offset:" + plSqlToken.getStart());
                System.out.println("Token: " + plSqlToken.getSource());
            } else {
                System.out.println("Offset:");
                System.out.println("Token: ");
            }
        }
        return plSqlToken;
    }

    public List<Integer> getLocationOffsets(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        char[] cArray = this.getSearchBuffer();
        for (int i = 1; i < cArray.length - string.length(); ++i) {
            int n;
            if (cArray[i - 1] != ' ' || cArray[i] != string.charAt(0)) continue;
            boolean bl = true;
            for (n = 0; n < string.length(); ++n) {
                if (cArray[i + n] == string.charAt(n)) continue;
                bl = false;
                break;
            }
            if (cArray[i + n] != ' ') {
                bl = false;
            }
            if (!bl) continue;
            arrayList.add(i - 1);
            i += n;
        }
        return arrayList;
    }

    private char[] getSearchBuffer() {
        if (this.m_searchBuffer == null) {
            PlSqlToken plSqlToken = this.getTokenAtOffset(0);
            if (plSqlToken != null) {
                this.m_searchBuffer = new char[this.m_source.length() + 2];
                for (int i = 0; i < this.m_source.length() + 2; ++i) {
                    this.m_searchBuffer[i] = 32;
                }
                while (plSqlToken.getType() != Token.Type.END_MARKER) {
                    if (plSqlToken.getType() == Token.Type.DOUBLE_QUOTED_STRING) {
                        String string = plSqlToken.getSource();
                        var3_5 = plSqlToken.getStart() + 1;
                        for (var4_6 = 1; var4_6 < string.length() - 1; ++var4_6) {
                            this.m_searchBuffer[var3_5 + var4_6] = string.charAt(var4_6);
                        }
                    } else if (plSqlToken.isCode(true)) {
                        String string = plSqlToken.getSource().toUpperCase();
                        var3_5 = plSqlToken.getStart() + 1;
                        for (var4_6 = 0; var4_6 < string.length(); ++var4_6) {
                            this.m_searchBuffer[var3_5 + var4_6] = string.charAt(var4_6);
                        }
                    }
                    plSqlToken = (PlSqlToken)plSqlToken.getNextToken();
                }
            } else {
                this.m_searchBuffer = new char[0];
            }
        }
        return this.m_searchBuffer;
    }

    static {
        s_knownTypes.add(KW_PROCEDURE);
        s_knownTypes.add(KW_FUNCTION);
        s_knownTypes.add(KW_TRIGGER);
        s_knownTypes.add(KW_PACKAGE);
        s_knownTypes.add(KW_TYPE);
    }

    private static class InterrogatorCancelledException
    extends PlSqlInterrogationException {
        private InterrogatorCancelledException() {
        }
    }

    private static enum InterrogateState {
        PROCEDURE,
        FUNCTION,
        TRIGGER,
        PLSQL_BLOCK,
        DECLARATIVE_SECTION,
        STATEMENT_BLOCK,
        EXCEPTION_BLOCK,
        SIMPLE_STATEMENT,
        LABEL,
        PARAMETER,
        PARAMETER_LIST,
        TRIGGER_EVENTS,
        TRIGGER_COLUMNS,
        CASE_STATEMENT,
        ORACLE_TYPE_DECLN,
        TYPE_SPEC,
        CURSOR;


        public String toString() {
            return super.toString().replaceAll("_", " ");
        }
    }

    private static class PlSqlInterrogationException
    extends Exception {
        private PlSqlInterrogationException() {
        }
    }
}

