/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.javatools.data.HashStructure;

public final class SharedProjectPropertiesHook {
    static final String HOOK_NAME = "shared-project-properties";
    static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "shared-project-properties");
    private static final String SHARED_PROPERTY_KEYS = "property-keys";
    private static final String PROPERTY_KEY = "key";
    private static HashStructureHook _hashStructureHook;
    private static final Set<String> _keys;

    static boolean shareable(String propertyDatakey) {
        SharedProjectPropertiesHook.initializeHook();
        return _keys.contains(propertyDatakey);
    }

    private static void initializeHook() {
        if (_hashStructureHook == null) {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
            _hashStructureHook = (HashStructureHook)extensionRegistry.getHook(NAME);
            if (_hashStructureHook == null) {
                return;
            }
            _hashStructureHook.addHashStructureHookListener(new HashStructureHookListener(){

                @Override
                public void elementVisited(HashStructureHookEvent e) {
                    Logger.getLogger(SharedProjectPropertiesHook.class.getName()).log(Level.SEVERE, "The shared-project-properties hook can only be used as a trigger hook.");
                }

                @Override
                public void listenerAttached(HashStructureHookEvent e) {
                    _keys.addAll(SharedProjectPropertiesHook.getItemsFromHook(e.getCombinedHashStructure()));
                }
            });
        }
    }

    private static Set<String> getItemsFromHook(HashStructure hashStructure) {
        HashSet<String> set = new HashSet<String>();
        List hashList = hashStructure.getAsList(SHARED_PROPERTY_KEYS);
        if (hashList == null) {
            return Collections.emptySet();
        }
        for (HashStructure hash : hashList) {
            if (!hash.containsKey(PROPERTY_KEY)) continue;
            List keys = hash.getAsList(PROPERTY_KEY);
            for (HashStructure keyHash : keys) {
                String key;
                if (!keyHash.containsKey("#text") || (key = keyHash.getString("#text")) == null) continue;
                set.add(key);
            }
        }
        return set;
    }

    private static void initFromHash(HashStructure hash) {
        _keys.addAll(SharedProjectPropertiesHook.getItemsFromHook(hash));
    }

    static {
        _keys = new HashSet<String>();
    }
}

