/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.preference;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.extension.preference.ManageFeaturesPanelListener;
import oracle.ide.extension.preference.ManageFeaturesPanelType;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ideimpl.extension.preference.UpdatePanelProvider;
import oracle.ideimpl.extension.preference.UpdatePanelProviderHook;
import oracle.ideimpl.resource.ManageFeaturesArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.RichHintLabel;

public class ManageUpdatesPanel
extends JPanel
implements ManageFeaturesPanelListener {
    private static final String TREE_EXPANSION_STATE_KEY = "features-updates-tree-expansion-state";
    private static final GridBagConstraints NORTH_CONSTRAINTS = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
    private static final GridBagConstraints CENTER_CONSTRAINTS = new GridBagConstraints(0, 1, 1, 5, 1.0, 1.0, 10, 1, new Insets(10, 0, 8, 0), 0, 0);
    private static final GridBagConstraints SOUTH_CONSTRAINTS = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0);
    private final RichHintLabel _headerLabel = new RichHintLabel();
    private final ManageFeaturesPanelType _treePanel;
    private final JButton _uninstallButton = new JButton();

    ManageUpdatesPanel() {
        super(new GridBagLayout());
        UpdatePanelProvider dialog = UpdatePanelProviderHook.getUpdatePanelProvider();
        this._treePanel = UpdatePanelProvider.getPanel();
        try {
            this._headerLabel.setHtmlText(ManageFeaturesArb.getString(26));
            this.add((Component)this._headerLabel, NORTH_CONSTRAINTS);
            this.add((Component)((JPanel)((Object)this._treePanel)), CENTER_CONSTRAINTS);
            AbstractAction action = this.getUpdateStatusAction();
            this._uninstallButton.setAction(action);
            this._treePanel.setPanelChangedListener(this);
            action.setEnabled(false);
            this.add((Component)this._uninstallButton, SOUTH_CONSTRAINTS);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    public boolean hasChanges() {
        return this._treePanel.hasChanges();
    }

    @Override
    public void panelChanged(ManageFeaturesPanelType type) {
        if (this.hasChanges()) {
            this._uninstallButton.setEnabled(true);
            this._uninstallButton.requestFocus();
        } else {
            this._uninstallButton.setEnabled(false);
        }
    }

    private AbstractAction getUpdateStatusAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageUpdatesPanel.this.doUninstall();
            }
        };
        String label = ManageFeaturesArb.getString(25);
        action.putValue("Name", StringUtils.stripMnemonic((String)label));
        action.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)label));
        return action;
    }

    private void doUninstall() {
        this._treePanel.makeChanges();
        this._uninstallButton.setEnabled(false);
        boolean ok = MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)IdeArb.getString(450), (String)IdeArb.getString(449), null);
        if (ok) {
            try {
                Ide.restart();
            }
            catch (UnsupportedOperationException uoe) {
                Ide.quit();
            }
        }
    }

    void populate() {
        this._treePanel.populate();
    }

    void saveTreeExpansionState() {
        String[] expansionState = this._treePanel.getTreeExpansionState();
        DTCache cache = Ide.getDTCache();
        if (expansionState.length == 0) {
            cache.remove(TREE_EXPANSION_STATE_KEY);
            return;
        }
        StringBuilder b = new StringBuilder();
        String delim = "";
        for (String s : expansionState) {
            b.append(delim).append(s);
            delim = ";";
        }
        cache.putString(TREE_EXPANSION_STATE_KEY, b.toString());
    }

    Component getFirstFocusComponent() {
        return this._treePanel.getFirstFocusComponent();
    }

    void setHeaderComponent(Component header) {
        this.remove((Component)this._headerLabel);
        if (header != null) {
            this.add(header, NORTH_CONSTRAINTS);
        }
    }
}

