/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.task;

import oracle.ide.task.CancellableTask;
import oracle.ide.task.DefaultTaskMonitorImpl;
import oracle.ide.task.Task;
import oracle.ide.task.TaskManager;
import oracle.ide.task.TaskMonitor;
import oracle.ide.task.TaskState;
import oracle.ide.task.event.TaskEvent;
import oracle.ide.task.event.TaskException;
import oracle.ide.task.event.TaskExitCode;
import oracle.ide.task.event.TaskFrameworkServicesImpl;

public class TaskRunnable
implements Runnable {
    final Task task;
    final TaskMonitor tc;
    final TaskFrameworkServicesImpl tg;

    public TaskRunnable(Task task) {
        this.task = task;
        this.tg = new TaskFrameworkServicesImpl(task);
        this.tc = new DefaultTaskMonitorImpl(task);
        TaskManager.setTaskMonitor(task.getShortName(), this.tc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        TaskEvent ee = new TaskEvent(this.task);
        this.tg.fireStarted(ee);
        try {
            TaskExitCode exitCode = this.task.performTask(this.tc);
            switch (exitCode) {
                case CANCELLED: {
                    this.task.state = TaskState.CANCELLED;
                    if (!(this.task instanceof CancellableTask)) return;
                    TaskEvent e = new TaskEvent(this.task);
                    this.tg.fireCancelled(e);
                    return;
                }
                case COMPLETED: {
                    this.task.state = TaskState.COMPLETED;
                    TaskEvent e = new TaskEvent(this.task);
                    this.tg.fireComplete(e);
                    return;
                }
                case ABORTED: {
                    this.task.state = TaskState.ABORTED_INCOMPLETE;
                    return;
                }
            }
            return;
        }
        catch (Throwable e) {
            this.task.state = TaskState.ABORTED_ON_EXCEPTION;
            if (e instanceof TaskException) {
                this.tg.fireException(ee, (TaskException)e);
                return;
            }
            this.tg.fireException(ee, new TaskException(e));
            return;
        }
        finally {
            TaskManager.setTaskMonitor(this.task.getShortName(), this.tc);
        }
    }
}

