/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import javax.swing.Icon;
import oracle.ide.model.Dependable;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;

public abstract class DiscoveredDependable
implements Displayable {
    public abstract Element getElement();

    public abstract Dependable getDependable();

    public static final DiscoveredDependable createDefault(Element element, Dependable dependable, Icon icon, String shortLabel, String longLabel, String tooltip) {
        return new DefaultDiscoveredDependable(element, dependable, icon, shortLabel, longLabel, tooltip);
    }

    public static final DiscoveredDependable createDefault(Element element, Dependable dependable) {
        return new DefaultDiscoveredDependable(element, dependable);
    }

    public static class DefaultDiscoveredDependable
    extends DiscoveredDependable {
        private final String shortLabel;
        private final String longLabel;
        private final String tooltip;
        private final Icon icon;
        private final Element element;
        private final Dependable dependable;

        public DefaultDiscoveredDependable(Element element, Dependable dependable) {
            this(element, dependable, null, null, null, null);
        }

        public DefaultDiscoveredDependable(Element element, Dependable dependable, Icon icon, String shortLabel, String longLabel, String tooltip) {
            assert (element != null);
            this.dependable = dependable;
            this.element = element;
            this.icon = icon;
            this.shortLabel = shortLabel;
            this.longLabel = longLabel;
            this.tooltip = tooltip;
        }

        @Override
        public Element getElement() {
            return this.element;
        }

        @Override
        public Dependable getDependable() {
            return this.dependable;
        }

        @Override
        public String getShortLabel() {
            return this.shortLabel != null ? this.shortLabel : this.element.getShortLabel();
        }

        @Override
        public String getLongLabel() {
            return this.longLabel != null ? this.longLabel : this.element.getLongLabel();
        }

        @Override
        public Icon getIcon() {
            return this.icon != null ? this.icon : this.element.getIcon();
        }

        @Override
        public String getToolTipText() {
            return this.tooltip != null ? this.tooltip : this.element.getToolTipText();
        }
    }
}

