/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension;

import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.SharedExtensionUtils;
import oracle.ide.javaxide.Util;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public final class LazyClassAdapter
extends HashStructureAdapter {
    private LazyClassAdapter(HashStructure hash) {
        super(hash);
    }

    public static LazyClassAdapter getInstance(HashStructure hash) {
        return new LazyClassAdapter(hash);
    }

    public <T> T createInstance(Class<T> clazz, String keyName) {
        MetaClass<T> mc = this.getMetaClass(keyName);
        if (mc == null) {
            return null;
        }
        return Util.createInstance(mc, clazz);
    }

    public <T> MetaClass<T> getMetaClass(String keyName) {
        if (keyName == null) {
            throw new NullPointerException("keyName is null.");
        }
        String fqName = this._hash.getString(keyName);
        if (fqName == null || (fqName = fqName.trim()).length() == 0) {
            return null;
        }
        String extensionId = SharedExtensionUtils.findExtensionClassLoader(keyName, this._hash);
        if (extensionId == null) {
            return null;
        }
        ClassLoader loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(extensionId);
        if (loader == null) {
            throw new IllegalStateException("Classloader not found for extension " + extensionId);
        }
        return new MetaClass(loader, fqName);
    }
}

