/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import oracle.ide.config.ExtensionSettingsPage;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public final class ExtensionSettingsUI
extends HashStructureAdapter {
    private ExtensionSettingsUI(HashStructure hs) {
        super(hs);
    }

    static ExtensionSettingsUI getInstance(HashStructure hs) {
        return new ExtensionSettingsUI(hs);
    }

    public String getObjectLabel(String id) {
        List data;
        if (id != null && (data = this._hash.getAsList("dialog")) != null) {
            for (HashStructure hash : data) {
                if (!id.equals(hash.getString("id"))) continue;
                return hash.getString("object-label");
            }
        }
        return "";
    }

    public Collection<String> getDialogs() {
        List data = this._hash.getAsList("dialog");
        if (data == null) {
            return Collections.emptySet();
        }
        ArrayList<String> ids = new ArrayList<String>(data.size());
        for (HashStructure hash : data) {
            ids.add(hash.getString("id"));
        }
        return Collections.unmodifiableCollection(ids);
    }

    public Collection<ExtensionSettingsPage> getPages() {
        List pageHashes = this._hash.getAsList("page");
        if (pageHashes == null) {
            return Collections.emptySet();
        }
        ArrayList<ExtensionSettingsPage> pages = new ArrayList<ExtensionSettingsPage>(pageHashes.size());
        for (HashStructure hs : pageHashes) {
            pages.add(ExtensionSettingsPage.getInstance(hs));
        }
        return Collections.unmodifiableCollection(pages);
    }

    Collection<ExtensionSettingsPage> getChildren(ExtensionSettingsPage page) {
        return this.getChildren(page.getIdPath());
    }

    public Collection<ExtensionSettingsPage> getChildren(String parentIdPath) {
        String normalizedParentIdPath = this.normalizeIdPath(parentIdPath);
        LinkedHashMap<String, ExtensionSettingsPage> map = new LinkedHashMap<String, ExtensionSettingsPage>();
        for (ExtensionSettingsPage candidate : this.getPages()) {
            if (!normalizedParentIdPath.equals(this.normalizeIdPath(candidate.getParentId()))) continue;
            map.put(candidate.getId(), candidate);
        }
        return Collections.unmodifiableCollection(map.values());
    }

    private String normalizeIdPath(String idPath) {
        if (idPath.charAt(0) != '/') {
            return "/" + idPath;
        }
        return idPath;
    }

    public ExtensionSettingsPage findPageByIdPath(String idPath) {
        for (ExtensionSettingsPage page : this.getPages()) {
            if (!idPath.equals(page.getIdPath())) continue;
            return page;
        }
        return null;
    }
}

