/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.treetable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.TreeTableModel;
import oracle.jdevimpl.style.treetable.CodingStyleTreeCategory;
import oracle.jdevimpl.style.treetable.CodingStyleTreeItem;

public class CodingStyleTreeTableModel
extends AbstractTreeTableModel {
    protected List listenerList;
    private JTree tree;

    public CodingStyleTreeTableModel(CodingStyleTreeCategory root) {
        super((Object)root);
        this.setRoot(root);
    }

    public void setRoot(CodingStyleTreeCategory root) {
        this.root = root;
    }

    public void setTree(JTree tree) {
        this.tree = tree;
    }

    public Object getValueAt(Object node, int column) {
        if (node instanceof CodingStyleTreeItem) {
            CodingStyleTreeItem item = (CodingStyleTreeItem)node;
            return item.getValue(column);
        }
        return null;
    }

    public String getColumnName(int column) {
        return "";
    }

    public int getColumnCount() {
        return 2;
    }

    public int getChildCount(Object node) {
        if (node instanceof CodingStyleTreeCategory) {
            CodingStyleTreeCategory category = (CodingStyleTreeCategory)node;
            return category.getChildCount();
        }
        return 0;
    }

    public Object getChild(Object node, int index) {
        if (node instanceof CodingStyleTreeCategory) {
            CodingStyleTreeCategory category = (CodingStyleTreeCategory)node;
            return category.getChild(index);
        }
        return null;
    }

    public Class getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : String.class;
    }

    public boolean isCellEditable(Object node, int column) {
        if (column == 1 && node instanceof CodingStyleTreeItem) {
            return ((CodingStyleTreeItem)node).isValueEditable();
        }
        return true;
    }

    public void setValueAt(Object value, Object node, int column) {
        if (node instanceof CodingStyleTreeItem) {
            CodingStyleTreeItem item = (CodingStyleTreeItem)node;
            Object oldValue = item.getValue();
            item.setValue(value);
            if (!oldValue.equals(value)) {
                this.fireChangeEvent(node);
            }
        }
    }

    public void itemsChanged(CodingStyleTreeCategory category, int[] childIndices) {
        this.fireChangeEvent((Object)this);
        Object[] children = new Object[childIndices.length];
        for (int i = 0; i < childIndices.length; ++i) {
            children[i] = category.getChild(childIndices[i]);
        }
        Object[] path = this.getPath(category);
        final TreePath[] selection = this.tree.getSelectionPaths();
        this.fireTreeNodesChanged((Object)this, path, childIndices, children);
        if (selection != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CodingStyleTreeTableModel.this.tree.setSelectionPaths(selection);
                }
            });
        }
    }

    public synchronized void addChangeListener(ChangeListener l) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList();
            this.listenerList.add(l);
        }
    }

    public synchronized void removeListenerList(ChangeListener l) {
        if (this.listenerList != null) {
            this.listenerList.remove(l);
        }
    }

    protected void fireChangeEvent(Object source) {
        if (this.listenerList != null) {
            for (ChangeListener l : this.listenerList) {
                l.stateChanged(new ChangeEvent(source));
            }
        }
    }

    private Object[] getPath(CodingStyleTreeItem item) {
        ArrayList<CodingStyleTreeItem> path = new ArrayList<CodingStyleTreeItem>();
        path.add(item);
        for (CodingStyleTreeItem parent = item.getParent(); parent != null; parent = parent.getParent()) {
            path.add(parent);
        }
        Collections.reverse(path);
        return path.toArray();
    }
}

