/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.deferredupdate.task;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.ideimpl.deferredupdate.UpdateArb;
import oracle.ideimpl.deferredupdate.task.AtomicTask;
import oracle.ideimpl.deferredupdate.task.BundleDetails;
import oracle.ideimpl.deferredupdate.task.CreateDirectory;
import oracle.ideimpl.deferredupdate.task.DeleteFile;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;
import oracle.ideimpl.deferredupdate.task.TaskStack;
import oracle.ideimpl.deferredupdate.task.UnzipTask;
import oracle.ideimpl.deferredupdate.task.UpdateBundlesInfoTask;

public class InstallExtensionTask
extends AtomicTask {
    private static final String META_INF_PATTERN = "^meta-inf.*";
    private static final Logger LOG = Logger.getLogger(InstallExtensionTask.class.getName());
    private List<String> extensionNames = new ArrayList<String>();
    private TaskStack _tasks;
    private List<BundleDetails> _osgiBundles;
    private String zipFileName;
    private String destinationDir;
    private boolean deleteZip;
    public static final String JAVAFX_ZIP_NAME_PREFIX_VALUE = System.getProperty("javafx.zip.name.prefix.key", "openjfx");

    InstallExtensionTask(String zipFileName, String destinationDir, boolean deleteZip, List<String> updateIds) {
        this.zipFileName = zipFileName;
        this.destinationDir = destinationDir;
        this.deleteZip = deleteZip;
        this.extensionNames.addAll(updateIds);
        if (this.extensionNames.size() > 1) {
            LOG.warning("Multiple Extensions In Bundle" + zipFileName);
        }
    }

    @Override
    public void perform(TaskContext tc) throws TaskFailedException {
        this._tasks = new TaskStack();
        this._osgiBundles = new ArrayList<BundleDetails>();
        if (this.zipFileName != null && this.zipFileName.contains(JAVAFX_ZIP_NAME_PREFIX_VALUE)) {
            return;
        }
        File zipFile = new File(this.zipFileName);
        if (!zipFile.exists() || !zipFile.canRead()) {
            throw new TaskFailedException(UpdateArb.format("READ_FAILED", zipFile.getPath()));
        }
        File destinationFile = new File(this.destinationDir);
        this._tasks.performTask(new CreateDirectory(destinationFile), tc);
        UnzipTask unzipTask = new UnzipTask(zipFile, destinationFile, this._osgiBundles, this.extensionNames);
        unzipTask.addSkipPattern(META_INF_PATTERN);
        this._tasks.performTask(unzipTask, tc);
        UpdateBundlesInfoTask updateBundlesInfo = new UpdateBundlesInfoTask(this._osgiBundles, false);
        this._tasks.performTask(updateBundlesInfo, tc);
        if (this._osgiBundles.isEmpty()) {
            LOG.warning("No Extensions In Bundle: " + this.zipFileName);
        }
        if (this.deleteZip) {
            this._tasks.performTask(new DeleteFile(zipFile), tc);
        }
    }

    @Override
    public void rollback(TaskContext tc) throws TaskFailedException {
        if (this._tasks != null) {
            this._tasks.rollbackTasks(tc);
        }
    }

    @Override
    public void commit(TaskContext tc) throws TaskFailedException {
        this._tasks.commitTasks(tc);
    }
}

