/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapdv.actions;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Rectangle;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdeveloper.db.ConnectionException;
import oracle.olapdv.OLAPDVArb;
import oracle.olapdv.app.DataValidateDialog;
import oracle.olapdv.app.DataValidatePanel;
import oracle.olapdv.app.ValidatePanel;
import oracle.olapdv.app.ValidateViewer;
import oracle.olapdv.connection.ConnectionManager;
import oracle.olapdv.connection.DatabaseConnection;
import oracle.olapdv.olap.model.DimensionDO;
import oracle.olapdv.olap.model.HierarchyDO;
import oracle.olapdv.olap.model.LevelDO;
import oracle.olapdv.olap.model.LevelMapDO;
import oracle.olapdv.olap.model.ValidateModelDO;
import oracle.olapdv.olap.model.ValidateTopDO;
import oracle.olapdv.query.QueryManager;
import oracle.olapdv.util.MiscUtils;

public class OlapDVAction
extends AbstractMenuAction {
    private static final Logger LOG = Logger.getLogger(OlapDVAction.class.getName());

    public void setArgs(String string) {
    }

    public void launch() {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        DBObject dBObject = this.getDBObject();
        Connection connection = dBObject.getConnection();
        ConnectionManager.getInstance().setMainConnection(connection);
        ideMainWindow.setCursor(new Cursor(3));
        Connection connection2 = this.getClonedConnection(connection);
        ConnectionManager.getInstance().setClonedConnection(connection2);
        ideMainWindow.setCursor(Cursor.getDefaultCursor());
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBObject.getDatabase();
        String string = dBObject.getSchemaName();
        String string2 = dBObject.getObjectName();
        ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
        validateTopDO.setOracleDatabaseImpl(oracleDatabaseImpl);
        if (validateTopDO.getIsAlreadyLaunched()) {
            JOptionPane.showMessageDialog((Component)ideMainWindow, OLAPDVArb.getString("OLAP_DATA_VALIDATION_EXTENSION_IS_ALREADY_RUNNING"), OLAPDVArb.getString("OLAP_DATA_VALIDATION_EXTENSION_IS_ALREADY_RUNNING"), 2);
            return;
        }
        validateTopDO.setIsAlreadyLaunched(true);
        validateTopDO.setPermissionError(false);
        ideMainWindow.setCursor(new Cursor(3));
        DataValidateDialog dataValidateDialog = new DataValidateDialog((Frame)ideMainWindow, (OracleConnection)connection2, string, string2);
        ideMainWindow.setCursor(Cursor.getDefaultCursor());
        if (validateTopDO.getPermissionError()) {
            validateTopDO.setIsAlreadyLaunched(false);
            return;
        }
        QueryManager queryManager = new QueryManager();
        if (!queryManager.areThereAnyDimensions(string, string2)) {
            JOptionPane.showMessageDialog((Component)ideMainWindow, OLAPDVArb.format("NO_DIMENSIONS_FOUND_MESSAGE", string, string2), OLAPDVArb.getString("NO_DIMENSIONS_FOUND_TITLE"), 0);
            validateTopDO.setIsAlreadyLaunched(false);
            return;
        }
        this.launchRaptorTaskForDimensionDataValidation(dataValidateDialog, string, string2);
    }

    private void launchRaptorTaskForDimensionDataValidation(final DataValidateDialog dataValidateDialog, final String string, final String string2) {
        try {
            RaptorTask raptorTask = new RaptorTask(OLAPDVArb.getString("LAUNCHING_DATA_VALIDATION_PLUG_IN"), true, IRaptorTaskRunMode.MODAL){

                protected Object doWork() throws TaskException {
                    Boolean bl = Boolean.TRUE;
                    try {
                        ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
                        validateTopDO.setInitializing(true);
                        dataValidateDialog.importAWOnStartUp(this, string, string2);
                        ValidateModelDO validateModelDO = validateTopDO.getValidateModelDO(string, string2);
                        if (!validateModelDO.isLaunchedFromCache()) {
                            OlapDVAction.this.validateModel(this, string, string2);
                        } else {
                            LevelDO levelDO = validateTopDO.getLastDrillToDetailLevel();
                            if (levelDO != null && OlapDVAction.this.isLastTimeDimensionTableUpdatedNewer()) {
                                DataValidatePanel dataValidatePanel = dataValidateDialog.getDataValidatePanel();
                                ValidateViewer validateViewer = dataValidatePanel.getValidateViewer();
                                ValidatePanel validatePanel = validateViewer.getValidatePanel();
                                String string3 = levelDO.getDimensionDO().getName();
                                validatePanel.runValidationOnAllReports(string3, true, null);
                            }
                        }
                        dataValidateDialog.notifyModelPanelReady();
                    }
                    catch (Exception exception) {
                        bl = Boolean.FALSE;
                        throw new TaskException((Throwable)exception);
                    }
                    return bl;
                }
            };
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
                            validateTopDO.setIsAlreadyLaunched(false);
                            QueryManager queryManager = new QueryManager();
                            queryManager.rollback();
                            Throwable throwable = raptorTaskEvent.getThrowable();
                            OlapDVAction.this.showErrorDialog(throwable);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            QueryManager queryManager = new QueryManager();
                            queryManager.commit();
                            dataValidateDialog.refreshModelViewer();
                            dataValidateDialog.refreshAllReportViewer();
                            dataValidateDialog.pack();
                            dataValidateDialog.setModal(false);
                            Rectangle rectangle = MiscUtils.centerWindow((Component)Ide.getMainWindow(), 900, 750);
                            dataValidateDialog.setBounds(rectangle);
                            dataValidateDialog.setVisible(true);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                    Runnable runnable2 = new Runnable(){

                        @Override
                        public void run() {
                            ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
                            ValidateModelDO validateModelDO = validateTopDO.getValidateModelDO(string, string2);
                            boolean bl = validateModelDO.isLaunchedFromCache();
                            dataValidateDialog.requestInitialFocus(bl);
                        }
                    };
                    SwingUtilities.invokeLater(runnable2);
                    Runnable runnable3 = new Runnable(){

                        @Override
                        public void run() {
                            ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
                            ValidateModelDO validateModelDO = validateTopDO.getValidateModelDO(string, string2);
                            LevelDO levelDO = validateTopDO.getLastDrillToDetailLevel();
                            boolean bl = validateModelDO.isLaunchedFromCache();
                            if (bl && levelDO != null) {
                                dataValidateDialog.requestInitialReportPanelRowSelection(levelDO);
                            }
                            validateTopDO.setInitializing(false);
                        }
                    };
                    SwingUtilities.invokeLater(runnable3);
                }

                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
                    validateTopDO.deleteModelDO(string, string2);
                    validateTopDO.setIsAlreadyLaunched(false);
                    validateTopDO.setInitializing(false);
                    QueryManager queryManager = new QueryManager();
                    queryManager.rollback();
                }
            });
            raptorTask.setCancellable(true);
            raptorTask.setPausable(false);
            raptorTask.setMessage(OLAPDVArb.getString("LAUNCHING_DATA_VALIDATION_PLUG_IN"));
            RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
            raptorTaskManager.addTask(raptorTask);
        }
        catch (Exception exception) {
            ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
            validateTopDO.deleteModelDO(string, string2);
            validateTopDO.setIsAlreadyLaunched(false);
            validateTopDO.setInitializing(false);
            this.showErrorDialog(exception);
        }
    }

    private void showErrorDialog(Throwable throwable) {
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), throwable.getLocalizedMessage());
    }

    private void validateModel(RaptorTask raptorTask, String string, String string2) {
        QueryManager queryManager = new QueryManager();
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        ArrayList<CallSite> arrayList2 = new ArrayList<CallSite>();
        boolean bl = false;
        ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
        ValidateModelDO validateModelDO = validateTopDO.getValidateModelDO(string, string2);
        ArrayList<DimensionDO> arrayList3 = validateModelDO.getDimensionDOs();
        for (DimensionDO dimensionDO : arrayList3) {
            boolean bl2;
            raptorTask.setMessage(OLAPDVArb.format("RUNNING_MODEL_VALIDATION_DETAIL_MSG", dimensionDO.getName()));
            dimensionDO.setValidState(true);
            ArrayList<HierarchyDO> arrayList4 = dimensionDO.getHierarchyDOs();
            for (HierarchyDO hierarchyDO : arrayList4) {
                ArrayList<LevelDO> arrayList5 = hierarchyDO.getLevelDOs();
                arrayList.clear();
                arrayList2.clear();
                for (LevelDO levelDO : arrayList5) {
                    LevelMapDO levelMapDO = levelDO.getLevelMapDO();
                    String string3 = levelMapDO.getOwner();
                    String string4 = levelMapDO.getTableName();
                    String string5 = levelMapDO.getColumnName();
                    String string6 = levelMapDO.getLongDescriptionColumnName();
                    String string7 = levelMapDO.getParentColumnName();
                    levelDO.setValidState(LevelDO.ValidStates.VALID_OK);
                    levelMapDO.setOwnerNameValid(true);
                    levelMapDO.setTableNameValid(true);
                    levelMapDO.setKeyColumnValid(true);
                    levelMapDO.setDescColumnValid(true);
                    levelMapDO.setSnowflakeColumnValid(true);
                    if (string3 == null || string4 == null || string5 == null || string6 == null) {
                        if (string3 == null) {
                            dimensionDO.setValidState(false);
                            levelDO.setValidState(LevelDO.ValidStates.VALID_ERROR);
                            levelMapDO.setOwnerNameValid(false);
                        }
                        if (string4 == null) {
                            dimensionDO.setValidState(false);
                            levelDO.setValidState(LevelDO.ValidStates.VALID_ERROR);
                            levelMapDO.setTableNameValid(false);
                        }
                        if (!levelMapDO.isKeyColumnMapSupported()) {
                            dimensionDO.setValidState(false);
                            levelDO.setValidState(LevelDO.ValidStates.VALID_ERROR);
                            levelMapDO.setKeyColumnValid(false);
                        }
                        if (string5 == null) {
                            dimensionDO.setValidState(false);
                            levelDO.setValidState(LevelDO.ValidStates.VALID_ERROR);
                            levelMapDO.setKeyColumnValid(false);
                        }
                        if (!levelMapDO.isDescColumnMapSupported()) {
                            dimensionDO.setValidState(false);
                            levelDO.setValidState(LevelDO.ValidStates.VALID_ERROR);
                            levelMapDO.setDescColumnValid(false);
                        }
                        if (string6 == null || string6.equals("null")) {
                            dimensionDO.setValidState(false);
                            levelDO.setValidState(LevelDO.ValidStates.VALID_ERROR);
                            levelMapDO.setDescColumnValid(false);
                        }
                        bl = true;
                        continue;
                    }
                    if (arrayList.contains(string3 + "." + string4 + "." + string5)) {
                        dimensionDO.setValidState(false);
                        levelDO.setValidState(LevelDO.ValidStates.VALID_ERROR);
                        levelMapDO.setKeyColumnValid(false);
                    } else {
                        arrayList.add((CallSite)((Object)(string3 + "." + string4 + "." + string5)));
                    }
                    if (arrayList2.contains(string3 + "." + string4 + "." + string6)) {
                        dimensionDO.setValidState(false);
                        levelDO.setValidState(LevelDO.ValidStates.VALID_ERROR);
                        levelMapDO.setDescColumnValid(false);
                    } else {
                        arrayList2.add((CallSite)((Object)(string3 + "." + string4 + "." + string6)));
                    }
                    if (!queryManager.isOwnerValid(string3)) {
                        dimensionDO.setValidState(false);
                        levelDO.setValidState(LevelDO.ValidStates.VALID_ERROR);
                        continue;
                    }
                    if (!queryManager.isTableNameValid(string3, string4)) {
                        dimensionDO.setValidState(false);
                        levelDO.setValidState(LevelDO.ValidStates.VALID_ERROR);
                        levelMapDO.setTableNameValid(false);
                        continue;
                    }
                    if (levelMapDO.isKeyColumnValid() && !queryManager.isColumnNameValid(string3, string4, string5)) {
                        dimensionDO.setValidState(false);
                        levelDO.setValidState(LevelDO.ValidStates.VALID_ERROR);
                        levelMapDO.setKeyColumnValid(false);
                    }
                    if (levelMapDO.isDescColumnValid() && !queryManager.isColumnNameValid(string3, string4, string6)) {
                        dimensionDO.setValidState(false);
                        levelDO.setValidState(LevelDO.ValidStates.VALID_ERROR);
                        levelMapDO.setDescColumnValid(false);
                    }
                    if (string7 == null || string7.length() <= 0 || queryManager.isColumnNameValid(string3, string4, string7)) continue;
                    dimensionDO.setValidState(false);
                    levelMapDO.setSnowflakeColumnValid(false);
                    levelDO.setValidState(LevelDO.ValidStates.VALID_ERROR);
                }
            }
            if (dimensionDO.getValidState() || !(bl2 = dimensionDO.supportPossibleTopLevelMemberLiteralMapping())) continue;
            dimensionDO.setValidState(true);
        }
    }

    protected boolean isLastTimeDimensionTableUpdatedNewer() {
        ValidateTopDO validateTopDO = ValidateTopDO.getInstance();
        LevelDO levelDO = validateTopDO.getLastDrillToDetailLevel();
        boolean bl = false;
        if (levelDO != null) {
            String string;
            String string2 = validateTopDO.getLastTimeDimensionTableUpdated();
            QueryManager queryManager = new QueryManager();
            LevelMapDO levelMapDO = levelDO.getLevelMapDO();
            String string3 = levelMapDO.getOwner();
            String string4 = queryManager.getLastTimeTableUpdated(string3, string = levelMapDO.getTableName());
            if (string4 != null && string2 != null && !string4.equalsIgnoreCase(string2)) {
                bl = true;
                validateTopDO.setLastTimeDimensionTableUpdated(string4);
            }
        }
        return bl;
    }

    private Connection getClonedConnection(Connection connection) {
        Connection connection2 = null;
        DatabaseConnection databaseConnection = DatabaseConnection.getInstance();
        try {
            connection2 = databaseConnection.getClonedConnection(connection);
        }
        catch (ConnectionException connectionException) {
            LOG.log(Level.SEVERE, "Unable to establish a cloned connection");
        }
        return connection2;
    }
}

