/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.Document;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.utils.RestTemplatePattern;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

public class RestPublishPanel
extends JPanel {
    private static final int MIN_SIZE = 0;
    private static final int MAX_SIZE = 10000;
    private static final int DEFAULT_PAGINATION_SIZE = 25;
    private Map<String, RestModule> _lookupModules;
    private Map<String, String> _existingUriPrefixes;
    private Map<String, List<String>> _modAvailTemplates;
    private Map<String, List<String>> _modExcludeTemplates;
    private Map<String, ?> _bindMap;
    private BasicEditorPane _queryEditor;
    private JComboBox<String> _moduleNameCB;
    private JComboBox<String> _uriPatternCB;
    private JTextField _uriPrefix;
    private JTextField _uriPattern;
    private NumericSpinBox _pagination;
    private JLabel _modURIExample;
    private List<String> _errMsg;
    private String _schema;
    private String _origSql;
    private boolean _newModule;
    private boolean _newTemplate;

    public RestPublishPanel(List<RestModule> list, String string, String string2, Map<String, ?> map, List<?> list2) {
        this._bindMap = map;
        if (string != null) {
            this._schema = string.toLowerCase();
        }
        this._origSql = string2;
        this.createLists(list);
        this.createPanel();
    }

    private void createLists(List<RestModule> list) {
        this._modAvailTemplates = new HashMap<String, List<String>>();
        this._modExcludeTemplates = new HashMap<String, List<String>>();
        this._existingUriPrefixes = new HashMap<String, String>();
        this._lookupModules = new LinkedHashMap<String, RestModule>();
        if (list != null) {
            for (RestModule restModule : list) {
                String string = restModule.getName();
                List list2 = restModule.getTemplates();
                if (list2 != null && list2.size() > 0) {
                    for (RestTemplate restTemplate : list2) {
                        List<String> list3;
                        if (restTemplate.getResourceHandlers() != null && restTemplate.getResourceHandlers().containsKey(RestResourceHandler.HTTP_METHOD_TYPE.GET)) {
                            list3 = this._modExcludeTemplates.get(string);
                            if (list3 == null) {
                                list3 = new ArrayList<String>();
                            }
                            list3.add(restTemplate.getURIPattern());
                            this._modExcludeTemplates.put(string, list3);
                            continue;
                        }
                        list3 = this._modAvailTemplates.get(string);
                        if (list3 == null) {
                            list3 = new ArrayList<String>();
                        }
                        list3.add(restTemplate.getURIPattern());
                        this._modAvailTemplates.put(string, list3);
                    }
                }
                this._existingUriPrefixes.put(restModule.getURIPrefix(), string);
                this._lookupModules.put(string, restModule);
            }
        }
    }

    private void initializeComponents() {
        Serializable serializable;
        if (this._lookupModules != null && !this._lookupModules.isEmpty()) {
            serializable = new ArrayList<String>(this._lookupModules.keySet());
            Collections.sort(serializable);
            String[] stringArray = ((ArrayList)serializable).toArray(new String[((ArrayList)serializable).size()]);
            this._moduleNameCB = new JComboBox<String>(stringArray);
        } else {
            this._moduleNameCB = new JComboBox();
        }
        this._moduleNameCB.setEditable(true);
        this._moduleNameCB.setSelectedItem("");
        this._uriPrefix = new JTextField();
        this._uriPatternCB = new JComboBox();
        this._uriPatternCB.setEditable(true);
        this._uriPattern = new JTextField();
        this._uriPattern.setText("");
        this._modURIExample = new JLabel();
        serializable = this._modURIExample.getFont();
        this._modURIExample.setFont(((Font)serializable).deriveFont(((Font)serializable).getStyle() | 1, ((Font)serializable).getSize()));
        this._pagination = new NumericSpinBox(0, 10000);
        this._pagination.setValue((Number)25);
        this._queryEditor = EditorFactory.createIdeEditorPane();
        this._queryEditor.setDocument((Document)new BasicDocument("foo.plsql"));
        this._queryEditor.installPlugin((EditorPlugin)new LineGutterPlugin());
        this._queryEditor.installPlugin((EditorPlugin)new LineHighlightPlugin());
        this._queryEditor.installPlugin((EditorPlugin)new HighlightEditorPlugin());
        this._queryEditor.setPreferredSize(null);
        this._queryEditor.setText(this._origSql);
        this._moduleNameCB.requestFocusInWindow();
    }

    private String getQueryString(Map<String, ?> map) {
        if (!RestUtils.nullOrEmpty(this._origSql) && map != null && !map.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            List list = DBUtil.getBindNames((String)this._origSql, (boolean)false);
            for (String string : list) {
                if (!map.containsKey(string)) continue;
                Object obj = map.get(string);
                String string2 = this.getStringBindValue(obj);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("&");
                }
                stringBuilder.append(string).append("=").append(string2);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, "?");
                return stringBuilder.toString();
            }
        }
        return "";
    }

    private String getStringBindValue(Object object) {
        if (object != null) {
            if (object instanceof String) {
                return (String)object;
            }
            return object.toString();
        }
        return "NULL";
    }

    private void updateSelection(String string) {
        if (this._lookupModules.containsKey(string)) {
            RestModule restModule = this._lookupModules.get(string);
            this._uriPrefix.setText(restModule.getURIPrefix());
            this._uriPrefix.setEnabled(false);
            this._uriPatternCB.removeAllItems();
            if (this._modAvailTemplates.containsKey(string)) {
                List<String> list = this._modAvailTemplates.get(string);
                for (String string2 : list) {
                    this._uriPatternCB.addItem(string2);
                }
            }
            this._uriPatternCB.setSelectedItem("");
            this._uriPatternCB.requestFocusInWindow();
        } else {
            this._uriPrefix.setText("");
            this._uriPrefix.setEnabled(true);
            this._uriPatternCB.setSelectedItem("");
            this._uriPatternCB.removeAllItems();
            this._uriPrefix.requestFocusInWindow();
        }
        this.updateURIExample();
    }

    private void createPanel() {
        this.initializeComponents();
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel(RestArb.getString("URI_EXAMPLE_LABEL"));
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(this.getQueryString(this._bindMap));
        ResourceUtils.resLabel((JLabel)jLabel, this._moduleNameCB, (String)RestArb.getString("MODULE_NAME"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._uriPrefix, (String)RestArb.getString("URI_PREFIX"));
        ResourceUtils.resLabel((JLabel)jLabel3, this._uriPatternCB, (String)RestArb.getString("URI_TEMPLATE"));
        jLabel3.setDisplayedMnemonic('P');
        ResourceUtils.resLabel((JLabel)jLabel6, (Component)this._pagination, (String)RestArb.getString("PAGINATION_SIZE"));
        URI uRI = RestUtils.getBaseURI();
        String string = "";
        if (uRI != null) {
            string = uRI.toString();
            string = string.substring(0, string.length() - 1);
        } else {
            string = this._schema != null ? RestArb.format("HTTP_EXAMPLE_HOST_PORT2", this._schema) : RestArb.getString("HTTP_EXAMPLE_HOST_PORT");
        }
        ResourceUtils.resLabel((JLabel)jLabel5, (Component)this._modURIExample, (String)string);
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 6), 0, 0));
        jPanel.add(this._moduleNameCB, new GridBagConstraints(1, n, 1, 1, 1.0, 0.5, 23, 2, new Insets(0, 0, 0, 8), 0, 0));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jLabel4, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 8, 6, 6), 0, 0));
        jPanel2.add((Component)jLabel5, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 0, 6, 0), 0, 0));
        jPanel2.add((Component)this._modURIExample, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 23, 2, new Insets(6, 0, 6, 0), 0, 0));
        jPanel2.add((Component)jLabel7, new GridBagConstraints(3, n, 1, 1, 0.0, 0.0, 23, 2, new Insets(6, 0, 6, 8), 0, 0));
        LayoutControl.GBC.addHSpring((JPanel)jPanel2, (int)4);
        LayoutControl.GBC.addVSpring((JPanel)jPanel2, (int)(++n));
        n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 0, 6), 0, 0));
        jPanel3.add((Component)this._uriPrefix, new GridBagConstraints(1, n, 2, 1, 0.5, 1.0, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        jPanel3.add((Component)jLabel3, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 8, 5, 6), 0, 0));
        jPanel3.add(this._uriPatternCB, new GridBagConstraints(1, n, 2, 1, 0.5, 1.0, 23, 2, new Insets(5, 0, 4, 8), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, ++n, 3, 1, 0.0, 0.0, 21, 2, new Insets(4, 8, 0, 6), 0, 0));
        LayoutControl.GBC.addVSpring((JPanel)jPanel3, (int)(++n));
        UIUtils.makeTitledBorder((JComponent)jPanel3, (String)RestArb.getString("URI_TITLE"));
        n = 0;
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)jLabel6, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 8, 0, 6), 0, 0));
        jPanel4.add((Component)this._pagination, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 23, 0, new Insets(0, 0, 0, 6), 0, 0));
        LayoutControl.GBC.addVSpring((JPanel)jPanel4, (int)(++n));
        JScrollPane jScrollPane = new JScrollPane((Component)this._queryEditor, 22, 32);
        jScrollPane.setPreferredSize(this._queryEditor.getPreferredSize());
        jScrollPane.setSize(jScrollPane.getPreferredSize());
        n = 0;
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.add((Component)jScrollPane, new GridBagConstraints(0, ++n, 1, 4, 1.0, 1.0, 23, 1, new Insets(0, 4, 4, 4), 0, 0));
        LayoutControl.GBC.addVSpring((JPanel)jPanel5, (int)(++n));
        UIUtils.makeTitledBorder((JComponent)jPanel5, (String)RestArb.getString("SQL_TITLE_BORDER"));
        n = 0;
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.add((Component)jPanel, new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 23, 2, new Insets(0, 8, 0, 8), 0, 0));
        jPanel6.add((Component)jPanel3, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 23, 2, new Insets(4, 8, 0, 8), 0, 0));
        jPanel6.add((Component)jPanel4, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 23, 2, new Insets(4, 8, 0, 8), 0, 0));
        jPanel6.add((Component)jPanel5, new GridBagConstraints(0, ++n, 2, 6, 1.0, 1.0, 23, 1, new Insets(4, 8, 0, 8), 0, 0));
        n = 0;
        this.add((Component)jPanel6, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addListeners();
    }

    private void updateURIExample() {
        this.updateURIExample(null);
    }

    private void updateURIExample(String string) {
        Object object = this._uriPrefix.getText();
        if (object != null && !((String)object).isEmpty() && !((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        if (object == null) {
            object = "";
        }
        Object object2 = "";
        object2 = string != null ? string : (String)this._uriPatternCB.getSelectedItem();
        if (!(object2 == null || ((String)object2).isEmpty() || ((String)object).endsWith("/") || ((String)object2).startsWith("/"))) {
            object2 = "/" + (String)object2;
        }
        if (object2 == null) {
            object2 = "";
        }
        String string2 = (String)object + (String)object2;
        this._modURIExample.setText(string2);
    }

    private boolean isExcludeURIPattern(String string, String string2) {
        List<String> list = this._modExcludeTemplates.get(string);
        return list != null && list.contains(string2);
    }

    public void addListeners() {
        this._moduleNameCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = ((String)jComboBox.getSelectedItem()).trim();
                RestPublishPanel.this.updateSelection(string);
            }
        });
        this._uriPatternCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RestPublishPanel.this.updateURIExample();
            }
        });
        this._uriPrefix.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                RestPublishPanel.this.updateURIExample();
            }
        });
        this._uriPattern = (JTextField)this._uriPatternCB.getEditor().getEditorComponent();
        this._uriPattern.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                RestPublishPanel.this.updateURIExample(RestPublishPanel.this._uriPattern.getText());
            }
        });
    }

    private void removeKeyListeners(JComponent jComponent) {
        if (jComponent != null) {
            KeyListener[] keyListenerArray;
            for (KeyListener keyListener : keyListenerArray = jComponent.getKeyListeners()) {
                jComponent.removeKeyListener(keyListener);
            }
        }
    }

    public void removeListeners() {
        ActionListener[] actionListenerArray;
        if (this._moduleNameCB != null) {
            this.removeKeyListeners(this._moduleNameCB);
            for (ActionListener actionListener : actionListenerArray = this._moduleNameCB.getActionListeners()) {
                this._moduleNameCB.removeActionListener(actionListener);
            }
        }
        this.removeKeyListeners(this._uriPrefix);
        if (this._uriPatternCB != null) {
            this.removeKeyListeners(this._uriPattern);
            for (ActionListener actionListener : actionListenerArray = this._uriPatternCB.getActionListeners()) {
                this._uriPatternCB.removeActionListener(actionListener);
            }
        }
    }

    public boolean validInfo() {
        String string;
        Object object;
        if (this._errMsg == null) {
            this._errMsg = new ArrayList<String>();
        } else {
            this._errMsg.clear();
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string2 = ((String)this._moduleNameCB.getSelectedItem()).trim();
        String string3 = this._uriPrefix.getText();
        if (RestUtils.emptyValue(string2)) {
            this.setErrorMessage(RestArb.format("VALUE_REQUIRED", RestArb.getString("LABEL_MODULE_NAME")));
            bl = true;
        }
        if (RestUtils.emptyValue(string3)) {
            this.setErrorMessage(RestArb.format("VALUE_REQUIRED", RestArb.getString("LABEL_URI_PREFIX")));
            bl2 = true;
        } else {
            object = string3;
            if (!string3.equals("/")) {
                object = ((String)object).replaceAll("^/+", "").replaceAll("/+$", "");
                object = "/" + (String)object + "/";
            }
            if (this._existingUriPrefixes.containsKey(object) && !string2.equals(string = this._existingUriPrefixes.get(object))) {
                this.setErrorMessage(RestArb.format("VALUE_ALREADY_EXIST_MODULE", string3, string));
                bl2 = true;
            }
        }
        try {
            new URI(string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.setErrorMessage(RestArb.format("URI_SYNTAX_ERROR", RestArb.getString("LABEL_URI_PREFIX")));
            bl2 = true;
        }
        object = (String)this._uriPatternCB.getSelectedItem();
        if (RestUtils.emptyValue((String)object)) {
            this.setErrorMessage(RestArb.format("VALUE_REQUIRED", RestArb.getString("LABEL_URI_PATTERN")));
            bl3 = true;
        } else if (this.isExcludeURIPattern(string2, (String)object)) {
            this.setErrorMessage(RestArb.format("TEMPLATE_GET_HANDLER_EXISTS", object));
            bl3 = true;
        } else if (RestTemplatePattern.isURITemplatePattern((String)object)) {
            if (!RestTemplatePattern.isValidURITemplate((String)object)) {
                this.setErrorMessage(RestArb.format("URI_SYNTAX_ERROR", RestArb.getString("LABEL_URI_TEMPLATE")));
                bl3 = true;
            }
        } else {
            try {
                RestTemplatePattern.getRoutePattern((String)object);
            }
            catch (Exception exception) {
                this.setErrorMessage(RestArb.format("TEMPLATE_URI_SYNTAX_ERROR", object, exception.getMessage()));
                bl3 = true;
            }
        }
        string = this._queryEditor.getText();
        if (RestUtils.emptyValue(string)) {
            this.setErrorMessage(RestArb.format("VALUE_REQUIRED", RestArb.getString("LABEL_SQL")));
            bl4 = true;
        }
        if (this._errMsg.size() > 0) {
            if (bl) {
                this._moduleNameCB.requestFocusInWindow();
            } else if (bl2) {
                this._uriPrefix.requestFocusInWindow();
            } else if (bl3) {
                this._uriPatternCB.requestFocusInWindow();
            } else if (bl4) {
                this._queryEditor.requestFocusInWindow();
            }
        }
        return this._errMsg.size() == 0;
    }

    public RestModule getValues() {
        RestModule restModule = new RestModule();
        String string = ((String)this._moduleNameCB.getSelectedItem()).trim();
        restModule.setName(string);
        restModule.setURIPrefix(this._uriPrefix.getText().trim());
        restModule.setPaginationSize(25L);
        restModule.setPublished(true);
        RestTemplate restTemplate = new RestTemplate();
        String string2 = ((String)this._uriPatternCB.getSelectedItem()).trim();
        restTemplate.setURIPattern(string2);
        RestResourceHandler restResourceHandler = new RestResourceHandler();
        restResourceHandler.setMethodType(RestResourceHandler.HTTP_METHOD_TYPE.GET);
        restResourceHandler.setSourceType("json/collection");
        restResourceHandler.setSQL(this._queryEditor.getText());
        restResourceHandler.setPaginationSize((long)this._pagination.getIntValue());
        restModule.addTemplate(restTemplate);
        restTemplate.addResourceHandler(RestResourceHandler.HTTP_METHOD_TYPE.GET, restResourceHandler);
        return restModule;
    }

    public boolean isNewModule() {
        this._newModule = false;
        String string = ((String)this._moduleNameCB.getSelectedItem()).trim();
        if (!this._lookupModules.containsKey(string)) {
            this._newModule = true;
        }
        return this._newModule;
    }

    public boolean isAddPublished() {
        RestModule restModule;
        boolean bl = false;
        String string = ((String)this._moduleNameCB.getSelectedItem()).trim();
        if (this._lookupModules.containsKey(string) && !(restModule = this._lookupModules.get(string)).isPublished()) {
            bl = true;
        }
        return bl;
    }

    public boolean isNewTemplate() {
        this._newTemplate = true;
        String string = ((String)this._moduleNameCB.getSelectedItem()).trim();
        String string2 = ((String)this._uriPatternCB.getSelectedItem()).trim();
        List<String> list = this._modAvailTemplates.get(string);
        if (list != null && list.contains(string2)) {
            this._newTemplate = false;
        }
        return this._newTemplate;
    }

    public String getErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this._errMsg) {
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    private void setErrorMessage(String string) {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList<String>();
        }
        this._errMsg.add(string);
    }
}

