/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.peek;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import oracle.ide.Addin;
import oracle.ide.config.Preferences;
import oracle.ide.extension.RegisteredByExtension;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverActivator;
import oracle.ide.hover.HoverEvent;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverListener;
import oracle.ide.hover.Hoverable;
import oracle.ide.hover.HoverableRegistry;
import oracle.ide.peek.Peekable;
import oracle.ideimpl.peek.HoverOptions;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.EditorProperties;

@RegisteredByExtension(value="oracle.peek")
final class PeekAddin
implements Addin {
    private static Hover hover;
    private static HideListener hideL;
    private static ActivationListener peekL;
    private static boolean metaDown;
    private static boolean altDown;
    private static boolean shiftDown;
    private static boolean ctrlDown;

    PeekAddin() {
    }

    public void initialize() {
        Toolkit.getDefaultToolkit().addAWTEventListener(peekL, 131128L);
        PeekAddin.writeEditorProperties();
    }

    private static void writeEditorProperties() {
        HoverOptions options = HoverOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        HoverActivator multiActivator = options.getMultiSelectActivator();
        String mod = multiActivator.toKeyEventNameString();
        EditorProperties editorProperties = EditorProperties.getProperties();
        editorProperties.putProperty("caret-multi-caret-key-modifier", (Object)mod);
    }

    public static void showPeek(Point p) {
        if (hover != null) {
            return;
        }
        Window activeW = null;
        for (Window w : Window.getWindows()) {
            if (!w.isActive()) continue;
            activeW = w;
            break;
        }
        if (activeW == null || !(activeW instanceof RootPaneContainer)) {
            return;
        }
        JLayeredPane c = ((RootPaneContainer)((Object)activeW)).getLayeredPane();
        SwingUtilities.convertPointFromScreen(p, c);
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return;
        }
        Point screenP = pointerInfo.getLocation();
        HoverOptions hoverOptions = HoverOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        List<HoverFlavor> flavors = PeekAddin.getAppropriateFlavors(hoverOptions);
        if (flavors.isEmpty()) {
            return;
        }
        for (Component comp = SwingUtilities.getDeepestComponentAt(c, p.x, p.y); comp != null; comp = comp.getParent()) {
            hover = comp instanceof Hoverable ? ((Hoverable)comp).hover((Point)screenP.clone(), flavors) : HoverableRegistry.getHover(flavors, (Component)comp, (Point)screenP);
            if (flavors.contains(HoverFlavor.getFlavor((String)"source")) && !hoverOptions.isSmartEnabled() && hover == null && comp instanceof Peekable) {
                hover = ((Peekable)((Object)comp)).peek((Point)screenP.clone());
            }
            if (hover == null) {
                continue;
            }
            ToolTipManager.sharedInstance().setEnabled(false);
            hover.addHoverListener((HoverListener)hideL);
            break;
        }
    }

    private static List<HoverFlavor> getAppropriateFlavors(HoverOptions hoverOptions) {
        boolean isSmart = hoverOptions.isSmartEnabled() && hoverOptions.getSmartActivator().isSuitable(shiftDown, ctrlDown, altDown, metaDown);
        ArrayList<HoverFlavor> flavors = new ArrayList<HoverFlavor>();
        if (isSmart) {
            for (HoverFlavor flavor : hoverOptions.getFlavorPriority()) {
                if (!hoverOptions.isFlavorSmartEnabled(flavor)) continue;
                flavors.add(flavor);
            }
        } else {
            for (HoverFlavor flavor : hoverOptions.getFlavorPriority()) {
                if (!hoverOptions.getFlavorActivator(flavor).isSuitable(shiftDown, ctrlDown, altDown, metaDown)) continue;
                flavors.add(flavor);
            }
        }
        return flavors;
    }

    public static void hidePeek() {
        ToolTipManager.sharedInstance().setEnabled(true);
        PeekAddin.peekL.steadyTimer.stop();
        if (hover != null) {
            hover.removeHoverListener((HoverListener)hideL);
            hover.hideHover();
        }
        hover = null;
    }

    static {
        hideL = new HideListener();
        peekL = new ActivationListener();
        metaDown = false;
        altDown = false;
        shiftDown = false;
        ctrlDown = false;
    }

    private static class ActivationListener
    implements AWTEventListener,
    ActionListener {
        private static final int STEADY_DURATION = 550;
        private static final int DONT_SHOW_DURATION = 1250;
        private Timer steadyTimer = new Timer(550, this);
        private long dontShowAfter = -1L;

        private ActivationListener() {
            this.steadyTimer.setRepeats(false);
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event instanceof KeyEvent) {
                KeyEvent ke = (KeyEvent)event;
                ctrlDown = ke.isControlDown();
                altDown = ke.isAltDown();
                metaDown = ke.isMetaDown();
                shiftDown = ke.isShiftDown();
                if (ke.getKeyCode() == 27) {
                    PeekAddin.hidePeek();
                }
                if (ke.getKeyCode() == 17 || ke.getKeyCode() == 16 || ke.getKeyCode() == 157 || ke.getKeyCode() == 18) {
                    if (System.currentTimeMillis() <= this.dontShowAfter) {
                        this.dontShowAfter = System.currentTimeMillis() + 1250L;
                        this.steadyTimer.restart();
                    }
                } else if (hover != null && hover.shouldHideHover(ke)) {
                    PeekAddin.hidePeek();
                }
                if (MouseInfo.getPointerInfo() == null) {
                    return;
                }
            }
            if (event instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)event;
                ctrlDown = me.isControlDown();
                altDown = me.isAltDown();
                metaDown = me.isMetaDown();
                shiftDown = me.isShiftDown();
                switch (me.getID()) {
                    case 500: 
                    case 501: 
                    case 502: 
                    case 507: {
                        Component c;
                        if (hover == null || !(event.getSource() instanceof Component)) {
                            PeekAddin.hidePeek();
                            break;
                        }
                        Point p = me.getLocationOnScreen();
                        if (me.getID() == 507 && p.x == 0 && p.y == 0 && (c = (Component)me.getSource()).isShowing()) {
                            p = me.getPoint();
                            SwingUtilities.convertPointToScreen(p, c);
                        }
                        if (hover.isPointWithinHover(p)) break;
                        PeekAddin.hidePeek();
                        break;
                    }
                    case 503: {
                        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                        if (pointerInfo == null) {
                            return;
                        }
                        this.dontShowAfter = System.currentTimeMillis() + 1250L;
                        if (hover != null) break;
                        if (ctrlDown || altDown || metaDown || shiftDown) {
                            this.activate();
                            break;
                        }
                        this.steadyTimer.restart();
                    }
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.activate();
        }

        private void activate() {
            this.steadyTimer.stop();
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            if (pointerInfo == null) {
                return;
            }
            try {
                PeekAddin.showPeek(pointerInfo.getLocation());
            }
            catch (ExpiredTextBufferException ex) {
                return;
            }
        }
    }

    private static class HideListener
    implements HoverListener {
        private HideListener() {
        }

        public void hoverChange(HoverEvent event) {
            if (event.isHidden()) {
                PeekAddin.hidePeek();
            }
        }
    }
}

