/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.converters;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

public final class RegionalSettings {
    static final Map<Locale, RegionalSettings> REG_MAP = new HashMap<Locale, RegionalSettings>();
    private final ResourceBundle dateBundle;
    private final Locale locale;
    private boolean pointDateSeparator;
    private final Map<SimpleDateFormat, Boolean> dateFormats = new LinkedHashMap<SimpleDateFormat, Boolean>();
    private final List<String> dateFormatPatterns = new ArrayList<String>();

    RegionalSettings() {
        this(Locale.getDefault());
    }

    RegionalSettings(Locale _locale) {
        String[] dfsp;
        this.dateBundle = ResourceBundle.getBundle("net.ucanaccess.util.format.dateFormat", _locale);
        this.locale = _locale;
        String[] stringArray = dfsp = new String[]{this.getGeneralPattern(), this.getLongDatePattern(), this.getMediumDatePattern(), this.getShortDatePattern()};
        int n = dfsp.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if (pattern.indexOf(46) > 0 && !pattern.contains("h.") && !pattern.contains("H.")) {
                this.pointDateSeparator = true;
                break;
            }
            ++n2;
        }
        this.addDateP("yyyy-MM-dd h:m:s a", false, false);
        this.addDateP("yyyy-MM-dd H:m:s", false, false);
        this.addDateP("yyyy-MM-dd", false, false);
        this.addDateP("yyyy/MM/dd h:m:s a", false, false);
        this.addDateP("yyyy/MM/dd H:m:s", false, false);
        this.addDateP("yyyy/MM/dd", false, false);
        this.addDateP(this.getGeneralPattern(), true, false);
        this.addDateP(this.getLongDatePattern(), true, false);
        this.addDateP(this.getMediumDatePattern(), true, false);
        this.addDateP(this.getShortDatePattern(), true, false);
        if (!this.locale.equals(Locale.US)) {
            RegionalSettings regUs = new RegionalSettings(Locale.US);
            this.addDateP(regUs.getGeneralPattern(), false, false);
            this.addDateP(regUs.getLongDatePattern(), true, false);
            this.addDateP(regUs.getMediumDatePattern(), true, false);
            this.addDateP(regUs.getShortDatePattern(), true, false);
        }
        this.addDateP("MMM dd,yyyy", false, false);
        this.addDateP("MM dd,yyyy", false, false);
        this.addDateP("MMM dd hh:mm:ss", false, true);
        this.addDateP("MM dd hh:mm:ss", false, true);
        this.addDateP("MMM yy hh:mm:ss", false, false);
        this.addDateP("MM yy hh:mm:ss", false, false);
        this.addDateP("dd/MM/yyyy h:m:s a", true, false);
        this.addDateP("dd/MM/yyyy H:m:s", true, false);
        this.addDateP("dd/MM/yyyy", true, false);
        this.addDateP("ddd MMM dd yyyy", false, false);
        for (SimpleDateFormat sdf : this.dateFormats.keySet()) {
            this.dateFormatPatterns.add(sdf.toPattern());
        }
    }

    public String getAM() {
        return this.dateBundle.getString("AM");
    }

    public String getPM() {
        return this.dateBundle.getString("PM");
    }

    public String getRS() {
        return this.dateBundle.getString("RS");
    }

    public String getLongDatePattern() {
        return this.dateBundle.getString("longDate");
    }

    public String getMediumDatePattern() {
        return this.dateBundle.getString("mediumDate");
    }

    public String getShortDatePattern() {
        return this.dateBundle.getString("shortDate");
    }

    public String getLongTimePattern() {
        return this.dateBundle.getString("longTime");
    }

    public String getMediumTimePattern() {
        return this.dateBundle.getString("mediumTime");
    }

    public String getShortTimePattern() {
        return this.dateBundle.getString("shortTime");
    }

    public String getGeneralPattern() {
        return this.dateBundle.getString("generalDate");
    }

    public boolean isPointDateSeparator() {
        return this.pointDateSeparator;
    }

    public Map<SimpleDateFormat, Boolean> getDateFormats() {
        return Collections.unmodifiableMap(this.dateFormats);
    }

    void addDateP(String _pattern, boolean _heuristic, boolean _yearOverride) {
        if (_heuristic && !_pattern.contains("a") && _pattern.indexOf(72) > 0) {
            String chg = _pattern.replaceAll("H", "h") + " a";
            this.addDateP(chg, false, false);
            this.addTogglePattern(chg);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(_pattern, this.locale);
        ((GregorianCalendar)sdf.getCalendar()).setGregorianChange(new Date(Long.MIN_VALUE));
        sdf.setLenient(false);
        if ("true".equalsIgnoreCase(this.getRS())) {
            DateFormatSymbols df = new DateFormatSymbols();
            df.setAmPmStrings(new String[]{"AM", "PM"});
            sdf.setDateFormatSymbols(df);
        }
        this.dateFormats.put(sdf, _yearOverride);
        if (_heuristic) {
            this.addTogglePattern(_pattern);
            if (_pattern.endsWith(" a") && _pattern.indexOf(104) > 0) {
                String chg = _pattern.substring(0, _pattern.length() - 2).trim().replaceAll("h", "H");
                this.addDateP(chg, false, false);
                this.addTogglePattern(chg);
            }
        }
    }

    void addTogglePattern(String _p) {
        if (_p.indexOf(47) > 0) {
            this.addDateP(_p.replaceAll("/", "-"), false, false);
            if (this.isPointDateSeparator()) {
                this.addDateP(_p.replaceAll("/", "."), false, false);
            }
        } else if (_p.indexOf(45) > 0) {
            this.addDateP(_p.replaceAll(Pattern.quote("-"), "/"), false, false);
            if (this.isPointDateSeparator()) {
                this.addDateP(_p.replaceAll(Pattern.quote("-"), "."), false, false);
            }
        } else if (_p.indexOf(46) > 0 && !_p.contains("h.") && !_p.contains("H.")) {
            this.addDateP(_p.replaceAll(Pattern.quote("."), "/"), false, false);
        }
    }

    public static RegionalSettings getRegionalSettings() {
        return RegionalSettings.getRegionalSettings(Locale.getDefault());
    }

    public static RegionalSettings getRegionalSettings(Locale _locale) {
        RegionalSettings rs;
        if (_locale == null) {
            _locale = Locale.getDefault();
        }
        if ((rs = REG_MAP.get(_locale)) == null) {
            rs = new RegionalSettings(_locale);
            REG_MAP.put(_locale, rs);
        }
        return rs;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[locale=" + String.valueOf(this.locale) + ", dateBundle=" + String.valueOf(this.dateBundle) + ", dateFormats=" + String.valueOf(this.dateFormatPatterns) + "]";
    }
}

