/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.complex;

import com.healthmarketscience.jackcess.complex.ComplexDataType;
import com.healthmarketscience.jackcess.complex.ComplexValue;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.impl.complex.ComplexColumnInfoImpl;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.ucanaccess.complex.Attachment;
import net.ucanaccess.complex.SingleValue;
import net.ucanaccess.complex.UnsupportedValue;
import net.ucanaccess.complex.Version;
import net.ucanaccess.jdbc.UcanaccessSQLException;

public abstract class ComplexBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ComplexValue.Id CREATE_ID = ComplexColumnInfoImpl.INVALID_ID;
    private int id;
    private String tableName;
    private String columnName;

    protected ComplexBase(ComplexValue.Id _id, String _tableName, String _columnName) {
        this.id = _id.get();
        this.tableName = _tableName;
        this.columnName = _columnName;
    }

    protected ComplexBase(ComplexValue cv) {
        this(cv.getId(), cv.getComplexValueForeignKey().getColumn().getTable().getName(), cv.getComplexValueForeignKey().getColumn().getName());
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String _tableName) {
        this.tableName = _tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String _columnName) {
        this.columnName = _columnName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ComplexBase other = (ComplexBase)obj;
        if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        return Objects.equals(this.tableName, other.tableName);
    }

    public static Object[] convert(ComplexValueForeignKey fk) throws IOException, UcanaccessSQLException {
        if (fk.getComplexType().equals((Object)ComplexDataType.ATTACHMENT)) {
            List lst = fk.getAttachments();
            Object[] lat = new Attachment[lst.size()];
            int i = 0;
            while (i < lat.length) {
                lat[i] = new Attachment((com.healthmarketscience.jackcess.complex.Attachment)lst.get(i));
                ++i;
            }
            return lat;
        }
        if (fk.getComplexType().equals((Object)ComplexDataType.MULTI_VALUE)) {
            List lst = fk.getMultiValues();
            Object[] lat = new SingleValue[lst.size()];
            int i = 0;
            while (i < lat.length) {
                lat[i] = new SingleValue((com.healthmarketscience.jackcess.complex.SingleValue)lst.get(i));
                ++i;
            }
            return lat;
        }
        if (fk.getComplexType().equals((Object)ComplexDataType.VERSION_HISTORY)) {
            List lst = fk.getVersions();
            Object[] lat = new Version[lst.size()];
            int i = 0;
            while (i < lat.length) {
                lat[i] = new Version((com.healthmarketscience.jackcess.complex.Version)lst.get(i));
                ++i;
            }
            return lat;
        }
        if (fk.getComplexType().equals((Object)ComplexDataType.UNSUPPORTED)) {
            List lst = fk.getUnsupportedValues();
            Object[] lat = new UnsupportedValue[lst.size()];
            int i = 0;
            while (i < lat.length) {
                lat[i] = new UnsupportedValue((com.healthmarketscience.jackcess.complex.UnsupportedValue)lst.get(i));
                ++i;
            }
            return lat;
        }
        throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.COMPLEX_TYPE_UNSUPPORTED);
    }

    public String toString() {
        return String.format("%s[id=%s, table=%s, column=%s]", this.getClass().getSimpleName(), this.id, this.tableName, this.columnName);
    }

    static LocalDateTime handleJackcessLocalDateTimeResolution(LocalDateTime _ldt) {
        if (_ldt == null) {
            return _ldt;
        }
        long millis = TimeUnit.NANOSECONDS.toMillis(_ldt.getNano());
        return _ldt.withNano((int)TimeUnit.MILLISECONDS.toNanos(millis));
    }
}

