/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.BlobKey;
import net.ucanaccess.jdbc.UcanaccessConnection;

public class BlobAction
implements IFeedbackAction {
    private final Table table;
    private boolean containsBlob;
    private final Set<BlobKey> keys = new HashSet<BlobKey>();

    public BlobAction(Table _table, Object[] newValues) {
        this.table = _table;
        if (!BlobKey.hasPrimaryKey(_table)) {
            return;
        }
        Index pk = _table.getPrimaryKeyIndex();
        HashSet<String> hsKey = new HashSet<String>();
        for (Index.Column icl : pk.getColumns()) {
            hsKey.add(icl.getName());
        }
        HashSet<String> hsBlob = new HashSet<String>();
        int i = 0;
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        for (Column col : _table.getColumns()) {
            if (col.getType().equals((Object)DataType.OLE) && newValues[i] != null) {
                this.containsBlob = true;
                hsBlob.add(col.getName());
            }
            if (hsKey.contains(col.getName())) {
                keyMap.put(col.getName(), newValues[i]);
            }
            ++i;
        }
        for (String cln : hsBlob) {
            this.keys.add(new BlobKey(keyMap, this.table.getName(), cln));
        }
    }

    @Override
    public void doAction(ICommand toChange) throws SQLException {
        if (this.containsBlob) {
            UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
            Connection connHsqldb = conn.getHSQLDBConnection();
            for (BlobKey bkey : this.keys) {
                String sql = "UPDATE " + SQLConverter.escapeIdentifier(this.table.getName(), connHsqldb) + " SET " + SQLConverter.escapeIdentifier(bkey.getColumnName(), connHsqldb) + "=? WHERE ";
                StringBuilder sb = new StringBuilder();
                String and = "";
                ArrayList<Object> values = new ArrayList<Object>();
                for (Map.Entry<String, Object> me : bkey.getKey().entrySet()) {
                    sb.append(and).append(SQLConverter.escapeIdentifier(me.getKey(), connHsqldb)).append(" = ?");
                    values.add(me.getValue());
                    and = " AND ";
                }
                sql = sql + sb.toString();
                conn.setFeedbackState(true);
                conn.setFeedbackState(true);
                Throwable throwable = null;
                Iterator<Map.Entry<String, Object>> iterator = null;
                try (PreparedStatement ps = connHsqldb.prepareStatement(sql);){
                    ps.setObject(1, bkey.getBytes());
                    int j = 2;
                    for (Object e : values) {
                        ps.setObject(j, e);
                        ++j;
                    }
                    ps.executeUpdate();
                    conn.setFeedbackState(false);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }
}

