/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.jaxrs;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import oracle.cloudstorage.api.jaxrs.IClientProvider;
import oracle.cloudstorage.api.jaxrs.IJaxrsImplementation;
import oracle.cloudstorage.api.jaxrs.JaxrsResponseAdapter;
import oracle.cloudstorage.api.jaxrs.SendableInvocationAdapter;
import oracle.cloudstorage.api.request.processor.IResponse;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.api.request.processor.ISender;
import oracle.cloudstorage.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class JaxrsSender
implements ISender,
IClientProvider {
    private final IClientProvider clientProvider;
    private final IJaxrsImplementation jaxrs;

    public JaxrsSender(IClientProvider clientProvider) {
        this(clientProvider, null);
    }

    public JaxrsSender(IClientProvider clientProvider, IJaxrsImplementation jaxrs) {
        this.clientProvider = clientProvider;
        this.jaxrs = jaxrs;
    }

    @Override
    public IResponse send(Logger logger, Marker marker, ISendable sendable) {
        logger.debug(marker, " JAX-RS Request {}", sendable.getRequestLogEvent());
        SendableInvocationAdapter adapter = new SendableInvocationAdapter(this.jaxrs, logger, marker, this, sendable);
        Invocation invocation = adapter.adapt();
        Response jaxrsResponse = invocation.invoke();
        Future<String> futureMd5 = sendable.getContent() == null ? null : sendable.getContent().getFutureMd5();
        JaxrsResponseAdapter response = new JaxrsResponseAdapter(jaxrsResponse, futureMd5);
        logger.debug(marker, "JAX-RS Response {}", sendable.getResponseLogEvent(response));
        return response;
    }

    @Override
    public Client getClient() {
        Client client = this.clientProvider.getClient();
        return client;
    }
}

