/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.identity.IdentityClient;
import com.oracle.bmc.identity.model.RegionSubscription;
import com.oracle.bmc.identity.requests.ListCompartmentsRequest;
import com.oracle.bmc.identity.requests.ListRegionSubscriptionsRequest;
import com.oracle.bmc.identity.responses.ListCompartmentsResponse;
import com.oracle.bmc.identity.responses.ListRegionSubscriptionsResponse;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import oracle.dbtools.core.oci.OCIClient;
import oracle.dbtools.core.oci.OCIProfile;

public final class OCIIdentityClient
extends OCIClient {
    private final IdentityClient client;

    public static Builder builder(OCIProfile profile) {
        return new Builder(profile);
    }

    private OCIIdentityClient(Builder builder) {
        super(builder);
        IdentityClient.Builder idBuilder = IdentityClient.builder();
        this.configureClient(idBuilder);
        this.client = idBuilder.build((AbstractAuthenticationDetailsProvider)this.getProfile().getAuthenticationProvider());
    }

    public List<RegionIdentifier> listRegions() throws IOException {
        ListRegionSubscriptionsRequest request = ListRegionSubscriptionsRequest.builder().tenancyId(this.getProfile().getProfileValue("tenancy")).build();
        ListRegionSubscriptionsResponse response = OCIIdentityClient.executeRequest(() -> this.client.listRegionSubscriptions(request));
        return response.getItems().stream().collect(Collectors.mapping(x$0 -> new RegionIdentifier((RegionSubscription)x$0), Collectors.toList()));
    }

    public List<String> listCompartments() throws IOException {
        ListCompartmentsRequest request = ListCompartmentsRequest.builder().compartmentId(this.getProfile().getProfileValue("tenancy")).build();
        ListCompartmentsResponse response = OCIIdentityClient.executeRequest(() -> this.client.listCompartments(request));
        return response.getItems().stream().map(p -> p.getName()).collect(Collectors.toList());
    }

    public static final class Builder
    extends OCIClient.Builder<Builder, OCIIdentityClient> {
        private Builder(OCIProfile profile) {
            super(profile);
        }

        @Override
        public OCIIdentityClient build() {
            return new OCIIdentityClient(this);
        }
    }

    public static final class RegionIdentifier {
        private final RegionSubscription regionSubscription;

        private RegionIdentifier(RegionSubscription subscription) {
            this.regionSubscription = subscription;
        }

        public String getRegionName() {
            return this.regionSubscription.getRegionName();
        }

        public boolean isHomeRegion() {
            return this.regionSubscription.getIsHomeRegion();
        }
    }
}

