/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.net.URL;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectListener;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;

public class DataBaseNodeUtil {
    public static void editNodeWizard(DatabaseNode databaseNode) {
        Context context = Context.newIdeContext((Element)databaseNode);
        final DBObject dBObject = new DBObject(databaseNode);
        SchemaObject schemaObject = dBObject.getSchemaObject();
        context.setProperty("ParentObject", (Object)schemaObject);
        Database database = dBObject.getDatabase();
        String string = dBObject.getObjectType();
        DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory((DBObjectProvider)database, (String)string);
        if (dBEditorFactory != null) {
            URL uRL = dBObject.getNode().getURL();
            if (schemaObject != null) {
                DBObjectListener dBObjectListener = new DBObjectListener(){

                    public void objectUpdated(DBObjectChange dBObjectChange) {
                        DatabaseNode databaseNode = (DatabaseNode)dBObject.getNode();
                        UpdateMessage.fireStructureChanged((Subject)databaseNode);
                    }
                };
                schemaObject.addObjectListener(dBObjectListener);
                dBEditorFactory.editDBObject(schemaObject, (DBObjectProvider)database);
                schemaObject.removeObjectListener(dBObjectListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openEditor(DatabaseNode databaseNode) {
        Context context = Context.newIdeContext((Element)databaseNode);
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
        openEditorOptions.setFlags(1);
        WaitCursor waitCursor = Ide.getWaitCursor();
        try {
            waitCursor.show();
            EditorManager.getEditorManager().openEditor(openEditorOptions);
        }
        finally {
            waitCursor.hide();
        }
    }
}

