/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import javax.swing.JFormattedTextField;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.javatools.util.ModelUtil;

public class TextBoxActionControl
extends ActionControl {
    private JFormattedTextField _field;
    private String _defaultValue;

    public static Format getIntegerFormat() {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        return numberFormat;
    }

    public static Format getDateFormat() {
        DateFormat dateFormat = DateFormat.getDateInstance();
        return dateFormat;
    }

    public TextBoxActionControl(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public TextBoxActionControl(String string, String string2, String string3, Format format) {
        super(string, string2);
        this._defaultValue = string3;
        this._field = format != null ? new JFormattedTextField(format) : new JFormattedTextField();
        this._field.setName(string);
        this.reset();
        this._field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                TextBoxActionControl.this.firePropertyChangeListeners();
            }
        });
    }

    public TextBoxActionControl(final String string, String string2, String string3, Format format, boolean bl) {
        super(string, string2);
        this._defaultValue = string3;
        this._field = format != null ? new JFormattedTextField(format) : new JFormattedTextField();
        this._field.setName(string);
        this.reset();
        if (bl) {
            this._field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    TextBoxActionControl.this.firePropertyChangeListeners(string);
                }
            });
        } else {
            this._field.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    TextBoxActionControl.this.firePropertyChangeListeners();
                }
            });
        }
    }

    @Override
    public ActionControl.Value getValue() {
        ActionControl.Value value = new ActionControl.Value();
        value.set(this._field.getText());
        return value;
    }

    @Override
    public Component getUI() {
        return this._field;
    }

    public void set(String string) {
        String string2 = this._field.getText();
        if (ModelUtil.areDifferent((Object)string2, (Object)string)) {
            this._field.setText(string);
        }
    }

    @Override
    public void reset() {
        this.set(this._defaultValue);
    }

    @Override
    public void setEditable(boolean bl) {
        this._field.setEditable(bl);
    }

    @Override
    public void enableUI(boolean bl) {
        super.enableUI(bl);
        this._field.setEnabled(bl);
    }
}

