/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.runner.GridData;
import oracle.dbtools.raptor.utils.DataTypesUtil;

class Type {
    private String _typeName;
    private String _declName;
    private boolean _outputSupported;
    private static final Set CHARACTER_TYPES = new HashSet<String>(Arrays.asList("CHAR", "NCHAR", "VARCHAR2", "NVARCHAR2"));
    String refRecordType = null;
    LinkedList<String> typeAttributes = null;

    Type(String string) {
        this(string, true);
    }

    Type(String string, boolean bl) {
        this(string, string, bl);
    }

    Type(String string, String string2, boolean bl) {
        this._typeName = string;
        this._declName = string2;
        this._outputSupported = bl;
    }

    String getTypeName() {
        return this._typeName;
    }

    void setTypeName(String string) {
        this._typeName = string;
    }

    String getDeclaredName() {
        return this._declName;
    }

    boolean isOutputSupported() {
        return this._outputSupported;
    }

    boolean isCharType() {
        return this._outputSupported && CHARACTER_TYPES.contains(this._typeName);
    }

    Integer getSqlType() {
        if ("REF CURSOR".equals(this._declName)) {
            return -10;
        }
        if ("NUMBER".equals(this._declName)) {
            return 2;
        }
        if ("DATE".equals(this._declName)) {
            return 91;
        }
        if ("TIMESTAMP".equals(this._declName)) {
            return 93;
        }
        if (this._declName.contains("CHAR")) {
            return 12;
        }
        if ("CLOB".equals(this._declName)) {
            return 2005;
        }
        return null;
    }

    GridData extractValue(CallableStatement callableStatement, int n) throws SQLException {
        GridData gridData = new GridData();
        if ("REF CURSOR".equals(this._declName)) {
            int n2;
            ResultSet resultSet = (ResultSet)callableStatement.getObject(n);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            gridData.header = new String[resultSetMetaData.getColumnCount()];
            for (n2 = 0; n2 < gridData.header.length; ++n2) {
                gridData.header[n2] = resultSetMetaData.getColumnName(n2 + 1);
            }
            gridData.data = new ArrayList<Object[]>();
            n2 = 0;
            while (resultSet.next()) {
                Object[] objectArray = new Object[gridData.header.length];
                gridData.data.add(objectArray);
                for (int i = 0; i < gridData.header.length; ++i) {
                    objectArray[i] = DataTypesUtil.stringValue((Object)resultSet.getObject(i + 1), (Connection)callableStatement.getConnection());
                }
                ++n2;
            }
        } else {
            gridData.header = new String[1];
            gridData.header[0] = "";
            gridData.data = new ArrayList<Object[]>();
            Object[] objectArray = new Object[1];
            gridData.data.add(objectArray);
            if ("CLOB".equals(this._declName)) {
                Clob clob = callableStatement.getClob(n);
                long l = clob.length();
                if (100L < l) {
                    l = 100L;
                }
                Object object = clob.getSubString(1L, (int)l);
                if (l == 100L) {
                    object = (String)object + "...";
                }
                objectArray[0] = object;
            } else {
                objectArray[0] = callableStatement.getObject(n);
            }
        }
        return gridData;
    }

    public String getTupleType(Connection connection) {
        if (this.refRecordType != null) {
            return this.refRecordType;
        }
        int n = this._typeName.indexOf(46);
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(this._typeName.substring(0, n));
        linkedList.add(this._typeName.substring(n + 1));
        this.refRecordType = DBUtil.getInstance((Connection)connection).executeReturnOneCol("SELECT oo.object_name \nFROM public_dependency d, all_objects io, all_objects oo  \nwhere d.object_id = io.object_id \nand io.owner = ? and io.object_name = ?  \nand io.object_type = 'TYPE'  \nand oo.object_type = 'TYPE' \nand d.referenced_object_id = oo.object_id \n", linkedList);
        return this.refRecordType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<String> getAttributes(Connection connection) {
        if (this.typeAttributes != null) {
            return this.typeAttributes;
        }
        this.refRecordType = this.getTupleType(connection);
        this.typeAttributes = new LinkedList();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("select attr_name from all_type_attrs \nwhere owner = ? and type_name = ? \norder by attr_no \n");
            int n = this._typeName.indexOf(46);
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(this._typeName.substring(0, n));
            linkedList.add(this._typeName.substring(n + 1));
            preparedStatement.setString(1, this._typeName.substring(0, n));
            preparedStatement.setString(2, this.refRecordType);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                this.typeAttributes.add(resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
        return this.typeAttributes;
    }
}

