/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.Replacements;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.IdentifiersDb;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.Member;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.refactor.Messages;
import oracle.dbtools.raptor.refactor.UndoableRefactoring;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class Inliner
extends UndoableRefactoring {
    static final String path = "/oracle/dbtools/raptor/refactor/";
    static IProgram program = null;
    private boolean debug = false;

    public Inliner(Context context) {
        super(context);
    }

    public Inliner(String string, List<LexerToken> list, ParseNode parseNode) {
        super(string, list, parseNode);
    }

    @Override
    protected Replacements runProgram(int n, int n2, Object object) {
        return this.runProgram(n, this.text, this.src, this.p, object == null);
    }

    Replacements runProgram(int n, String string, List<LexerToken> list, BasicEditorPane basicEditorPane, boolean bl) {
        long l = System.currentTimeMillis();
        try {
            int n2;
            int n3;
            Object object;
            Object object22;
            Object object3;
            Tuple tuple32;
            Parsed parsed = new Parsed(string, list, (Earley)SqlEarley.getInstance(), "sql_statement");
            if (this.debug) {
                parsed.getRoot().printTree();
            }
            if (program == null) {
                program = new IProgram();
                Program.debug = this.debug;
            }
            Inliner.program.offset = LexerToken.scanner2parserOffset(list, (int)n);
            LexerToken lexerToken = list.get(Inliner.program.offset);
            if (basicEditorPane != null) {
                int n4;
                int n5 = basicEditorPane.getLineFromOffset(n);
                if (n5 < (n4 = basicEditorPane.getLineFromOffset(lexerToken.begin))) {
                    --Inliner.program.offset;
                }
                lexerToken = list.get(Inliner.program.offset);
                n4 = basicEditorPane.getLineFromOffset(lexerToken.begin);
                if (n5 < n4) {
                    --Inliner.program.offset;
                }
            }
            String string2 = lexerToken.content;
            Map map = null;
            try {
                map = program.eval(parsed);
            }
            catch (AssertionError assertionError) {
                if (((Throwable)((Object)assertionError)).getMessage().contains("syntactically invalid")) {
                    String string3 = Messages.getString("SyntaxErrorMsg");
                    SyntaxError syntaxError = parsed.getSyntaxError();
                    if (syntaxError != null) {
                        string3 = syntaxError.getDetailedMessage();
                    }
                    MessageDialog.information(null, (Object)string3, (String)Messages.getString("ErrorTitle"), null);
                }
                System.out.println("Refactoring aborted due to " + ((Throwable)((Object)assertionError)).getMessage());
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ParseNode parseNode = null;
            ParseNode parseNode2 = null;
            boolean bl2 = false;
            MaterializedPredicate materializedPredicate = (MaterializedPredicate)map.get("\"prm val\"");
            MaterializedPredicate materializedPredicate2 = (MaterializedPredicate)map.get("\"prm decl\"");
            MaterializedPredicate materializedPredicate3 = (MaterializedPredicate)map.get("\"all calls\"");
            if (materializedPredicate3.cardinality() == 0) {
                MaterializedPredicate materializedPredicate4 = (MaterializedPredicate)map.get("\"proc@offset\"");
                Iterator iterator = materializedPredicate4.getTuples().iterator();
                if (iterator.hasNext()) {
                    Tuple tuple2 = (Tuple)iterator.next();
                    ParseNode parseNode3 = materializedPredicate4.getAttribute(tuple2, "id");
                    string2 = parseNode3.content(list);
                }
                iterator = Messages.getString("NoCalls") + " " + string2;
                MessageDialog.information(null, (Object)iterator, (String)Messages.getString("ErrorTitle"), null);
                return null;
            }
            int n6 = materializedPredicate2.cardinality();
            TreeMap treeMap = new TreeMap();
            MaterializedPredicate materializedPredicate5 = (MaterializedPredicate)map.get("\"all calls+fml\"");
            for (Tuple tuple32 : materializedPredicate3.getTuples()) {
                ParseNode parseNode4 = materializedPredicate3.getAttribute(tuple32, "call");
                string2 = parseNode4.content(list);
                parseNode = materializedPredicate3.getAttribute(tuple32, "body");
                bl2 = materializedPredicate3.getAttribute(tuple32, "f").contains(SqlEarley.getInstance().getSymbol("'FUNCTION'"));
                if (bl2) {
                    MessageDialog.information(null, (Object)Messages.getString("CantInlineFunction"), (String)Messages.getString("ErrorTitle"), null);
                    return null;
                }
                if (parseNode.from <= parseNode4.from && parseNode4.to <= parseNode.to) {
                    MessageDialog.information(null, (Object)Messages.getString("RecursiveInvocationMsg"), (String)Messages.getString("ErrorTitle"), null);
                    return null;
                }
                if (parseNode4.from <= Inliner.program.offset && Inliner.program.offset <= parseNode4.to) {
                    parseNode2 = parseNode4;
                }
                TreeMap<ParseNode, Object> treeMap2 = new TreeMap<ParseNode, Object>();
                ParseNode parseNode5 = null;
                for (Object object4 : materializedPredicate5.getTuples()) {
                    object3 = materializedPredicate5.getAttribute((Tuple)object4, "call");
                    if (parseNode4.from != ((ParseNode)object3).from || parseNode4.to != ((ParseNode)object3).to) continue;
                    parseNode5 = materializedPredicate5.getAttribute((Tuple)object4, "paren_expr_list");
                    break;
                }
                if (parseNode5 != null) {
                    Object object4;
                    int n7 = 0;
                    object4 = materializedPredicate.getTuples().iterator();
                    while (object4.hasNext()) {
                        object3 = (Tuple)object4.next();
                        int n8 = 0;
                        ParseNode object5 = materializedPredicate.getAttribute((Tuple)object3, "arg");
                        if (object5.from < parseNode5.from || parseNode5.to < object5.to) continue;
                        for (Object object22 : materializedPredicate2.getTuples()) {
                            if (n8 == n7) {
                                object = materializedPredicate2.getAttribute((Tuple)object22, "prm_spec");
                                treeMap2.put(object5, object);
                            }
                            ++n8;
                        }
                        ++n7;
                    }
                }
                treeMap.put(parseNode4, treeMap2);
            }
            System.out.println("Inline time = " + (System.currentTimeMillis() - l));
            int n9 = treeMap.size();
            if (bl && !MessageDialog.confirm(null, (Object)MessageFormat.format(Messages.getString("Replace"), n9, list.get((int)(parseNode.from + 1)).content), (String)Messages.getString("InlineProcedure"), null)) {
                return null;
            }
            tuple32 = new Replacements(string);
            int n10 = list.get((int)parseNode.from).begin;
            int n11 = string.substring(0, n10).lastIndexOf(10) + 1;
            if (n11 < 0) {
                n11 = 0;
            }
            if ((n3 = (n2 = list.get((int)(parseNode.to - 1)).end) + string.substring(n2).indexOf(10) + 1) < 0) {
                n3 = n2;
            }
            if (this.notPublic(string2)) {
                tuple32.put(n11, n3, "");
            } else if (this.notUsedOutsideBody(string2)) {
                boolean bl3 = false;
                object3 = this.getPkgNode();
                if (object3 != null) {
                    for (Member member : ((PlSqlNode)object3).parseMembers()) {
                        if (!member.name.equals(string2)) continue;
                        TextBuffer textBuffer = object3.tryAcquireTextBuffer();
                        try {
                            textBuffer.beginEdit();
                            object22 = ((PlSqlNode)object3).getParser().src;
                            textBuffer.remove(((LexerToken)object22.get((int)member.from)).begin, ((LexerToken)object22.get((int)member.to)).begin - ((LexerToken)object22.get((int)member.from)).begin);
                            textBuffer.endEdit();
                            bl3 = true;
                        }
                        catch (Exception exception) {
                            System.err.println("Failed to delete member from package declaration");
                        }
                        break;
                    }
                }
                if (bl3) {
                    tuple32.put(n11, n3, "");
                }
            }
            int n12 = n10 - n11;
            object3 = new StringBuffer();
            for (int i = 0; i < n12; ++i) {
                ((StringBuffer)object3).append(' ');
            }
            String string4 = "";
            for (TextBuffer textBuffer : parseNode.children()) {
                if (!textBuffer.contains(IdentifiersDb.instance.seq_of_stmts)) continue;
                string4 = string.substring(list.get((int)textBuffer.from).begin, list.get((int)textBuffer.to).begin);
            }
            for (TextBuffer textBuffer : treeMap.keySet()) {
                int n4;
                object22 = (Map)treeMap.get(textBuffer);
                object = string4;
                for (ParseNode parseNode3 : object22.keySet()) {
                    ParseNode parseNode4 = (ParseNode)object22.get(parseNode3);
                    String string3 = list.get((int)parseNode4.from).content;
                    String string5 = list.get((int)parseNode3.from).content;
                    object = ((String)object).replace(string3, string5);
                }
                ParseNode parseNode5 = textBuffer.parent();
                if (!parseNode5.contains(SqlEarley.getInstance().getSymbol("stmt"))) {
                    parseNode5 = parseNode5.parent();
                }
                if ((n4 = string.substring(0, n10 = list.get((int)parseNode5.from).begin).lastIndexOf(10) + 1) < 0) {
                    n4 = 0;
                }
                tuple32.put(n4, list.get((int)(parseNode5.to - 1)).end, Inliner.indentLines(n10 - n4 - n12, (String)object));
            }
            return tuple32;
        }
        catch (Exception exception) {
            System.err.println("Exception caught during inline: ");
            exception.printStackTrace();
            return null;
        }
    }

    private boolean notPublic(String string) {
        if (this.plsNode == null) {
            return true;
        }
        PlSqlNode plSqlNode = this.getPkgNode();
        if (plSqlNode == null) {
            return true;
        }
        for (Member member : plSqlNode.parseMembers()) {
            if (!member.name.equals(string)) continue;
            return false;
        }
        return true;
    }

    private boolean notUsedOutsideBody(String string) {
        if (this.plsNode == null) {
            return true;
        }
        String string2 = this.plsNode.getConnectionName();
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(string2, true);
        }
        catch (DBException dBException) {
            return true;
        }
        String string3 = DBUtil.getInstance((Connection)connection).executeReturnOneCol("select * from sys.all_identifiers where rownum <= 5 \nand name ='" + string + "'  and usage ='CALL' and object_name != '" + this.plsNode.getObjectName() + "' --and owner ='SCOTT';");
        return string3 == null;
    }

    public static String indentLines(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().intern();
            stringBuffer2.append(string2);
            if (!"\n".equals(string2)) continue;
            stringBuffer2.append(stringBuffer);
        }
        return stringBuffer2.toString();
    }

    private static String padFromNL2Pos(int n, String string) {
        int n2 = string.substring(0, n).lastIndexOf(10) + 1;
        if (n2 < 0) {
            n2 = 0;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n - n2; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private PlSqlNode getPkgNode() {
        URL uRL = this.plsNode.getURL();
        String string = DBURLFormatHelper.getBaseType(uRL);
        URL uRL2 = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", DBURLFormatHelper.getConnectionName(uRL), "", DBURLFormatHelper.getSchema(uRL), string.substring(0, string.indexOf(32))), DBURLFormatHelper.getName(uRL));
        return PlSqlNode.find(uRL2);
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        Replacements replacements;
        boolean bl;
        String string = Service.readFile(Inliner.class, (String)"testInline.sql");
        Parsed parsed = new Parsed(string, (Earley)SqlEarley.getInstance(), "sql_statements");
        boolean bl2 = bl = 10000 < string.length();
        if (!bl) {
            parsed.getRoot().printTree();
        }
        if ((replacements = new Inliner(null).runProgram(n = parsed.getInput().indexOf("--^"), parsed.getInput(), parsed.getSrc(), null, true)) == null) {
            return;
        }
        System.out.println(replacements.toString());
    }

    static class IProgram
    extends SqlProgram {
        public int offset = -1;

        public IProgram() throws IOException {
            super(Service.readFile(Inliner.class, (String)"/oracle/dbtools/raptor/refactor/inline.prg"));
        }
    }
}

