/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure.arbori;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.raptor.plsql.structure.arbori.ArboriDocument;
import oracle.dbtools.raptor.plsql.structure.arbori.ArboriEditor;
import oracle.dbtools.raptor.plsql.structure.arbori.ArboriFoldingPlugin;
import oracle.dbtools.raptor.plsql.structure.arbori.ArboriLanguageSupport;
import oracle.dbtools.raptor.plsql.structure.arbori.BackgroundParser;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

public class ArboriTextPane
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    ArboriEditor editor;
    BasicEditorPane editorPane = EditorFactory.createIdeEditorPane();
    private static final int CMD_ID = Ide.findOrCreateCmdID((String)"SqlEditorUndoWrapperCommand");

    public ArboriTextPane() {
        this(new ArboriEditor(), null);
    }

    public ArboriTextPane(final ArboriEditor arboriEditor, TextBuffer textBuffer) {
        super(new BorderLayout());
        this.editor = arboriEditor;
        String string = "tmp.arbori";
        if (arboriEditor.node != null) {
            string = arboriEditor.node.getURL().getFile();
        }
        if (textBuffer != null) {
            this.editorPane.setDocument((Document)((Object)new ArboriDocument(string, textBuffer)));
        } else {
            this.editorPane.setDocument((Document)((Object)new ArboriDocument(string)));
        }
        this.editorPane.installPlugin((EditorPlugin)new LineHighlightPlugin());
        LanguageSupport languageSupport = this.editorPane.getLanguageSupport();
        BackgroundParser backgroundParser = null;
        if (languageSupport instanceof ArboriLanguageSupport) {
            backgroundParser = ((ArboriLanguageSupport)languageSupport).parser;
        } else {
            Logger.severe(ArboriTextPane.class, (String)"!!! Expected ArboriLanguageSupport");
        }
        ArboriFoldingPlugin arboriFoldingPlugin = new ArboriFoldingPlugin();
        this.editorPane.installPlugin((EditorPlugin)arboriFoldingPlugin);
        backgroundParser.install(this.editorPane);
        CodeFoldingMargin codeFoldingMargin = arboriFoldingPlugin.getCodeFoldingMargin();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)codeFoldingMargin, "East");
        JScrollPane jScrollPane = new JScrollPane((Component)this.editorPane, 22, 32);
        jScrollPane.setRowHeaderView(jPanel);
        this.add(jScrollPane);
        Document document = this.editorPane.getDocument();
        final UndoableEditListener undoableEditListener = new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                UndoableEdit undoableEdit = undoableEditEvent.getEdit();
                UndoCommandWrapper undoCommandWrapper = new UndoCommandWrapper(undoableEdit);
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                undoCommandWrapper.setContext(arboriEditor.getContext());
                try {
                    commandProcessor.invoke((Command)undoCommandWrapper);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        document.addUndoableEditListener(undoableEditListener);
        this.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Document document;
                Document document2 = (Document)propertyChangeEvent.getOldValue();
                if (document2 != null && undoableEditListener != null) {
                    document2.removeUndoableEditListener(undoableEditListener);
                }
                if ((document = (Document)propertyChangeEvent.getNewValue()) != null && undoableEditListener != null) {
                    document.addUndoableEditListener(undoableEditListener);
                }
            }
        });
    }

    public void selectAll() {
        this.editorPane.setSelectionStart(0);
        this.editorPane.setSelectionEnd(this.editorPane.getText().length());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void replaceSelection(String string) {
        this.editorPane.replaceSelection(string);
    }

    public void setCaretPosition(int n) {
        this.editorPane.setCaretPosition(n);
    }

    public String getText() {
        return this.editorPane.getText();
    }

    public LanguageSupport getLanguageSupport() {
        return this.editorPane.getLanguageSupport();
    }

    class UndoCommandWrapper
    extends Command {
        private UndoableEdit m_edit;

        UndoCommandWrapper(UndoableEdit undoableEdit) {
            super(CMD_ID, 0);
            this.m_edit = undoableEdit;
        }

        public String getName() {
            return this.m_edit.getPresentationName();
        }

        public int doit() {
            int n = 0;
            if (this.m_edit.canRedo()) {
                try {
                    this.m_edit.redo();
                    n = 0;
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
            return n;
        }

        public int undo() {
            int n = 1;
            if (this.m_edit.canUndo()) {
                try {
                    this.m_edit.undo();
                    n = 0;
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
            return n;
        }
    }
}

