/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure.arbori;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.raptor.plsql.folding.TypedFoldingBlock;
import oracle.dbtools.raptor.plsql.structure.arbori.BackgroundParser;
import oracle.dbtools.raptor.plsql.structure.arbori.ParserEventListener;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.folding.DefaultCodeFoldingModel;
import oracle.javatools.editor.folding.DefaultFoldingBlock;
import oracle.javatools.editor.folding.FoldingBlock;
import oracle.javatools.editor.language.NumberRange;

public class ArboriFoldingModel
extends DefaultCodeFoldingModel
implements ParserEventListener {
    public BackgroundParser parser;
    private static final int threshold = 2;

    public ArboriFoldingModel(BasicDocument basicDocument, BackgroundParser backgroundParser) {
        super(basicDocument);
        this.parser = backgroundParser;
        backgroundParser.addParserEventListener(this);
        BasicDocument basicDocument2 = this.getDocument();
        TextBuffer textBuffer = basicDocument2.getTextBuffer();
        textBuffer.readLock();
        this.setRoot(new TypedFoldingBlock(0, textBuffer.getLength(), "", null));
        textBuffer.readUnlock();
    }

    public void reload(int n, int n2) {
        TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)this.getRoot();
        ArboriFoldingModel.updateFoldingBlock(typedFoldingBlock, n, n2);
        super.reload();
    }

    private static void updateFoldingBlock(TypedFoldingBlock typedFoldingBlock, int n, int n2) {
        if (typedFoldingBlock.getStartOffset() >= n) {
            typedFoldingBlock.setStartOffset(typedFoldingBlock.getStartOffset() + n2);
        }
        if (typedFoldingBlock.getEndOffset() >= n) {
            typedFoldingBlock.setEndOffset(typedFoldingBlock.getEndOffset() + n2);
        }
        LinkedList<TypedFoldingBlock> linkedList = new LinkedList<TypedFoldingBlock>();
        Iterator iterator = typedFoldingBlock.getChildren();
        while (iterator.hasNext()) {
            TypedFoldingBlock typedFoldingBlock2 = (TypedFoldingBlock)iterator.next();
            if (n2 < 0 && n <= typedFoldingBlock2.getStartOffset() && typedFoldingBlock2.getStartOffset() < n - n2) {
                linkedList.add(typedFoldingBlock2);
                continue;
            }
            ArboriFoldingModel.updateFoldingBlock(typedFoldingBlock2, n, n2);
        }
        for (TypedFoldingBlock typedFoldingBlock2 : linkedList) {
            typedFoldingBlock.remove((FoldingBlock)typedFoldingBlock2);
        }
    }

    private static void walkParseTree(String string, LineMap lineMap, ParseNode parseNode, List<LexerToken> list, TypedFoldingBlock typedFoldingBlock, TypedFoldingBlock typedFoldingBlock2, ArrayList<NumberRange> arrayList, int n) {
        TypedFoldingBlock typedFoldingBlock3 = typedFoldingBlock;
        if (parseNode == null) {
            return;
        }
        if (parseNode.contains("rule")) {
            int n2;
            int n3;
            LexerToken lexerToken = list.get(parseNode.from);
            int n4 = n3 = lexerToken.begin;
            lexerToken = list.get(parseNode.to - 1);
            int n5 = n2 = lexerToken.end;
            for (NumberRange numberRange : arrayList) {
                if (n4 >= numberRange.start) {
                    n4 += numberRange.end - numberRange.start;
                }
                if (n5 < numberRange.start) continue;
                n5 += numberRange.end - numberRange.start;
            }
            int n6 = ArboriFoldingModel.lineDiff(lineMap, n4, n5);
            if (n6 > 2) {
                TypedFoldingBlock typedFoldingBlock4;
                int n7 = string.length() - n3 < 127 ? string.length() : n3 + 128;
                String string2 = string.substring(n3, n7);
                int n8 = string2.indexOf(10);
                if (n8 > 0) {
                    string2 = string2.substring(0, n8);
                }
                typedFoldingBlock3 = new TypedFoldingBlock(n4, n5, string2 + "...", parseNode);
                typedFoldingBlock.add((FoldingBlock)typedFoldingBlock3);
                if (typedFoldingBlock2 != null && (typedFoldingBlock4 = ArboriFoldingModel.searchShiftedBlock(typedFoldingBlock2, typedFoldingBlock3, n)) != null) {
                    typedFoldingBlock3.setExpanded(typedFoldingBlock4.isExpanded());
                }
            }
        }
        for (ParseNode parseNode2 : parseNode.children()) {
            ArboriFoldingModel.walkParseTree(string, lineMap, parseNode2, list, typedFoldingBlock3, typedFoldingBlock2, arrayList, n);
        }
    }

    void foldComments(String string, LineMap lineMap, List<LexerToken> list, TypedFoldingBlock typedFoldingBlock, TypedFoldingBlock typedFoldingBlock2) {
        LexerToken lexerToken = null;
        TypedFoldingBlock typedFoldingBlock3 = null;
        for (LexerToken lexerToken2 : list) {
            if (lexerToken2.type == Token.WS) continue;
            if (lexerToken2.type != Token.COMMENT && lexerToken2.type != Token.LINE_COMMENT) {
                lexerToken = lexerToken2;
                typedFoldingBlock3 = null;
                continue;
            }
            if (lexerToken != null && typedFoldingBlock3 != null && (lexerToken2.type == Token.COMMENT || lexerToken2.type == Token.LINE_COMMENT)) {
                typedFoldingBlock3.setEndOffset(lexerToken2.end);
                int n = ArboriFoldingModel.lineDiff(lineMap, typedFoldingBlock3.getStartOffset(), lexerToken2.end);
                if (n > 1) {
                    typedFoldingBlock.add((FoldingBlock)typedFoldingBlock3);
                }
                lexerToken = lexerToken2;
                continue;
            }
            TypedFoldingBlock typedFoldingBlock4 = new TypedFoldingBlock(lexerToken2.begin, lexerToken2.end, lexerToken2.content, null);
            int n = ArboriFoldingModel.lineDiff(lineMap, lexerToken2.begin, lexerToken2.end);
            if (n > 1) {
                typedFoldingBlock.add((FoldingBlock)typedFoldingBlock4);
            }
            typedFoldingBlock3 = typedFoldingBlock4;
            lexerToken = lexerToken2;
        }
    }

    private static int lineDiff(LineMap lineMap, int n, int n2) {
        int n3 = lineMap.getLineFromOffset(n);
        int n4 = lineMap.getLineFromOffset(n2);
        return n4 - n3;
    }

    public static void print(DefaultFoldingBlock defaultFoldingBlock, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("  ");
        }
        System.out.println("[" + defaultFoldingBlock.getStartOffset() + "," + defaultFoldingBlock.getEndOffset() + ") " + defaultFoldingBlock.getClass().getName());
        Iterator iterator = defaultFoldingBlock.getChildren();
        while (iterator.hasNext()) {
            ArboriFoldingModel.print((TypedFoldingBlock)iterator.next(), n + 1);
        }
    }

    private static boolean isShifted(TypedFoldingBlock typedFoldingBlock, TypedFoldingBlock typedFoldingBlock2, int n) {
        if (typedFoldingBlock2.getStartOffset() - typedFoldingBlock.getStartOffset() == n && typedFoldingBlock2.getEndOffset() - typedFoldingBlock.getEndOffset() == n) {
            return true;
        }
        return typedFoldingBlock2.getStartOffset() - typedFoldingBlock.getStartOffset() == 0 && typedFoldingBlock2.getEndOffset() - typedFoldingBlock.getEndOffset() == 0;
    }

    public static TypedFoldingBlock searchShiftedBlock(TypedFoldingBlock typedFoldingBlock, TypedFoldingBlock typedFoldingBlock2, int n) {
        if (ArboriFoldingModel.isShifted(typedFoldingBlock, typedFoldingBlock2, n)) {
            return typedFoldingBlock;
        }
        Iterator iterator = typedFoldingBlock.getChildren();
        while (iterator.hasNext()) {
            TypedFoldingBlock typedFoldingBlock3 = (TypedFoldingBlock)iterator.next();
            TypedFoldingBlock typedFoldingBlock4 = ArboriFoldingModel.searchShiftedBlock(typedFoldingBlock3, typedFoldingBlock2, n);
            if (typedFoldingBlock4 == null) continue;
            return typedFoldingBlock4;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(BackgroundParser backgroundParser) {
        TypedFoldingBlock typedFoldingBlock = (TypedFoldingBlock)this.getRoot();
        TypedFoldingBlock typedFoldingBlock2 = new TypedFoldingBlock(0, backgroundParser.text != null ? backgroundParser.text.length() : 0, "", null);
        int n = typedFoldingBlock2.getEndOffset() - typedFoldingBlock.getEndOffset();
        BasicDocument basicDocument = this.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        textBuffer.readLock();
        LineMap lineMap = null;
        try {
            lineMap = textBuffer.getLineMap();
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            return;
        }
        finally {
            textBuffer.readUnlock();
        }
        ArboriFoldingModel.walkParseTree(backgroundParser.text, lineMap, backgroundParser.root, backgroundParser.src, typedFoldingBlock2, typedFoldingBlock, backgroundParser.increments, n);
        this.foldComments(backgroundParser.text, lineMap, backgroundParser.allSrc, typedFoldingBlock2, typedFoldingBlock);
        this.setRoot(typedFoldingBlock2);
        ArboriFoldingModel.super.reload();
    }
}

