/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.structure;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

public abstract class AutoCompleter
extends MouseAdapter
implements ActionListener {
    protected JList<String> list = new JList();
    JPopupMenu popup = new JPopupMenu();
    protected JTextComponent textComp;
    private static final String AUTOCOMPLETER = "AUTOCOMPLETER";
    DocumentListener documentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            AutoCompleter.this.showPopup();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            AutoCompleter.this.showPopup();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    };
    static Action showAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            AutoCompleter autoCompleter = (AutoCompleter)jComponent.getClientProperty(AutoCompleter.AUTOCOMPLETER);
            if (jComponent.isEnabled()) {
                if (autoCompleter.popup.isVisible()) {
                    autoCompleter.selectNextPossibleValue();
                } else {
                    autoCompleter.showPopup();
                }
            }
        }
    };
    static Action upAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            AutoCompleter autoCompleter = (AutoCompleter)jComponent.getClientProperty(AutoCompleter.AUTOCOMPLETER);
            if (jComponent.isEnabled() && autoCompleter.popup.isVisible()) {
                autoCompleter.selectPreviousPossibleValue();
            }
        }
    };
    static Action hidePopupAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            AutoCompleter autoCompleter = (AutoCompleter)jComponent.getClientProperty(AutoCompleter.AUTOCOMPLETER);
            if (jComponent.isEnabled()) {
                autoCompleter.popup.setVisible(false);
            }
        }
    };

    public AutoCompleter(JTextComponent jTextComponent) {
        this.textComp = jTextComponent;
        this.textComp.putClientProperty(AUTOCOMPLETER, this);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setBorder(null);
        this.list.setFocusable(false);
        jScrollPane.getVerticalScrollBar().setFocusable(false);
        jScrollPane.getHorizontalScrollBar().setFocusable(false);
        this.popup.add(jScrollPane);
        if (this.textComp instanceof JTextField) {
            this.textComp.registerKeyboardAction(showAction, KeyStroke.getKeyStroke(40, 0), 0);
            this.textComp.getDocument().addDocumentListener(this.documentListener);
        } else {
            this.textComp.registerKeyboardAction(showAction, KeyStroke.getKeyStroke(32, 2), 0);
        }
        this.textComp.registerKeyboardAction(upAction, KeyStroke.getKeyStroke(38, 0), 0);
        this.textComp.registerKeyboardAction(hidePopupAction, KeyStroke.getKeyStroke(27, 0), 0);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                AutoCompleter.this.textComp.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.list.setRequestFocusEnabled(false);
        this.list.addMouseListener(this);
        this.list.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = new JLabel();
                jLabel.setOpaque(true);
                jLabel.setHorizontalAlignment(2);
                jLabel.setVerticalAlignment(0);
                if (bl) {
                    jLabel.setBackground(jList.getSelectionBackground());
                    jLabel.setForeground(jList.getSelectionForeground());
                } else {
                    jLabel.setBackground(jList.getBackground());
                    jLabel.setForeground(jList.getForeground());
                }
                String string = AutoCompleter.this.textComp.getText();
                int n2 = object.toString().toLowerCase().indexOf(string.toLowerCase());
                if (n2 < 0) {
                    n2 = 0;
                }
                String string2 = object.toString().substring(0, n2);
                String string3 = object.toString().substring(string2.length() + string.length());
                String string4 = "<html><font color=gray>" + string2 + "</font><font color=blue>" + string + "</font><font color=gray>" + string3;
                jLabel.setText(string4);
                return jLabel;
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.acceptedListItem(this.list.getSelectedValue());
        this.popup.setVisible(false);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        this.acceptedListItem(this.list.getSelectedValue());
        this.popup.setVisible(false);
    }

    private void showPopup() {
        this.popup.setVisible(false);
        if (this.textComp.isEnabled() && this.updateListData() && this.list.getModel().getSize() != 0) {
            if (!(this.textComp instanceof JTextField)) {
                this.textComp.getDocument().addDocumentListener(this.documentListener);
            }
            this.textComp.registerKeyboardAction(this, KeyStroke.getKeyStroke(10, 0), 0);
            int n = this.list.getModel().getSize();
            this.list.setVisibleRowCount(n < 10 ? n : 10);
            int n2 = 0;
            try {
                int n3 = Math.min(this.textComp.getCaret().getDot(), this.textComp.getCaret().getMark());
                n2 = this.textComp.getUI().modelToView((JTextComponent)this.textComp, (int)n3).x;
                this.popup.show(this.textComp, n2, this.textComp.getHeight());
            }
            catch (Throwable throwable) {}
        } else {
            this.popup.setVisible(false);
        }
        this.textComp.requestFocusInWindow();
    }

    protected void selectNextPossibleValue() {
        int n = this.list.getSelectedIndex();
        if (n < this.list.getModel().getSize() - 1) {
            this.list.setSelectedIndex(n + 1);
            this.list.ensureIndexIsVisible(n + 1);
        }
    }

    protected void selectPreviousPossibleValue() {
        int n = this.list.getSelectedIndex();
        if (n > 0) {
            this.list.setSelectedIndex(n - 1);
            this.list.ensureIndexIsVisible(n - 1);
        }
    }

    protected abstract boolean updateListData();

    protected abstract void acceptedListItem(String var1);
}

