/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.model;

import java.awt.Component;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.ide.util.MetaClass;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.http.auth.AuthenticationCanceledException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DummyElement;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorHook;
import oracle.dbtools.raptor.navigator.model.CustomTreeModel;
import oracle.dbtools.raptor.navigator.model.DefaultNavigatorTreeNode;
import oracle.dbtools.raptor.navigator.model.ExceptionDialogRunnable;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.ui.CustomTree;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Pair;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.javatools.data.HashStructure;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CancelledSQLException;
import oracle.javatools.db.DBException;

public final class NavigatorTree
implements TreeExpansionListener {
    private static final String ELEMENT_KEY = "tree-element";
    private static final String ELEMENT_CLASS = "element-class";
    private static final String NODE_CLASS = "class";
    static List<Class<? extends Exception>> s_cancelTypes = new ArrayList<Class<? extends Exception>>();
    private static Map<Class<? extends Element>, Class<? extends NavigatorTreeNode>> s_types;
    private static Map<Class<? extends Element>, Class<? extends NavigatorTreeNode>> s_exactTypes;
    private static boolean s_loaded;
    private NavigatorWindow m_view;
    private CustomTree m_tree;
    private NavigatorTreeNode m_root;
    private CustomTreeModel m_model;
    private boolean m_rootVisible;
    private boolean m_displayRootHandles;
    private Map<NavigatorTreeNode, List<NavigatorContext.ExpandInfo>> nodesToExpand = new HashMap<NavigatorTreeNode, List<NavigatorContext.ExpandInfo>>();
    private Map<NavigatorTreeNode, RaptorTask<?>> m_tasks = new WeakHashMap();

    public static void registerElementType(Class<? extends Element> clazz, Class<? extends NavigatorTreeNode> clazz2) {
        s_types.put(clazz, clazz2);
        s_exactTypes = null;
    }

    public NavigatorTree(NavigatorWindow navigatorWindow, Element element, boolean bl) {
        this.m_rootVisible = bl;
        this.m_view = navigatorWindow;
        this.m_root = this.createTreeElement(element);
        this.m_model = new CustomTreeModel(this.m_root);
    }

    public NavigatorWindow getOwningView() {
        return this.m_view;
    }

    public Component getGUI() {
        return this.getTree();
    }

    public CustomTree getTree() {
        if (this.m_tree == null) {
            this.createGUI();
        }
        return this.m_tree;
    }

    private CustomTree createGUI() {
        this.m_tree = new CustomTree(this.m_model);
        this.setRootVisible(this.m_rootVisible);
        this.setShowRootHandles(this.m_displayRootHandles);
        this.m_tree.addTreeExpansionListener(this);
        this.m_tree.setName(this.m_view.getTreeID());
        return this.m_tree;
    }

    public void setRootVisible(boolean bl) {
        if (this.m_tree == null) {
            this.m_rootVisible = bl;
        } else {
            this.m_tree.setRootVisible(bl);
        }
    }

    public void setShowRootHandles(boolean bl) {
        if (this.m_tree == null) {
            this.m_displayRootHandles = bl;
        } else {
            this.m_tree.setShowsRootHandles(bl);
        }
    }

    public boolean isRootVisible() {
        return this.m_tree != null ? this.m_tree.isRootVisible() : this.m_rootVisible;
    }

    public NavigatorTreeNode getRoot() {
        return this.m_root;
    }

    public CustomTreeModel getModel() {
        return this.m_model;
    }

    public boolean isElementLoadedAsynchronously(NavigatorTreeNode navigatorTreeNode) {
        return navigatorTreeNode.isLoadingAsychronous();
    }

    NavigatorTreeNode createTreeElement(Element element) {
        Serializable serializable;
        Class<? extends NavigatorTreeNode> clazz;
        NavigatorTree.loadRegisteredElements();
        Class<?> clazz2 = element.getClass();
        if (s_exactTypes == null) {
            s_exactTypes = new HashMap<Class<? extends Element>, Class<? extends NavigatorTreeNode>>(s_types);
        }
        if ((clazz = s_exactTypes.get(clazz2)) == null) {
            serializable = null;
            for (Map.Entry<Class<? extends Element>, Class<? extends NavigatorTreeNode>> entry : s_types.entrySet()) {
                Class<? extends Element> clazz3 = entry.getKey();
                if (!clazz3.isAssignableFrom(clazz2) || serializable != null && !((Class)serializable).isAssignableFrom(clazz3)) continue;
                serializable = clazz3;
                clazz = entry.getValue();
            }
            if (clazz != null) {
                s_exactTypes.put((Class<? extends Element>)serializable, clazz);
            }
        }
        serializable = null;
        if (clazz != null) {
            try {
                serializable = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                Logger.severe(NavigatorTree.class, (String)instantiationException.getLocalizedMessage(), (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.severe(NavigatorTree.class, (String)illegalAccessException.getLocalizedMessage(), (Throwable)illegalAccessException);
            }
        }
        if (serializable == null) {
            serializable = new DefaultNavigatorTreeNode();
            s_exactTypes.put(clazz2, DefaultNavigatorTreeNode.class);
        }
        serializable.setOwner(this);
        serializable.setData(element);
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadRegisteredElements() {
        Class<NavigatorTree> clazz = NavigatorTree.class;
        synchronized (NavigatorTree.class) {
            HashStructureHook hashStructureHook;
            if (!s_loaded && (hashStructureHook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(NavigatorHook.ELEMENT_NAME)) != null) {
                hashStructureHook.addHashStructureHookListener((HashStructureHookListener)new Listener());
            }
            s_loaded = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    void fireChildrenAdded(NavigatorTreeNode navigatorTreeNode, int[] nArray) {
        this.m_model.nodesWereInserted(navigatorTreeNode, nArray);
    }

    void fireChildrenRemoved(NavigatorTreeNode navigatorTreeNode, NavigatorTreeNode[] navigatorTreeNodeArray, int[] nArray) {
        this.m_model.nodesWereRemoved(navigatorTreeNode, nArray, navigatorTreeNodeArray);
    }

    void fireChildrenChanged(NavigatorTreeNode navigatorTreeNode) {
        this.m_model.nodeStructureChanged(navigatorTreeNode);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        NavigatorTreeNode navigatorTreeNode = (NavigatorTreeNode)treePath.getLastPathComponent();
        if (!navigatorTreeNode.isLeaf()) {
            this.open(navigatorTreeNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOpen(NavigatorTreeNode navigatorTreeNode) {
        Object object = navigatorTreeNode.getLock();
        synchronized (object) {
            return navigatorTreeNode.getState() == NavigatorTreeNode.State.OPEN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClosed(NavigatorTreeNode navigatorTreeNode) {
        Object object = navigatorTreeNode.getLock();
        synchronized (object) {
            return navigatorTreeNode.getState() == NavigatorTreeNode.State.CLOSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open(NavigatorTreeNode navigatorTreeNode) {
        Object object = navigatorTreeNode.getLock();
        synchronized (object) {
            if (this.isClosed(navigatorTreeNode)) {
                navigatorTreeNode.open();
                this.loadChildren(navigatorTreeNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(NavigatorTreeNode navigatorTreeNode) {
        Object object = navigatorTreeNode.getLock();
        synchronized (object) {
            if (!this.isClosed(navigatorTreeNode)) {
                navigatorTreeNode.close();
                this.cancelLoadTask(navigatorTreeNode);
                this.m_model.nodeStructureChanged(navigatorTreeNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNodesToExpand(NavigatorTreeNode navigatorTreeNode, List<NavigatorContext.ExpandInfo> list) {
        Map<NavigatorTreeNode, List<NavigatorContext.ExpandInfo>> map = this.nodesToExpand;
        synchronized (map) {
            if (this.nodesToExpand.containsKey(navigatorTreeNode)) {
                for (NavigatorContext.ExpandInfo expandInfo : list) {
                    if (this.nodesToExpand.get(navigatorTreeNode).contains(expandInfo)) continue;
                    this.nodesToExpand.get(navigatorTreeNode).add(expandInfo);
                }
            } else {
                this.nodesToExpand.put(navigatorTreeNode, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(NavigatorTreeNode navigatorTreeNode) {
        Object object = navigatorTreeNode.getLock();
        synchronized (object) {
            if (!this.isClosed(navigatorTreeNode)) {
                List<NavigatorContext.ExpandInfo> list = NavigatorContext.storeExpansionState(this, navigatorTreeNode);
                this.addNodesToExpand(navigatorTreeNode, list);
                this.close(navigatorTreeNode);
                this.open(navigatorTreeNode);
            }
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadChildrenSynchronously(NavigatorTreeNode navigatorTreeNode) {
        Object object = navigatorTreeNode.getLock();
        synchronized (object) {
            try {
                this.addChildrenToNodeImpl(navigatorTreeNode, navigatorTreeNode.loadChildrenImpl());
            }
            finally {
                navigatorTreeNode.setState(NavigatorTreeNode.State.OPEN);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadChildrenAsynchronously(final NavigatorTreeNode navigatorTreeNode) {
        Object object = navigatorTreeNode.getLock();
        synchronized (object) {
            final RaptorTask<Collection<Element>> raptorTask = navigatorTreeNode.getLoadingTask();
            if (raptorTask != null) {
                final NavigatorTreeNode navigatorTreeNode2 = this.createTreeElement(DummyElement.INSTANCE);
                Element element = navigatorTreeNode.getElement();
                raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                    public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                        this.cleanupOnError(navigatorTreeNode);
                    }

                    private boolean isCancel(Throwable throwable) {
                        boolean bl = false;
                        for (Class<? extends Exception> clazz : s_cancelTypes) {
                            if (!clazz.isInstance(throwable)) continue;
                            bl = true;
                            break;
                        }
                        return bl;
                    }

                    public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                        if (NavigatorTree.this.isTaskValid(navigatorTreeNode)) {
                            Throwable throwable;
                            Throwable throwable2 = throwable = raptorTaskEvent.getThrowable();
                            while (throwable instanceof DBException) {
                                if ((throwable = throwable.getCause()) == null) continue;
                                throwable2 = throwable;
                            }
                            if (!this.isCancel(throwable2)) {
                                ExceptionDialogRunnable exceptionDialogRunnable = new ExceptionDialogRunnable(DatabaseNavigatorResources.getString("CONNECTION_FILTER_CONNECT_ERROR"), throwable2);
                                if (SwingUtilities.isEventDispatchThread()) {
                                    exceptionDialogRunnable.run();
                                } else {
                                    try {
                                        SwingUtilities.invokeLater(exceptionDialogRunnable);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            this.cleanupOnError(navigatorTreeNode);
                            NavigatorTree.this.loadTaskComplete(navigatorTreeNode);
                        }
                    }

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        if (NavigatorTree.this.isTaskValid(navigatorTreeNode)) {
                            SwingUtilities.invokeLater(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    Object object = navigatorTreeNode.getLock();
                                    synchronized (object) {
                                        int n = navigatorTreeNode.removeChild(navigatorTreeNode2);
                                        if (n >= 0) {
                                            NavigatorTree.this.fireChildrenRemoved(navigatorTreeNode, new NavigatorTreeNode[]{navigatorTreeNode2}, new int[]{n});
                                        }
                                        try {
                                            NavigatorTree.this.addChildrenToNodeImpl(navigatorTreeNode, ((Collection)raptorTask.getResult()).iterator());
                                        }
                                        catch (InterruptedException interruptedException) {
                                        }
                                        catch (ExecutionException executionException) {
                                        }
                                        finally {
                                            navigatorTreeNode.setState(NavigatorTreeNode.State.OPEN);
                                            NavigatorTree.this.loadTaskComplete(navigatorTreeNode);
                                            NavigatorTree.this.expandSavedNodes();
                                        }
                                    }
                                }
                            });
                        }
                    }

                    private void cleanupOnError(final NavigatorTreeNode navigatorTreeNode3) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NavigatorTree.this.collapse(navigatorTreeNode3, true);
                            }
                        });
                    }
                });
                this.startLoadTask(navigatorTreeNode, raptorTask);
                this.addChildToNode(navigatorTreeNode, navigatorTreeNode2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandSavedNodes() {
        Map<NavigatorTreeNode, List<NavigatorContext.ExpandInfo>> map = this.nodesToExpand;
        synchronized (map) {
            if (this.nodesToExpand.size() > 0) {
                NavigatorTreeNode navigatorTreeNode = null;
                Vector<NavigatorTreeNode> vector = new Vector<NavigatorTreeNode>();
                Set<NavigatorTreeNode> set = this.nodesToExpand.keySet();
                for (NavigatorTreeNode navigatorTreeNode2 : set) {
                    List<NavigatorContext.ExpandInfo> list = this.nodesToExpand.get(navigatorTreeNode2);
                    ArrayList<TreePath> arrayList = new ArrayList<TreePath>(list.size());
                    NavigatorContext.checkExpansionState(navigatorTreeNode2, list, 0, arrayList);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        NavigatorTreeNode navigatorTreeNode3;
                        TreePath treePath = (TreePath)arrayList.get(i);
                        Object object = treePath.getLastPathComponent();
                        if (!(object instanceof NavigatorTreeNode) || !(navigatorTreeNode3 = (NavigatorTreeNode)object).getState().equals((Object)NavigatorTreeNode.State.CLOSED)) continue;
                        navigatorTreeNode = navigatorTreeNode3;
                        break;
                    }
                    if (navigatorTreeNode != null) continue;
                    vector.add(navigatorTreeNode2);
                }
                for (NavigatorTreeNode navigatorTreeNode2 : vector) {
                    set.remove(navigatorTreeNode2);
                }
                if (navigatorTreeNode != null) {
                    this.open(navigatorTreeNode);
                    this.expand(navigatorTreeNode, false);
                }
            }
        }
    }

    private void loadChildren(NavigatorTreeNode navigatorTreeNode) {
        if (navigatorTreeNode.getAllowsChildren()) {
            if (navigatorTreeNode.isLoadingAsychronous()) {
                this.loadChildrenAsynchronously(navigatorTreeNode);
            } else {
                this.loadChildrenSynchronously(navigatorTreeNode);
                this.expandSavedNodes();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadTask(NavigatorTreeNode navigatorTreeNode, RaptorTask<Collection<Element>> raptorTask) {
        Map<NavigatorTreeNode, RaptorTask<?>> map = this.m_tasks;
        synchronized (map) {
            this.m_tasks.put(navigatorTreeNode, raptorTask);
        }
        RaptorTaskManager.getInstance().addTask(raptorTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelLoadTask(NavigatorTreeNode navigatorTreeNode) {
        if (navigatorTreeNode.getAllowsChildren() && navigatorTreeNode.isLoadingAsychronous()) {
            RaptorTask<?> raptorTask;
            Map<NavigatorTreeNode, RaptorTask<?>> map = this.m_tasks;
            synchronized (map) {
                raptorTask = this.m_tasks.remove(navigatorTreeNode);
            }
            if (raptorTask != null) {
                raptorTask.requestCancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTaskComplete(NavigatorTreeNode navigatorTreeNode) {
        Map<NavigatorTreeNode, RaptorTask<?>> map = this.m_tasks;
        synchronized (map) {
            this.m_tasks.remove(navigatorTreeNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTaskValid(NavigatorTreeNode navigatorTreeNode) {
        Map<NavigatorTreeNode, RaptorTask<?>> map = this.m_tasks;
        synchronized (map) {
            return this.m_tasks.containsKey(navigatorTreeNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildrenToNode(NavigatorTreeNode navigatorTreeNode, Collection<Element> collection) {
        Object object = navigatorTreeNode.getLock();
        synchronized (object) {
            if (!this.isOpen(navigatorTreeNode)) {
                return;
            }
        }
        this.addChildrenToNodeImpl(navigatorTreeNode, collection.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildFromNode(NavigatorTreeNode navigatorTreeNode, NavigatorTreeNode navigatorTreeNode2) {
        Object object = navigatorTreeNode.getLock();
        synchronized (object) {
            if (!this.isOpen(navigatorTreeNode)) {
                return;
            }
        }
        int n = navigatorTreeNode.removeChild(navigatorTreeNode2);
        if (n >= 0) {
            this.fireChildrenRemoved(navigatorTreeNode, new NavigatorTreeNode[]{navigatorTreeNode2}, new int[]{n});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildrenFromNode(NavigatorTreeNode navigatorTreeNode, Collection<Element> collection) {
        Object object = navigatorTreeNode.getLock();
        synchronized (object) {
            if (!this.isOpen(navigatorTreeNode)) {
                return;
            }
        }
        this.removeChildrenFromNodeImpl(navigatorTreeNode, collection);
    }

    private void addChildrenToNodeImpl(NavigatorTreeNode navigatorTreeNode, Iterator<Element> iterator) {
        Object object;
        ArrayList<NavigatorTreeNode> arrayList = new ArrayList<NavigatorTreeNode>();
        while (iterator.hasNext()) {
            object = iterator.next();
            NavigatorTreeNode navigatorTreeNode2 = this.createTreeElement((Element)object);
            if (navigatorTreeNode2 == null) continue;
            arrayList.add(navigatorTreeNode2);
        }
        object = navigatorTreeNode.addChildren(arrayList.toArray(new NavigatorTreeNode[0]));
        this.fireChildrenAdded(navigatorTreeNode, (int[])object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildToNode(NavigatorTreeNode navigatorTreeNode, Element element) {
        Object object = navigatorTreeNode.getLock();
        synchronized (object) {
            if (!this.isOpen(navigatorTreeNode)) {
                return;
            }
        }
        object = this.createTreeElement(element);
        if (object != null) {
            this.addChildToNode(navigatorTreeNode, (NavigatorTreeNode)object);
        }
    }

    final void addChildToNode(NavigatorTreeNode navigatorTreeNode, NavigatorTreeNode navigatorTreeNode2) {
        int n = navigatorTreeNode.addChild(navigatorTreeNode2);
        if (n >= 0) {
            this.fireChildrenAdded(navigatorTreeNode, new int[]{n});
        }
    }

    protected void removeChildrenFromNodeImpl(NavigatorTreeNode navigatorTreeNode, Collection<Element> collection) {
        Pair<NavigatorTreeNode, Integer>[] pairArray;
        NavigatorTreeNode[] navigatorTreeNodeArray = navigatorTreeNode.findNodes(collection);
        if (navigatorTreeNodeArray.length > 0 && (pairArray = navigatorTreeNode.removeChildren(navigatorTreeNodeArray)).length > 0) {
            NavigatorTreeNode[] navigatorTreeNodeArray2 = new NavigatorTreeNode[pairArray.length];
            int[] nArray = new int[pairArray.length];
            for (int i = pairArray.length - 1; i >= 0; --i) {
                navigatorTreeNodeArray2[i] = (NavigatorTreeNode)pairArray[i].first();
                nArray[i] = (Integer)pairArray[i].second();
            }
            this.fireChildrenRemoved(navigatorTreeNode, navigatorTreeNodeArray2, nArray);
        }
    }

    public void expand(NavigatorTreeNode navigatorTreeNode, boolean bl) {
        if (navigatorTreeNode == null || navigatorTreeNode.isLeaf()) {
            return;
        }
        TreePath treePath = new TreePath(this.getPathToRoot(navigatorTreeNode, 0));
        this.open(navigatorTreeNode);
        this.m_tree.expandPath(treePath);
        if (bl) {
            Enumeration enumeration = navigatorTreeNode.children();
            while (enumeration.hasMoreElements()) {
                this.expand((NavigatorTreeNode)enumeration.nextElement(), true);
            }
        }
    }

    public void collapse(NavigatorTreeNode navigatorTreeNode, boolean bl) {
        if (navigatorTreeNode == null || navigatorTreeNode.isLeaf()) {
            return;
        }
        TreePath treePath = new TreePath(this.getPathToRoot(navigatorTreeNode, 0));
        if (this.m_tree.isExpanded(treePath)) {
            this.m_tree.collapsePath(treePath);
        }
        if (bl) {
            this.close(navigatorTreeNode);
            this.m_model.nodeStructureChanged(navigatorTreeNode);
        }
    }

    public void setSelectedNode(final NavigatorTreeNode navigatorTreeNode) {
        if (navigatorTreeNode == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavigatorTree.this.setSelectedNode(navigatorTreeNode);
                }
            });
        }
        TreePath treePath = new TreePath(navigatorTreeNode.getPath());
        this.m_tree.setSelectionPath(treePath);
        this.m_tree.scrollPathToVisible(treePath);
    }

    public void reparentNode(NavigatorTreeNode navigatorTreeNode, NavigatorTreeNode navigatorTreeNode2) {
        NavigatorTreeNode navigatorTreeNode3 = (NavigatorTreeNode)navigatorTreeNode.getParent();
        if (navigatorTreeNode3 == navigatorTreeNode2) {
            return;
        }
        int n = navigatorTreeNode3.removeChild(navigatorTreeNode);
        this.fireChildrenRemoved(navigatorTreeNode3, new NavigatorTreeNode[]{navigatorTreeNode}, new int[]{n});
        if (navigatorTreeNode2 != null && (n = navigatorTreeNode2.addChild(navigatorTreeNode)) >= 0) {
            this.fireChildrenAdded(navigatorTreeNode2, new int[]{n});
        }
    }

    protected TreeNode[] getPathToRoot(TreeNode treeNode, int n) {
        TreeNode[] treeNodeArray;
        TreeNode[] treeNodeArray2 = null;
        if (treeNode == null) {
            if (n == 0) {
                return treeNodeArray2;
            }
            treeNodeArray = new TreeNode[n];
        } else {
            treeNodeArray = this.getPathToRoot(treeNode.getParent(), ++n);
            treeNodeArray[treeNodeArray.length - n] = treeNode;
        }
        return treeNodeArray;
    }

    void nodeChanged(NavigatorTreeNode navigatorTreeNode) {
        if (navigatorTreeNode != null) {
            this.m_model.nodeChanged(navigatorTreeNode);
        }
    }

    public NavigatorTreeNode findTreeNode(Element element, NavigatorTreeNode navigatorTreeNode) {
        if (navigatorTreeNode == null || element == null) {
            return null;
        }
        if (element == navigatorTreeNode.getElement()) {
            return navigatorTreeNode;
        }
        return !navigatorTreeNode.isLeaf() && this.isOpen(navigatorTreeNode) ? this.findChildTreeNode(element, navigatorTreeNode) : null;
    }

    private NavigatorTreeNode findChildTreeNode(Element element, NavigatorTreeNode navigatorTreeNode) {
        ArrayList<NavigatorTreeNode> arrayList = new ArrayList<NavigatorTreeNode>();
        Iterator<NavigatorTreeNode> iterator = navigatorTreeNode.getChildNodes();
        while (iterator.hasNext()) {
            NavigatorTreeNode navigatorTreeNode2 = iterator.next();
            if (element == navigatorTreeNode2.getElement()) {
                return navigatorTreeNode2;
            }
            if (navigatorTreeNode2.isLeaf() || !this.isOpen(navigatorTreeNode2)) continue;
            arrayList.add(navigatorTreeNode2);
        }
        for (NavigatorTreeNode navigatorTreeNode2 : arrayList) {
            NavigatorTreeNode navigatorTreeNode3 = this.findChildTreeNode(element, navigatorTreeNode2);
            if (navigatorTreeNode3 == null) continue;
            return navigatorTreeNode3;
        }
        return null;
    }

    public NavigatorTreeNode findTreeNode(URL uRL, NavigatorTreeNode navigatorTreeNode) {
        if (navigatorTreeNode == null || uRL == null) {
            return null;
        }
        if (this.checkElement(navigatorTreeNode.getElement(), uRL)) {
            return navigatorTreeNode;
        }
        return !navigatorTreeNode.isLeaf() && this.isOpen(navigatorTreeNode) ? this.findChildTreeNode(uRL, navigatorTreeNode) : null;
    }

    private boolean checkElement(Element element, URL uRL) {
        return element instanceof Locatable && uRL.equals(((Locatable)element).getURL());
    }

    private NavigatorTreeNode findChildTreeNode(URL uRL, NavigatorTreeNode navigatorTreeNode) {
        ArrayList<NavigatorTreeNode> arrayList = new ArrayList<NavigatorTreeNode>();
        Iterator<NavigatorTreeNode> iterator = navigatorTreeNode.getChildNodes();
        while (iterator.hasNext()) {
            NavigatorTreeNode navigatorTreeNode2 = iterator.next();
            if (this.checkElement(navigatorTreeNode2.getElement(), uRL)) {
                return navigatorTreeNode2;
            }
            if (navigatorTreeNode2.isLeaf() || !this.isOpen(navigatorTreeNode2)) continue;
            arrayList.add(navigatorTreeNode2);
        }
        for (NavigatorTreeNode navigatorTreeNode2 : arrayList) {
            NavigatorTreeNode navigatorTreeNode3 = this.findChildTreeNode(uRL, navigatorTreeNode2);
            if (navigatorTreeNode3 == null) continue;
            return navigatorTreeNode3;
        }
        return null;
    }

    static {
        s_cancelTypes.add(AuthenticationCanceledException.class);
        s_cancelTypes.add(CancellationException.class);
        s_cancelTypes.add(ConnectionCanceledException.class);
        s_cancelTypes.add(CancelledException.class);
        s_cancelTypes.add(CancelledSQLException.class);
        s_types = new HashMap<Class<? extends Element>, Class<? extends NavigatorTreeNode>>();
    }

    private static class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void elementVisited(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getNewElementHashStructure());
        }

        public void listenerAttached(HashStructureHookEvent hashStructureHookEvent) {
            this.processDescriptors(hashStructureHookEvent.getCombinedHashStructure());
        }

        private void processDescriptors(HashStructure hashStructure) {
            List list = hashStructure.getAsList(NavigatorTree.ELEMENT_KEY);
            if (list != null) {
                for (HashStructure hashStructure2 : list) {
                    MetaClass metaClass;
                    LazyClassAdapter lazyClassAdapter = LazyClassAdapter.getInstance((HashStructure)hashStructure2);
                    MetaClass metaClass2 = lazyClassAdapter.getMetaClass(NavigatorTree.ELEMENT_CLASS);
                    if (metaClass2 == null || (metaClass = lazyClassAdapter.getMetaClass(NavigatorTree.NODE_CLASS)) == null) continue;
                    try {
                        NavigatorTree.registerElementType(metaClass2.toClass(), metaClass.toClass());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Logger.severe(NavigatorTree.class, (String)classNotFoundException.getLocalizedMessage(), (Throwable)classNotFoundException);
                    }
                }
            }
        }
    }
}

