/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.db.impl.AbstractContainerTreeNode;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBContainerInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemaInstance;
import oracle.dbtools.raptor.navigator.db.model.DBSchemasInstance;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.NavigatorQueryTask;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Element;

public class OtherSchemasTreeNode
extends AbstractContainerTreeNode {
    @Override
    public DBContainerInstance getFolderInstance() {
        return ((OtherSchemasFolder)this.getElement()).getDBSchemasInstance();
    }

    @Override
    protected RaptorTask<Collection<Element>> getLoadingTask() {
        OtherSchemasFolder otherSchemasFolder = (OtherSchemasFolder)this.getElement();
        String string = DBURLFormatHelper.getConnectionName(otherSchemasFolder.getURL());
        return new LoadTask(otherSchemasFolder, string);
    }

    private class LoadTask
    extends NavigatorQueryTask {
        private OtherSchemasFolder m_folder;

        LoadTask(OtherSchemasFolder otherSchemasFolder, String string) {
            super(DatabaseNavigatorResources.getString("OTHER_SCHEMAS_LOAD_MSG"), string, true);
            this.m_folder = otherSchemasFolder;
        }

        @Override
        protected Collection<Element> doWorkImpl() throws TaskException {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            DBSchemasInstance dBSchemasInstance = this.m_folder.getDBSchemasInstance();
            try {
                this.checkCanProceed();
                String string = OtherSchemasTreeNode.getURLProtocol((Element)this.m_folder);
                String string2 = this.getConnectionName();
                String string3 = (String)dBSchemasInstance.getProperty("ConnectionType");
                for (DBChildInstance dBChildInstance : dBSchemasInstance.listChildren()) {
                    DBSchemaInstance dBSchemaInstance = (DBSchemaInstance)dBChildInstance;
                    SchemaFolder schemaFolder = new SchemaFolder(DBURLFormatHelper.getURL(string, string2, null, (String)dBSchemaInstance.getProperty("SCHEMA"), null), dBSchemaInstance, string3);
                    arrayList.add(schemaFolder);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            catch (AbortException abortException) {
                arrayList.clear();
            }
            catch (ExecutionException executionException) {
                arrayList.clear();
            }
            return arrayList;
        }
    }
}

