/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.validators;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.raptor.data.validators.BaseValidator;

public class NumberValidator
extends BaseValidator {
    Character _nlsDecimalSeparator;

    public void setNlsDecimalSeparator(Character c) {
        this._nlsDecimalSeparator = c;
    }

    @Override
    public boolean validateData(Column column, Object object) {
        if (object == null || object.toString().length() == 0) {
            return column.isNullable();
        }
        Object object2 = "";
        String string = object.toString();
        DecimalFormat decimalFormat = null;
        ParsePosition parsePosition = new ParsePosition(0);
        decimalFormat = this._l != null ? (DecimalFormat)DecimalFormat.getInstance(this._l) : (DecimalFormat)DecimalFormat.getInstance();
        if (this._nlsDecimalSeparator != null && decimalFormat instanceof DecimalFormat) {
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator(this._nlsDecimalSeparator.charValue());
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        }
        try {
            decimalFormat.setParseBigDecimal(true);
            object2 = ((BigDecimal)decimalFormat.parse(string, parsePosition)).toPlainString();
        }
        catch (Exception exception) {
            return false;
        }
        if (parsePosition.getIndex() < string.length()) {
            return false;
        }
        if (((String)object2).length() == 0) {
            return false;
        }
        if (column.getType().equalsIgnoreCase("BINARY_DOUBLE")) {
            try {
                Double.parseDouble((String)object2);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        if (column.getType().equalsIgnoreCase("BINARY_FLOAT")) {
            try {
                Float.parseFloat((String)object2);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        int n = ((String)object2).lastIndexOf(".");
        if (n < 0) {
            if (column.getPrecision() == 0) {
                return ((String)object2).length() <= 38;
            }
            if (((String)object2).length() > column.getPrecision()) {
                return false;
            }
        } else {
            try {
                int n2;
                Float f;
                int n3;
                if (column.getPrecision() == 0 && column.getScale() >= 0) {
                    return n <= 38;
                }
                if (column.getPrecision() > column.getScale() && column.getPrecision() - column.getScale() < n) {
                    return false;
                }
                if (column.getScale() <= 0 && (float)(n3 = (f = Float.valueOf(Float.parseFloat((String)object2))).intValue()) == f.floatValue()) {
                    return true;
                }
                if (column.getScale() < 0 ? (n2 = column.getScale() * -1) < ((String)object2).length() - n - 1 : column.getScale() < ((String)object2).length() - n - 1) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }
}

