/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.sqldialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.RadioGroupPanel;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.sqldialog.ActionSql;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionPrompt;
import oracle.dbtools.raptor.controls.validators.IValidator;
import oracle.dbtools.raptor.controls.validators.ValidatableObject;
import oracle.dbtools.raptor.controls.validators.ValidatorRegistry;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

public class SQLPromptPanel
extends JPanel
implements LayoutControl {
    private static final String CHECK_PROMPT = "check";
    private static final String RADIO_PROMPT = "radio";
    private static final String CONFIRM_PROMPT = "confirm";
    private static final String SELECT_VALUE = "SELECT";
    private static final String STATIC_VALUE = "STATIC:";
    private static final String LIST_CONNECTIONS = "LISTCONNECTIONS";
    private static final String CHECKBOX_VALUE = "CHECKBOX_VALUE";
    private Map<String, Object> _dict = new HashMap<String, Object>();
    private ArrayList<JComponent> _textValues = new ArrayList();
    private ObjectAction _action;
    private String _conn;
    private int row = 0;
    private ActionSql _actionSql;
    private FocusListener _focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!(focusEvent.getSource() instanceof JComboBox)) {
                SQLPromptPanel.this.processReloadablePrompts((JComponent)focusEvent.getSource());
            }
        }
    };
    private ItemListener _comboListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                SQLPromptPanel.this.processReloadablePrompts((JComponent)itemEvent.getSource());
            }
        }
    };

    public SQLPromptPanel(ObjectAction objectAction, String string, Map<String, Object> map) {
        super(new GridBagLayout(), true);
        this._action = objectAction;
        this._conn = string;
        this._dict = map;
        this.init();
    }

    public List<String> getValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (JComponent jComponent : this._textValues) {
            String string = null;
            if (jComponent == null) {
                string = "";
            } else if (jComponent instanceof JTextComponent) {
                string = ((JTextComponent)jComponent).getText();
            } else if (jComponent instanceof RadioGroupPanel) {
                string = ((RadioGroupPanel)jComponent).getSelectedValue();
            } else if (jComponent instanceof JComboBox) {
                var6_6 = ((JComboBox)jComponent).getSelectedItem();
                if (var6_6 != null) {
                    if (var6_6 instanceof AbstractAction) {
                        AbstractAction abstractAction = (AbstractAction)var6_6;
                        string = (String)abstractAction.getValue("org_val");
                    } else {
                        string = var6_6.toString();
                    }
                } else {
                    string = "";
                }
            } else if (jComponent instanceof JCheckBox) {
                var6_6 = (JCheckBox)jComponent;
                string = (String)((JComponent)var6_6).getClientProperty(CHECKBOX_VALUE);
                if (string.indexOf(STATIC_VALUE) == 0) {
                    string = string.substring(7);
                }
                if (((AbstractButton)var6_6).isSelected() && (string == null || string.length() == 0)) {
                    string = ((AbstractButton)var6_6).getText();
                }
            } else if (jComponent instanceof JScrollPane && ((JViewport)((JScrollPane)jComponent).getComponent(0)).getComponent(0) instanceof BasicEditorPane) {
                string = ((BasicEditorPane)((JViewport)((JScrollPane)jComponent).getComponent(0)).getComponent(0)).getText();
            }
            arrayList.add(string);
            ++n;
        }
        return arrayList;
    }

    public int getPromptIndex(String string) {
        int n = -1;
        for (ObjectActionPrompt objectActionPrompt : this._action.getPrompts()) {
            String string2 = objectActionPrompt.getPrompt();
            ++n;
            if (string == null || !string.equalsIgnoreCase(string2)) continue;
            break;
        }
        return n;
    }

    private ActionSql getActionSql() {
        if (this._actionSql == null) {
            this._actionSql = new ActionSql();
        }
        this._actionSql.clear();
        return this._actionSql;
    }

    public void evalDefaults() {
        ActionSql actionSql = this.getActionSql();
        actionSql.setDict(this._dict);
        for (int i = 0; i < this._action.getPrompts().size(); ++i) {
            String string = (String)this._action.getDefaults().get(i);
            if (string == null) continue;
            String string2 = null;
            if (string.toLowerCase().indexOf("static:") == 0) {
                string2 = ActionSql.manualSubstitute(string.substring(7), this._dict);
            } else if (ModelUtil.hasLength((String)string)) {
                actionSql.setSql(string);
                actionSql.processSql(this.getTextValues(), this.getValues());
                string2 = DBUtil.getInstance((String)this._conn).executeReturnOneCol(actionSql.getSql(), actionSql.getBinds());
            } else {
                string2 = "";
            }
            JComponent jComponent = this._textValues.get(i);
            if (jComponent instanceof RadioGroupPanel) {
                ((RadioGroupPanel)jComponent).setSelectedValue(string2);
                continue;
            }
            if (jComponent instanceof JTextField) {
                ((JTextField)jComponent).setText(string2);
                continue;
            }
            if (jComponent instanceof JComboBox) {
                ((JComboBox)jComponent).setSelectedItem(string2);
                continue;
            }
            if (!(jComponent instanceof JScrollPane)) continue;
            ((BasicEditorPane)((JViewport)((JScrollPane)jComponent).getComponent(0)).getComponent(0)).setText(string2);
        }
    }

    public void init() {
        Object object;
        if (this._dict.get("OBJECT_OWNER") != null && this._dict.get("OBJECT_NAME") != null) {
            JTextField jTextField = new JTextField();
            jTextField.setText(this._dict.get("OBJECT_OWNER").toString());
            jTextField.setEditable(false);
            object = new JTextField();
            ((JTextComponent)object).setText(this._dict.get("OBJECT_NAME").toString());
            ((JTextComponent)object).setEditable(false);
            this.addRow(new JLabel(ControlsArb.getString("LABEL_OWNER")), jTextField);
            this.addRow(new JLabel(ControlsArb.getString("LABEL_NAME")), (Component)object);
        }
        boolean bl = true;
        if (this._action.getPrompts() == null || this._action.getPrompts().size() == 0) {
            object = this._action.getType();
            if (!((String)object).equalsIgnoreCase("JOBS")) {
                this.add((Component)new JLabel("Confirm Action " + UIUtils.stripElipses((String)this._action.getTitle())), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP.inset(), 0, 0));
            }
        } else {
            for (ObjectActionPrompt objectActionPrompt : this._action.getPrompts()) {
                JComponent jComponent;
                String string = objectActionPrompt.getType();
                String string2 = objectActionPrompt.getPrompt();
                if (string2.indexOf("#") > 0) {
                    this._actionSql = this.getActionSql();
                    this._actionSql.setDict(this._dict);
                    string2 = ActionSql.manualSubstitute(string2, this._dict);
                }
                if (string.equalsIgnoreCase(CONFIRM_PROMPT)) {
                    if (this._action.getPrompts().size() == 1) {
                        if (this._dict.get("OBJECT_OWNER") == null && this._dict.get("OBJECT_NAME") == null) {
                            bl = false;
                        }
                        this.add((Component)new JLabel(string2), LayoutControl.GBC.gbc(0, this.row, 2, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.NONE, LayoutControl.GBC.Anchor.CENTER));
                    } else {
                        this.add((Component)new JLabel(string2), LayoutControl.GBC.gbc(0, this.row, 2, 1, this.row == 0 ? LayoutControl.GBC.Inset.FIRST_LINE_START_COMP : LayoutControl.GBC.Inset.LINE_START_COMP));
                    }
                    ++this.row;
                    jComponent = new JLabel("");
                } else {
                    String string3 = objectActionPrompt.getValue();
                    if (string.equalsIgnoreCase(RADIO_PROMPT)) {
                        if (string3.indexOf(STATIC_VALUE) == 0) {
                            string3 = string3.substring(STATIC_VALUE.length());
                        }
                        var8_9 = string3.split(":");
                        var9_10 = new RadioGroupPanel((String[])var8_9, (String[])var8_9);
                        jComponent = var9_10;
                    } else if (string.equalsIgnoreCase("codearea")) {
                        bl = false;
                        var8_9 = EditorFactory.createIdeEditorPane();
                        var8_9.setText("");
                        var8_9.setDocument((Document)new BasicDocument("foo.plsql"));
                        var8_9.installPlugin((EditorPlugin)new LineHighlightPlugin());
                        var8_9.setEditable(true);
                        var9_10 = new JScrollPane((Component)var8_9, 22, 32);
                        var9_10.setPreferredSize(var8_9.getPreferredSize());
                        var9_10.setSize(var9_10.getPreferredSize());
                        jComponent = var9_10;
                    } else if (string.equalsIgnoreCase(CHECK_PROMPT)) {
                        jComponent = new JCheckBox();
                        var8_9 = objectActionPrompt.getDefault();
                        if (string3.equals(var8_9) || ((String)var8_9).indexOf(STATIC_VALUE) == 0 && string3.equals(((String)var8_9).substring(7))) {
                            ((JCheckBox)jComponent).setSelected(true);
                        }
                        ((JCheckBox)jComponent).putClientProperty(CHECKBOX_VALUE, string3);
                        ((JCheckBox)jComponent).addItemListener(this._comboListener);
                    } else if (string3.toUpperCase().indexOf(STATIC_VALUE) == 0) {
                        var8_9 = string3.substring(STATIC_VALUE.length()).split(":");
                        var9_10 = null;
                        if (var8_9 != null && ((String[])var8_9).length > 0) {
                            var10_11 = new AbstractAction[((Object)var8_9).length];
                            for (int i = 0; i < ((Object)var8_9).length; ++i) {
                                var12_15 = var8_9[i];
                                var10_11[i] = new AbstractAction((String)var12_15){
                                    final /* synthetic */ String val$nls_txt;
                                    {
                                        this.val$nls_txt = string;
                                    }

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                    }

                                    public String toString() {
                                        return this.val$nls_txt;
                                    }
                                };
                                ((AbstractAction)var10_11[i]).putValue("org_val", var8_9[i]);
                            }
                            var9_10 = var10_11;
                        }
                        jComponent = new JComboBox(var9_10);
                        ((JComboBox)jComponent).addItemListener(this._comboListener);
                    } else if (string3.toUpperCase().indexOf(SELECT_VALUE) == 0) {
                        var8_9 = string3;
                        var9_10 = this.getActionSql();
                        var9_10.setSql((String)var8_9);
                        var9_10.setDict(this._dict);
                        var9_10.processSql(this.getTextValues(), this._action.getDefaults());
                        jComponent = new JComboBox(new SQLComboxModel(this._conn, var9_10.getSql(), var9_10.getBinds(), null));
                        ((JComboBox)jComponent).addItemListener(this._comboListener);
                    } else if (string3.toUpperCase().indexOf(LIST_CONNECTIONS) == 0) {
                        var8_9 = Connections.getInstance().getConnNames();
                        var9_10 = new ArrayList();
                        for (int i = 0; i < ((Object)var8_9).length; ++i) {
                            if (!Connections.getInstance().isOracle((String)var8_9[i])) continue;
                            var9_10.add(Connections.getConnectionName((String)var8_9[i]));
                        }
                        var10_11 = var9_10.toArray(new String[var9_10.size()]);
                        AbstractAction[] abstractActionArray = null;
                        if (var10_11 != null && var10_11.length > 0) {
                            var12_15 = new AbstractAction[var10_11.length];
                            for (int i = 0; i < var10_11.length; ++i) {
                                Object object2 = var10_11[i];
                                var12_15[i] = new AbstractAction((String)object2){
                                    final /* synthetic */ String val$nls_txt;
                                    {
                                        this.val$nls_txt = string;
                                    }

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                    }

                                    public String toString() {
                                        return this.val$nls_txt;
                                    }
                                };
                                var12_15[i].putValue("org_val", var10_11[i]);
                            }
                            abstractActionArray = var12_15;
                        }
                        jComponent = new JComboBox(abstractActionArray);
                    } else {
                        jComponent = new JTextField(25);
                        var8_9 = objectActionPrompt.getValidator();
                        var9_10 = ValidatorRegistry.getValidator((String)var8_9);
                        ((JTextField)jComponent).setDocument(new ValidatedDocument((IValidator)var9_10, objectActionPrompt));
                    }
                }
                jComponent.addFocusListener(this._focusListener);
                this._textValues.add(jComponent);
                if (string.equalsIgnoreCase(CONFIRM_PROMPT)) continue;
                this.addRow(new JLabel(string2), jComponent);
            }
        }
        this.evalDefaults();
        this.toggleReadOnlyPrompts(false);
        if (bl) {
            LayoutControl.GBC.addSpring(this, this.row, 2);
        }
        this.setSize(this.getPreferredSize());
    }

    private void addRow(Component component, Component component2) {
        GridBagConstraints gridBagConstraints = LayoutControl.GBC.gbc(0, this.row, 1, 1, this.row == 0 ? LayoutControl.GBC.Inset.FIRST_LINE_START_COMP : LayoutControl.GBC.Inset.LINE_START_COMP);
        GridBagConstraints gridBagConstraints2 = LayoutControl.GBC.gbc(1, this.row, 1, 1, this.row == 0 ? LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP : LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X);
        if (component instanceof JLabel) {
            component.setFocusable(false);
            ((JLabel)component).setLabelFor(component2);
        }
        if (component2 instanceof JScrollPane) {
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weighty = 1.0;
        }
        this.add(component, gridBagConstraints);
        this.add(component2, gridBagConstraints2);
        ++this.row;
    }

    public void processReloadablePrompts(JComponent jComponent) {
        ActionSql actionSql;
        int n;
        int n2 = -1;
        this.toggleReadOnlyPrompts(true);
        for (n = 0; n < this._textValues.size(); ++n) {
            if (!jComponent.equals(this._textValues.get(n))) continue;
            n2 = n;
        }
        n = 0;
        for (ObjectActionPrompt objectActionPrompt : this._action.getPrompts()) {
            if (objectActionPrompt.getValue().toUpperCase().trim().indexOf(SELECT_VALUE) == 0 && objectActionPrompt.isReloadable() && objectActionPrompt.getReload().indexOf("" + n2) > 0) {
                actionSql = this.getActionSql();
                actionSql.setDict(this._dict);
                actionSql.setSql(objectActionPrompt.getValue());
                actionSql.processSql(this.getTextValues(), this.getValues());
                ((JComboBox)this._textValues.get(n)).setModel(new SQLComboxModel(this._conn, actionSql.getSql(), actionSql.getBinds(), null));
            }
            ++n;
        }
        for (ObjectActionPrompt objectActionPrompt : this._action.getPrompts()) {
            if (objectActionPrompt.getDefault().toUpperCase().trim().indexOf(SELECT_VALUE) != 0 || !objectActionPrompt.isReloadable() || objectActionPrompt.getReload().indexOf("" + n2) <= 0) continue;
            actionSql = this.getActionSql();
            actionSql.setDict(this._dict);
            actionSql.setSql(objectActionPrompt.getDefault());
            actionSql.processSql(this.getTextValues(), this.getValues());
            String string = DBUtil.getInstance((String)this._conn).executeReturnOneCol(actionSql.getSql(), actionSql.getBinds());
            if (this._textValues.get(n > 0 ? n - 1 : n) instanceof RadioGroupPanel) {
                ((RadioGroupPanel)this._textValues.get(n > 0 ? n - 1 : n)).setSelectedValue(string);
                continue;
            }
            if (this._textValues.get(n > 0 ? n - 1 : n) instanceof JTextField) {
                ((JTextField)this._textValues.get(n > 0 ? n - 1 : n)).setText(string);
                continue;
            }
            if (this._textValues.get(n > 0 ? n - 1 : n) instanceof JComboBox) {
                ((JComboBox)this._textValues.get(n > 0 ? n - 1 : n)).setSelectedItem(string);
                continue;
            }
            if (!(this._textValues.get(n > 0 ? n - 1 : n) instanceof JScrollPane)) continue;
            ((BasicEditorPane)((JViewport)((JScrollPane)this._textValues.get(n)).getComponent(0)).getComponent(0)).setText(string);
        }
        this.toggleReadOnlyPrompts(false);
    }

    private void toggleReadOnlyPrompts(boolean bl) {
        for (int i = 0; i < this._action.getPrompts().size(); ++i) {
            if (!((ObjectActionPrompt)((Object)this._action.getPrompts().get(i))).isReadOnly()) continue;
            if (this._textValues.get(i) instanceof RadioGroupPanel) {
                ((RadioGroupPanel)this._textValues.get(i)).setEnabled(bl);
                continue;
            }
            if (this._textValues.get(i) instanceof JTextField) {
                ((JTextField)this._textValues.get(i)).setEditable(bl);
                continue;
            }
            if (this._textValues.get(i) instanceof JComboBox) {
                ((JComboBox)this._textValues.get(i)).setEditable(bl);
                continue;
            }
            if (!(this._textValues.get(i) instanceof JScrollPane)) continue;
            ((BasicEditorPane)((JViewport)((JScrollPane)this._textValues.get(i)).getComponent(0)).getComponent(0)).setEditable(bl);
        }
    }

    public void update() {
    }

    public ArrayList<JComponent> getTextValues() {
        return this._textValues;
    }

    public Map<String, Object> getDictionary() {
        return this._dict;
    }

    public ObjectAction getAction() {
        return this._action;
    }

    public void setDictionary(Map<String, Object> map) {
        this._dict = map;
    }

    class ValidatedDocument
    extends PlainDocument {
        private IValidator _validator;
        private ObjectActionPrompt _p;

        ValidatedDocument(IValidator iValidator, ObjectActionPrompt objectActionPrompt) {
            this._validator = iValidator;
            this._p = objectActionPrompt;
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            int n2;
            ValidatableObject validatableObject = new ValidatableObject();
            validatableObject.putValue("value", this.getContent().getString(0, this.getContent().length()).trim() + string);
            if (this._p != null) {
                validatableObject.putValue("datatype", this._p.getDataType());
                validatableObject.putValue("typeAttrib", this._p.getTypeAttribute());
            }
            if ((n2 = SQLPromptPanel.this.getPromptIndex("Data Type")) >= 0) {
                validatableObject.putValue("selected_data_type", SQLPromptPanel.this.getValues().get(n2));
            }
            if (this.getContent().length() > 0 && this._validator != null && !this._validator.isValid(SQLPromptPanel.this._conn, validatableObject)) {
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

