/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.Component;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.OracleOptionsPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.util.ResourceUtils;

public class OracleHttpOptions
extends OracleOptionsPanel {
    public static final String PROXY_MODE = "sqldev.http.proxymode";
    public static final String PROXY_HOST = "sqldev.http.proxy.host";
    public static final String PROXY_PORT = "sqldev.http.proxy.port";
    private static final String LEGACY_USE_PROXY = "sqldev.cloud.useproxy";
    private static final String LEGACY_PROXY_HOST = "sqldev.cloud.proxy.host";
    private static final String LEGACY_PROXY_PORT = "sqldev.cloud.proxy.port";
    private JRadioButton radNoProxy = new JRadioButton();
    private JRadioButton radIdeProxy = new JRadioButton();
    private JRadioButton radCustomProxy = new JRadioButton();
    private JTextField fldProxyHost = new JTextField();
    private JTextField fldProxyPort = new JTextField(5);

    @Override
    public void generateProperties(Properties properties) {
        ProxyMode proxyMode = ProxyMode.NONE;
        if (this.radIdeProxy.isSelected()) {
            proxyMode = ProxyMode.IDE;
        } else if (this.radCustomProxy.isSelected()) {
            proxyMode = ProxyMode.CUSTOM;
        }
        properties.setProperty(PROXY_MODE, proxyMode.toString());
        properties.setProperty(PROXY_HOST, this.fldProxyHost.getText());
        properties.setProperty(PROXY_PORT, this.fldProxyPort.getText());
    }

    @Override
    public void updatePrompts(Properties properties) {
        boolean bl;
        String string = properties.getProperty(PROXY_MODE);
        ProxyMode proxyMode = string != null ? ProxyMode.valueOf(string) : ((bl = Boolean.parseBoolean(properties.getProperty(LEGACY_USE_PROXY))) ? ProxyMode.CUSTOM : ProxyMode.NONE);
        switch (proxyMode) {
            case NONE: {
                this.radNoProxy.setSelected(true);
                break;
            }
            case IDE: {
                this.radIdeProxy.setSelected(true);
                break;
            }
            case CUSTOM: {
                this.radCustomProxy.setSelected(true);
            }
        }
        String string2 = properties.getProperty(PROXY_HOST);
        if (string2 == null) {
            string2 = properties.getProperty(LEGACY_PROXY_HOST);
        }
        this.fldProxyHost.setText(string2 != null ? string2 : "");
        String string3 = properties.getProperty(PROXY_PORT);
        if (string3 == null) {
            string3 = properties.getProperty(LEGACY_PROXY_PORT);
        }
        this.fldProxyPort.setText(string3 != null ? string3 : "");
    }

    @Override
    public void clear() {
        this.radNoProxy.setSelected(true);
        this.fldProxyHost.setText("");
        this.fldProxyPort.setText("");
    }

    @Override
    public void setDefaultPrompts() {
        this.clear();
    }

    @Override
    protected Component createUI() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        ResourceUtils.resButton((AbstractButton)this.radNoProxy, (String)ConnectionDialogArb.getString("HTTP_PROXY_OPTION_NONE"));
        buttonGroup.add(this.radNoProxy);
        jPanel.add((Component)this.radNoProxy, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        ResourceUtils.resButton((AbstractButton)this.radIdeProxy, (String)ConnectionDialogArb.getString("HTTP_PROXY_OPTION_GLOBAL"));
        buttonGroup.add(this.radIdeProxy);
        jPanel.add((Component)this.radIdeProxy, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        ResourceUtils.resButton((AbstractButton)this.radCustomProxy, (String)ConnectionDialogArb.getString("HTTP_PROXY_OPTION_CUSTOM"));
        this.radCustomProxy.addItemListener(itemEvent -> this.updateProxyState(this.radCustomProxy.isSelected()));
        this.updateProxyState(this.radCustomProxy.isSelected());
        buttonGroup.add(this.radCustomProxy);
        jPanel.add((Component)this.radCustomProxy, LayoutControl.GBC.gbc(0, 2, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        JPanel jPanel2 = LayoutControl.GBC.createPanel();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.fldProxyHost, (String)ConnectionDialogArb.getString("LABEL_HTTP_PROXY_HOST"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        jPanel2.add((Component)this.fldProxyHost, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.fldProxyPort, (String)ConnectionDialogArb.getString("LABEL_HTTP_PROXY_PORT"));
        jPanel2.add((Component)jLabel, LayoutControl.GBC.gbc(2, 0, 1, 1, LayoutControl.GBC.Inset.LINE_CONTROL2CONTROL_COMP));
        jPanel2.add((Component)this.fldProxyPort, LayoutControl.GBC.gbc(3, 0, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X));
        jPanel.add((Component)jPanel2, LayoutControl.GBC.gbc(0, 3, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        if (buttonGroup.getSelection() == null) {
            this.radNoProxy.setSelected(true);
        }
        return jPanel;
    }

    @Override
    public String getLabel() {
        return ConnectionDialogArb.getString("HTTP_PROXY_TAB");
    }

    private void updateProxyState(boolean bl) {
        this.fldProxyHost.setEnabled(bl);
        this.fldProxyPort.setEnabled(bl);
    }

    public static enum ProxyMode {
        NONE,
        IDE,
        CUSTOM;

    }
}

